/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathInt$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns an integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001.B\u0001\"\b\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005!\t\u0003\u0005J\u0001\tE\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013qI\u0004\n\u0003Wb\u0012\u0011!E\u0001\u0003[2\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0015V!\t!a\"\t\u0013\u0005%U#!A\u0005F\u0005-\u0005\"CAG+\u0005\u0005I\u0011QAH\u0011%\t)*FA\u0001\n\u0003\u000b9\nC\u0005\u0002*V\t\t\u0011\"\u0003\u0002,\nA\u0001\fU1uQ&sGO\u0003\u0002\u001e=\u0005\u0019\u00010\u001c7\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u00171mA\u0011QFL\u0007\u00029%\u0011q\u0006\b\u0002\r1B\u000bG\u000f[#yiJ\f7\r\u001e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b!J|G-^2u!\t9tH\u0004\u00029{9\u0011\u0011\bP\u0007\u0002u)\u00111HK\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!A\u0010\u001a\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003}I*\u0012a\u0011\t\u0003\t\u0016k\u0011AH\u0005\u0003\rz\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0011AX\u000e\u001c\u0011\u0002\tA\fG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071ke\n\u0005\u0002.\u0001!)Q$\u0002a\u0001\u0007\")\u0001*\u0002a\u0001\u0007\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003E\u0003\"A\u0015,\u000f\u0005M#\u0006CA\u001d3\u0013\t)&'\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+3\u0003!!\u0017\r^1UsB,W#A.\u0011\u0005q{V\"A/\u000b\u0005y\u0013\u0013!\u0002;za\u0016\u001c\u0018B\u00011^\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA2gOB\u0011\u0011\u0007Z\u0005\u0003KJ\u00121!\u00118z\u0011\u0015i\u0002\u00021\u0001d\u0011\u0015A\u0005\u00021\u0001d\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002DU2DQa[\u0005A\u0002\r\u000bqA\\3x\u0019\u00164G\u000fC\u0003n\u0013\u0001\u00071)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u00071\u0003\u0018\u000fC\u0004\u001e\u0015A\u0005\t\u0019A\"\t\u000f!S\u0001\u0013!a\u0001\u0007\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u0001;+\u0005\r+8&\u0001<\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018!C;oG\",7m[3e\u0015\tY('\u0001\u0006b]:|G/\u0019;j_:L!! =\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\tAA[1wC&\u0019q+a\u0002\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0001cA\u0019\u0002\u0018%\u0019\u0011\u0011\u0004\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\r\fy\u0002C\u0005\u0002\"=\t\t\u00111\u0001\u0002\u0016\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\n\u0011\u000b\u0005%\u0012qF2\u000e\u0005\u0005-\"bAA\u0017e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00121\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00028\u0005u\u0002cA\u0019\u0002:%\u0019\u00111\b\u001a\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011E\t\u0002\u0002\u0003\u00071-\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\u0002\u0003\u0007B\u0011\"!\t\u0013\u0003\u0003\u0005\r!!\u0006\u0002\r\u0015\fX/\u00197t)\u0011\t9$!\u0013\t\u0011\u0005\u00052#!AA\u0002\rD3\u0003AA'\u0003'\n)&!\u0017\u0002\\\u0005}\u0013\u0011MA3\u0003O\u00022\u0001RA(\u0013\r\t\tF\b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t9&AA\t?\u001a+fjQ0)q6dG\u0006\t=qCRD\u0017\u0006I\u0017!%\u0016$XO\u001d8tA\u0005t\u0007%\u001b8uK\u001e,'\u000f\t<bYV,G\u0006I8sAQDW\r\t<bYV,\u0007E_3s_\u0002Jg\r\t8pA5\fGo\u00195!SN\u0004cm\\;oI2\u0002sN\u001d\u0011bA5\fGo\u00195!SN\u0004cm\\;oI\u0002\u0012W\u000f\u001e\u0011uQ\u0016\u0004c/\u00197vK\u0002J7\u000f\t8p]6rW/\\3sS\u000et\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0013\u0001\u0017\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)Oq\ng\b\u00102?cqz#M\u0010\u001fc}IbtF\u0019 =_\u0005tt\u0005\f\u0011(gVl\u0007&Y\u0018cS\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a\u0019\u0002\u000bIr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0014!\u0003=nY~3WO\\2t\u0003!A\u0006+\u0019;i\u0013:$\bCA\u0017\u0016'\u0015)\u0012\u0011OA?!\u001d\t\u0019(!\u001fD\u00072k!!!\u001e\u000b\u0007\u0005]$'A\u0004sk:$\u0018.\\3\n\t\u0005m\u0014Q\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151B\u0001\u0003S>L1\u0001QAA)\t\ti'\u0001\u0005u_N#(/\u001b8h)\t\t\u0019!A\u0003baBd\u0017\u0010F\u0003M\u0003#\u000b\u0019\nC\u0003\u001e1\u0001\u00071\tC\u0003I1\u0001\u00071)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005e\u0015Q\u0015\t\u0006c\u0005m\u0015qT\u0005\u0004\u0003;\u0013$AB(qi&|g\u000eE\u00032\u0003C\u001b5)C\u0002\u0002$J\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAT3\u0005\u0005\t\u0019\u0001'\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002.B!\u0011QAAX\u0013\u0011\t\t,a\u0002\u0003\r=\u0013'.Z2u\u0001")
public class XPathInt
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathInt x$0) {
        return XPathInt$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathInt> tupled() {
        return XPathInt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathInt>> curried() {
        return XPathInt$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_int";
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        if (ret == null) {
            return null;
        }
        return BoxesRunTime.boxToInteger((int)ret.intValue());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathInt copy(Expression xml, Expression path) {
        return new XPathInt(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathInt";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.xml();
            }
            case 1: {
                return this.path();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathInt;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "xml";
            }
            case 1: {
                return "path";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathInt)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathInt xPathInt = (XPathInt)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathInt.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathInt.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathInt.canEqual(this)) return false;
        return true;
    }

    public XPathInt(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

