/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathLong$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a long integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ", since="2.0.0", group="xml_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u000e\u001d\u0001.B\u0001\"\b\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\u0007\"A\u0001\n\u0001BK\u0002\u0013\u0005!\t\u0003\u0005J\u0001\tE\t\u0015!\u0003D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015A\u0007\u0001\"\u0015j\u0011\u001dq\u0007!!A\u0005\u0002=DqA\u001d\u0001\u0012\u0002\u0013\u00051\u000fC\u0004\u007f\u0001E\u0005I\u0011A:\t\u0011}\u0004\u0011\u0011!C!\u0003\u0003A\u0011\"!\u0005\u0001\u0003\u0003%\t!a\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0012\u0001\u0005\u0005I\u0011IA\u0013\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013qI\u0004\n\u0003Wb\u0012\u0011!E\u0001\u0003[2\u0001b\u0007\u000f\u0002\u0002#\u0005\u0011q\u000e\u0005\u0007\u0015V!\t!a\"\t\u0013\u0005%U#!A\u0005F\u0005-\u0005\"CAG+\u0005\u0005I\u0011QAH\u0011%\t)*FA\u0001\n\u0003\u000b9\nC\u0005\u0002*V\t\t\u0011\"\u0003\u0002,\nI\u0001\fU1uQ2{gn\u001a\u0006\u0003;y\t1\u0001_7m\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011\u0003\u0002\u0001-aY\u0002\"!\f\u0018\u000e\u0003qI!a\f\u000f\u0003\u0019a\u0003\u0016\r\u001e5FqR\u0014\u0018m\u0019;\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u000fA\u0013x\u000eZ;diB\u0011qg\u0010\b\u0003qur!!\u000f\u001f\u000e\u0003iR!a\u000f\u0016\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014B\u0001 3\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005y\u0012T#A\"\u0011\u0005\u0011+U\"\u0001\u0010\n\u0005\u0019s\"AC#yaJ,7o]5p]\u0006!\u00010\u001c7!\u0003\u0011\u0001\u0018\r\u001e5\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\raUJ\u0014\t\u0003[\u0001AQ!H\u0003A\u0002\rCQ\u0001S\u0003A\u0002\r\u000b!\u0002\u001d:fiRLh*Y7f+\u0005\t\u0006C\u0001*W\u001d\t\u0019F\u000b\u0005\u0002:e%\u0011QKM\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002Ve\u0005AA-\u0019;b)f\u0004X-F\u0001\\!\tav,D\u0001^\u0015\tq&%A\u0003usB,7/\u0003\u0002a;\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002dM\u001e\u0004\"!\r3\n\u0005\u0015\u0014$aA!os\")Q\u0004\u0003a\u0001G\")\u0001\n\u0003a\u0001G\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004\u0019*d\u0007\"B6\n\u0001\u0004\u0019\u0015a\u00028fo2+g\r\u001e\u0005\u0006[&\u0001\raQ\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\ra\u0005/\u001d\u0005\b;)\u0001\n\u00111\u0001D\u0011\u001dA%\u0002%AA\u0002\r\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001uU\t\u0019UoK\u0001w!\t9H0D\u0001y\u0015\tI(0A\u0005v]\u000eDWmY6fI*\u00111PM\u0001\u000bC:tw\u000e^1uS>t\u0017BA?y\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0001\t\u0005\u0003\u000b\ty!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003\u0011a\u0017M\\4\u000b\u0005\u00055\u0011\u0001\u00026bm\u0006L1aVA\u0004\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0002E\u00022\u0003/I1!!\u00073\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\u0019\u0017q\u0004\u0005\n\u0003Cy\u0011\u0011!a\u0001\u0003+\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0014!\u0015\tI#a\fd\u001b\t\tYCC\u0002\u0002.I\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t$a\u000b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003o\ti\u0004E\u00022\u0003sI1!a\u000f3\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\t\u0012\u0003\u0003\u0005\raY\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0004\u0005\r\u0003\"CA\u0011%\u0005\u0005\t\u0019AA\u000b\u0003\u0019)\u0017/^1mgR!\u0011qGA%\u0011!\t\tcEA\u0001\u0002\u0004\u0019\u0007f\u0005\u0001\u0002N\u0005M\u0013QKA-\u00037\ny&!\u0019\u0002f\u0005\u001d\u0004c\u0001#\u0002P%\u0019\u0011\u0011\u000b\u0010\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011qK\u0001\u0002\u001a}3UKT\"`QalG\u000e\f\u0011ya\u0006$\b.\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007\u0005\\8oO\u0002Jg\u000e^3hKJ\u0004c/\u00197vK2\u0002sN\u001d\u0011uQ\u0016\u0004c/\u00197vK\u0002RXM]8!S\u001a\u0004cn\u001c\u0011nCR\u001c\u0007\u000eI5tA\u0019|WO\u001c3-A=\u0014\b%\u0019\u0011nCR\u001c\u0007\u000eI5tA\u0019|WO\u001c3!EV$\b\u0005\u001e5fAY\fG.^3!SN\u0004cn\u001c8.]VlWM]5d]\u0005AQ\r_1na2,7/\t\u0002\u0002^\u0005A&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014=Czb$MP\u0019=_\ttDH\u0019 3y=\u0012g\bP\u0018b}\u001db\u0003eJ:v[\"\nwFY\u0015(SmR\u0001\u0005\t\u0011!A\u0001\u00023G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019'A\u00033]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002j\u0005I\u00010\u001c7`MVt7m]\u0001\n1B\u000bG\u000f\u001b'p]\u001e\u0004\"!L\u000b\u0014\u000bU\t\t(! \u0011\u000f\u0005M\u0014\u0011P\"D\u00196\u0011\u0011Q\u000f\u0006\u0004\u0003o\u0012\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003w\n)HA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000bY!\u0001\u0002j_&\u0019\u0001)!!\u0015\u0005\u00055\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0011!B1qa2LH#\u0002'\u0002\u0012\u0006M\u0005\"B\u000f\u0019\u0001\u0004\u0019\u0005\"\u0002%\u0019\u0001\u0004\u0019\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u000b)\u000bE\u00032\u00037\u000by*C\u0002\u0002\u001eJ\u0012aa\u00149uS>t\u0007#B\u0019\u0002\"\u000e\u001b\u0015bAARe\t1A+\u001e9mKJB\u0001\"a*\u001a\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAW!\u0011\t)!a,\n\t\u0005E\u0016q\u0001\u0002\u0007\u001f\nTWm\u0019;")
public class XPathLong
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathLong x$0) {
        return XPathLong$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathLong> tupled() {
        return XPathLong$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathLong>> curried() {
        return XPathLong$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_long";
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        if (ret == null) {
            return null;
        }
        return BoxesRunTime.boxToLong((long)ret.longValue());
    }

    @Override
    public XPathLong withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public XPathLong copy(Expression xml, Expression path) {
        return new XPathLong(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathLong";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.xml();
            }
            case 1: {
                return this.path();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathLong;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "xml";
            }
            case 1: {
                return "path";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathLong)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathLong xPathLong = (XPathLong)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathLong.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathLong.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathLong.canEqual(this)) return false;
        return true;
    }

    public XPathLong(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

