/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.catalyst.expressions.StringRPad$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.CharVarcharCodegenUtils;
import org.apache.spark.sql.catalyst.util.SparkCharVarcharUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CharVarcharUtils$
implements Logging,
SparkCharVarcharUtils {
    public static final CharVarcharUtils$ MODULE$ = new CharVarcharUtils$();
    private static final String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        SparkCharVarcharUtils.$init$((SparkCharVarcharUtils)MODULE$);
        CHAR_VARCHAR_TYPE_STRING_METADATA_KEY = "__CHAR_VARCHAR_TYPE_STRING";
    }

    public boolean hasCharVarchar(DataType dt) {
        return SparkCharVarcharUtils.hasCharVarchar$((SparkCharVarcharUtils)this, (DataType)dt);
    }

    public DataType failIfHasCharVarchar(DataType dt) {
        return SparkCharVarcharUtils.failIfHasCharVarchar$((SparkCharVarcharUtils)this, (DataType)dt);
    }

    public DataType replaceCharVarcharWithString(DataType dt) {
        return SparkCharVarcharUtils.replaceCharVarcharWithString$((SparkCharVarcharUtils)this, (DataType)dt);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY() {
        return CHAR_VARCHAR_TYPE_STRING_METADATA_KEY;
    }

    public StructType replaceCharVarcharWithStringInSchema(StructType st) {
        return StructType$.MODULE$.apply((Seq)st.map((Function1 & Serializable)field -> {
            if (MODULE$.hasCharVarchar(field.dataType())) {
                Metadata metadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY(), field.dataType().catalogString()).build();
                DataType x$1 = MODULE$.replaceCharVarcharWithString(field.dataType());
                Metadata x$2 = metadata;
                String x$3 = field.copy$default$1();
                boolean x$4 = field.copy$default$3();
                return field.copy(x$3, x$1, x$4, x$2);
            }
            return field;
        }));
    }

    public DataType replaceCharWithVarchar(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean nullable = arrayType.containsNull();
            return new ArrayType(this.replaceCharWithVarchar(et), nullable);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean nullable = mapType.valueContainsNull();
            return new MapType(this.replaceCharWithVarchar(kt), this.replaceCharWithVarchar(vt), nullable);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)field -> {
                DataType x$1 = MODULE$.replaceCharWithVarchar(field.dataType());
                String x$2 = field.copy$default$1();
                boolean x$3 = field.copy$default$3();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$1, x$3, x$4);
            }, ClassTag$.MODULE$.apply(StructField.class)));
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            return new VarcharType(length);
        }
        return dt;
    }

    public DataType replaceCharVarcharWithStringForCast(DataType dt) {
        if (SQLConf$.MODULE$.get().charVarcharAsString()) {
            return this.replaceCharVarcharWithString(dt);
        }
        if (this.hasCharVarchar(dt)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The Spark cast operator does not support char/varchar type and simply treats"}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" them as string type. Please use string type directly to avoid confusion. Otherwise,"}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" you can set ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)SQLConf$.MODULE$.LEGACY_CHAR_VARCHAR_AS_STRING().key())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to true, so that Spark treat them as string type as same as Spark 3.0 and earlier"}))).log((Seq)Nil$.MODULE$))));
            return this.replaceCharVarcharWithString(dt);
        }
        return dt;
    }

    public AttributeReference cleanAttrMetadata(AttributeReference attr) {
        Metadata cleaned = new MetadataBuilder().withMetadata(attr.metadata()).remove(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()).build();
        return attr.withMetadata(cleaned);
    }

    public Option<String> getRawTypeString(Metadata metadata) {
        if (metadata.contains(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY())) {
            return new Some((Object)metadata.getString(this.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()));
        }
        return None$.MODULE$;
    }

    public Option<DataType> getRawType(Metadata metadata) {
        return this.getRawTypeString(metadata).map((Function1 & Serializable)sqlText -> CatalystSqlParser$.MODULE$.parseDataType((String)sqlText));
    }

    public StructType getRawSchema(StructType schema) {
        Seq fields = (Seq)schema.map((Function1 & Serializable)field -> (StructField)MODULE$.getRawType(field.metadata()).map((Function1 & Serializable)dt -> {
            DataType x$1 = dt;
            String x$2 = field.copy$default$1();
            boolean x$3 = field.copy$default$3();
            Metadata x$4 = field.copy$default$4();
            return field.copy(x$2, x$1, x$3, x$4);
        }).getOrElse((Function0 & Serializable)() -> field));
        return StructType$.MODULE$.apply(fields);
    }

    public StructType getRawSchema(StructType schema, SQLConf conf) {
        Seq fields = (Seq)schema.map((Function1 & Serializable)field -> (StructField)MODULE$.getRawType(field.metadata()).map((Function1 & Serializable)dt -> {
            if (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.CHAR_AS_VARCHAR()))) {
                Metadata metadata = new MetadataBuilder().withMetadata(field.metadata()).remove(MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()).build();
                DataType x$1 = MODULE$.replaceCharWithVarchar((DataType)dt);
                Metadata x$2 = metadata;
                String x$3 = field.copy$default$1();
                boolean x$4 = field.copy$default$3();
                return field.copy(x$3, x$1, x$4, x$2);
            }
            DataType x$5 = dt;
            String x$6 = field.copy$default$1();
            boolean x$7 = field.copy$default$3();
            Metadata x$8 = field.copy$default$4();
            return field.copy(x$6, x$5, x$7, x$8);
        }).getOrElse((Function0 & Serializable)() -> field));
        return StructType$.MODULE$.apply(fields);
    }

    public Expression stringLengthCheck(Expression expr, Attribute targetAttr) {
        return (Expression)this.getRawType(targetAttr.metadata()).map((Function1 & Serializable)rawType -> MODULE$.stringLengthCheck(expr, (DataType)rawType)).getOrElse((Function0 & Serializable)() -> expr);
    }

    public Expression stringLengthCheck(Expression expr, DataType dt) {
        return this.processStringForCharVarchar(expr, dt, (Option<String>)new Some((Object)"charTypeWriteSideCheck"), (Option<String>)new Some((Object)"varcharTypeWriteSideCheck"));
    }

    private Expression processStringForCharVarchar(Expression expr, DataType dt, Option<String> charFuncName, Option<String> varcharFuncName) {
        DataType dataType = dt;
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            if (charFuncName.isDefined()) {
                Class<CharVarcharCodegenUtils> x$12 = CharVarcharCodegenUtils.class;
                StringType$ x$2 = StringType$.MODULE$;
                String x$3 = (String)charFuncName.get();
                Expression expression = expr;
                Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
                List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
                return new StaticInvoke(CharVarcharCodegenUtils.class, (DataType)x$2, x$3, (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
            }
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int length = varcharType.length();
            if (varcharFuncName.isDefined()) {
                Class<CharVarcharCodegenUtils> x$10 = CharVarcharCodegenUtils.class;
                StringType$ x$11 = StringType$.MODULE$;
                String x$12 = (String)varcharFuncName.get();
                Expression expression = expr;
                Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
                List x$13 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
                boolean x$14 = false;
                Seq<AbstractDataType> x$15 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$16 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$17 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$18 = StaticInvoke$.MODULE$.apply$default$9();
                return new StaticInvoke(CharVarcharCodegenUtils.class, (DataType)x$11, x$12, (Seq<Expression>)x$13, x$15, x$16, false, x$17, x$18);
            }
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            CreateNamedStruct struct = new CreateNamedStruct((Seq<Expression>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])fields))), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField f = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return new .colon.colon((Object)Literal$.MODULE$.apply(f.name()), (List)new .colon.colon((Object)MODULE$.processStringForCharVarchar(new GetStructField(expr, i, (Option<String>)new Some((Object)f.name())), f.dataType(), charFuncName, varcharFuncName), (List)Nil$.MODULE$));
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Expression.class))).toImmutableArraySeq());
            if (struct.valExprs().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CharVarcharUtils$.$anonfun$processStringForCharVarchar$2(x$1)))) {
                return expr;
            }
            if (expr.nullable()) {
                return new If(new IsNull(expr), new Literal(null, (DataType)struct.dataType()), struct);
            }
            return struct;
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return this.processStringForCharVarcharInArray(expr, et, containsNull, charFuncName, varcharFuncName);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType kt = mapType.keyType();
            DataType vt = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            MapKeys keys = new MapKeys(expr);
            Expression newKeys = this.processStringForCharVarcharInArray(keys, kt, false, charFuncName, varcharFuncName);
            MapValues values = new MapValues(expr);
            Expression newValues = this.processStringForCharVarcharInArray(values, vt, valueContainsNull, charFuncName, varcharFuncName);
            if (newKeys.fastEquals(keys) && newValues.fastEquals(values)) {
                return expr;
            }
            return new MapFromArrays(newKeys, newValues);
        }
        return expr;
    }

    private Expression processStringForCharVarcharInArray(Expression arr, DataType et, boolean containsNull, Option<String> charFuncName, Option<String> varcharFuncName) {
        NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        Expression funcBody = this.processStringForCharVarchar(param, et, charFuncName, varcharFuncName);
        if (funcBody.fastEquals(param)) {
            return arr;
        }
        return new ArrayTransform(arr, new LambdaFunction(funcBody, (Seq<NamedExpression>)new .colon.colon((Object)param, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3()));
    }

    public Expression addPaddingForScan(Attribute attr) {
        return (Expression)this.getRawType(attr.metadata()).map((Function1 & Serializable)rawType -> MODULE$.processStringForCharVarchar(attr, (DataType)rawType, (Option<String>)new Some((Object)"readSidePadding"), (Option<String>)None$.MODULE$)).getOrElse((Function0 & Serializable)() -> attr);
    }

    public Seq<Expression> addPaddingInStringComparison(Seq<Attribute> attrs2) {
        Seq rawTypes = (Seq)attrs2.map((Function1 & Serializable)attr -> MODULE$.getRawType(attr.metadata()));
        if (rawTypes.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty()))) {
            return attrs2;
        }
        DataType typeWithTargetCharLength = (DataType)((IterableOnceOps)rawTypes.map((Function1 & Serializable)x$3 -> (DataType)x$3.get())).reduce((Function2 & Serializable)(type1, type2) -> MODULE$.typeWithWiderCharLength((DataType)type1, (DataType)type2));
        return (Seq)((IterableOps)attrs2.zip((IterableOnce)rawTypes.map((Function1 & Serializable)x$4 -> (DataType)x$4.get()))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attr = (Attribute)tuple2._1();
                DataType rawType = (DataType)tuple2._2();
                return (Expression)MODULE$.padCharToTargetLength(attr, rawType, typeWithTargetCharLength).getOrElse((Function0 & Serializable)() -> attr);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private DataType typeWithWiderCharLength(DataType type1, DataType type2) {
        Tuple2 tuple2 = new Tuple2((Object)type1, (Object)type2);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof CharType) {
                CharType charType = (CharType)dataType;
                int len1 = charType.length();
                if (dataType2 instanceof CharType) {
                    CharType charType2 = (CharType)dataType2;
                    int len2 = charType2.length();
                    return new CharType(package$.MODULE$.max(len1, len2));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields1 = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] fields2 = structType2.fields();
                    Predef$.MODULE$.assert(fields1.length == fields2.length);
                    return new StructType((StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])fields1), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])fields2))), (Function1 & Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            StructField left = (StructField)tuple2._1();
                            StructField right = (StructField)tuple2._2();
                            return new StructField("", MODULE$.typeWithWiderCharLength(left.dataType(), right.dataType()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                        }
                        throw new MatchError((Object)tuple2);
                    }, ClassTag$.MODULE$.apply(StructField.class)));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et1 = arrayType.elementType();
                if (dataType4 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType4;
                    DataType et2 = arrayType2.elementType();
                    return ArrayType$.MODULE$.apply(this.typeWithWiderCharLength(et1, et2));
                }
            }
        }
        return NullType$.MODULE$;
    }

    private Option<Expression> padCharToTargetLength(Expression expr, DataType rawType, DataType typeWithTargetCharLength) {
        Tuple2 tuple2 = new Tuple2((Object)rawType, (Object)typeWithTargetCharLength);
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (dataType instanceof CharType) {
                CharType charType;
                int target;
                CharType charType2 = (CharType)dataType;
                int len = charType2.length();
                if (dataType2 instanceof CharType && (target = (charType = (CharType)dataType2).length()) > len) {
                    return new Some((Object)new StringRPad(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)target)), StringRPad$.MODULE$.apply$default$3()));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] targets = structType2.fields();
                    Predef$.MODULE$.assert(fields.length == targets.length);
                    boolean needPadding = false;
                    ArrayBuffer createStructExprs = ArrayBuffer$.MODULE$.empty();
                    for (int i = 0; i < fields.length; ++i) {
                        StructField field = fields[i];
                        GetStructField fieldExpr = new GetStructField(expr, i, (Option<String>)new Some((Object)field.name()));
                        Option<Expression> padded2 = this.padCharToTargetLength(fieldExpr, field.dataType(), targets[i].dataType());
                        needPadding = padded2.isDefined();
                        createStructExprs.$plus$eq((Object)Literal$.MODULE$.apply(field.name()));
                        createStructExprs.$plus$eq(padded2.getOrElse((Function0 & Serializable)() -> fieldExpr));
                    }
                    if (needPadding) {
                        return new Some((Object)new CreateNamedStruct((Seq<Expression>)createStructExprs.toSeq()));
                    }
                    return None$.MODULE$;
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType4 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (dataType4 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)dataType4;
                    DataType target = arrayType2.elementType();
                    NamedLambdaVariable param = new NamedLambdaVariable("x", this.replaceCharVarcharWithString(et), containsNull, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    return this.padCharToTargetLength(param, et, target).map((Function1 & Serializable)padded -> {
                        LambdaFunction func = new LambdaFunction((Expression)padded, (Seq<NamedExpression>)new .colon.colon((Object)param, (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                        return new ArrayTransform(expr, func);
                    });
                }
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$processStringForCharVarchar$2(Expression x$1) {
        return x$1 instanceof GetStructField;
    }

    private CharVarcharUtils$() {
    }
}

