/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DoubleExactNumeric$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class DateTimeUtils$
implements SparkDateTimeUtils {
    public static final DateTimeUtils$ MODULE$ = new DateTimeUtils$();
    private static final String TIMEZONE_OPTION;
    private static final UTF8String gmtUtf8;
    private static final int SUNDAY;
    private static final int MONDAY;
    private static final int TUESDAY;
    private static final int WEDNESDAY;
    private static final int THURSDAY;
    private static final int FRIDAY;
    private static final int SATURDAY;
    private static final int TRUNC_INVALID;
    private static final int TRUNC_TO_MICROSECOND;
    private static final int MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    private static final int TRUNC_TO_MILLISECOND;
    private static final int TRUNC_TO_SECOND;
    private static final int TRUNC_TO_MINUTE;
    private static final int TRUNC_TO_HOUR;
    private static final int TRUNC_TO_DAY;
    private static final int TRUNC_TO_WEEK;
    private static final int MIN_LEVEL_OF_DATE_TRUNC;
    private static final int TRUNC_TO_MONTH;
    private static final int TRUNC_TO_QUARTER;
    private static final int TRUNC_TO_YEAR;
    private static final Regex specialValueRe;
    private static final Map<String, Function2<Temporal, Temporal, Object>> timestampDiffMap;
    private static TimeZone TimeZoneUTC;
    private static Pattern singleHourTz;
    private static Pattern singleMinuteTz;
    private static long org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$MIN_SECONDS;
    private static String org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$zoneInfoClassName;
    private static MethodHandle org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle;
    private static volatile boolean bitmap$0;

    static {
        SparkDateTimeUtils.$init$((SparkDateTimeUtils)MODULE$);
        TIMEZONE_OPTION = "timeZone";
        gmtUtf8 = UTF8String.fromString((String)"GMT");
        SUNDAY = 3;
        MONDAY = 4;
        TUESDAY = 5;
        WEDNESDAY = 6;
        THURSDAY = 0;
        FRIDAY = 1;
        SATURDAY = 2;
        TRUNC_INVALID = -1;
        TRUNC_TO_MICROSECOND = 0;
        MIN_LEVEL_OF_TIMESTAMP_TRUNC = MODULE$.TRUNC_TO_MICROSECOND();
        TRUNC_TO_MILLISECOND = 1;
        TRUNC_TO_SECOND = 2;
        TRUNC_TO_MINUTE = 3;
        TRUNC_TO_HOUR = 4;
        TRUNC_TO_DAY = 5;
        TRUNC_TO_WEEK = 6;
        MIN_LEVEL_OF_DATE_TRUNC = MODULE$.TRUNC_TO_WEEK();
        TRUNC_TO_MONTH = 7;
        TRUNC_TO_QUARTER = 8;
        TRUNC_TO_YEAR = 9;
        specialValueRe = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\p{Alpha}+)\\p{Blank}*(.*)"));
        timestampDiffMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MICROSECOND"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MICROS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MILLISECOND"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MILLIS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SECOND"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.SECONDS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MINUTE"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MINUTES.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"HOUR"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.HOURS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DAY"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.DAYS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WEEK"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.WEEKS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"MONTH"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.MONTHS.between(x$1, x$2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"QUARTER"), (Function2 & Serializable)(startTs, endTs) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.$anonfun$timestampDiffMap$9(startTs, endTs))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"YEAR"), (Function2 & Serializable)(x$1, x$2) -> BoxesRunTime.boxToLong((long)ChronoUnit.YEARS.between(x$1, x$2)))}));
    }

    public ZoneId getZoneId(String timeZoneId) {
        return SparkDateTimeUtils.getZoneId$((SparkDateTimeUtils)this, (String)timeZoneId);
    }

    public TimeZone getTimeZone(String timeZoneId) {
        return SparkDateTimeUtils.getTimeZone$((SparkDateTimeUtils)this, (String)timeZoneId);
    }

    public int anyToDays(Object obj) {
        return SparkDateTimeUtils.anyToDays$((SparkDateTimeUtils)this, (Object)obj);
    }

    public long anyToMicros(Object obj) {
        return SparkDateTimeUtils.anyToMicros$((SparkDateTimeUtils)this, (Object)obj);
    }

    public long microsToMillis(long micros) {
        return SparkDateTimeUtils.microsToMillis$((SparkDateTimeUtils)this, (long)micros);
    }

    public long millisToMicros(long millis) {
        return SparkDateTimeUtils.millisToMicros$((SparkDateTimeUtils)this, (long)millis);
    }

    public Instant microsToInstant(long micros) {
        return SparkDateTimeUtils.microsToInstant$((SparkDateTimeUtils)this, (long)micros);
    }

    public long instantToMicros(Instant instant) {
        return SparkDateTimeUtils.instantToMicros$((SparkDateTimeUtils)this, (Instant)instant);
    }

    public long convertTz(long micros, ZoneId fromZone, ZoneId toZone) {
        return SparkDateTimeUtils.convertTz$((SparkDateTimeUtils)this, (long)micros, (ZoneId)fromZone, (ZoneId)toZone);
    }

    public LocalDateTime getLocalDateTime(long micros, ZoneId zoneId) {
        return SparkDateTimeUtils.getLocalDateTime$((SparkDateTimeUtils)this, (long)micros, (ZoneId)zoneId);
    }

    public LocalDateTime microsToLocalDateTime(long micros) {
        return SparkDateTimeUtils.microsToLocalDateTime$((SparkDateTimeUtils)this, (long)micros);
    }

    public long localDateTimeToMicros(LocalDateTime localDateTime) {
        return SparkDateTimeUtils.localDateTimeToMicros$((SparkDateTimeUtils)this, (LocalDateTime)localDateTime);
    }

    public int localDateToDays(LocalDate localDate) {
        return SparkDateTimeUtils.localDateToDays$((SparkDateTimeUtils)this, (LocalDate)localDate);
    }

    public LocalDate daysToLocalDate(int days) {
        return SparkDateTimeUtils.daysToLocalDate$((SparkDateTimeUtils)this, (int)days);
    }

    public int microsToDays(long micros, ZoneId zoneId) {
        return SparkDateTimeUtils.microsToDays$((SparkDateTimeUtils)this, (long)micros, (ZoneId)zoneId);
    }

    public long daysToMicros(int days, ZoneId zoneId) {
        return SparkDateTimeUtils.daysToMicros$((SparkDateTimeUtils)this, (int)days, (ZoneId)zoneId);
    }

    public int fromJavaDate(Date date) {
        return SparkDateTimeUtils.fromJavaDate$((SparkDateTimeUtils)this, (Date)date);
    }

    public Date toJavaDate(int days) {
        return SparkDateTimeUtils.toJavaDate$((SparkDateTimeUtils)this, (int)days);
    }

    public Timestamp toJavaTimestamp(long micros) {
        return SparkDateTimeUtils.toJavaTimestamp$((SparkDateTimeUtils)this, (long)micros);
    }

    public Timestamp toJavaTimestampNoRebase(long micros) {
        return SparkDateTimeUtils.toJavaTimestampNoRebase$((SparkDateTimeUtils)this, (long)micros);
    }

    public long fromJavaTimestamp(Timestamp t) {
        return SparkDateTimeUtils.fromJavaTimestamp$((SparkDateTimeUtils)this, (Timestamp)t);
    }

    public long fromJavaTimestampNoRebase(Timestamp t) {
        return SparkDateTimeUtils.fromJavaTimestampNoRebase$((SparkDateTimeUtils)this, (Timestamp)t);
    }

    public Option<Object> stringToDate(UTF8String s) {
        return SparkDateTimeUtils.stringToDate$((SparkDateTimeUtils)this, (UTF8String)s);
    }

    public int stringToDateAnsi(UTF8String s, QueryContext context) {
        return SparkDateTimeUtils.stringToDateAnsi$((SparkDateTimeUtils)this, (UTF8String)s, (QueryContext)context);
    }

    public QueryContext stringToDateAnsi$default$2() {
        return SparkDateTimeUtils.stringToDateAnsi$default$2$((SparkDateTimeUtils)this);
    }

    public Tuple3<int[], Option<ZoneId>, Object> parseTimestampString(UTF8String s) {
        return SparkDateTimeUtils.parseTimestampString$((SparkDateTimeUtils)this, (UTF8String)s);
    }

    public Option<Object> stringToTimestamp(UTF8String s, ZoneId timeZoneId) {
        return SparkDateTimeUtils.stringToTimestamp$((SparkDateTimeUtils)this, (UTF8String)s, (ZoneId)timeZoneId);
    }

    public long stringToTimestampAnsi(UTF8String s, ZoneId timeZoneId, QueryContext context) {
        return SparkDateTimeUtils.stringToTimestampAnsi$((SparkDateTimeUtils)this, (UTF8String)s, (ZoneId)timeZoneId, (QueryContext)context);
    }

    public QueryContext stringToTimestampAnsi$default$3() {
        return SparkDateTimeUtils.stringToTimestampAnsi$default$3$((SparkDateTimeUtils)this);
    }

    public Option<Object> stringToTimestampWithoutTimeZone(UTF8String s, boolean allowTimeZone) {
        return SparkDateTimeUtils.stringToTimestampWithoutTimeZone$((SparkDateTimeUtils)this, (UTF8String)s, (boolean)allowTimeZone);
    }

    public final TimeZone TimeZoneUTC() {
        return TimeZoneUTC;
    }

    public final Pattern singleHourTz() {
        return singleHourTz;
    }

    public final Pattern singleMinuteTz() {
        return singleMinuteTz;
    }

    public long org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$MIN_SECONDS() {
        return org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$MIN_SECONDS;
    }

    public String org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$zoneInfoClassName() {
        return org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$zoneInfoClassName;
    }

    private MethodHandle org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle$lzycompute() {
        DateTimeUtils$ dateTimeUtils$ = this;
        synchronized (dateTimeUtils$) {
            if (!bitmap$0) {
                org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle = SparkDateTimeUtils.org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle$((SparkDateTimeUtils)this);
                bitmap$0 = true;
            }
        }
        return org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle;
    }

    public MethodHandle org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle() {
        if (!bitmap$0) {
            return this.org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle$lzycompute();
        }
        return org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$getOffsetsByWallHandle;
    }

    public final void org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$_setter_$TimeZoneUTC_$eq(TimeZone x$1) {
        TimeZoneUTC = x$1;
    }

    public final void org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$_setter_$singleHourTz_$eq(Pattern x$1) {
        singleHourTz = x$1;
    }

    public final void org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$_setter_$singleMinuteTz_$eq(Pattern x$1) {
        singleMinuteTz = x$1;
    }

    public final void org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$_setter_$org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$MIN_SECONDS_$eq(long x$1) {
        org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$MIN_SECONDS = x$1;
    }

    public final void org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$_setter_$org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$zoneInfoClassName_$eq(String x$1) {
        org$apache$spark$sql$catalyst$util$SparkDateTimeUtils$$zoneInfoClassName = x$1;
    }

    public final int JULIAN_DAY_OF_EPOCH() {
        return 2440588;
    }

    public String TIMEZONE_OPTION() {
        return TIMEZONE_OPTION;
    }

    public long fromJulianDay(int days, long nanos) {
        return (long)(days - 2440588) * 86400000000L + nanos / 1000L;
    }

    public Tuple2<Object, Object> toJulianDay(long micros) {
        long julianUs = micros + 210866803200000000L;
        long days = julianUs / 86400000000L;
        long us = julianUs % 86400000000L;
        return new Tuple2.mcIJ.sp((int)days, TimeUnit.MICROSECONDS.toNanos(us));
    }

    private final UTF8String gmtUtf8() {
        return gmtUtf8;
    }

    public UTF8String cleanLegacyTimestampStr(UTF8String s) {
        return s.replace(this.gmtUtf8(), UTF8String.EMPTY_UTF8);
    }

    public long doubleToTimestampAnsi(double d, QueryContext context) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw QueryExecutionErrors$.MODULE$.invalidInputInCastToDatetimeError(d, (DataType)TimestampType$.MODULE$, context);
        }
        return DoubleExactNumeric$.MODULE$.toLong(d * (double)1000000L);
    }

    public Option<Object> stringToTimestampWithoutTimeZone(UTF8String s) {
        return this.stringToTimestampWithoutTimeZone(s, true);
    }

    public long stringToTimestampWithoutTimeZoneAnsi(UTF8String s, QueryContext context) {
        return BoxesRunTime.unboxToLong((Object)this.stringToTimestampWithoutTimeZone(s, true).getOrElse((Function0 & Serializable)() -> {
            throw QueryExecutionErrors$.MODULE$.invalidInputInCastToDatetimeError(s, (DataType)TimestampNTZType$.MODULE$, context);
        }));
    }

    public int getHours(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getHour();
    }

    public int getMinutes(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getMinute();
    }

    public int getSeconds(long micros, ZoneId zoneId) {
        return this.getLocalDateTime(micros, zoneId).getSecond();
    }

    public Decimal getSecondsWithFraction(long micros, ZoneId zoneId) {
        return Decimal$.MODULE$.apply((long)this.getMicroseconds(micros, zoneId), 8, 6);
    }

    public int getMicroseconds(long micros, ZoneId zoneId) {
        LocalDateTime lt = this.getLocalDateTime(micros, zoneId);
        return (int)(lt.getLong(ChronoField.MICRO_OF_SECOND) + (long)lt.getSecond() * 1000000L);
    }

    public int getDayInYear(int days) {
        return this.daysToLocalDate(days).getDayOfYear();
    }

    public int getYear(int days) {
        return this.daysToLocalDate(days).getYear();
    }

    public int getWeekBasedYear(int days) {
        return this.daysToLocalDate(days).get(IsoFields.WEEK_BASED_YEAR);
    }

    public int getQuarter(int days) {
        return this.daysToLocalDate(days).get(IsoFields.QUARTER_OF_YEAR);
    }

    public int getMonth(int days) {
        return this.daysToLocalDate(days).getMonthValue();
    }

    public int getDayOfMonth(int days) {
        return this.daysToLocalDate(days).getDayOfMonth();
    }

    public int getDayOfWeek(int days) {
        return LocalDate.ofEpochDay(days).getDayOfWeek().plus(1L).getValue();
    }

    public int getWeekDay(int days) {
        return LocalDate.ofEpochDay(days).getDayOfWeek().ordinal();
    }

    public int getWeekOfYear(int days) {
        return LocalDate.ofEpochDay(days).get(IsoFields.WEEK_OF_WEEK_BASED_YEAR);
    }

    public int dateAddMonths(int days, int months) {
        return this.localDateToDays(this.daysToLocalDate(days).plusMonths(months));
    }

    public UTF8String getMonthName(int days) {
        String monthName = Month.of(this.getMonth(days)).getDisplayName(TextStyle.SHORT, DateFormatter$.MODULE$.defaultLocale());
        return UTF8String.fromString((String)monthName);
    }

    public UTF8String getDayName(int days) {
        String dayName = DayOfWeek.of(this.getWeekDay(days) + 1).getDisplayName(TextStyle.SHORT, DateFormatter$.MODULE$.defaultLocale());
        return UTF8String.fromString((String)dayName);
    }

    public long timestampAddMonths(long micros, int months, ZoneId zoneId) {
        return this.instantToMicros(this.microsToInstant(micros).atZone(zoneId).plusMonths(months).toInstant());
    }

    public long timestampAddDayTime(long micros, long dayTime, ZoneId zoneId) {
        long days = dayTime / 86400000000L;
        long microseconds = dayTime - days * 86400000000L;
        ZonedDateTime resultTimestamp = this.microsToInstant(micros).atZone(zoneId).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.instantToMicros(resultTimestamp.toInstant());
    }

    public long timestampAddInterval(long start, int months, int days, long microseconds, ZoneId zoneId) {
        ZonedDateTime resultTimestamp = this.microsToInstant(start).atZone(zoneId).plusMonths(months).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.instantToMicros(resultTimestamp.toInstant());
    }

    public long timestampNTZAddInterval(long start, int months, int days, long microseconds, ZoneId zoneId) {
        LocalDateTime localDateTime = this.microsToLocalDateTime(start).plusMonths(months).plusDays(days).plus(microseconds, ChronoUnit.MICROS);
        return this.localDateTimeToMicros(localDateTime);
    }

    public int dateAddInterval(int start, CalendarInterval interval) {
        if (interval.microseconds != 0L) {
            throw QueryExecutionErrors$.MODULE$.ansiIllegalArgumentError("Cannot add hours, minutes or seconds, milliseconds, microseconds to a date");
        }
        LocalDate ld = this.daysToLocalDate(start).plusMonths(interval.months).plusDays(interval.days);
        return this.localDateToDays(ld);
    }

    private Tuple4<Object, Object, Object, Object> splitDate(int days) {
        LocalDate ld = this.daysToLocalDate(days);
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)ld.getYear()), (Object)BoxesRunTime.boxToInteger((int)ld.getMonthValue()), (Object)BoxesRunTime.boxToInteger((int)ld.getDayOfMonth()), (Object)BoxesRunTime.boxToInteger((int)(ld.lengthOfMonth() - ld.getDayOfMonth())));
    }

    public double monthsBetween(long micros1, long micros2, boolean roundOff, ZoneId zoneId) {
        int date1 = this.microsToDays(micros1, zoneId);
        int date2 = this.microsToDays(micros2, zoneId);
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date1);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        int year1 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int monthInYear1 = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int dayInMonth1 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int daysToMonthEnd1 = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year1), (Object)BoxesRunTime.boxToInteger((int)monthInYear1), (Object)BoxesRunTime.boxToInteger((int)dayInMonth1), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd1));
        int year12 = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int monthInYear12 = BoxesRunTime.unboxToInt((Object)tuple42._2());
        int dayInMonth12 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int daysToMonthEnd12 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4<Object, Object, Object, Object> tuple43 = this.splitDate(date2);
        if (tuple43 == null) {
            throw new MatchError(tuple43);
        }
        int year2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int dayInMonth2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        Tuple4 tuple44 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear2), (Object)BoxesRunTime.boxToInteger((int)dayInMonth2), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd2));
        int year22 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        int monthInYear22 = BoxesRunTime.unboxToInt((Object)tuple44._2());
        int dayInMonth22 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int daysToMonthEnd22 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        int months1 = year12 * 12 + monthInYear12;
        int months2 = year22 * 12 + monthInYear22;
        double monthDiff = months1 - months2;
        if (dayInMonth12 == dayInMonth22 || daysToMonthEnd12 == 0 && daysToMonthEnd22 == 0) {
            return monthDiff;
        }
        long secondsInDay1 = TimeUnit.MICROSECONDS.toSeconds(micros1 - this.daysToMicros(date1, zoneId));
        long secondsInDay2 = TimeUnit.MICROSECONDS.toSeconds(micros2 - this.daysToMicros(date2, zoneId));
        long secondsDiff = (long)(dayInMonth12 - dayInMonth22) * 86400L + secondsInDay1 - secondsInDay2;
        long secondsInMonth = TimeUnit.DAYS.toSeconds(31L);
        double diff = monthDiff + (double)secondsDiff / (double)secondsInMonth;
        if (roundOff) {
            return (double)package$.MODULE$.round(diff * 1.0E8) / 1.0E8;
        }
        return diff;
    }

    private int SUNDAY() {
        return SUNDAY;
    }

    private int MONDAY() {
        return MONDAY;
    }

    private int TUESDAY() {
        return TUESDAY;
    }

    private int WEDNESDAY() {
        return WEDNESDAY;
    }

    private int THURSDAY() {
        return THURSDAY;
    }

    private int FRIDAY() {
        return FRIDAY;
    }

    private int SATURDAY() {
        return SATURDAY;
    }

    public int getDayOfWeekFromString(UTF8String string) {
        block26: {
            block29: {
                block32: {
                    block28: {
                        block31: {
                            block30: {
                                block27: {
                                    String dowString = string.toString().toUpperCase(Locale.ROOT);
                                    String string2 = dowString;
                                    switch (string2 == null ? 0 : string2.hashCode()) {
                                        case -2015173360: {
                                            if (!"MONDAY".equals(string2)) break block26;
                                            break block27;
                                        }
                                        case -1940284966: {
                                            if (!"THURSDAY".equals(string2)) break block26;
                                            break block28;
                                        }
                                        case -1837857328: {
                                            if ("SUNDAY".equals(string2)) {
                                                break;
                                            }
                                            break block26;
                                        }
                                        case -1331574855: {
                                            if (!"SATURDAY".equals(string2)) break block26;
                                            break block29;
                                        }
                                        case -259361235: {
                                            if (!"TUESDAY".equals(string2)) break block26;
                                            break block30;
                                        }
                                        case -114841802: {
                                            if (!"WEDNESDAY".equals(string2)) break block26;
                                            break block31;
                                        }
                                        case 2252: {
                                            if (!"FR".equals(string2)) break block26;
                                            break block32;
                                        }
                                        case 2466: {
                                            if (!"MO".equals(string2)) break block26;
                                            break block27;
                                        }
                                        case 2638: {
                                            if (!"SA".equals(string2)) break block26;
                                            break block29;
                                        }
                                        case 2658: {
                                            if ("SU".equals(string2)) {
                                                break;
                                            }
                                            break block26;
                                        }
                                        case 2676: {
                                            if (!"TH".equals(string2)) break block26;
                                            break block28;
                                        }
                                        case 2689: {
                                            if (!"TU".equals(string2)) break block26;
                                            break block30;
                                        }
                                        case 2766: {
                                            if (!"WE".equals(string2)) break block26;
                                            break block31;
                                        }
                                        case 69885: {
                                            if (!"FRI".equals(string2)) break block26;
                                            break block32;
                                        }
                                        case 76524: {
                                            if (!"MON".equals(string2)) break block26;
                                            break block27;
                                        }
                                        case 81862: {
                                            if (!"SAT".equals(string2)) break block26;
                                            break block29;
                                        }
                                        case 82476: {
                                            if ("SUN".equals(string2)) {
                                                break;
                                            }
                                            break block26;
                                        }
                                        case 83041: {
                                            if (!"THU".equals(string2)) break block26;
                                            break block28;
                                        }
                                        case 83428: {
                                            if (!"TUE".equals(string2)) break block26;
                                            break block30;
                                        }
                                        case 85814: {
                                            if (!"WED".equals(string2)) break block26;
                                            break block31;
                                        }
                                        case 2082011487: {
                                            if (!"FRIDAY".equals(string2)) break block26;
                                            break block32;
                                        }
                                        default: {
                                            break block26;
                                        }
                                    }
                                    return this.SUNDAY();
                                }
                                return this.MONDAY();
                            }
                            return this.TUESDAY();
                        }
                        return this.WEDNESDAY();
                    }
                    return this.THURSDAY();
                }
                return this.FRIDAY();
            }
            return this.SATURDAY();
        }
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3209", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)string.toString())})));
    }

    public int getNextDateForDayOfWeek(int startDay, int dayOfWeek) {
        return startDay + 1 + ((dayOfWeek - 1 - startDay) % 7 + 7) % 7;
    }

    public int getLastDayOfMonth(int days) {
        LocalDate localDate = this.daysToLocalDate(days);
        return days - localDate.getDayOfMonth() + localDate.lengthOfMonth();
    }

    public int TRUNC_INVALID() {
        return TRUNC_INVALID;
    }

    public int TRUNC_TO_MICROSECOND() {
        return TRUNC_TO_MICROSECOND;
    }

    public int MIN_LEVEL_OF_TIMESTAMP_TRUNC() {
        return MIN_LEVEL_OF_TIMESTAMP_TRUNC;
    }

    public int TRUNC_TO_MILLISECOND() {
        return TRUNC_TO_MILLISECOND;
    }

    public int TRUNC_TO_SECOND() {
        return TRUNC_TO_SECOND;
    }

    public int TRUNC_TO_MINUTE() {
        return TRUNC_TO_MINUTE;
    }

    public int TRUNC_TO_HOUR() {
        return TRUNC_TO_HOUR;
    }

    public int TRUNC_TO_DAY() {
        return TRUNC_TO_DAY;
    }

    public int TRUNC_TO_WEEK() {
        return TRUNC_TO_WEEK;
    }

    public int MIN_LEVEL_OF_DATE_TRUNC() {
        return MIN_LEVEL_OF_DATE_TRUNC;
    }

    public int TRUNC_TO_MONTH() {
        return TRUNC_TO_MONTH;
    }

    public int TRUNC_TO_QUARTER() {
        return TRUNC_TO_QUARTER;
    }

    public int TRUNC_TO_YEAR() {
        return TRUNC_TO_YEAR;
    }

    public int truncDate(int days, int level) {
        int n = level;
        if (this.TRUNC_TO_WEEK() == n) {
            return this.getNextDateForDayOfWeek(days - 7, this.MONDAY());
        }
        if (this.TRUNC_TO_MONTH() == n) {
            return days - this.getDayOfMonth(days) + 1;
        }
        if (this.TRUNC_TO_QUARTER() == n) {
            return this.localDateToDays(this.daysToLocalDate(days).with(IsoFields.DAY_OF_QUARTER, 1L));
        }
        if (this.TRUNC_TO_YEAR() == n) {
            return days - this.getDayInYear(days) + 1;
        }
        throw QueryExecutionErrors$.MODULE$.unreachableError(": Invalid trunc level: " + level);
    }

    private long truncToUnit(long micros, ZoneId zoneId, ChronoUnit unit) {
        ZonedDateTime truncated = this.microsToInstant(micros).atZone(zoneId).truncatedTo(unit);
        return this.instantToMicros(truncated.toInstant());
    }

    public long truncTimestamp(long micros, int level, ZoneId zoneId) {
        int n = level;
        if (this.TRUNC_TO_MICROSECOND() == n) {
            return micros;
        }
        if (this.TRUNC_TO_MILLISECOND() == n) {
            return micros - Math.floorMod(micros, 1000L);
        }
        if (this.TRUNC_TO_SECOND() == n) {
            return micros - Math.floorMod(micros, 1000000L);
        }
        if (this.TRUNC_TO_MINUTE() == n) {
            return this.truncToUnit(micros, zoneId, ChronoUnit.MINUTES);
        }
        if (this.TRUNC_TO_HOUR() == n) {
            return this.truncToUnit(micros, zoneId, ChronoUnit.HOURS);
        }
        if (this.TRUNC_TO_DAY() == n) {
            return this.truncToUnit(micros, zoneId, ChronoUnit.DAYS);
        }
        int dDays = this.microsToDays(micros, zoneId);
        return this.daysToMicros(this.truncDate(dDays, level), zoneId);
    }

    public int parseTruncLevel(UTF8String format) {
        block27: {
            block29: {
                block28: {
                    if (format == null) {
                        return this.TRUNC_INVALID();
                    }
                    String string = format.toString().toUpperCase(Locale.ROOT);
                    switch (string == null ? 0 : string.hashCode()) {
                        case -2020697580: {
                            if ("MINUTE".equals(string)) {
                                return this.TRUNC_TO_MINUTE();
                            }
                            break block27;
                        }
                        case -1852950412: {
                            if ("SECOND".equals(string)) {
                                return this.TRUNC_TO_SECOND();
                            }
                            break block27;
                        }
                        case -199595423: {
                            if ("MILLISECOND".equals(string)) {
                                return this.TRUNC_TO_MILLISECOND();
                            }
                            break block27;
                        }
                        case 2176: {
                            if ("DD".equals(string)) {
                                break;
                            }
                            break block27;
                        }
                        case 2464: {
                            if (!"MM".equals(string)) break block27;
                            break block28;
                        }
                        case 2848: {
                            if (!"YY".equals(string)) break block27;
                            break block29;
                        }
                        case 67452: {
                            if ("DAY".equals(string)) {
                                break;
                            }
                            break block27;
                        }
                        case 76524: {
                            if (!"MON".equals(string)) break block27;
                            break block28;
                        }
                        case 2223588: {
                            if ("HOUR".equals(string)) {
                                return this.TRUNC_TO_HOUR();
                            }
                            break block27;
                        }
                        case 2660340: {
                            if ("WEEK".equals(string)) {
                                return this.TRUNC_TO_WEEK();
                            }
                            break block27;
                        }
                        case 2719805: {
                            if (!"YEAR".equals(string)) break block27;
                            break block29;
                        }
                        case 2739776: {
                            if (!"YYYY".equals(string)) break block27;
                            break block29;
                        }
                        case 73542240: {
                            if (!"MONTH".equals(string)) break block27;
                            break block28;
                        }
                        case 1369386636: {
                            if ("QUARTER".equals(string)) {
                                return this.TRUNC_TO_QUARTER();
                            }
                            break block27;
                        }
                        case 1784607768: {
                            if ("MICROSECOND".equals(string)) {
                                return this.TRUNC_TO_MICROSECOND();
                            }
                            break block27;
                        }
                        default: {
                            break block27;
                        }
                    }
                    return this.TRUNC_TO_DAY();
                }
                return this.TRUNC_TO_MONTH();
            }
            return this.TRUNC_TO_YEAR();
        }
        return this.TRUNC_INVALID();
    }

    public long convertTimestampNtzToAnotherTz(String sourceTz, String targetTz, long micros) {
        LocalDateTime ldt = this.microsToLocalDateTime(micros).atZone(this.getZoneId(sourceTz)).withZoneSameInstant(this.getZoneId(targetTz)).toLocalDateTime();
        return this.localDateTimeToMicros(ldt);
    }

    public long fromUTCTime(long micros, String timeZone) {
        return this.convertTz(micros, ZoneOffset.UTC, this.getZoneId(timeZone));
    }

    public long toUTCTime(long micros, String timeZone) {
        return this.convertTz(micros, this.getZoneId(timeZone), ZoneOffset.UTC);
    }

    public int currentDate(ZoneId zoneId) {
        return this.localDateToDays(LocalDate.now(zoneId));
    }

    private ZonedDateTime today(ZoneId zoneId) {
        return Instant.now().atZone(zoneId).with(LocalTime.MIDNIGHT);
    }

    private Regex specialValueRe() {
        return specialValueRe;
    }

    private Option<String> extractSpecialValue(String input) {
        String z;
        String v;
        Option option;
        Predef$.MODULE$.assert(input.trim().length() == input.length());
        if (input.length() < 3 || !RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(input), 0)))) {
            return None$.MODULE$;
        }
        String string = input;
        if (string != null && !(option = this.specialValueRe().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0 && this.isValid$1(v = (String)((LinearSeqOps)option.get()).apply(0), z = (String)((LinearSeqOps)option.get()).apply(1))) {
            return new Some((Object)v.toLowerCase(Locale.US));
        }
        return None$.MODULE$;
    }

    public Option<Object> convertSpecialTimestamp(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input.trim()).flatMap((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1621979774: {
                    if (!"yesterday".equals(string)) break;
                    return new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).minusDays(1L).toInstant())));
                }
                case -1037172987: {
                    if (!"tomorrow".equals(string)) break;
                    return new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).plusDays(1L).toInstant())));
                }
                case 109270: {
                    if (!"now".equals(string)) break;
                    return new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(Instant.now())));
                }
                case 96722057: {
                    if (!"epoch".equals(string)) break;
                    return new Some((Object)BoxesRunTime.boxToLong((long)0L));
                }
                case 110534465: {
                    if (!"today".equals(string)) break;
                    return new Some((Object)BoxesRunTime.boxToLong((long)MODULE$.instantToMicros(MODULE$.today(zoneId).toInstant())));
                }
            }
            return None$.MODULE$;
        });
    }

    public Option<Object> convertSpecialTimestampNTZ(String input, ZoneId zoneId) {
        Option localDateTime2 = this.extractSpecialValue(input.trim()).flatMap((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1621979774: {
                    if (!"yesterday".equals(string)) break;
                    return new Some((Object)LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT).minusDays(1L));
                }
                case -1037172987: {
                    if (!"tomorrow".equals(string)) break;
                    return new Some((Object)LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT).plusDays(1L));
                }
                case 109270: {
                    if (!"now".equals(string)) break;
                    return new Some((Object)LocalDateTime.now(zoneId));
                }
                case 96722057: {
                    if (!"epoch".equals(string)) break;
                    return new Some((Object)LocalDateTime.of(1970, 1, 1, 0, 0));
                }
                case 110534465: {
                    if (!"today".equals(string)) break;
                    return new Some((Object)LocalDateTime.now(zoneId).with(LocalTime.MIDNIGHT));
                }
            }
            return None$.MODULE$;
        });
        return localDateTime2.map((Function1 & Serializable)localDateTime -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime)));
    }

    public Option<Object> convertSpecialDate(String input, ZoneId zoneId) {
        return this.extractSpecialValue(input.trim()).flatMap((Function1 & Serializable)x0$1 -> {
            block12: {
                String string = x0$1;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1621979774: {
                        if ("yesterday".equals(string)) {
                            return new Some((Object)BoxesRunTime.boxToInteger((int)Math.subtractExact(MODULE$.currentDate(zoneId), 1)));
                        }
                        break block12;
                    }
                    case -1037172987: {
                        if ("tomorrow".equals(string)) {
                            return new Some((Object)BoxesRunTime.boxToInteger((int)Math.addExact(MODULE$.currentDate(zoneId), 1)));
                        }
                        break block12;
                    }
                    case 109270: {
                        if ("now".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    case 96722057: {
                        if ("epoch".equals(string)) {
                            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
                        }
                        break block12;
                    }
                    case 110534465: {
                        if ("today".equals(string)) {
                            break;
                        }
                        break block12;
                    }
                    default: {
                        break block12;
                    }
                }
                return new Some((Object)BoxesRunTime.boxToInteger((int)MODULE$.currentDate(zoneId)));
            }
            return None$.MODULE$;
        });
    }

    public CalendarInterval subtractDates(int endDay, int startDay) {
        Period period = Period.between(this.daysToLocalDate(startDay), this.daysToLocalDate(endDay));
        int months = Math.toIntExact(period.toTotalMonths());
        int days = period.getDays();
        return new CalendarInterval(months, days, 0L);
    }

    public long subtractTimestamps(long endMicros, long startMicros, ZoneId zoneId) {
        LocalDateTime localEndTs = this.getLocalDateTime(endMicros, zoneId);
        LocalDateTime localStartTs = this.getLocalDateTime(startMicros, zoneId);
        return ChronoUnit.MICROS.between(localStartTs, localEndTs);
    }

    public long timestampAdd(String unit, int quantity, long micros, ZoneId zoneId) {
        long l;
        block29: {
            try {
                String string;
                block30: {
                    string = unit.toUpperCase(Locale.ROOT);
                    switch (string == null ? 0 : string.hashCode()) {
                        case -2020697580: {
                            if ("MINUTE".equals(string)) {
                                l = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 60000000L), zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case -1852950412: {
                            if ("SECOND".equals(string)) {
                                l = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 1000000L), zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case -1321778928: {
                            if ("DAYOFYEAR".equals(string)) {
                                break;
                            }
                            break block30;
                        }
                        case -199595423: {
                            if ("MILLISECOND".equals(string)) {
                                l = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 1000L), zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case 67452: {
                            if ("DAY".equals(string)) {
                                break;
                            }
                            break block30;
                        }
                        case 2223588: {
                            if ("HOUR".equals(string)) {
                                l = this.timestampAddInterval(micros, 0, 0, Math.multiplyExact((long)quantity, 3600000000L), zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case 2660340: {
                            if ("WEEK".equals(string)) {
                                l = this.timestampAddInterval(micros, 0, Math.multiplyExact(quantity, 7), 0L, zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case 2719805: {
                            if ("YEAR".equals(string)) {
                                l = this.timestampAddMonths(micros, Math.multiplyExact(quantity, 12), zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case 73542240: {
                            if ("MONTH".equals(string)) {
                                l = this.timestampAddMonths(micros, quantity, zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case 1369386636: {
                            if ("QUARTER".equals(string)) {
                                l = this.timestampAddMonths(micros, Math.multiplyExact(quantity, 3), zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        case 1784607768: {
                            if ("MICROSECOND".equals(string)) {
                                l = this.timestampAddInterval(micros, 0, 0, quantity, zoneId);
                                break block29;
                            }
                            break block30;
                        }
                        default: {
                            break block30;
                        }
                    }
                    l = this.timestampAddInterval(micros, 0, quantity, 0L, zoneId);
                    break block29;
                }
                throw new MatchError((Object)string);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof MatchError) {
                    throw SparkException$.MODULE$.internalError("Got the unexpected unit '" + unit + "'.");
                }
                if (throwable2 instanceof ArithmeticException ? true : throwable2 instanceof DateTimeException) {
                    throw QueryExecutionErrors$.MODULE$.timestampAddOverflowError(micros, quantity, unit);
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    throw SparkException$.MODULE$.internalError("Failure of 'timestampAdd': " + throwable3.getMessage());
                }
                throw throwable;
            }
        }
        return l;
    }

    private Map<String, Function2<Temporal, Temporal, Object>> timestampDiffMap() {
        return timestampDiffMap;
    }

    public long timestampDiff(String unit, long startTs, long endTs, ZoneId zoneId) {
        String unitInUpperCase = unit.toUpperCase(Locale.ROOT);
        if (this.timestampDiffMap().contains((Object)unitInUpperCase)) {
            LocalDateTime startLocalTs = this.getLocalDateTime(startTs, zoneId);
            LocalDateTime endLocalTs = this.getLocalDateTime(endTs, zoneId);
            return BoxesRunTime.unboxToLong((Object)((Function2)this.timestampDiffMap().apply((Object)unitInUpperCase)).apply((Object)startLocalTs, (Object)endLocalTs));
        }
        throw SparkException$.MODULE$.internalError("Got the unexpected unit '" + unit + "'.");
    }

    private final boolean isValid$1(String value, String timeZoneId) {
        boolean bl;
        if (timeZoneId.isEmpty()) {
            return true;
        }
        if (value.compareToIgnoreCase("now") == 0) {
            return false;
        }
        try {
            this.getZoneId(timeZoneId);
            bl = true;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public static final /* synthetic */ long $anonfun$timestampDiffMap$9(Temporal startTs, Temporal endTs) {
        return ChronoUnit.MONTHS.between(startTs, endTs) / 3L;
    }

    private DateTimeUtils$() {
    }
}

