/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class StringUtils$
implements Logging {
    public static final StringUtils$ MODULE$ = new StringUtils$();
    private static final Set<UTF8String> trueStrings;
    private static final Set<UTF8String> falseStrings;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        trueStrings = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t", "true", "y", "yes", "1"}))).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
        falseStrings = (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"f", "false", "n", "no", "0"}))).map((Function1 & Serializable)x$1 -> UTF8String.fromString((String)x$1));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String escapeLikeRegex(String pattern, char escapeChar) {
        Iterator in = StringOps$.MODULE$.iterator$extension(Predef$.MODULE$.augmentString(pattern));
        StringBuilder out = new StringBuilder();
        block3: while (in.hasNext()) {
            char c = BoxesRunTime.unboxToChar((Object)in.next());
            if (c == escapeChar && in.hasNext()) {
                char c2;
                char c3 = c2 = BoxesRunTime.unboxToChar((Object)in.next());
                switch (c3) {
                    case '%': 
                    case '_': {
                        out.$plus$plus$eq(Pattern.quote(Character.toString(c2)));
                        continue block3;
                    }
                }
                if (c3 == escapeChar) {
                    out.$plus$plus$eq(Pattern.quote(Character.toString(c3)));
                    continue;
                }
                throw QueryCompilationErrors$.MODULE$.escapeCharacterInTheMiddleError(pattern, Character.toString(c2));
            }
            if (c == escapeChar) {
                throw QueryCompilationErrors$.MODULE$.escapeCharacterAtTheEndError(pattern);
            }
            if ('_' == c) {
                out.$plus$plus$eq(".");
                continue;
            }
            if ('%' == c) {
                out.$plus$plus$eq(".*");
                continue;
            }
            out.$plus$plus$eq(Pattern.quote(Character.toString(c)));
        }
        return "(?s)" + out.result();
    }

    public String getHexString(byte[] bytes) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("[", " ", "]");
    }

    public Seq<String> orderSuggestedIdentifiersBySimilarity(String baseString, Seq<Seq<String>> candidates) {
        Seq<String> baseParts = UnresolvedAttribute$.MODULE$.parseAttributeName(baseString);
        Seq strippedCandidates = baseParts.size() == 1 && candidates.groupBy((Function1 & Serializable)x$2 -> (Seq)x$2.dropRight(1)).size() == 1 ? (Seq)candidates.map((Function1 & Serializable)x$3 -> (Seq)x$3.takeRight(1)) : (baseParts.size() <= 2 && candidates.groupBy((Function1 & Serializable)x$4 -> (Seq)x$4.dropRight(2)).size() == 1 ? (Seq)candidates.map((Function1 & Serializable)x$5 -> (Seq)x$5.takeRight(2)) : candidates);
        return (Seq)((SeqOps)strippedCandidates.map((Function1 & Serializable)name -> package$.MODULE$.quoteNameParts((Seq<String>)name))).sortBy((Function1 & Serializable)x$6 -> LevenshteinDistance.getDefaultInstance().apply((CharSequence)x$6, (CharSequence)baseString), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public boolean isTrueString(UTF8String s) {
        return trueStrings.contains((Object)s.trimAll().toLowerCase());
    }

    public boolean isFalseString(UTF8String s) {
        return falseStrings.contains((Object)s.trimAll().toLowerCase());
    }

    public Seq<String> filterPattern(Seq<String> names, String pattern) {
        SortedSet funcNames = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering.String$.MODULE$);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])pattern.trim().split("\\|")), (Function1 & Serializable)subPattern -> {
            BoxedUnit boxedUnit;
            try {
                Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?i)" + subPattern.replaceAll("\\*", ".*")));
                boxedUnit = funcNames.$plus$plus$eq((IterableOnce)names.filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)StringUtils$.$anonfun$filterPattern$2(regex, name))));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return funcNames.toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$filterPattern$2(Regex regex$1, String name) {
        return regex$1.pattern().matcher(name).matches();
    }

    private StringUtils$() {
    }
}

