/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

public final class UnsafeRowUtils$ {
    public static final UnsafeRowUtils$ MODULE$ = new UnsafeRowUtils$();

    private Option<String> validateStructuralIntegrityWithReasonImpl(UnsafeRow row, StructType expectedSchema) {
        Option option;
        Object object = new Object();
        try {
            if (expectedSchema.fields().length != row.numFields()) {
                return new Some((Object)("Field length mismatch: expected: " + expectedSchema.fields().length + ", actual: " + row.numFields()));
            }
            int bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
            int rowSizeInBytes = row.getSizeInBytes();
            if (expectedSchema.fields().length > 0 && bitSetWidthInBytes >= rowSizeInBytes) {
                return new Some((Object)("rowSizeInBytes should not exceed bitSetWidthInBytes, bitSetWidthInBytes: " + bitSetWidthInBytes + ", rowSizeInBytes: " + rowSizeInBytes));
            }
            IntRef varLenFieldsSizeInBytes = IntRef.create((int)0);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields()))), (Function1 & Serializable)x0$1 -> {
                UnsafeRowUtils$.$anonfun$validateStructuralIntegrityWithReasonImpl$1(row, bitSetWidthInBytes, rowSizeInBytes, object, varLenFieldsSizeInBytes, x0$1);
                return BoxedUnit.UNIT;
            });
            if (bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem > rowSizeInBytes) {
                return new Some((Object)("Row total length invalid: calculated: " + (bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem) + " rowSizeInBytes: " + rowSizeInBytes));
            }
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Option<String> validateStructuralIntegrityWithReason(UnsafeRow row, StructType expectedSchema) {
        return this.validateStructuralIntegrityWithReasonImpl(row, expectedSchema).map((Function1 & Serializable)errorMessage -> "Error message is: " + errorMessage + ", UnsafeRow status: " + MODULE$.getStructuralIntegrityStatus(row, expectedSchema));
    }

    public Tuple2<Object, Object> getOffsetAndSize(UnsafeRow row, int index) {
        long offsetAndSize = row.getLong(index);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return new Tuple2.mcII.sp(offset, size);
    }

    public boolean avoidSetNullAt(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        if (dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return true;
        }
        return CalendarIntervalType$.MODULE$.equals(dataType);
    }

    public String getStructuralIntegrityStatus(UnsafeRow row, StructType expectedSchema) {
        int minLength = Math.min(row.numFields(), expectedSchema.fields().length);
        String[] fieldStatusArr = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields()), minLength)))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object object;
                StructField field = (StructField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (!UnsafeRow.isFixedLength(field.dataType())) {
                    Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row, index);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    int offset = tuple22._1$mcI$sp();
                    int size = tuple22._2$mcI$sp();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                    int offset2 = sp2._1$mcI$sp();
                    int size2 = sp2._2$mcI$sp();
                    object = "offset: " + offset2 + ", size: " + size2;
                } else {
                    object = "";
                }
                String offsetAndSizeStr = object;
                return "[UnsafeRowFieldStatus] index: " + index + ", expectedFieldType: " + field.dataType() + ", isNull: " + row.isNullAt(index) + ", isFixedLength: " + UnsafeRow.isFixedLength(field.dataType()) + ". " + offsetAndSizeStr;
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class));
        return "[UnsafeRowStatus] expectedSchema: " + expectedSchema + ", expectedSchemaNumFields: " + expectedSchema.fields().length + ", numFields: " + row.numFields() + ", bitSetWidthInBytes: " + UnsafeRow.calculateBitSetWidthInBytes(row.numFields()) + ", rowSizeInBytes: " + row.getSizeInBytes() + "\nfieldStatus:\n" + Predef$.MODULE$.wrapRefArray((Object[])fieldStatusArr).mkString("\n");
    }

    public boolean isBinaryStable(DataType dataType) {
        return !dataType.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)UnsafeRowUtils$.$anonfun$isBinaryStable$1(x0$1)));
    }

    public static final /* synthetic */ void $anonfun$validateStructuralIntegrityWithReasonImpl$1(UnsafeRow row$1, int bitSetWidthInBytes$1, int rowSizeInBytes$1, Object nonLocalReturnKey1$1, IntRef varLenFieldsSizeInBytes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (!UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row$1, index);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                int offset = tuple22._1$mcI$sp();
                int size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                int offset2 = sp2._1$mcI$sp();
                int size2 = sp2._2$mcI$sp();
                if (size2 < 0 || offset2 < bitSetWidthInBytes$1 + 8 * row$1.numFields() || offset2 + size2 > rowSizeInBytes$1) {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Variable-length field validation error: field: " + field + ", index: " + index)));
                }
                varLenFieldsSizeInBytes$1.elem += size2;
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 1 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Fixed-length field validation error: field: " + field + ", index: " + index)));
                    }
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 8 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Fixed-length field validation error: field: " + field + ", index: " + index)));
                    }
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 16 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Fixed-length field validation error: field: " + field + ", index: " + index)));
                    }
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Fixed-length field validation error: field: " + field + ", index: " + index)));
                    }
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Fixed-length field validation error: field: " + field + ", index: " + index)));
                    }
                }
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (row$1.isNullAt(index)) {
                DecimalType decimalType;
                DataType dataType = field.dataType();
                if (dataType instanceof DecimalType && !UnsafeRow.isFixedLength((DataType)(decimalType = (DecimalType)dataType))) {
                    Tuple2<Object, Object> tuple23 = MODULE$.getOffsetAndSize(row$1, index);
                    if (tuple23 == null) {
                        throw new MatchError(tuple23);
                    }
                    int offset = tuple23._1$mcI$sp();
                    int size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(offset, size);
                    int offset3 = sp3._1$mcI$sp();
                    int size3 = sp3._2$mcI$sp();
                    if (size3 != 0 || offset3 != 0 && (offset3 < bitSetWidthInBytes$1 + 8 * row$1.numFields() || offset3 > rowSizeInBytes$1)) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Variable-length decimal field special case validation error: field: " + field + ", index: " + index)));
                    }
                } else if (row$1.getLong(index) != 0L) {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)("Variable-length offset-size validation error: field: " + field + ", index: " + index)));
                }
                return;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$isBinaryStable$1(DataType x0$1) {
        DataType dataType = x0$1;
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return !CollationFactory.fetchCollation((int)stringType.collationId()).supportsBinaryEquality;
        }
        return false;
    }

    private UnsafeRowUtils$() {
    }
}

