/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.catalog.TempVariableManager;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e!\u0002\u0012$\u0001\u001dz\u0003\u0002\u0003\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!Q1A\u0005\u0002%C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006!\u0002!\t!\u0015\u0005\b+\u0002\u0011\r\u0011\"\u0003W\u0011\u0019Q\u0007\u0001)A\u0005/\"91\u000e\u0001b\u0001\n\u0003a\u0007B\u00029\u0001A\u0003%Q\u000eC\u0003%\u0001\u0011\u0005\u0011\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003{\u0001\u0011%1\u0010\u0003\u0004}\u0001\u0011\u0005q% \u0005\b}\u0002\u0001\r\u0011\"\u0003\u0000\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty\u0001\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0015BA\u0001\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0005\u0002*\u0001\u0001\r\u0011\"\u0003\u0002,!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002.!1\u0011q\u0007\u0001\u0005\u0002uDq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002B\u0001!\t!a\u0011\t\u0011\u0005m\u0003\u0001\"\u0001(\u0003;:\u0001\"a\u0018$\u0011\u00039\u0013\u0011\r\u0004\bE\rB\taJA2\u0011\u0019\u0001&\u0004\"\u0001\u0002f!I\u0011q\r\u000eC\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0003WR\u0002\u0015!\u0003`\u0011%\tiG\u0007b\u0001\n\u0003\ty\u0007\u0003\u0005\u0002\u0000i\u0001\u000b\u0011BA9\u0011%\t\tI\u0007b\u0001\n\u0003\ty\u0007\u0003\u0005\u0002\u0004j\u0001\u000b\u0011BA9\u00059\u0019\u0015\r^1m_\u001el\u0015M\\1hKJT!\u0001J\u0013\u0002\u000f\r\fG/\u00197pO*\u0011aeJ\u0001\nG>tg.Z2u_JT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h'\u0011\u0001\u0001G\u000e\u001f\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9$(D\u00019\u0015\tIt%\u0001\u0005dCR\fG._:u\u0013\tY\u0004HA\u0007T#2\u001buN\u001c4IK2\u0004XM\u001d\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f%\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0003z\u0012q\u0001T8hO&tw-A\u000beK\u001a\fW\u000f\u001c;TKN\u001c\u0018n\u001c8DCR\fGn\\4\u0004\u0001A\u0011QIR\u0007\u0002G%\u0011qi\t\u0002\u000e\u0007\u0006$\u0018\r\\8h!2,x-\u001b8\u0002!Y\f4+Z:tS>t7)\u0019;bY><W#\u0001&\u0011\u0005-kU\"\u0001'\u000b\u0005\u0011B\u0014B\u0001(M\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001e\f\u0011C^\u0019TKN\u001c\u0018n\u001c8DCR\fGn\\4!\u0003\u0019a\u0014N\\5u}Q\u0019!k\u0015+\u0011\u0005\u0015\u0003\u0001\"\u0002\"\u0005\u0001\u0004!\u0005\"\u0002%\u0005\u0001\u0004Q\u0015\u0001C2bi\u0006dwnZ:\u0016\u0003]\u0003B\u0001W/`\t6\t\u0011L\u0003\u0002[7\u00069Q.\u001e;bE2,'B\u0001/3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003=f\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002aO:\u0011\u0011-\u001a\t\u0003EJj\u0011a\u0019\u0006\u0003I\u000e\u000ba\u0001\u0010:p_Rt\u0014B\u000143\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u0014\u0014!C2bi\u0006dwnZ:!\u0003M!X-\u001c9WCJL\u0017M\u00197f\u001b\u0006t\u0017mZ3s+\u0005i\u0007CA&o\u0013\tyGJA\nUK6\u0004h+\u0019:jC\ndW-T1oC\u001e,'/\u0001\u000buK6\u0004h+\u0019:jC\ndW-T1oC\u001e,'\u000f\t\u000b\u0003\tJDQa]\u0005A\u0002}\u000bAA\\1nK\u0006\u0019\u0012n]\"bi\u0006dwn\u001a*fO&\u001cH/\u001a:fIR\u0011a/\u001f\t\u0003c]L!\u0001\u001f\u001a\u0003\u000f\t{w\u000e\\3b]\")1O\u0003a\u0001?\u0006!Bn\\1e-J\u001aVm]:j_:\u001c\u0015\r^1m_\u001e$\u0012\u0001R\u0001\u0011mJ\u001aVm]:j_:\u001c\u0015\r^1m_\u001e,\u0012\u0001R\u0001\u0012?\u000e,(O]3oi:\u000bW.Z:qC\u000e,WCAA\u0001!\u0015\t\u00141AA\u0004\u0013\r\t)A\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tE\nIaX\u0005\u0004\u0003\u0017\u0011$!B!se\u0006L\u0018!F0dkJ\u0014XM\u001c;OC6,7\u000f]1dK~#S-\u001d\u000b\u0005\u0003#\t9\u0002E\u00022\u0003'I1!!\u00063\u0005\u0011)f.\u001b;\t\u0013\u0005ea\"!AA\u0002\u0005\u0005\u0011a\u0001=%c\u0005\u0011rlY;se\u0016tGOT1nKN\u0004\u0018mY3!\u0003A\u0019WO\u001d:f]Rt\u0015-\\3ta\u0006\u001cW-\u0006\u0002\u0002\b\u0005\u00192/\u001a;DkJ\u0014XM\u001c;OC6,7\u000f]1dKR!\u0011\u0011CA\u0013\u0011\u001d\t9#\u0005a\u0001\u0003\u000f\t\u0011B\\1nKN\u0004\u0018mY3\u0002'}\u001bWO\u001d:f]R\u001c\u0015\r^1m_\u001et\u0015-\\3\u0016\u0005\u00055\u0002\u0003B\u0019\u0002\u0004}\u000bqcX2veJ,g\u000e^\"bi\u0006dwn\u001a(b[\u0016|F%Z9\u0015\t\u0005E\u00111\u0007\u0005\n\u00033\u0019\u0012\u0011!a\u0001\u0003[\tAcX2veJ,g\u000e^\"bi\u0006dwn\u001a(b[\u0016\u0004\u0013AD2veJ,g\u000e^\"bi\u0006dwnZ\u0001\u0012g\u0016$8)\u001e:sK:$8)\u0019;bY><G\u0003BA\t\u0003{Aa!a\u0010\u0017\u0001\u0004y\u0016aC2bi\u0006dwn\u001a(b[\u0016\fA\u0002\\5ti\u000e\u000bG/\u00197pON$B!!\u0012\u0002XA)\u0011qIA)?:!\u0011\u0011JA'\u001d\r\u0011\u00171J\u0005\u0002g%\u0019\u0011q\n\u001a\u0002\u000fA\f7m[1hK&!\u00111KA+\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001f\u0012\u0004bBA-/\u0001\u0007\u0011QF\u0001\ba\u0006$H/\u001a:o\u0003\u0015\u0011Xm]3u)\t\t\t\"\u0001\bDCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0015S2C\u0001\u000e1)\t\t\t'\u0001\u000bT\u000bN\u001b\u0016j\u0014(`\u0007\u0006#\u0016\tT(H?:\u000bU*R\u000b\u0002?\u0006)2+R*T\u0013>sulQ!U\u00032{ui\u0018(B\u001b\u0016\u0003\u0013aE*Z'R+UjX\"B)\u0006cujR0O\u00036+UCAA9!\u0011\t\u0019(! \u000e\u0005\u0005U$\u0002BA<\u0003s\nA\u0001\\1oO*\u0011\u00111P\u0001\u0005U\u00064\u0018-C\u0002i\u0003k\nAcU-T)\u0016kulQ!U\u00032{ui\u0018(B\u001b\u0016\u0003\u0013!E*F'NKuJT0O\u00036+5\u000bU!D\u000b\u0006\u00112+R*T\u0013>suLT!N\u000bN\u0003\u0016iQ#!\u0001")
public class CatalogManager
implements SQLConfHelper,
Logging {
    private final CatalogPlugin defaultSessionCatalog;
    private final SessionCatalog v1SessionCatalog;
    private final scala.collection.mutable.HashMap<String, CatalogPlugin> catalogs;
    private final TempVariableManager tempVariableManager;
    private Option<String[]> _currentNamespace;
    private Option<String> _currentCatalogName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String SESSION_NAMESPACE() {
        return CatalogManager$.MODULE$.SESSION_NAMESPACE();
    }

    public static String SYSTEM_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SYSTEM_CATALOG_NAME();
    }

    public static String SESSION_CATALOG_NAME() {
        return CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SessionCatalog v1SessionCatalog() {
        return this.v1SessionCatalog;
    }

    private scala.collection.mutable.HashMap<String, CatalogPlugin> catalogs() {
        return this.catalogs;
    }

    public TempVariableManager tempVariableManager() {
        return this.tempVariableManager;
    }

    public synchronized CatalogPlugin catalog(String name) {
        if (name.equalsIgnoreCase(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())) {
            return this.v2SessionCatalog();
        }
        return (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)name, (Function0 & Serializable)() -> Catalogs$.MODULE$.load(name, this.conf()));
    }

    public boolean isCatalogRegistered(String name) {
        boolean bl;
        try {
            this.catalog(name);
            bl = true;
        }
        catch (CatalogNotFoundException catalogNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private CatalogPlugin loadV2SessionCatalog() {
        CatalogPlugin catalogPlugin = Catalogs$.MODULE$.load(CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), this.conf());
        if (catalogPlugin instanceof CatalogExtension) {
            CatalogExtension catalogExtension = (CatalogExtension)catalogPlugin;
            catalogExtension.setDelegateCatalog(this.defaultSessionCatalog);
            return catalogExtension;
        }
        return catalogPlugin;
    }

    public CatalogPlugin v2SessionCatalog() {
        return (CatalogPlugin)this.conf().getConf(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION()).map((Function1 & Serializable)x$1 -> (CatalogPlugin)this.catalogs().getOrElseUpdate((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME(), (Function0 & Serializable)() -> this.loadV2SessionCatalog())).getOrElse((Function0 & Serializable)() -> $this.defaultSessionCatalog);
    }

    private Option<String[]> _currentNamespace() {
        return this._currentNamespace;
    }

    private void _currentNamespace_$eq(Option<String[]> x$1) {
        this._currentNamespace = x$1;
    }

    public String[] currentNamespace() {
        String[] stringArray;
        String string = this.currentCatalog().name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] defaultNamespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{this.v1SessionCatalog().getCurrentDatabase()}) : this.currentCatalog().defaultNamespace();
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            stringArray = (String[])this._currentNamespace().getOrElse((Function0 & Serializable)() -> defaultNamespace);
        }
        return stringArray;
    }

    public synchronized void setCurrentNamespace(String[] namespace) {
        SupportsNamespaces supportsNamespaces;
        CatalogPlugin catalogPlugin = this.currentCatalog();
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog()) && namespace.length == 1) {
            this.v1SessionCatalog().setCurrentDatabase((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])namespace)));
            return;
        }
        if (CatalogV2Util$.MODULE$.isSessionCatalog(this.currentCatalog())) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        if (catalogPlugin instanceof SupportsNamespaces && !(supportsNamespaces = (SupportsNamespaces)catalogPlugin).namespaceExists(namespace)) {
            throw QueryCompilationErrors$.MODULE$.noSuchNamespaceError(namespace);
        }
        this._currentNamespace_$eq((Option<String[]>)new Some((Object)namespace));
    }

    private Option<String> _currentCatalogName() {
        return this._currentCatalogName;
    }

    private void _currentCatalogName_$eq(Option<String> x$1) {
        this._currentCatalogName = x$1;
    }

    public synchronized CatalogPlugin currentCatalog() {
        return this.catalog((String)this._currentCatalogName().getOrElse((Function0 & Serializable)() -> this.conf().getConf(SQLConf$.MODULE$.DEFAULT_CATALOG())));
    }

    public synchronized void setCurrentCatalog(String catalogName) {
        String string = this.currentCatalog().name();
        String string2 = catalogName;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.catalog(catalogName);
            this._currentCatalogName_$eq((Option<String>)new Some((Object)catalogName));
            this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
            this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
            return;
        }
    }

    public Seq<String> listCatalogs(Option<String> pattern) {
        Seq seq;
        CatalogManager catalogManager = this;
        synchronized (catalogManager) {
            seq = this.catalogs().keys().toSeq();
        }
        Seq allCatalogs = (Seq)((SeqOps)((SeqOps)seq.$colon$plus((Object)CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        return (Seq)pattern.map((Function1 & Serializable)x$2 -> StringUtils$.MODULE$.filterPattern((Seq<String>)allCatalogs, (String)x$2)).getOrElse((Function0 & Serializable)() -> allCatalogs);
    }

    public synchronized void reset() {
        this.catalogs().clear();
        this._currentNamespace_$eq((Option<String[]>)None$.MODULE$);
        this._currentCatalogName_$eq((Option<String>)None$.MODULE$);
        this.v1SessionCatalog().setCurrentDatabase(this.conf().defaultDatabase());
    }

    public CatalogManager(CatalogPlugin defaultSessionCatalog, SessionCatalog v1SessionCatalog) {
        this.defaultSessionCatalog = defaultSessionCatalog;
        this.v1SessionCatalog = v1SessionCatalog;
        SQLConfHelper.$init$(this);
        Logging.$init$((Logging)this);
        this.catalogs = HashMap$.MODULE$.empty();
        this.tempVariableManager = new TempVariableManager();
        this._currentNamespace = None$.MODULE$;
        this._currentCatalogName = None$.MODULE$;
    }
}

