/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import java.util.Map;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType;
import org.apache.spark.sql.catalyst.types.PhysicalByteType;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType;
import org.apache.spark.sql.catalyst.types.PhysicalLongType;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalShortType;
import org.apache.spark.sql.catalyst.types.PhysicalStringType;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.sql.vectorized.ColumnarRow;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;

@DeveloperApi
public final class ColumnarBatchRow
extends InternalRow {
    public int rowId;
    private final ColumnVector[] columns;

    public ColumnarBatchRow(ColumnVector[] columns) {
        this.columns = columns;
    }

    @Override
    public int numFields() {
        return this.columns.length;
    }

    @Override
    public InternalRow copy() {
        GenericInternalRow row = new GenericInternalRow(this.columns.length);
        for (int i = 0; i < this.numFields(); ++i) {
            if (this.isNullAt(i)) {
                row.setNullAt(i);
                continue;
            }
            DataType dt = this.columns[i].dataType();
            PhysicalDataType pdt = PhysicalDataType.apply(dt);
            if (pdt instanceof PhysicalBooleanType) {
                row.setBoolean(i, this.getBoolean(i));
                continue;
            }
            if (pdt instanceof PhysicalByteType) {
                row.setByte(i, this.getByte(i));
                continue;
            }
            if (pdt instanceof PhysicalShortType) {
                row.setShort(i, this.getShort(i));
                continue;
            }
            if (pdt instanceof PhysicalIntegerType) {
                row.setInt(i, this.getInt(i));
                continue;
            }
            if (pdt instanceof PhysicalLongType) {
                row.setLong(i, this.getLong(i));
                continue;
            }
            if (pdt instanceof PhysicalFloatType) {
                row.setFloat(i, this.getFloat(i));
                continue;
            }
            if (pdt instanceof PhysicalDoubleType) {
                row.setDouble(i, this.getDouble(i));
                continue;
            }
            if (pdt instanceof PhysicalStringType) {
                row.update(i, this.getUTF8String(i).copy());
                continue;
            }
            if (pdt instanceof PhysicalBinaryType) {
                row.update(i, this.getBinary(i));
                continue;
            }
            if (pdt instanceof PhysicalDecimalType) {
                PhysicalDecimalType t = (PhysicalDecimalType)pdt;
                row.setDecimal(i, this.getDecimal(i, t.precision(), t.scale()), t.precision());
                continue;
            }
            if (pdt instanceof PhysicalStructType) {
                PhysicalStructType t = (PhysicalStructType)pdt;
                row.update(i, this.getStruct(i, t.fields().length).copy());
                continue;
            }
            if (pdt instanceof PhysicalArrayType) {
                row.update(i, this.getArray(i).copy());
                continue;
            }
            if (pdt instanceof PhysicalMapType) {
                row.update(i, this.getMap(i).copy());
                continue;
            }
            throw new RuntimeException("Not implemented. " + dt);
        }
        return row;
    }

    @Override
    public boolean anyNull() {
        throw SparkUnsupportedOperationException.apply();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.columns[ordinal].isNullAt(this.rowId);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.columns[ordinal].getBoolean(this.rowId);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.columns[ordinal].getByte(this.rowId);
    }

    @Override
    public short getShort(int ordinal) {
        return this.columns[ordinal].getShort(this.rowId);
    }

    @Override
    public int getInt(int ordinal) {
        return this.columns[ordinal].getInt(this.rowId);
    }

    @Override
    public long getLong(int ordinal) {
        return this.columns[ordinal].getLong(this.rowId);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.columns[ordinal].getFloat(this.rowId);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.columns[ordinal].getDouble(this.rowId);
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.columns[ordinal].getDecimal(this.rowId, precision, scale);
    }

    @Override
    public UTF8String getUTF8String(int ordinal) {
        return this.columns[ordinal].getUTF8String(this.rowId);
    }

    @Override
    public byte[] getBinary(int ordinal) {
        return this.columns[ordinal].getBinary(this.rowId);
    }

    @Override
    public CalendarInterval getInterval(int ordinal) {
        return this.columns[ordinal].getInterval(this.rowId);
    }

    @Override
    public VariantVal getVariant(int ordinal) {
        return this.columns[ordinal].getVariant(this.rowId);
    }

    @Override
    public ColumnarRow getStruct(int ordinal, int numFields) {
        return this.columns[ordinal].getStruct(this.rowId);
    }

    @Override
    public ColumnarArray getArray(int ordinal) {
        return this.columns[ordinal].getArray(this.rowId);
    }

    @Override
    public ColumnarMap getMap(int ordinal) {
        return this.columns[ordinal].getMap(this.rowId);
    }

    @Override
    public Object get(int ordinal, DataType dataType) {
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType instanceof IntegerType || dataType instanceof YearMonthIntervalType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType || dataType instanceof DayTimeIntervalType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof StringType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType t = (DecimalType)dataType;
            return this.getDecimal(ordinal, t.precision(), t.scale());
        }
        if (dataType instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof TimestampNTZType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return this.getStruct(ordinal, structType.fields().length);
        }
        if (dataType instanceof MapType) {
            return this.getMap(ordinal);
        }
        if (dataType instanceof VariantType) {
            return this.getVariant(ordinal);
        }
        throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3152", Map.of("dataType", String.valueOf(dataType)));
    }

    @Override
    public void update(int ordinal, Object value) {
        throw SparkUnsupportedOperationException.apply();
    }

    @Override
    public void setNullAt(int ordinal) {
        throw SparkUnsupportedOperationException.apply();
    }
}

