/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.BitmapExpressionUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005a2A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0005;!)q\u0005\u0001C\u0005Q!)a\u0006\u0001C\u0005_\tQ\")\u001b;nCB,\u0005\u0010\u001d:fgNLwN\\+uS2\u001c8+^5uK*\u0011q\u0001C\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\n\u0015\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\f\u0019\u0005\u00191/\u001d7\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u00051\u0011\u0001D2sK\u0006$XMQ5u[\u0006\u0004H#\u0001\u0010\u0011\u0007}\u0011C%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0015\t%O]1z!\tyR%\u0003\u0002'A\t!!)\u001f;f\u0003-\u0019G.Z1s\u0005&$X.\u00199\u0015\u0005%b\u0003CA\u0010+\u0013\tY\u0003E\u0001\u0003V]&$\b\"B\u0017\u0004\u0001\u0004q\u0012A\u00022ji6\f\u0007/A\u0007tKR\u0014\u0015\u000e^7ba\nKGo\u001d\u000b\u0005SA\nd\u0007C\u0003.\t\u0001\u0007a\u0004C\u00033\t\u0001\u00071'A\u0004csR,\u0007k\\:\u0011\u0005}!\u0014BA\u001b!\u0005\rIe\u000e\u001e\u0005\u0006o\u0011\u0001\raM\u0001\u0005E&$8\u000f")
public class BitmapExpressionUtilsSuite
extends SparkFunSuite {
    private byte[] createBitmap() {
        return (byte[])Array$.MODULE$.fill(4096, (Function0)(JFunction0.mcB.sp & Serializable)() -> 0, (ClassTag)ClassTag$.MODULE$.Byte());
    }

    private void clearBitmap(byte[] bitmap) {
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.byteArrayOps(bitmap)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            bitmap$1[i] = 0;
        });
    }

    private void setBitmapBits(byte[] bitmap, int bytePos, int bits) {
        bitmap[bytePos] = (byte)(bitmap[bytePos] & 0xFF | bits & 0xFF);
    }

    public BitmapExpressionUtilsSuite() {
        this.test("bitmap_bucket_number with positive inputs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(0L, 0L), new Tuple2.mcJJ.sp(1L, 1L), new Tuple2.mcJJ.sp(2L, 1L), new Tuple2.mcJJ.sp(3L, 1L), new Tuple2.mcJJ.sp(65537L, 3L), new Tuple2.mcJJ.sp(65536L, 2L), new Tuple2.mcJJ.sp(3232423L, 99L), new Tuple2.mcJJ.sp(4538345L, 139L), new Tuple2.mcJJ.sp(845894934L, 25815L), new Tuple2.mcJJ.sp(Integer.MAX_VALUE, 65536L), new Tuple2.mcJJ.sp(Long.MAX_VALUE, 0x1000000000000L), new Tuple2.mcJJ.sp(32768L, 1L), new Tuple2.mcJJ.sp(32769L, 2L), new Tuple2.mcJJ.sp(32770L, 2L)})).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long input = tuple2._1$mcJ$sp();
                long expected = tuple2._2$mcJ$sp();
                long $org_scalatest_assert_macro_left = BitmapExpressionUtils.bitmapBucketNumber((long)input);
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
            }
            throw new MatchError((Object)tuple2);
        }), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24));
        this.test("bitmap_bucket_number with negative inputs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(-1L, 0L), new Tuple2.mcJJ.sp(-2L, 0L), new Tuple2.mcJJ.sp(-3L, 0L), new Tuple2.mcJJ.sp(-65536L, -2L), new Tuple2.mcJJ.sp(65537L, 3L), new Tuple2.mcJJ.sp(-65535L, -1L), new Tuple2.mcJJ.sp(-3843485L, -117L), new Tuple2.mcJJ.sp(-2147483647L, -65535L), new Tuple2.mcJJ.sp(Integer.MIN_VALUE, -65536L), new Tuple2.mcJJ.sp(Long.MIN_VALUE, -281474976710656L), new Tuple2.mcJJ.sp(-9223372036854775807L, -281474976710655L), new Tuple2.mcJJ.sp(-32767L, 0L), new Tuple2.mcJJ.sp(-32768L, -1L), new Tuple2.mcJJ.sp(-32769L, -1L)})).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                long input = tuple2._1$mcJ$sp();
                long expected = tuple2._2$mcJ$sp();
                long $org_scalatest_assert_macro_left = BitmapExpressionUtils.bitmapBucketNumber((long)input);
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            }
            throw new MatchError((Object)tuple2);
        }), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.test("bitmap_bit_position with positive inputs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(0L, 0L), new Tuple2.mcJJ.sp(1L, 0L), new Tuple2.mcJJ.sp(2L, 1L), new Tuple2.mcJJ.sp(3L, 2L), new Tuple2.mcJJ.sp(65537L, 0L), new Tuple2.mcJJ.sp(65536L, 32767L), new Tuple2.mcJJ.sp(3232423L, 21158L), new Tuple2.mcJJ.sp(4538345L, 16360L), new Tuple2.mcJJ.sp(845894934L, 21781L), new Tuple2.mcJJ.sp(Integer.MAX_VALUE, 32766L), new Tuple2.mcJJ.sp(Long.MAX_VALUE, 32766L), new Tuple2.mcJJ.sp(32768L, 32767L), new Tuple2.mcJJ.sp(32769L, 0L), new Tuple2.mcJJ.sp(32770L, 1L)})).foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                long input = tuple2._1$mcJ$sp();
                long expected = tuple2._2$mcJ$sp();
                long $org_scalatest_assert_macro_left = BitmapExpressionUtils.bitmapBitPosition((long)input);
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
            }
            throw new MatchError((Object)tuple2);
        }), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("bitmap_bit_position with negative inputs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(-1L, 1L), new Tuple2.mcJJ.sp(-2L, 2L), new Tuple2.mcJJ.sp(-3L, 3L), new Tuple2.mcJJ.sp(-65536L, 0L), new Tuple2.mcJJ.sp(-65535L, 32767L), new Tuple2.mcJJ.sp(-3843485L, 9629L), new Tuple2.mcJJ.sp(-2147483647L, 32767L), new Tuple2.mcJJ.sp(Integer.MIN_VALUE, 0L), new Tuple2.mcJJ.sp(Long.MIN_VALUE, 0L), new Tuple2.mcJJ.sp(-9223372036854775807L, 32767L), new Tuple2.mcJJ.sp(-32767L, 32767L), new Tuple2.mcJJ.sp(-32768L, 0L), new Tuple2.mcJJ.sp(-32769L, 1L)})).foreach((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                long input = tuple2._1$mcJ$sp();
                long expected = tuple2._2$mcJ$sp();
                long $org_scalatest_assert_macro_left = BitmapExpressionUtils.bitmapBitPosition((long)input);
                long $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            }
            throw new MatchError((Object)tuple2);
        }), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("bitmap_count empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            byte[] bitmap = this.createBitmap();
            long $org_scalatest_assert_macro_left = BitmapExpressionUtils.bitmapCount((byte[])bitmap);
            long $org_scalatest_assert_macro_right = 0L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("bitmap_count", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            byte[] bitmap = this.createBitmap();
            this.setBitmapBits(bitmap, 0, 1);
            long $org_scalatest_assert_macro_left = BitmapExpressionUtils.bitmapCount((byte[])bitmap);
            long $org_scalatest_assert_macro_right = 1L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            this.clearBitmap(bitmap);
            this.setBitmapBits(bitmap, 0, 255);
            long $org_scalatest_assert_macro_left2 = BitmapExpressionUtils.bitmapCount((byte[])bitmap);
            long $org_scalatest_assert_macro_right2 = 8L;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            this.setBitmapBits(bitmap, 1, 34);
            long $org_scalatest_assert_macro_left3 = BitmapExpressionUtils.bitmapCount((byte[])bitmap);
            long $org_scalatest_assert_macro_right3 = 10L;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            this.setBitmapBits(bitmap, bitmap.length - 1, 103);
            long $org_scalatest_assert_macro_left4 = BitmapExpressionUtils.bitmapCount((byte[])bitmap);
            long $org_scalatest_assert_macro_right4 = 15L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        }, new Position("BitmapExpressionUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }
}

