/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Base64;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtilsSuite$TestCase$;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r]a\u0001B-[\u0001\u001dDQ\u0001\u001c\u0001\u0005\u00025Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000fC\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002:\t\u0013\u0005-\u0001A1A\u0005\n\u00055\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0004\u0007\r\u0005]\u0001\u0001QA\r\u0011)\tyD\u0002BK\u0002\u0013\u0005\u0011\u0011\t\u0005\u000b\u0003'2!\u0011#Q\u0001\n\u0005\r\u0003BCA+\r\tU\r\u0011\"\u0001\u0002B!Q\u0011q\u000b\u0004\u0003\u0012\u0003\u0006I!a\u0011\t\u0015\u0005ecA!f\u0001\n\u0003\t\t\u0005\u0003\u0006\u0002\\\u0019\u0011\t\u0012)A\u0005\u0003\u0007B!\"!\u0018\u0007\u0005+\u0007I\u0011AA!\u0011)\tyF\u0002B\tB\u0003%\u00111\t\u0005\u000b\u0003C2!Q3A\u0005\u0002\u0005\u0005\u0003BCA2\r\tE\t\u0015!\u0003\u0002D!Q\u0011Q\r\u0004\u0003\u0016\u0004%\t!a\u001a\t\u0015\u0005=dA!E!\u0002\u0013\tI\u0007\u0003\u0006\u0002r\u0019\u0011)\u001a!C\u0001\u0003OB!\"a\u001d\u0007\u0005#\u0005\u000b\u0011BA5\u0011)\t)H\u0002BK\u0002\u0013\u0005\u0011q\r\u0005\u000b\u0003o2!\u0011#Q\u0001\n\u0005%\u0004BCA=\r\tU\r\u0011\"\u0001\u0002|!Q\u00111\u0011\u0004\u0003\u0012\u0003\u0006I!! \t\r14A\u0011AAC\u0011\u001d\tiJ\u0002C\u0001\u0003?C\u0011\"a*\u0007\u0005\u0004%\t!!+\t\u0011\u0005]f\u0001)A\u0005\u0003WC\u0011\"!/\u0007\u0005\u0004%\t!!+\t\u0011\u0005mf\u0001)A\u0005\u0003WC\u0011\"!0\u0007\u0005\u0004%\t!a0\t\u0011\u0005Eg\u0001)A\u0005\u0003\u0003D\u0011\"a5\u0007\u0005\u0004%\t!a0\t\u0011\u0005Ug\u0001)A\u0005\u0003\u0003D\u0011\"a6\u0007\u0005\u0004%\t!a(\t\u0011\u0005eg\u0001)A\u0005\u0003CC\u0011\"a7\u0007\u0005\u0004%\t!!+\t\u0011\u0005ug\u0001)A\u0005\u0003WC\u0011\"a8\u0007\u0005\u0004%\t!!+\t\u0011\u0005\u0005h\u0001)A\u0005\u0003WC\u0011\"a9\u0007\u0003\u0003%\t!!:\t\u0013\u0005eh!%A\u0005\u0002\u0005m\b\"\u0003B\t\rE\u0005I\u0011AA~\u0011%\u0011\u0019BBI\u0001\n\u0003\tY\u0010C\u0005\u0003\u0016\u0019\t\n\u0011\"\u0001\u0002|\"I!q\u0003\u0004\u0012\u0002\u0013\u0005\u00111 \u0005\n\u000531\u0011\u0013!C\u0001\u00057A\u0011Ba\b\u0007#\u0003%\tAa\u0007\t\u0013\t\u0005b!%A\u0005\u0002\tm\u0001\"\u0003B\u0012\rE\u0005I\u0011\u0001B\u0013\u0011%\u0011ICBA\u0001\n\u0003\u0012Y\u0003C\u0005\u00038\u0019\t\t\u0011\"\u0001\u0003:!I!\u0011\t\u0004\u0002\u0002\u0013\u0005!1\t\u0005\n\u0005\u001f2\u0011\u0011!C!\u0005#B\u0011Ba\u0018\u0007\u0003\u0003%\tA!\u0019\t\u0013\t\u0015d!!A\u0005B\t\u001d\u0004\"\u0003B6\r\u0005\u0005I\u0011\tB7\u0011%\u0011yGBA\u0001\n\u0003\u0012\t\bC\u0005\u0003t\u0019\t\t\u0011\"\u0011\u0003v\u001dI!\u0011\u0010\u0001\u0002\u0002#\u0005!1\u0010\u0004\n\u0003/\u0001\u0011\u0011!E\u0001\u0005{Ba\u0001\\\u001f\u0005\u0002\tU\u0005\"\u0003B8{\u0005\u0005IQ\tB9\u0011%\u00119*PA\u0001\n\u0003\u0013I\nC\u0005\u0003.v\n\n\u0011\"\u0001\u0002|\"I!qV\u001f\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005ck\u0014\u0013!C\u0001\u00057A\u0011Ba->#\u0003%\tAa\u0007\t\u0013\tUV(%A\u0005\u0002\t\u0015\u0002\"\u0003B\\{\u0005\u0005I\u0011\u0011B]\u0011%\u00119-PI\u0001\n\u0003\tY\u0010C\u0005\u0003Jv\n\n\u0011\"\u0001\u0003\u001c!I!1Z\u001f\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005\u001bl\u0014\u0013!C\u0001\u00057A\u0011Ba4>#\u0003%\tA!\n\t\u0013\tE\u0007A1A\u0005\u0002\tM\u0007\u0002\u0003Bq\u0001\u0001\u0006IA!6\t\u0013\t\r\bA1A\u0005\u0002\tM\u0007\u0002\u0003Bs\u0001\u0001\u0006IA!6\t\u000f\t\u001d\b\u0001\"\u0001\u0003j\"9!Q\u001f\u0001\u0005\u0002\t]\b\"\u0003B~\u0001\t\u0007I\u0011\u0001Bj\u0011!\u0011i\u0010\u0001Q\u0001\n\tU\u0007\"\u0003B\u0000\u0001\t\u0007I\u0011\u0001B\u0016\u0011!\u0019\t\u0001\u0001Q\u0001\n\t5\u0002\"CB\u0002\u0001\t\u0007I\u0011\u0001Bj\u0011!\u0019)\u0001\u0001Q\u0001\n\tU\u0007bBB\u0004\u0001\u0011%1\u0011\u0002\u0002\u0019\u000bb\u0004(/Z:tS>t\u0017*\u001c9m+RLGn]*vSR,'BA.]\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005us\u0016\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005}\u0003\u0017aA:rY*\u0011\u0011MY\u0001\u0006gB\f'o\u001b\u0006\u0003G\u0012\fa!\u00199bG\",'\"A3\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001A\u0007CA5k\u001b\u0005\u0001\u0017BA6a\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012A\u001c\t\u0003_\u0002i\u0011AW\u0001\u000bEZ\"D-Z2pI\u0016\u0014X#\u0001:\u0011\u0007M\f\u0019A\u0004\u0002u}:\u0011Qo\u001f\b\u0003mfl\u0011a\u001e\u0006\u0003q\u001a\fa\u0001\u0010:p_Rt\u0014\"\u0001>\u0002\t)\fg/Y\u0005\u0003yv\fA!\u001e;jY*\t!0C\u0002\u0000\u0003\u0003\taAQ1tKZ\"$B\u0001?~\u0013\u0011\t)!a\u0002\u0003\u000f\u0011+7m\u001c3fe*\u0019q0!\u0001\u0002\u0017\t4D\u0007Z3d_\u0012,'\u000fI\u0001\u000bEZ\"TM\\2pI\u0016\u0014XCAA\b!\r\u0019\u0018\u0011C\u0005\u0005\u0003'\t9AA\u0004F]\u000e|G-\u001a:\u0002\u0017\t4D'\u001a8d_\u0012,'\u000f\t\u0002\t)\u0016\u001cHoQ1tKN9a!a\u0007\u0002(\u00055\u0002\u0003BA\u000f\u0003Gi!!a\b\u000b\u0005\u0005\u0005\u0012!B:dC2\f\u0017\u0002BA\u0013\u0003?\u0011a!\u00118z%\u00164\u0007\u0003BA\u000f\u0003SIA!a\u000b\u0002 \t9\u0001K]8ek\u000e$\b\u0003BA\u0018\u0003sqA!!\r\u000269\u0019a/a\r\n\u0005\u0005\u0005\u0012\u0002BA\u001c\u0003?\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0005u\"\u0001D*fe&\fG.\u001b>bE2,'\u0002BA\u001c\u0003?\t\u0011\u0002\u001d7bS:$X\r\u001f;\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001brA!a\u0012\u0002JA\u0019a/a\b\n\t\u0005-\u0013qD\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0013\u0011\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005-\u0013qD\u0001\u000ba2\f\u0017N\u001c;fqR\u0004\u0013aA6fs\u0006!1.Z=!\u0003a\u0011\u0017m]37i\rK\u0007\u000f[3si\u0016DH/\u0012=qK\u000e$X\rZ\u0001\u001aE\u0006\u001cXM\u000e\u001bDSBDWM\u001d;fqR,\u0005\u0010]3di\u0016$\u0007%\u0001\u0003n_\u0012,\u0017!B7pI\u0016\u0004\u0013a\u00029bI\u0012LgnZ\u0001\ta\u0006$G-\u001b8hA\u0005A\u0011N\u001e%fq>\u0003H/\u0006\u0002\u0002jA1\u0011QDA6\u0003\u0007JA!!\u001c\u0002 \t1q\n\u001d;j_:\f\u0011\"\u001b<IKb|\u0005\u000f\u001e\u0011\u0002\r\u0005\fGm\u00149u\u0003\u001d\t\u0017\rZ(qi\u0002\nQ#\u001a=qK\u000e$X\rZ#se>\u00148\t\\1tg>\u0003H/\u0001\ffqB,7\r^3e\u000bJ\u0014xN]\"mCN\u001cx\n\u001d;!\u00039)'O]8s!\u0006\u0014\u0018-\\:NCB,\"!! \u0011\u0011\u0005\u0015\u0013qPA\"\u0003\u0007JA!!!\u0002R\t\u0019Q*\u00199\u0002\u001f\u0015\u0014(o\u001c:QCJ\fWn]'ba\u0002\"B#a\"\u0002\f\u00065\u0015qRAI\u0003'\u000b)*a&\u0002\u001a\u0006m\u0005cAAE\r5\t\u0001\u0001C\u0004\u0002@e\u0001\r!a\u0011\t\u000f\u0005U\u0013\u00041\u0001\u0002D!9\u0011\u0011L\rA\u0002\u0005\r\u0003bBA/3\u0001\u0007\u00111\t\u0005\n\u0003CJ\u0002\u0013!a\u0001\u0003\u0007B\u0011\"!\u001a\u001a!\u0003\u0005\r!!\u001b\t\u0013\u0005E\u0014\u0004%AA\u0002\u0005%\u0004\"CA;3A\u0005\t\u0019AA5\u0011%\tI(\u0007I\u0001\u0002\u0004\ti(A\u0006jg&3H)\u001a4j]\u0016$WCAAQ!\u0011\ti\"a)\n\t\u0005\u0015\u0016q\u0004\u0002\b\u0005>|G.Z1o\u00039\u0001H.Y5oi\u0016DHOQ=uKN,\"!a+\u0011\r\u0005u\u0011QVAY\u0013\u0011\ty+a\b\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005u\u00111W\u0005\u0005\u0003k\u000byB\u0001\u0003CsR,\u0017a\u00049mC&tG/\u001a=u\u0005f$Xm\u001d\u0011\u0002\u0011-,\u0017PQ=uKN\f\u0011b[3z\u0005f$Xm\u001d\u0011\u0002\u0011U$h\rO7pI\u0016,\"!!1\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u0006)A/\u001f9fg*\u0019\u00111\u001a1\u0002\rUt7/\u00194f\u0013\u0011\ty-!2\u0003\u0015U#f\tO*ue&tw-A\u0005vi\u001aDTn\u001c3fA\u0005YQ\u000f\u001e49!\u0006$G-\u001b8h\u00031)HO\u001a\u001dQC\u0012$\u0017N\\4!\u00035!W\r^3s[&t\u0017n\u001d;jG\u0006qA-\u001a;fe6Lg.[:uS\u000e\u0004\u0013aB5w\u0005f$Xm]\u0001\tSZ\u0014\u0015\u0010^3tA\u0005A\u0011-\u00193CsR,7/A\u0005bC\u0012\u0014\u0015\u0010^3tA\u0005!1m\u001c9z)Q\t9)a:\u0002j\u0006-\u0018Q^Ax\u0003c\f\u00190!>\u0002x\"I\u0011qH\u0015\u0011\u0002\u0003\u0007\u00111\t\u0005\n\u0003+J\u0003\u0013!a\u0001\u0003\u0007B\u0011\"!\u0017*!\u0003\u0005\r!a\u0011\t\u0013\u0005u\u0013\u0006%AA\u0002\u0005\r\u0003\"CA1SA\u0005\t\u0019AA\"\u0011%\t)'\u000bI\u0001\u0002\u0004\tI\u0007C\u0005\u0002r%\u0002\n\u00111\u0001\u0002j!I\u0011QO\u0015\u0011\u0002\u0003\u0007\u0011\u0011\u000e\u0005\n\u0003sJ\u0003\u0013!a\u0001\u0003{\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002~*\"\u00111IA\u0000W\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t5QB\u0001B\u0003\u0015\u0011\u00119A!\u0003\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002B\u0006\u0003?\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yA!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iB\u000b\u0003\u0002j\u0005}\u0018AD2paf$C-\u001a4bk2$HeN\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00139\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIe*\"Aa\n+\t\u0005u\u0014q`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0002\u0003\u0002B\u0018\u0005ki!A!\r\u000b\u0007\tMR0\u0001\u0003mC:<\u0017\u0002BA(\u0005c\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u000f\u0011\t\u0005u!QH\u0005\u0005\u0005\u007f\tyBA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003F\t-\u0003\u0003BA\u000f\u0005\u000fJAA!\u0013\u0002 \t\u0019\u0011I\\=\t\u0013\t5S'!AA\u0002\tm\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003TA1!Q\u000bB.\u0005\u000bj!Aa\u0016\u000b\t\te\u0013qD\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B/\u0005/\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0015B2\u0011%\u0011ieNA\u0001\u0002\u0004\u0011)%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B\u0017\u0005SB\u0011B!\u00149\u0003\u0003\u0005\rAa\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u000f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\f\u0002\r\u0015\fX/\u00197t)\u0011\t\tKa\u001e\t\u0013\t53(!AA\u0002\t\u0015\u0013\u0001\u0003+fgR\u001c\u0015m]3\u0011\u0007\u0005%UhE\u0003>\u0005\u007f\u0012Y\t\u0005\r\u0003\u0002\n\u001d\u00151IA\"\u0003\u0007\n\u0019%a\u0011\u0002j\u0005%\u0014\u0011NA?\u0003\u000fk!Aa!\u000b\t\t\u0015\u0015qD\u0001\beVtG/[7f\u0013\u0011\u0011IIa!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\b\u0005\u0003\u0003\u000e\nMUB\u0001BH\u0015\r\u0011\t*`\u0001\u0003S>LA!a\u000f\u0003\u0010R\u0011!1P\u0001\u0006CB\u0004H.\u001f\u000b\u0015\u0003\u000f\u0013YJ!(\u0003 \n\u0005&1\u0015BS\u0005O\u0013IKa+\t\u000f\u0005}\u0002\t1\u0001\u0002D!9\u0011Q\u000b!A\u0002\u0005\r\u0003bBA-\u0001\u0002\u0007\u00111\t\u0005\b\u0003;\u0002\u0005\u0019AA\"\u0011%\t\t\u0007\u0011I\u0001\u0002\u0004\t\u0019\u0005C\u0005\u0002f\u0001\u0003\n\u00111\u0001\u0002j!I\u0011\u0011\u000f!\u0011\u0002\u0003\u0007\u0011\u0011\u000e\u0005\n\u0003k\u0002\u0005\u0013!a\u0001\u0003SB\u0011\"!\u001fA!\u0003\u0005\r!! \u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq\"\u00199qYf$C-\u001a4bk2$HEN\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u0003\u001d)h.\u00199qYf$BAa/\u0003DB1\u0011QDA6\u0005{\u0003b#!\b\u0003@\u0006\r\u00131IA\"\u0003\u0007\n\u0019%!\u001b\u0002j\u0005%\u0014QP\u0005\u0005\u0005\u0003\fyB\u0001\u0004UkBdW-\u000f\u0005\n\u0005\u000b4\u0015\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u0001\ni\u0016\u001cHoQ1tKN,\"A!6\u0011\r\t]'Q\\AD\u001b\t\u0011IN\u0003\u0003\u0003\\\n]\u0013!C5n[V$\u0018M\u00197f\u0013\u0011\u0011yN!7\u0003\u0007M+\u0017/\u0001\u0006uKN$8)Y:fg\u0002\na\"\u001b<BC\u0012$Vm\u001d;DCN,7/A\bjm\u0006\u000bG\rV3ti\u000e\u000b7/Z:!\u0003-!WmY(oYf\u001c\u0015m]3\u0015\t\t-(\u0011\u001f\t\u0005\u0003;\u0011i/\u0003\u0003\u0003p\u0006}!\u0001B+oSRDqAa=Q\u0001\u0004\t9)A\u0001u\u0003))gn\u0019#fG\u000e\u000b7/\u001a\u000b\u0005\u0005W\u0014I\u0010C\u0004\u0003tF\u0003\r!a\"\u0002+Ut7/\u001e9q_J$X\rZ#se>\u00148)Y:fg\u00061RO\\:vaB|'\u000f^3e\u000bJ\u0014xN]\"bg\u0016\u001c\b%\u0001\bng\u001e$\u0016mZ'jg6\fGo\u00195\u0002\u001f5\u001cx\rV1h\u001b&\u001cX.\u0019;dQ\u0002\nAcY8seV\u0004H/\u001a3DSBDWM\u001d;fqR\u001c\u0018!F2peJ,\b\u000f^3e\u0007&\u0004\b.\u001a:uKb$8\u000fI\u0001\u0013G\",7m[#ya\u0016\u001cG/\u001a3FeJ|'\u000f\u0006\u0004\u0003l\u000e-1Q\u0002\u0005\b\u0005gD\u0006\u0019AAD\u0011\u001d\u0019y\u0001\u0017a\u0001\u0007#\t\u0011A\u001a\t\t\u0003;\u0019\u0019\"a\"\u0003l&!1QCA\u0010\u0005%1UO\\2uS>t\u0017\u0007")
public class ExpressionImplUtilsSuite
extends SparkFunSuite {
    private volatile ExpressionImplUtilsSuite$TestCase$ TestCase$module;
    private final Base64.Decoder b64decoder = Base64.getDecoder();
    private final Base64.Encoder b64encoder = Base64.getEncoder();
    private final Seq<TestCase> testCases;
    private final Seq<TestCase> ivAadTestCases;
    private final Seq<TestCase> unsupportedErrorCases;
    private final String msgTagMismatch;
    private final Seq<TestCase> corruptedCiphertexts;

    public ExpressionImplUtilsSuite$TestCase$ TestCase() {
        if (this.TestCase$module == null) {
            this.TestCase$lzycompute$1();
        }
        return this.TestCase$module;
    }

    private Base64.Decoder b64decoder() {
        return this.b64decoder;
    }

    private Base64.Encoder b64encoder() {
        return this.b64encoder;
    }

    public Seq<TestCase> testCases() {
        return this.testCases;
    }

    public Seq<TestCase> ivAadTestCases() {
        return this.ivAadTestCases;
    }

    public void decOnlyCase(TestCase t) {
        String decryptedString;
        byte[] expectedBytes = this.b64decoder().decode(t.base64CiphertextExpected());
        byte[] decryptedBytes = ExpressionImplUtils.aesDecrypt((byte[])expectedBytes, (byte[])t.keyBytes(), (UTF8String)t.utf8mode(), (UTF8String)t.utf8Padding(), (byte[])t.aadBytes());
        String $org_scalatest_assert_macro_left = decryptedString = new String(decryptedBytes);
        String $org_scalatest_assert_macro_right = t.plaintext();
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
    }

    public void encDecCase(TestCase t) {
        String decryptedString;
        byte[] ciphertextBytes = ExpressionImplUtils.aesEncrypt((byte[])t.plaintextBytes(), (byte[])t.keyBytes(), (UTF8String)t.utf8mode(), (UTF8String)t.utf8Padding(), (byte[])t.ivBytes(), (byte[])t.aadBytes());
        String ciphertextBase64 = this.b64encoder().encodeToString(ciphertextBytes);
        byte[] decryptedBytes = ExpressionImplUtils.aesDecrypt((byte[])ciphertextBytes, (byte[])t.keyBytes(), (UTF8String)t.utf8mode(), (UTF8String)t.utf8Padding(), (byte[])t.aadBytes());
        String $org_scalatest_assert_macro_left = decryptedString = new String(decryptedBytes);
        String $org_scalatest_assert_macro_right = t.plaintext();
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        if (t.deterministic()) {
            String $org_scalatest_assert_macro_left2 = t.base64CiphertextExpected();
            String $org_scalatest_assert_macro_right2 = ciphertextBase64;
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            return;
        }
    }

    public Seq<TestCase> unsupportedErrorCases() {
        return this.unsupportedErrorCases;
    }

    public String msgTagMismatch() {
        return this.msgTagMismatch;
    }

    public Seq<TestCase> corruptedCiphertexts() {
        return this.corruptedCiphertexts;
    }

    private void checkExpectedError(TestCase t, Function1<TestCase, BoxedUnit> f) {
        SparkRuntimeException x$1 = (SparkRuntimeException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> f.apply((Object)t), ClassTag$.MODULE$.apply(SparkRuntimeException.class), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        String x$2 = (String)t.expectedErrorClassOpt().get();
        Map<String, String> x$3 = t.errorParamsMap();
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, x$2, x$4, x$3, x$5, x$6);
    }

    private final void TestCase$lzycompute$1() {
        ExpressionImplUtilsSuite expressionImplUtilsSuite = this;
        synchronized (expressionImplUtilsSuite) {
            if (this.TestCase$module == null) {
                this.TestCase$module = new ExpressionImplUtilsSuite$TestCase$(this);
            }
        }
    }

    private final void validateUTF8$1(UTF8String str, UTF8String expected, boolean except) {
        if (except) {
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)this.intercept((Function0 & Serializable)() -> ExpressionImplUtils.validateUTF8String((UTF8String)str), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            String x$2 = "INVALID_UTF8_STRING";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"str"), (Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(str.getBytes()), (Function1 & Serializable)object -> StringOps$.MODULE$.format$extension("\\x%02X", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)object))})), ClassTag$.MODULE$.apply(String.class))).mkString())}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "INVALID_UTF8_STRING", x$4, x$3, x$5, x$6);
            return;
        }
        UTF8String $org_scalatest_assert_macro_left = ExpressionImplUtils.validateUTF8String((UTF8String)str);
        UTF8String $org_scalatest_assert_macro_right = expected;
        UTF8String uTF8String = $org_scalatest_assert_macro_left;
        UTF8String uTF8String2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uTF8String != null ? !uTF8String.equals(uTF8String2) : uTF8String2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
    }

    private static final void tryValidateUTF8$1(UTF8String str, UTF8String expected) {
        UTF8String $org_scalatest_assert_macro_left = ExpressionImplUtils.tryValidateUTF8String((UTF8String)str);
        UTF8String $org_scalatest_assert_macro_right = expected;
        UTF8String uTF8String = $org_scalatest_assert_macro_left;
        UTF8String uTF8String2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uTF8String != null ? !uTF8String.equals(uTF8String2) : uTF8String2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
    }

    public ExpressionImplUtilsSuite() {
        TestCase[] testCaseArray = new TestCase[11];
        testCaseArray[0] = new TestCase(this, "Spark", "abcdefghijklmnop", "4Hv0UKCx6nfUeAoPZo1z+w==", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[1] = new TestCase(this, "Spark", "abcdefghijklmnop12345678", "NeTYNgA+PCQBN50DA//O2w==", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[2] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "9J3iZbIxnmaG+OIA9Amd+A==", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        String x$1 = "Spark";
        String x$2 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$3 = "9J3iZbIxnmaG+OIA9Amd+A==";
        String x$4 = "ECB";
        Some x$5 = new Some((Object)"");
        Some x$6 = new Some((Object)"");
        String x$7 = this.TestCase().apply$default$5();
        Option<String> x$8 = this.TestCase().apply$default$8();
        Map<String, String> x$9 = this.TestCase().apply$default$9();
        testCaseArray[3] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "9J3iZbIxnmaG+OIA9Amd+A==", "ECB", x$7, (Option<String>)x$5, (Option<String>)x$6, x$8, x$9);
        testCaseArray[4] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93KvhY=", "CBC", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        String x$10 = "Spark";
        String x$11 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$12 = "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93KvhY=";
        String x$13 = "CBC";
        Some x$14 = new Some((Object)"");
        Some x$15 = new Some((Object)"");
        String x$16 = this.TestCase().apply$default$5();
        Option<String> x$17 = this.TestCase().apply$default$8();
        Map<String, String> x$18 = this.TestCase().apply$default$9();
        testCaseArray[5] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93KvhY=", "CBC", x$16, (Option<String>)x$14, (Option<String>)x$15, x$17, x$18);
        testCaseArray[6] = new TestCase(this, "Apache Spark", "1234567890abcdef", "2NYmDCjgXTbbxGA3/SnJEfFC/JQ7olk2VQWReIAAFKo=", "CBC", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[7] = new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "y5la3muiuxN2suj6VsYXB+0XUFjtrUD0/zv5eDafsA3U", "GCM", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[8] = new TestCase(this, "This message is longer than a single AES block and should work fine.", "abcdefghijklmnop12345678ABCDEFGH", "agUfTbLT8KPsqbAmQn/YdpohvxqX5bBsfFjtxE5UwqvO6EWSUVyjeDA6r30XyS0ARebsBgXKSExaAVZ40NMgDLQa6/o9pieYwLT5YXI7flU=", "ECB", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[9] = new TestCase(this, "This message is longer than a single AES block and should work fine.", "abcdefghijklmnop12345678ABCDEFGH", "cxUKNdlZa/6hT6gdhp46OThPcdNONdBwJj/Ctl6z4gWVKfcA6DElJg84LbkueIifjNOTloduKgidk9G9a4BDsn0NjlGLUeG8GH1moPWb/+knBC7oT/OOA06W6rJXudDo", "CBC", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        testCaseArray[10] = new TestCase(this, "This message is longer than a single AES block and should work fine.", "abcdefghijklmnop12345678ABCDEFGH", "73B0tHM3F7bvmG7yIZB9vMKnzHyuCYjD9PzAI7NJ+kDBWtaFO22n2cKlkNcCzr45a4Uol+sNtQwQAV7iRhBdt6YmXoviemyXJWOZ89G279SgxabaomEIyN/HZwenxeN4", "GCM", this.TestCase().apply$default$5(), this.TestCase().apply$default$6(), this.TestCase().apply$default$7(), this.TestCase().apply$default$8(), this.TestCase().apply$default$9());
        this.testCases = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])testCaseArray));
        this.test("AesDecrypt Only", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.testCases().map((Function1 & Serializable)t -> {
            this.decOnlyCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("AesEncrypt and AesDecrypt", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.testCases().map((Function1 & Serializable)t -> {
            this.encDecCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        String x$19 = "Spark";
        String x$20 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$21 = "AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg=";
        String x$22 = "CBC";
        Some x$23 = new Some((Object)"00000000000000000000000000000000");
        String x$24 = this.TestCase().apply$default$5();
        Option<String> x$25 = this.TestCase().apply$default$7();
        Option<String> x$26 = this.TestCase().apply$default$8();
        Map<String, String> x$27 = this.TestCase().apply$default$9();
        String x$28 = "Spark";
        String x$29 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$30 = "AAAAAAAAAAAAAAAAQiYi+sRNYDAOTjdSEcYBFsAWPL1f";
        String x$31 = "GCM";
        Some x$32 = new Some((Object)"000000000000000000000000");
        String x$33 = this.TestCase().apply$default$5();
        Option<String> x$34 = this.TestCase().apply$default$7();
        Option<String> x$35 = this.TestCase().apply$default$8();
        Map<String, String> x$36 = this.TestCase().apply$default$9();
        String x$37 = "Spark";
        String x$38 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$39 = "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4";
        String x$40 = "GCM";
        Some x$41 = new Some((Object)"000000000000000000000000");
        Some x$42 = new Some((Object)"This is an AAD mixed into the input");
        String x$43 = this.TestCase().apply$default$5();
        Option<String> x$44 = this.TestCase().apply$default$8();
        Map<String, String> x$45 = this.TestCase().apply$default$9();
        String x$46 = "Spark";
        String x$47 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$48 = "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4";
        String x$49 = "GCM";
        Some x$50 = new Some((Object)"This is an AAD mixed into the input");
        String x$51 = this.TestCase().apply$default$5();
        Option<String> x$52 = this.TestCase().apply$default$6();
        Option<String> x$53 = this.TestCase().apply$default$8();
        Map<String, String> x$54 = this.TestCase().apply$default$9();
        this.ivAadTestCases = new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg=", "CBC", x$24, (Option<String>)x$23, x$25, x$26, x$27), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sRNYDAOTjdSEcYBFsAWPL1f", "GCM", x$33, (Option<String>)x$32, x$34, x$35, x$36), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4", "GCM", x$43, (Option<String>)x$41, (Option<String>)x$42, x$44, x$45), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4", "GCM", x$51, x$52, (Option<String>)x$50, x$53, x$54), (List)Nil$.MODULE$))));
        this.test("AesDecrypt only with IVs or AADs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.ivAadTestCases().map((Function1 & Serializable)t -> {
            this.decOnlyCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("AesEncrypt and AesDecrypt with IVs or AADs", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Seq)this.ivAadTestCases().map((Function1 & Serializable)t -> {
            this.encDecCase(t);
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        String x$55 = "Spark";
        String x$56 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$57 = "unused";
        String x$58 = "ECB";
        Some x$59 = new Some((Object)"0000000000000000");
        Some x$60 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE_IV");
        Map x$61 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"ECB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`")}));
        String x$62 = this.TestCase().apply$default$5();
        Option<String> x$63 = this.TestCase().apply$default$7();
        String x$64 = "Spark";
        String x$65 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$66 = "unused";
        String x$67 = "ECB";
        Some x$68 = new Some((Object)"ECB does not support AAD mode");
        Some x$69 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE_AAD");
        Map x$70 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"ECB"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`")}));
        String x$71 = this.TestCase().apply$default$5();
        Option<String> x$72 = this.TestCase().apply$default$6();
        String x$73 = "Spark";
        String x$74 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$75 = "unused";
        String x$76 = "CBC";
        Some x$77 = new Some((Object)"0000000000");
        Some x$78 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_IV_LENGTH");
        Map x$79 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"CBC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`iv`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualLength"), (Object)"5")}));
        String x$80 = this.TestCase().apply$default$5();
        Option<String> x$81 = this.TestCase().apply$default$7();
        String x$82 = "Spark";
        String x$83 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$84 = "unused";
        String x$85 = "GCM";
        Some x$86 = new Some((Object)"0000000000");
        Some x$87 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_IV_LENGTH");
        Map x$88 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"GCM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`iv`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualLength"), (Object)"5")}));
        String x$89 = this.TestCase().apply$default$5();
        Option<String> x$90 = this.TestCase().apply$default$7();
        String x$91 = "Spark";
        String x$92 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$93 = "unused";
        String x$94 = "GCM";
        String x$95 = "PKCS";
        Some x$96 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE");
        Map x$97 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"GCM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"padding"), (Object)"PKCS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`")}));
        Option<String> x$98 = this.TestCase().apply$default$6();
        Option<String> x$99 = this.TestCase().apply$default$7();
        String x$100 = "Spark";
        String x$101 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$102 = "unused";
        String x$103 = "CBC";
        Some x$104 = new Some((Object)"CBC doesn't support AADs");
        Some x$105 = new Some((Object)"UNSUPPORTED_FEATURE.AES_MODE_AAD");
        Map x$106 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)"CBC"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`")}));
        String x$107 = this.TestCase().apply$default$5();
        Option<String> x$108 = this.TestCase().apply$default$6();
        this.unsupportedErrorCases = new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "ECB", x$62, (Option<String>)x$59, x$63, (Option<String>)x$60, (Map<String, String>)x$61), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "ECB", x$71, x$72, (Option<String>)x$68, (Option<String>)x$69, (Map<String, String>)x$70), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "CBC", x$80, (Option<String>)x$77, x$81, (Option<String>)x$78, (Map<String, String>)x$79), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "GCM", x$89, (Option<String>)x$86, x$90, (Option<String>)x$87, (Map<String, String>)x$88), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "GCM", "PKCS", x$98, x$99, (Option<String>)x$96, (Map<String, String>)x$97), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "unused", "CBC", x$107, x$108, (Option<String>)x$104, (Option<String>)x$105, (Map<String, String>)x$106), (List)Nil$.MODULE$))))));
        this.test("AesEncrypt unsupported errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.unsupportedErrorCases().foreach((Function1 & Serializable)t -> {
            this.checkExpectedError(t, (Function1<TestCase, BoxedUnit>)(Function1 & Serializable)t -> {
                $this.encDecCase(t);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        this.msgTagMismatch = SystemUtils.isJavaVersionAtMost((JavaVersion)JavaVersion.JAVA_17) ? "Tag mismatch!" : "Tag mismatch";
        String x$109 = "Spark";
        String x$110 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$111 = "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93=";
        String x$112 = "CBC";
        Some x$113 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_CRYPTO_ERROR");
        Map x$114 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`expr`, `key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)"Input length must be multiple of 16 when decrypting with padded cipher")}));
        String x$115 = this.TestCase().apply$default$5();
        Option<String> x$116 = this.TestCase().apply$default$6();
        Option<String> x$117 = this.TestCase().apply$default$7();
        String x$118 = "Spark";
        String x$119 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$120 = "y5la3muiuxN2suj6VsYXB+1XUFjtrUD0/zv5eDafsA3U";
        String x$121 = "GCM";
        Some x$122 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_CRYPTO_ERROR");
        Map x$123 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`expr`, `key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)this.msgTagMismatch())}));
        String x$124 = this.TestCase().apply$default$5();
        Option<String> x$125 = this.TestCase().apply$default$6();
        Option<String> x$126 = this.TestCase().apply$default$7();
        String x$127 = "Spark";
        String x$128 = "abcdefghijklmnop12345678ABCDEFGH";
        String x$129 = "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4";
        String x$130 = "GCM";
        Some x$131 = new Some((Object)"The ciphertext is valid, but the AAD is wrong");
        Some x$132 = new Some((Object)"INVALID_PARAMETER_VALUE.AES_CRYPTO_ERROR");
        Map x$133 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)"`expr`, `key`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)"`aes_encrypt`/`aes_decrypt`"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"detailMessage"), (Object)this.msgTagMismatch())}));
        String x$134 = this.TestCase().apply$default$5();
        Option<String> x$135 = this.TestCase().apply$default$6();
        this.corruptedCiphertexts = new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "+MgyzJxhusYVGWCljk7fhhl6C6oUqWmtdqoaG93=", "CBC", x$115, x$116, x$117, (Option<String>)x$113, (Map<String, String>)x$114), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "y5la3muiuxN2suj6VsYXB+1XUFjtrUD0/zv5eDafsA3U", "GCM", x$124, x$125, x$126, (Option<String>)x$122, (Map<String, String>)x$123), (List)new .colon.colon((Object)new TestCase(this, "Spark", "abcdefghijklmnop12345678ABCDEFGH", "AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4", "GCM", x$134, x$135, (Option<String>)x$131, (Option<String>)x$132, (Map<String, String>)x$133), (List)Nil$.MODULE$)));
        this.test("AesEncrypt Expected Errors", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.corruptedCiphertexts().foreach((Function1 & Serializable)t -> {
            this.checkExpectedError(t, (Function1<TestCase, BoxedUnit>)(Function1 & Serializable)t -> {
                $this.decOnlyCase(t);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        this.test("Validate UTF8 string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.validateUTF8$1(UTF8String.EMPTY_UTF8, UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromString((String)"aa"), UTF8String.fromString((String)"aa"), false);
            this.validateUTF8$1(UTF8String.fromString((String)"a"), UTF8String.fromString((String)"a"), false);
            this.validateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromString((String)"abc"), UTF8String.fromString((String)"abc"), false);
            this.validateUTF8$1(UTF8String.fromString((String)"hello"), UTF8String.fromString((String)"hello"), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))), UTF8String.fromString((String)""), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{65}), UTF8String.fromString((String)"A"), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{97}), UTF8String.fromString((String)"a"), false);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)128}), UTF8String.fromString((String)"\ufffd"), true);
            this.validateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)255}), UTF8String.fromString((String)"\ufffd"), true);
        }, new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("TryValidate UTF8 string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"aa"), UTF8String.fromString((String)"aa"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"a"), UTF8String.fromString((String)"a"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.EMPTY_UTF8, UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)""), UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"abc"), UTF8String.fromString((String)"abc"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromString((String)"hello"), UTF8String.fromString((String)"hello"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])((byte[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Byte()))), UTF8String.fromString((String)""));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{65}), UTF8String.fromString((String)"A"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{97}), UTF8String.fromString((String)"a"));
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)128}), null);
            ExpressionImplUtilsSuite.tryValidateUTF8$1(UTF8String.fromBytes((byte[])new byte[]{(byte)255}), null);
        }, new Position("ExpressionImplUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
    }

    public class TestCase
    implements Product,
    Serializable {
        private final String plaintext;
        private final String key;
        private final String base64CiphertextExpected;
        private final String mode;
        private final String padding;
        private final Option<String> ivHexOpt;
        private final Option<String> aadOpt;
        private final Option<String> expectedErrorClassOpt;
        private final Map<String, String> errorParamsMap;
        private final byte[] plaintextBytes;
        private final byte[] keyBytes;
        private final UTF8String utf8mode;
        private final UTF8String utf8Padding;
        private final boolean deterministic;
        private final byte[] ivBytes;
        private final byte[] aadBytes;
        public final /* synthetic */ ExpressionImplUtilsSuite $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String plaintext() {
            return this.plaintext;
        }

        public String key() {
            return this.key;
        }

        public String base64CiphertextExpected() {
            return this.base64CiphertextExpected;
        }

        public String mode() {
            return this.mode;
        }

        public String padding() {
            return this.padding;
        }

        public Option<String> ivHexOpt() {
            return this.ivHexOpt;
        }

        public Option<String> aadOpt() {
            return this.aadOpt;
        }

        public Option<String> expectedErrorClassOpt() {
            return this.expectedErrorClassOpt;
        }

        public Map<String, String> errorParamsMap() {
            return this.errorParamsMap;
        }

        public boolean isIvDefined() {
            return this.ivHexOpt().isDefined() && this.ivHexOpt().get() != null && ((String)this.ivHexOpt().get()).length() > 0;
        }

        public byte[] plaintextBytes() {
            return this.plaintextBytes;
        }

        public byte[] keyBytes() {
            return this.keyBytes;
        }

        public UTF8String utf8mode() {
            return this.utf8mode;
        }

        public UTF8String utf8Padding() {
            return this.utf8Padding;
        }

        public boolean deterministic() {
            return this.deterministic;
        }

        public byte[] ivBytes() {
            return this.ivBytes;
        }

        public byte[] aadBytes() {
            return this.aadBytes;
        }

        public TestCase copy(String plaintext, String key, String base64CiphertextExpected, String mode, String padding, Option<String> ivHexOpt, Option<String> aadOpt, Option<String> expectedErrorClassOpt, Map<String, String> errorParamsMap) {
            return new TestCase(this.org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer(), plaintext, key, base64CiphertextExpected, mode, padding, ivHexOpt, aadOpt, expectedErrorClassOpt, errorParamsMap);
        }

        public String copy$default$1() {
            return this.plaintext();
        }

        public String copy$default$2() {
            return this.key();
        }

        public String copy$default$3() {
            return this.base64CiphertextExpected();
        }

        public String copy$default$4() {
            return this.mode();
        }

        public String copy$default$5() {
            return this.padding();
        }

        public Option<String> copy$default$6() {
            return this.ivHexOpt();
        }

        public Option<String> copy$default$7() {
            return this.aadOpt();
        }

        public Option<String> copy$default$8() {
            return this.expectedErrorClassOpt();
        }

        public Map<String, String> copy$default$9() {
            return this.errorParamsMap();
        }

        public String productPrefix() {
            return "TestCase";
        }

        public int productArity() {
            return 9;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.plaintext();
                }
                case 1: {
                    return this.key();
                }
                case 2: {
                    return this.base64CiphertextExpected();
                }
                case 3: {
                    return this.mode();
                }
                case 4: {
                    return this.padding();
                }
                case 5: {
                    return this.ivHexOpt();
                }
                case 6: {
                    return this.aadOpt();
                }
                case 7: {
                    return this.expectedErrorClassOpt();
                }
                case 8: {
                    return this.errorParamsMap();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestCase;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "plaintext";
                }
                case 1: {
                    return "key";
                }
                case 2: {
                    return "base64CiphertextExpected";
                }
                case 3: {
                    return "mode";
                }
                case 4: {
                    return "padding";
                }
                case 5: {
                    return "ivHexOpt";
                }
                case 6: {
                    return "aadOpt";
                }
                case 7: {
                    return "expectedErrorClassOpt";
                }
                case 8: {
                    return "errorParamsMap";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TestCase)) return false;
            if (((TestCase)object).org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer() != this.org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            TestCase testCase = (TestCase)x$1;
            String string = this.plaintext();
            String string2 = testCase.plaintext();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.key();
            String string4 = testCase.key();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.base64CiphertextExpected();
            String string6 = testCase.base64CiphertextExpected();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.mode();
            String string8 = testCase.mode();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.padding();
            String string10 = testCase.padding();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            Option<String> option = this.ivHexOpt();
            Option<String> option2 = testCase.ivHexOpt();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.aadOpt();
            Option<String> option4 = testCase.aadOpt();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<String> option5 = this.expectedErrorClassOpt();
            Option<String> option6 = testCase.expectedErrorClassOpt();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Map<String, String> map = this.errorParamsMap();
            Map<String, String> map2 = testCase.errorParamsMap();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!testCase.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ExpressionImplUtilsSuite org$apache$spark$sql$catalyst$expressions$ExpressionImplUtilsSuite$TestCase$$$outer() {
            return this.$outer;
        }

        public TestCase(ExpressionImplUtilsSuite $outer, String plaintext, String key, String base64CiphertextExpected, String mode, String padding, Option<String> ivHexOpt, Option<String> aadOpt, Option<String> expectedErrorClassOpt, Map<String, String> errorParamsMap) {
            this.plaintext = plaintext;
            this.key = key;
            this.base64CiphertextExpected = base64CiphertextExpected;
            this.mode = mode;
            this.padding = padding;
            this.ivHexOpt = ivHexOpt;
            this.aadOpt = aadOpt;
            this.expectedErrorClassOpt = expectedErrorClassOpt;
            this.errorParamsMap = errorParamsMap;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.plaintextBytes = plaintext.getBytes("UTF-8");
            this.keyBytes = key.getBytes("UTF-8");
            this.utf8mode = UTF8String.fromString((String)mode);
            this.utf8Padding = UTF8String.fromString((String)padding);
            this.deterministic = mode.equalsIgnoreCase("ECB") || this.isIvDefined();
            this.ivBytes = (byte[])ivHexOpt.map((Function1 & Serializable)ivHex -> Hex$.MODULE$.unhex(ivHex.getBytes("UTF-8"))).getOrElse((Function0 & Serializable)() -> null);
            this.aadBytes = (byte[])aadOpt.map((Function1 & Serializable)aad -> aad.getBytes("UTF-8")).getOrElse((Function0 & Serializable)() -> null);
        }
    }
}

