/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.HexFormat;
import java.util.Locale;
import org.apache.commons.codec.binary.Hex;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class HexBenchmark$
extends BenchmarkBase {
    public static final HexBenchmark$ MODULE$ = new HexBenchmark$();
    private static final Seq<String> hexStrings;
    private static final Seq<byte[]> hexBin;

    static {
        ObjectRef tmp = ObjectRef.create((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"AB", (List)new .colon.colon((Object)"ABC", (List)new .colon.colon((Object)"ABCD", (List)new .colon.colon((Object)"123ABCDEF", (List)Nil$.MODULE$)))))));
        tmp.elem = (Seq)((Seq)tmp.elem).$plus$plus((IterableOnce)((Seq)tmp.elem).map((Function1 & Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(2), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            tmp$1.elem = (Seq)((Seq)tmp$1.elem).$plus$plus((IterableOnce)((Seq)tmp$1.elem).map((Function1 & Serializable)x -> StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(x), i)));
        });
        hexStrings = (Seq)((Seq)tmp.elem).map((Function1 & Serializable)x$2 -> UTF8String.fromString((String)x$2).toString());
        hexBin = (Seq)MODULE$.hexStrings().map((Function1 & Serializable)x$3 -> x$3.getBytes());
    }

    private Seq<String> hexStrings() {
        return hexStrings;
    }

    private Seq<byte[]> hexBin() {
        return hexBin;
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("UnHex Comparison", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int N = 1000000;
            String x$1 = "Cardinality " + N;
            long x$2 = N;
            int x$3 = 3;
            Option x$42 = MODULE$.output();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, 3, x$5, x$62, x$7, x$42);
            benchmark.addCase("Common Codecs", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$5 -> MODULE$.hexStrings().foreach((Function1 & Serializable)y -> MODULE$.apacheDecodeHex((String)y))));
            benchmark.addCase("Java", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$6 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$7 -> MODULE$.hexStrings().foreach((Function1 & Serializable)y -> MODULE$.javaUnhex((String)y))));
            benchmark.addCase("Spark", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$8 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$9 -> MODULE$.hexStrings().foreach((Function1 & Serializable)y -> MODULE$.builtinUnHex((String)y))));
            benchmark.addCase("Spark Binary", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable)x$10 -> RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), N).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$11 -> MODULE$.hexBin().foreach((Function1 & Serializable)y -> MODULE$.builtinUnHex((byte[])y))));
            benchmark.run(benchmark.run$default$1());
        });
    }

    public byte[] apacheDecodeHex(String value) {
        String padding = value.length() % 2 != 0 ? "0" : "";
        return Hex.decodeHex((String)(padding + value));
    }

    public byte[] builtinUnHex(String value) {
        return Hex$.MODULE$.unhex(value);
    }

    public byte[] builtinUnHex(byte[] value) {
        return Hex$.MODULE$.unhex(value);
    }

    public byte[] javaUnhex(String value) {
        String padding = (value.length() & 1) != 0 ? "0" : "";
        return HexFormat.of().parseHex(padding + value);
    }

    private HexBenchmark$() {
    }
}

