/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionEvalHelper;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.PrintToStderr;
import org.apache.spark.sql.catalyst.expressions.RaiseError$;
import org.apache.spark.sql.catalyst.expressions.Uuid;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.scalacheck.Arbitrary;
import org.scalacheck.Gen;
import org.scalacheck.Shrink;
import org.scalacheck.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.enablers.WheneverAsserting;
import org.scalatest.prop.Configuration;
import org.scalatest.prop.Configuration$MaxDiscardedFactor$;
import org.scalatest.prop.Configuration$MinSize$;
import org.scalatest.prop.Configuration$MinSuccessful$;
import org.scalatest.prop.Configuration$PropertyCheckConfiguration$;
import org.scalatest.prop.Configuration$SizeRange$;
import org.scalatest.prop.Configuration$Workers$;
import org.scalatest.prop.Whenever;
import org.scalatestplus.scalacheck.CheckerAsserting;
import org.scalatestplus.scalacheck.ScalaCheckConfiguration;
import org.scalatestplus.scalacheck.ScalaCheckDrivenPropertyChecks;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005q1AAA\u0002\u0001!!)\u0011\u0004\u0001C\u00015\t!R*[:d\u000bb\u0004(/Z:tS>t7oU;ji\u0016T!\u0001B\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\r\u001d\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0004\u0001E)\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011acF\u0007\u0002\u0007%\u0011\u0001d\u0001\u0002\u0015\u000bb\u0004(/Z:tS>tWI^1m\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0001")
public class MiscExpressionsSuite
extends SparkFunSuite
implements ExpressionEvalHelper {
    private String sparkHome;
    private volatile Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration$module;
    private volatile Configuration$MinSuccessful$ MinSuccessful$module;
    private volatile Configuration$MaxDiscardedFactor$ MaxDiscardedFactor$module;
    private volatile Configuration$MinSize$ MinSize$module;
    private volatile Configuration$SizeRange$ SizeRange$module;
    private volatile Configuration$Workers$ Workers$module;
    private Configuration.PropertyCheckConfiguration generatorDrivenConfig;
    private volatile boolean bitmap$0;

    @Override
    public InternalRow create_row(Seq<Object> values) {
        return ExpressionEvalHelper.create_row$(this, values);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Tuple2<?, ?>> entries) {
        return ExpressionEvalHelper.create_map$(this, entries);
    }

    @Override
    public ArrayBasedMapData create_map(Seq<Object> keys, Seq<Object> values) {
        return ExpressionEvalHelper.create_map$(this, keys, values);
    }

    @Override
    public Expression replace(Expression expr) {
        return ExpressionEvalHelper.replace$(this, expr);
    }

    @Override
    public void checkEvaluation(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluation$default$3() {
        return ExpressionEvalHelper.checkEvaluation$default$3$(this);
    }

    @Override
    public boolean checkResult(Object result, Object expected, Expression expression) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, expression);
    }

    @Override
    public boolean checkResult(Object result, Object expected, DataType exprDataType, boolean exprNullable) {
        return ExpressionEvalHelper.checkResult$(this, result, expected, exprDataType, exprNullable);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, String condition, Map<String, String> parameters, ClassTag<T> evidence$1) {
        ExpressionEvalHelper.checkErrorInExpression$((ExpressionEvalHelper)this, expression, condition, parameters, evidence$1);
    }

    @Override
    public <T extends SparkThrowable> Map<String, String> checkErrorInExpression$default$3() {
        return ExpressionEvalHelper.checkErrorInExpression$default$3$(this);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String condition, ClassTag<T> evidence$2) {
        ExpressionEvalHelper.checkErrorInExpression$((ExpressionEvalHelper)this, expression, inputRow, condition, evidence$2);
    }

    @Override
    public <T extends SparkThrowable> void checkErrorInExpression(Function0<Expression> expression, InternalRow inputRow, String condition, Map<String, String> parameters, ClassTag<T> evidence$3) {
        ExpressionEvalHelper.checkErrorInExpression$(this, expression, inputRow, condition, parameters, evidence$3);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, String expectedErrMsg, ClassTag<T> evidence$4) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, expectedErrMsg, evidence$4);
    }

    @Override
    public <T extends Throwable> void checkExceptionInExpression(Function0<Expression> expression, InternalRow inputRow, String expectedErrMsg, ClassTag<T> evidence$5) {
        ExpressionEvalHelper.checkExceptionInExpression$(this, expression, inputRow, expectedErrMsg, evidence$5);
    }

    @Override
    public Object evaluateWithoutCodegen(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithoutCodegen$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithoutCodegen$default$2() {
        return ExpressionEvalHelper.evaluateWithoutCodegen$default$2$(this);
    }

    @Override
    public void checkEvaluationWithoutCodegen(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithoutCodegen$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithoutCodegen$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithoutCodegen$default$3$(this);
    }

    @Override
    public void checkEvaluationWithMutableProjection(Function0<Expression> expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithMutableProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithMutableProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithMutableProjection$default$3$(this);
    }

    @Override
    public Object evaluateWithMutableProjection(Function0<Expression> expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithMutableProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithMutableProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithMutableProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithUnsafeProjection(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithUnsafeProjection$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithUnsafeProjection$default$3$(this);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection(Expression expression, InternalRow inputRow) {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$(this, expression, inputRow);
    }

    @Override
    public InternalRow evaluateWithUnsafeProjection$default$2() {
        return ExpressionEvalHelper.evaluateWithUnsafeProjection$default$2$(this);
    }

    @Override
    public void checkEvaluationWithOptimization(Expression expression, Object expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkEvaluationWithOptimization$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkEvaluationWithOptimization$default$3() {
        return ExpressionEvalHelper.checkEvaluationWithOptimization$default$3$(this);
    }

    @Override
    public void checkDoubleEvaluation(Function0<Expression> expression, TripleEqualsSupport.Spread<Object> expected, InternalRow inputRow) {
        ExpressionEvalHelper.checkDoubleEvaluation$(this, expression, expected, inputRow);
    }

    @Override
    public InternalRow checkDoubleEvaluation$default$3() {
        return ExpressionEvalHelper.checkDoubleEvaluation$default$3$(this);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function1<Expression, Expression> c, DataType dataType) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegenAllowingException(Function2<Expression, Expression, Expression> c, DataType dataType1, DataType dataType2) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegenAllowingException$(this, c, dataType1, dataType2);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function3<Expression, Expression, Expression, Expression> c, DataType dataType1, DataType dataType2, DataType dataType3) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$(this, c, dataType1, dataType2, dataType3);
    }

    @Override
    public void checkConsistencyBetweenInterpretedAndCodegen(Function1<Seq<Expression>, Expression> c, DataType dataType, int minNumElements) {
        ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$((ExpressionEvalHelper)this, c, dataType, minNumElements);
    }

    @Override
    public int checkConsistencyBetweenInterpretedAndCodegen$default$3() {
        return ExpressionEvalHelper.checkConsistencyBetweenInterpretedAndCodegen$default$3$(this);
    }

    @Override
    public void cmpInterpretWithCodegen(InternalRow inputRow, Expression expr, boolean exceptionAllowed) {
        ExpressionEvalHelper.cmpInterpretWithCodegen$(this, inputRow, expr, exceptionAllowed);
    }

    @Override
    public boolean cmpInterpretWithCodegen$default$3() {
        return ExpressionEvalHelper.cmpInterpretWithCodegen$default$3$(this);
    }

    @Override
    public void testBothCodegenAndInterpreted(String name, Function0<BoxedUnit> f) {
        ExpressionEvalHelper.testBothCodegenAndInterpreted$(this, name, f);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$(this);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public ScalaCheckDrivenPropertyChecks.ConfiguredPropertyCheck forAll(Seq<Configuration.PropertyCheckConfigParam> configParams) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, configParams);
    }

    public <A, ASSERTION> Object forAll(Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(String nameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Gen<A> genA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Seq<Configuration.PropertyCheckConfigParam> configParams, Function1<A, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(String nameA, String nameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Seq<Configuration.PropertyCheckConfigParam> configParams, Function2<A, B, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(String nameA, String nameB, String nameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Seq<Configuration.PropertyCheckConfigParam> configParams, Function3<A, B, C, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Seq<Configuration.PropertyCheckConfigParam> configParams, Function4<A, B, C, D, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Seq<Configuration.PropertyCheckConfigParam> configParams, Function5<A, B, C, D, E, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(String nameA, String nameB, String nameC, String nameD, String nameE, String nameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Arbitrary<A> arbA, Shrink<A> shrA, Arbitrary<B> arbB, Shrink<B> shrB, Arbitrary<C> arbC, Shrink<C> shrC, Arbitrary<D> arbD, Shrink<D> shrD, Arbitrary<E> arbE, Shrink<E> shrE, Arbitrary<F> arbF, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, (String)nameA, (String)nameB, (String)nameC, (String)nameD, (String)nameE, (String)nameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, arbA, shrA, arbB, shrB, arbC, shrC, arbD, shrD, arbE, shrE, arbF, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Gen<A> genA, Gen<B> genB, Gen<C> genC, Gen<D> genD, Gen<E> genE, Gen<F> genF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genA, genB, genC, genD, genE, genF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public <A, B, C, D, E, F, ASSERTION> Object forAll(Tuple2<Gen<A>, String> genAndNameA, Tuple2<Gen<B>, String> genAndNameB, Tuple2<Gen<C>, String> genAndNameC, Tuple2<Gen<D>, String> genAndNameD, Tuple2<Gen<E>, String> genAndNameE, Tuple2<Gen<F>, String> genAndNameF, Seq<Configuration.PropertyCheckConfigParam> configParams, Function6<A, B, C, D, E, F, ASSERTION> fun, Configuration.PropertyCheckConfiguration config, Shrink<A> shrA, Shrink<B> shrB, Shrink<C> shrC, Shrink<D> shrD, Shrink<E> shrE, Shrink<F> shrF, CheckerAsserting<ASSERTION> asserting, Prettifier prettifier, Position pos) {
        return ScalaCheckDrivenPropertyChecks.forAll$((ScalaCheckDrivenPropertyChecks)this, genAndNameA, genAndNameB, genAndNameC, genAndNameD, genAndNameE, genAndNameF, configParams, fun, (Configuration.PropertyCheckConfiguration)config, shrA, shrB, shrC, shrD, shrE, shrF, asserting, (Prettifier)prettifier, (Position)pos);
    }

    public Test.Parameters getScalaCheckParams(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return ScalaCheckConfiguration.getScalaCheckParams$((ScalaCheckConfiguration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public Configuration.MinSuccessful minSuccessful(int value) {
        return Configuration.minSuccessful$((Configuration)this, (int)value);
    }

    public Configuration.MaxDiscardedFactor maxDiscardedFactor(double value) {
        return Configuration.maxDiscardedFactor$((Configuration)this, (double)value);
    }

    public Configuration.MinSize minSize(int value) {
        return Configuration.minSize$((Configuration)this, (int)value);
    }

    public Configuration.SizeRange sizeRange(int value) {
        return Configuration.sizeRange$((Configuration)this, (int)value);
    }

    public Configuration.Workers workers(int value) {
        return Configuration.workers$((Configuration)this, (int)value);
    }

    public Configuration.Parameter getParameter(Seq<Configuration.PropertyCheckConfigParam> configParams, Configuration.PropertyCheckConfiguration config) {
        return Configuration.getParameter$((Configuration)this, configParams, (Configuration.PropertyCheckConfiguration)config);
    }

    public <T> Object whenever(boolean condition, Function0<T> fun, WheneverAsserting<T> wa) {
        return Whenever.whenever$((Whenever)this, (boolean)condition, fun, wa);
    }

    private String sparkHome$lzycompute() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public Configuration$PropertyCheckConfiguration$ PropertyCheckConfiguration() {
        if (this.PropertyCheckConfiguration$module == null) {
            this.PropertyCheckConfiguration$lzycompute$1();
        }
        return this.PropertyCheckConfiguration$module;
    }

    public Configuration$MinSuccessful$ MinSuccessful() {
        if (this.MinSuccessful$module == null) {
            this.MinSuccessful$lzycompute$1();
        }
        return this.MinSuccessful$module;
    }

    public Configuration$MaxDiscardedFactor$ MaxDiscardedFactor() {
        if (this.MaxDiscardedFactor$module == null) {
            this.MaxDiscardedFactor$lzycompute$1();
        }
        return this.MaxDiscardedFactor$module;
    }

    public Configuration$MinSize$ MinSize() {
        if (this.MinSize$module == null) {
            this.MinSize$lzycompute$1();
        }
        return this.MinSize$module;
    }

    public Configuration$SizeRange$ SizeRange() {
        if (this.SizeRange$module == null) {
            this.SizeRange$lzycompute$1();
        }
        return this.SizeRange$module;
    }

    public Configuration$Workers$ Workers() {
        if (this.Workers$module == null) {
            this.Workers$lzycompute$1();
        }
        return this.Workers$module;
    }

    public Configuration.PropertyCheckConfiguration generatorDrivenConfig() {
        return this.generatorDrivenConfig;
    }

    public void org$scalatest$prop$Configuration$_setter_$generatorDrivenConfig_$eq(Configuration.PropertyCheckConfiguration x$1) {
        this.generatorDrivenConfig = x$1;
    }

    private final void PropertyCheckConfiguration$lzycompute$1() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (this.PropertyCheckConfiguration$module == null) {
                this.PropertyCheckConfiguration$module = new Configuration$PropertyCheckConfiguration$((Configuration)this);
            }
        }
    }

    private final void MinSuccessful$lzycompute$1() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (this.MinSuccessful$module == null) {
                this.MinSuccessful$module = new Configuration$MinSuccessful$((Configuration)this);
            }
        }
    }

    private final void MaxDiscardedFactor$lzycompute$1() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (this.MaxDiscardedFactor$module == null) {
                this.MaxDiscardedFactor$module = new Configuration$MaxDiscardedFactor$((Configuration)this);
            }
        }
    }

    private final void MinSize$lzycompute$1() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (this.MinSize$module == null) {
                this.MinSize$module = new Configuration$MinSize$((Configuration)this);
            }
        }
    }

    private final void SizeRange$lzycompute$1() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (this.SizeRange$module == null) {
                this.SizeRange$module = new Configuration$SizeRange$((Configuration)this);
            }
        }
    }

    private final void Workers$lzycompute$1() {
        MiscExpressionsSuite miscExpressionsSuite = this;
        synchronized (miscExpressionsSuite) {
            if (this.Workers$module == null) {
                this.Workers$module = new Configuration$Workers$((Configuration)this);
            }
        }
    }

    public MiscExpressionsSuite() {
        Whenever.$init$((Whenever)this);
        Configuration.$init$((Configuration)this);
        ScalaCheckConfiguration.$init$((ScalaCheckConfiguration)this);
        ScalaCheckDrivenPropertyChecks.$init$((ScalaCheckDrivenPropertyChecks)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        ExpressionEvalHelper.$init$(this);
        this.test("RaiseError", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> RaiseError$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)"error message")), package$.MODULE$.EmptyRow(), "error message", ClassTag$.MODULE$.apply(RuntimeException.class));
            this.checkExceptionInExpression((Function0<Expression>)(Function0 & Serializable)() -> RaiseError$.MODULE$.apply((Expression)Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$)), package$.MODULE$.EmptyRow(), "[USER_RAISED_EXCEPTION] null", ClassTag$.MODULE$.apply(RuntimeException.class));
            TypeCheckResult $org_scalatest_assert_macro_left = RaiseError$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)5))).checkInputDataTypes();
            TypeCheckResult.DataTypeMismatch $org_scalatest_assert_macro_right = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)"\"MAP<STRING, STRING>\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)"\"map(errorMessage, 5)\""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"\"MAP<STRING, INT>\"")})));
            TypeCheckResult typeCheckResult = $org_scalatest_assert_macro_left;
            TypeCheckResult.DataTypeMismatch dataTypeMismatch = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(typeCheckResult != null ? !typeCheckResult.equals(dataTypeMismatch) : dataTypeMismatch != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("uuid", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            this.checkEvaluation((Function0<Expression>)(Function0 & Serializable)() -> new Length((Expression)new Uuid((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)))), BoxesRunTime.boxToInteger((int)36), this.checkEvaluation$default$3());
            Random r = new Random();
            Some seed1 = new Some((Object)BoxesRunTime.boxToLong((long)r.nextLong()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.evaluateWithoutCodegen((Expression)new Uuid((Option)seed1), this.evaluateWithoutCodegen$default$2()));
            Object $org_scalatest_assert_macro_right = this.evaluateWithoutCodegen((Expression)new Uuid((Option)seed1), this.evaluateWithoutCodegen$default$2());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.evaluateWithMutableProjection((Function0<Expression>)(Function0 & Serializable)() -> new Uuid((Option)seed1), this.evaluateWithMutableProjection$default$2()));
            Object $org_scalatest_assert_macro_right2 = this.evaluateWithMutableProjection((Function0<Expression>)(Function0 & Serializable)() -> new Uuid((Option)seed1), this.evaluateWithMutableProjection$default$2());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", $org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq($org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.evaluateWithUnsafeProjection((Expression)new Uuid((Option)seed1), this.evaluateWithUnsafeProjection$default$2()));
            InternalRow $org_scalatest_assert_macro_right3 = this.evaluateWithUnsafeProjection((Expression)new Uuid((Option)seed1), this.evaluateWithUnsafeProjection$default$2());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Some seed2 = new Some((Object)BoxesRunTime.boxToLong((long)r.nextLong()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.evaluateWithoutCodegen((Expression)new Uuid((Option)seed1), this.evaluateWithoutCodegen$default$2()));
            Object $org_scalatest_assert_macro_right4 = this.evaluateWithoutCodegen((Expression)new Uuid((Option)seed2), this.evaluateWithoutCodegen$default$2());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!==", $org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$bang$eq$eq($org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(this.evaluateWithMutableProjection((Function0<Expression>)(Function0 & Serializable)() -> new Uuid((Option)seed1), this.evaluateWithMutableProjection$default$2()));
            Object $org_scalatest_assert_macro_right5 = this.evaluateWithMutableProjection((Function0<Expression>)(Function0 & Serializable)() -> new Uuid((Option)seed2), this.evaluateWithMutableProjection$default$2());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "!==", $org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$bang$eq$eq($org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(this.evaluateWithUnsafeProjection((Expression)new Uuid((Option)seed1), this.evaluateWithUnsafeProjection$default$2()));
            InternalRow $org_scalatest_assert_macro_right6 = this.evaluateWithUnsafeProjection((Expression)new Uuid((Option)seed2), this.evaluateWithUnsafeProjection$default$2());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        }, new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("PrintToStderr", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String outputCodegen;
            Tuple2 tuple2;
            Literal inputExpr = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
            PrintStream systemErr = System.err;
            try {
                ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
                System.setErr(new PrintStream(errorStream));
                this.checkEvaluationWithoutCodegen((Expression)new PrintToStderr((Expression)inputExpr), BoxesRunTime.boxToInteger((int)1), this.checkEvaluationWithoutCodegen$default$3());
                String outputEval = errorStream.toString();
                errorStream.reset();
                this.checkEvaluationWithMutableProjection((Function0<Expression>)(Function0 & Serializable)() -> new PrintToStderr((Expression)inputExpr), BoxesRunTime.boxToInteger((int)1), this.checkEvaluationWithMutableProjection$default$3());
                String outputCodegen2 = errorStream.toString();
                tuple2 = new Tuple2((Object)outputEval, (Object)outputCodegen2);
            }
            finally {
                System.setErr(systemErr);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String outputEval = (String)tuple22._1();
            String outputCodegen3 = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)outputEval, (Object)outputCodegen3);
            String outputEval2 = (String)tuple23._1();
            String $org_scalatest_assert_macro_left = outputCodegen = (String)tuple23._2();
            String $org_scalatest_assert_macro_right = "Result of " + inputExpr + " is 1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            String $org_scalatest_assert_macro_left2 = outputEval2;
            String $org_scalatest_assert_macro_right2 = "Result of " + inputExpr + " is 1";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("MiscExpressionsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        Statics.releaseFence();
    }
}

