/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.codegen;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.VariantVal;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0005E2Aa\u0001\u0003\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\t!RK\\:bM\u0016\u0014vn^,sSR,'oU;ji\u0016T!!\u0002\u0004\u0002\u000f\r|G-Z4f]*\u0011q\u0001C\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\n\u0015\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\f\u0019\u0005\u00191/\u001d7\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u0019%\u0011q\u0003\u0004\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005!\u0011aF2iK\u000e\\G)Z2j[\u0006d7+\u001b>f\u0013:\u0014\u0015\u0010^3t)\rqB\u0005\f\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0005+:LG\u000fC\u0003&\u0005\u0001\u0007a%A\u0004eK\u000eLW.\u00197\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%R\u0011!\u0002;za\u0016\u001c\u0018BA\u0016)\u0005\u001d!UmY5nC2DQ!\f\u0002A\u00029\n\u0001B\\;n\u0005f$Xm\u001d\t\u0003?=J!\u0001\r\u0011\u0003\u0007%sG\u000f")
public class UnsafeRowWriterSuite
extends SparkFunSuite {
    public void checkDecimalSizeInBytes(Decimal decimal, int numBytes) {
        byte[] $org_scalatest_assert_macro_left = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        int $org_scalatest_assert_macro_right = numBytes;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
    }

    public UnsafeRowWriterSuite() {
        this.test("SPARK-25538: zero-out all bits for decimals", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Decimal decimal1 = Decimal$.MODULE$.apply(0.431);
            decimal1.changePrecision(38, 18);
            this.checkDecimalSizeInBytes(decimal1, 8);
            Decimal decimal2 = Decimal$.MODULE$.apply(1.2345678912324569E8);
            decimal2.changePrecision(38, 18);
            this.checkDecimalSizeInBytes(decimal2, 11);
            UnsafeRowWriter unsafeRowWriter1 = new UnsafeRowWriter(1);
            unsafeRowWriter1.resetRowWriter();
            unsafeRowWriter1.write(0, decimal2, decimal2.precision(), decimal2.scale());
            unsafeRowWriter1.reset();
            unsafeRowWriter1.write(0, decimal1, decimal1.precision(), decimal1.scale());
            UnsafeRow res1 = unsafeRowWriter1.getRow();
            UnsafeRowWriter unsafeRowWriter2 = new UnsafeRowWriter(1);
            unsafeRowWriter2.resetRowWriter();
            unsafeRowWriter2.write(0, decimal1, decimal1.precision(), decimal1.scale());
            UnsafeRow res2 = unsafeRowWriter2.getRow();
            UnsafeRow $org_scalatest_assert_macro_left = res1;
            UnsafeRow $org_scalatest_assert_macro_right = res2;
            UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
            UnsafeRow unsafeRow2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(unsafeRow != null ? !unsafeRow.equals(unsafeRow2) : unsafeRow2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        }, new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("write and get calendar intervals through UnsafeRowWriter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            UnsafeRowWriter rowWriter = new UnsafeRowWriter(2);
            rowWriter.resetRowWriter();
            rowWriter.write(0, null);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rowWriter.getRow().isNullAt(0), "rowWriter.getRow().isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rowWriter.getRow().getInterval(0));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            CalendarInterval interval = new CalendarInterval(0, 1, 0L);
            rowWriter.write(1, interval);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rowWriter.getRow().getInterval(1));
            CalendarInterval $org_scalatest_assert_macro_right2 = interval;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        this.test("write and get variant through UnsafeRowWriter", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            UnsafeRowWriter rowWriter = new UnsafeRowWriter(2);
            rowWriter.resetRowWriter();
            rowWriter.setNullAt(0);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rowWriter.getRow().isNullAt(0), "rowWriter.getRow().isNullAt(0)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rowWriter.getRow().getVariant(0));
            Null$ $org_scalatest_assert_macro_right = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            VariantVal variant = new VariantVal(new byte[]{1, 2, 3}, new byte[]{-1, -2, -3, -4});
            rowWriter.write(1, variant);
            String $org_scalatest_assert_macro_left2 = rowWriter.getRow().getVariant(1).debugString();
            String $org_scalatest_assert_macro_right2 = variant.debugString();
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("UnsafeRowWriterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }
}

