/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.xml.UDFXPathUtil;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00052Aa\u0001\u0003\u0001'!)\u0001\u0004\u0001C\u00013!AA\u0004\u0001EC\u0002\u0013%QDA\tV\t\u001aC\u0006+\u0019;i+RLGnU;ji\u0016T!!\u0002\u0004\u0002\u0007alGN\u0003\u0002\b\u0011\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI!\"\u0001\u0005dCR\fG._:u\u0015\tYA\"A\u0002tc2T!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\tA\"\u0003\u0002\u0018\u0019\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0003\u0002\tU$\u0018\u000e\\\u000b\u0002=A\u00111dH\u0005\u0003A\u0011\u0011A\"\u0016#G1B\u000bG\u000f[+uS2\u0004")
public class UDFXPathUtilSuite
extends SparkFunSuite {
    private UDFXPathUtil util;
    private volatile boolean bitmap$0;

    private UDFXPathUtil util$lzycompute() {
        UDFXPathUtilSuite uDFXPathUtilSuite = this;
        synchronized (uDFXPathUtilSuite) {
            if (!this.bitmap$0) {
                this.util = new UDFXPathUtil();
                this.bitmap$0 = true;
            }
        }
        return this.util;
    }

    private UDFXPathUtil util() {
        if (!this.bitmap$0) {
            return this.util$lzycompute();
        }
        return this.util;
    }

    public UDFXPathUtilSuite() {
        this.test("illegal arguments", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object $org_scalatest_assert_macro_left = this.util().eval(null, "a/text()", XPathConstants.STRING);
            Object $org_scalatest_assert_macro_right = null;
            Object object = $org_scalatest_assert_macro_left;
            Object var4_3 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var4_3) : var4_3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Object $org_scalatest_assert_macro_left2 = this.util().eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", null, XPathConstants.STRING);
            Object $org_scalatest_assert_macro_right2 = null;
            Object object2 = $org_scalatest_assert_macro_left2;
            Object var8_7 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var8_7) : var8_7 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
            Object $org_scalatest_assert_macro_left3 = this.util().eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/text()", null);
            Object $org_scalatest_assert_macro_right3 = null;
            Object object3 = $org_scalatest_assert_macro_left3;
            Object var12_11 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "==", null, !(object3 != null ? !object3.equals(var12_11) : var12_11 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            Object $org_scalatest_assert_macro_left4 = this.util().eval("", "a/text()", XPathConstants.STRING);
            Object $org_scalatest_assert_macro_right4 = null;
            Object object4 = $org_scalatest_assert_macro_left4;
            Object var16_15 = null;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", null, !(object4 != null ? !object4.equals(var16_15) : var16_15 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            Object $org_scalatest_assert_macro_left5 = this.util().eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "", XPathConstants.STRING);
            Object $org_scalatest_assert_macro_right5 = null;
            Object object5 = $org_scalatest_assert_macro_left5;
            Object var20_19 = null;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left5, "==", null, !(object5 != null ? !object5.equals(var20_19) : var20_19 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            return (RuntimeException)this.intercept((Function0 & Serializable)() -> this.util().eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/text(", XPathConstants.STRING), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("generic eval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Object ret;
            Object $org_scalatest_assert_macro_left = ret = this.util().eval("<a><b>b1</b><b>b2</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/c[2]/text()", XPathConstants.STRING);
            String $org_scalatest_assert_macro_right = "c2";
            Object object = $org_scalatest_assert_macro_left;
            String string = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(string) : string != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("boolean eval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Boolean ret = this.util().evalBoolean("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[1]/text()");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(ret), "scala.Predef.Boolean2boolean(ret)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Boolean $org_scalatest_assert_macro_left = ret = this.util().evalBoolean("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[4]");
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("string eval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String ret;
            String $org_scalatest_assert_macro_left = ret = this.util().evalString("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[3]/text()");
            String $org_scalatest_assert_macro_right = "b3";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            String $org_scalatest_assert_macro_left2 = ret = this.util().evalString("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[4]/text()");
            String $org_scalatest_assert_macro_right2 = "";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            String $org_scalatest_assert_macro_left3 = ret = this.util().evalString("<a><b>true</b><b k=\"foo\">FALSE</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[2]/@k");
            String $org_scalatest_assert_macro_right3 = "foo";
            String string5 = $org_scalatest_assert_macro_left3;
            String string6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("embedFailure", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String evaled;
            String secretValue = String.valueOf(Math.random());
            File tempFile = File.createTempFile("verifyembed", ".tmp");
            tempFile.deleteOnExit();
            String fname = tempFile.getAbsolutePath();
            FileUtils.writeStringToFile((File)tempFile, (String)secretValue, (Charset)StandardCharsets.UTF_8);
            String xml = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n        |<!DOCTYPE test [\n        |    <!ENTITY embed SYSTEM \"" + fname + "\">\n        |]>\n        |<foo>&embed;</foo>\n      "));
            String $org_scalatest_assert_macro_left = evaled = new UDFXPathUtil().evalString(xml, "/foo");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("number eval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Double ret;
            Double $org_scalatest_assert_macro_left = ret = this.util().evalNumber("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>-77</c></a>", "a/c[2]");
            double $org_scalatest_assert_macro_right = -77.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), BoxesRunTime.equalsNumObject((Number)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            ret = this.util().evalNumber("<a><b>true</b><b k=\"foo\">FALSE</b><b>b3</b><c>c1</c><c>c2</c></a>", "a/b[2]/@k");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ret.isNaN(), "ret.isNaN()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("node eval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            Node ret;
            Node $org_scalatest_assert_macro_left = ret = this.util().evalNode("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>-77</c></a>", "a/c[2]");
            Object $org_scalatest_assert_macro_right = null;
            Node node = $org_scalatest_assert_macro_left;
            Object var6_4 = null;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, node == null ? var6_4 != null : !node.equals(var6_4), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                Node $org_scalatest_assert_macro_left3 = ret;
                bool = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.w3c.dom.Node", $org_scalatest_assert_macro_left3 instanceof Node, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right2 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("node list eval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            NodeList ret;
            NodeList $org_scalatest_assert_macro_left = ret = this.util().evalNodeList("<a><b>true</b><b>false</b><b>b3</b><c>c1</c><c>-77</c></a>", "a/*");
            Object $org_scalatest_assert_macro_right = null;
            NodeList nodeList = $org_scalatest_assert_macro_left;
            Object var6_4 = null;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, nodeList == null ? var6_4 != null : !nodeList.equals(var6_4), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                NodeList $org_scalatest_assert_macro_left3 = ret;
                bool = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.w3c.dom.NodeList", $org_scalatest_assert_macro_left3 instanceof NodeList, Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right2 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            int $org_scalatest_assert_macro_left4 = ret.getLength();
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("UDFXPathUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
    }
}

