/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000592AAB\u0004\u0001)!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002BB\u0014\u0001A\u0003%q\u0004C\u0004)\u0001\t\u0007I\u0011A\u0015\t\r5\u0002\u0001\u0015!\u0003+\u0005UQ\u0015mY6t_:<UM\\3sCR|'oU;ji\u0016T!\u0001C\u0005\u0002\t)\u001cxN\u001c\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\f\u000e\u00035I!\u0001G\u0007\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\tq!A\u0003vi\u000eLE-F\u0001 !\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0003mC:<'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012aa\u0015;sS:<\u0017AB;uG&#\u0007%\u0001\u0004paRLwN\\\u000b\u0002UA\u0011AdK\u0005\u0003Y\u001d\u00111BS*P\u001d>\u0003H/[8og\u00069q\u000e\u001d;j_:\u0004\u0003")
public class JacksonGeneratorSuite
extends SparkFunSuite {
    private final String utcId = DateTimeUtils$.MODULE$.TimeZoneUTC().getID();
    private final JSONOptions option = new JSONOptions(Predef$.MODULE$.Map().empty(), this.utcId(), JSONOptions$.MODULE$.$lessinit$greater$default$3());

    public String utcId() {
        return this.utcId;
    }

    public JSONOptions option() {
        return this.option;
    }

    public JacksonGeneratorSuite() {
        this.test("initial with StructType and write out a row", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            InternalRow input = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            gen.write(input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "{\"a\":1}";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("SPARK-29444: initial with StructType and write out an empty row with ignoreNullFields=false", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            InternalRow input = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}));
            CharArrayWriter writer = new CharArrayWriter();
            JSONOptions allowNullOption = new JSONOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ignoreNullFields"), (Object)"false")})), this.utcId(), JSONOptions$.MODULE$.$lessinit$greater$default$3());
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, allowNullOption);
            gen.write(input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "{\"a\":null}";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("SPARK-29444: initial with StructType field and write out a row with ignoreNullFields=false and struct inner null", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType fieldType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            StructField structField2 = new StructField("a", (DataType)fieldType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField2));
            InternalRow input = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}))}));
            CharArrayWriter writer = new CharArrayWriter();
            JSONOptions allowNullOption = new JSONOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ignoreNullFields"), (Object)"false")})), this.utcId(), JSONOptions$.MODULE$.$lessinit$greater$default$3());
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, allowNullOption);
            gen.write(input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "{\"a\":{\"b\":null}}";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("initial with StructType and write out rows", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            InternalRow internalRow = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            InternalRow internalRow2 = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
            GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$.$colon$colon((Object)internalRow2).$colon$colon((Object)internalRow));
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            gen.write((ArrayData)input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "[{\"a\":1},{\"a\":2}]";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("initial with StructType and write out an array with single empty row", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            InternalRow internalRow = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null}));
            GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$.$colon$colon((Object)internalRow));
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            gen.write((ArrayData)input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "[{}]";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("initial with StructType and write out an empty array", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$);
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            gen.write((ArrayData)input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "[]";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("initial with Map and write out a map data", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType dataType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            ArrayBasedMapData input = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            gen.write((MapData)input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "{\"a\":1}";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("initial with Map and write out an array of maps", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType dataType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            ArrayBasedMapData arrayBasedMapData = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
            ArrayBasedMapData arrayBasedMapData2 = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
            GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$.$colon$colon((Object)arrayBasedMapData2).$colon$colon((Object)arrayBasedMapData));
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            gen.write((ArrayData)input);
            gen.flush();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(writer.toString());
            String $org_scalatest_assert_macro_right = "[{\"a\":1},{\"b\":2}]";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("error handling: initial with StructType but error calling write a map", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructType dataType = StructType$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            ArrayBasedMapData input = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            return (SparkUnsupportedOperationException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> gen.write((MapData)input), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("error handling: initial with MapType and write out a row", (scala.collection.immutable.Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            MapType dataType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
            InternalRow input = InternalRow$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            CharArrayWriter writer = new CharArrayWriter();
            JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.option());
            return (SparkUnsupportedOperationException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> gen.write(input), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }
}

