/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.ScalarSubquery;
import org.apache.spark.sql.catalyst.parser.CaseStatement;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.CompoundBody;
import org.apache.spark.sql.catalyst.parser.CompoundPlanStatement;
import org.apache.spark.sql.catalyst.parser.IfElseStatement;
import org.apache.spark.sql.catalyst.parser.IterateStatement;
import org.apache.spark.sql.catalyst.parser.LeaveStatement;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.RepeatStatement;
import org.apache.spark.sql.catalyst.parser.SingleStatement;
import org.apache.spark.sql.catalyst.parser.WhileStatement;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.CreateVariable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.exceptions.SqlScriptingException;
import org.apache.spark.sql.internal.SQLConf;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000553A\u0001B\u0003\u0001%!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)!\u0007\u0001C\u0005g\t92+\u001d7TGJL\u0007\u000f^5oOB\u000b'o]3s'VLG/\u001a\u0006\u0003\r\u001d\ta\u0001]1sg\u0016\u0014(B\u0001\u0005\n\u0003!\u0019\u0017\r^1msN$(B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011c\u0001\u0001\u0014/A\u0011A#F\u0007\u0002\u0017%\u0011ac\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005aYR\"A\r\u000b\u0005i9\u0011!\u00029mC:\u001c\u0018B\u0001\u000f\u001a\u0005%\u0019\u0016\u000b\u0014%fYB,'/\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u000b\u000512\r\\3b]V\u00048\u000b^1uK6,g\u000e^*ue&tw\r\u0006\u0002$aA\u0011A%\f\b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001K\t\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051J\u0003\"B\u0019\u0003\u0001\u0004\u0019\u0013\u0001D:uCR,W.\u001a8u'R\u0014\u0018!I2iK\u000e\\7+[7qY\u0016\u001c\u0015m]3Ti\u0006$X-\\3oi\u000e{g\u000eZ5uS>tG\u0003\u0002\u001b9{-\u0003\"!\u000e\u001c\u000e\u0003%J!aN\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006s\r\u0001\rAO\u0001\u0013G>tG-\u001b;j_:\u001cF/\u0019;f[\u0016tG\u000f\u0005\u0002!w%\u0011A(\u0002\u0002\u0010'&tw\r\\3Ti\u0006$X-\\3oi\")ah\u0001a\u0001\u007f\u0005i\u0001O]3eS\u000e\fG/\u001a'fMR\u0004B!\u000e!C\u0011&\u0011\u0011)\u000b\u0002\n\rVt7\r^5p]F\u0002\"a\u0011$\u000e\u0003\u0011S!!R\u0004\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u000f\u0012\u0013!\"\u0012=qe\u0016\u001c8/[8o!\t)\u0014*\u0003\u0002KS\t9!i\\8mK\u0006t\u0007\"\u0002'\u0004\u0001\u0004y\u0014A\u00049sK\u0012L7-\u0019;f%&<\u0007\u000e\u001e")
public class SqlScriptingParserSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        SqlScriptingParserSuite sqlScriptingParserSuite = this;
        synchronized (sqlScriptingParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public String cleanupStatementString(String statementStr) {
        return statementStr.replace("\n", "").replace("BEGIN", "").replace("END", "").trim();
    }

    private void checkSimpleCaseStatementCondition(SingleStatement conditionStatement, Function1<Expression, Object> predicateLeft, Function1<Expression, Object> predicateRight) {
        LogicalPlan $org_scalatest_assert_macro_left = conditionStatement.parsedPlan();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.catalyst.plans.logical.Project", $org_scalatest_assert_macro_left instanceof Project, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1416));
        Project project = (Project)conditionStatement.parsedPlan();
        NamedExpression $org_scalatest_assert_macro_left2 = (NamedExpression)project.projectList().head();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.Alias", $org_scalatest_assert_macro_left2 instanceof Alias, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1418));
        Expression $org_scalatest_assert_macro_left3 = ((Alias)project.projectList().head()).child();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.EqualTo", $org_scalatest_assert_macro_left3 instanceof EqualTo, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1419));
        EqualTo equalTo = (EqualTo)((Alias)project.projectList().head()).child();
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean((Object)predicateLeft.apply((Object)equalTo.left())), "predicateLeft.apply(equalTo.left)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1421));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean((Object)predicateRight.apply((Object)equalTo.right())), "predicateRight.apply(equalTo.right)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1422));
    }

    public static final /* synthetic */ boolean $anonfun$new$6(CompoundPlanStatement x$1) {
        return x$1 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$15(CompoundPlanStatement x$2) {
        return x$2 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$20(CompoundPlanStatement x$3) {
        return x$3 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$22(CompoundPlanStatement x$4) {
        return x$4 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$28(CompoundPlanStatement x$5) {
        return x$5 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$30(CompoundPlanStatement x$6) {
        return x$6 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$32(CompoundPlanStatement x$7) {
        return x$7 instanceof SingleStatement;
    }

    public static final /* synthetic */ boolean $anonfun$new$33(CompoundPlanStatement x$8) {
        return ((SingleStatement)x$8).parsedPlan() instanceof CreateVariable;
    }

    public static final /* synthetic */ boolean $anonfun$new$76(Expression x$9) {
        Expression expression = x$9;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$77(Expression x$10) {
        Expression expression = x$10;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$79(Expression x$11) {
        Expression expression = x$11;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$80(Expression x$12) {
        Expression expression = x$12;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$81(Expression x$13) {
        Expression expression = x$13;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$82(Expression x$14) {
        return x$14 instanceof ScalarSubquery;
    }

    public static final /* synthetic */ boolean $anonfun$new$83(Expression x$15) {
        Expression expression = x$15;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$84(Expression x$16) {
        return x$16 instanceof In;
    }

    public static final /* synthetic */ boolean $anonfun$new$86(Expression x$17) {
        Expression expression = x$17;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$87(Expression x$18) {
        Expression expression = x$18;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$89(Expression x$19) {
        return x$19 instanceof ScalarSubquery;
    }

    public static final /* synthetic */ boolean $anonfun$new$90(Expression x$20) {
        Expression expression = x$20;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$91(Expression x$21) {
        Expression expression = x$21;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$92(Expression x$22) {
        Expression expression = x$22;
        Literal literal = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2));
        return !(expression != null ? !expression.equals(literal) : literal != null);
    }

    public SqlScriptingParserSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("single select", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1;";
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            SingleStatement sparkStatement = (SingleStatement)tree.collection().head();
            String $org_scalatest_assert_macro_left3 = sparkStatement.getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 1;";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("single select without ;", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1";
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            SingleStatement sparkStatement = (SingleStatement)tree.collection().head();
            String $org_scalatest_assert_macro_left3 = sparkStatement.getText();
            String $org_scalatest_assert_macro_right2 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("multi select without ; - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = "SELECT 1 SELECT 1";
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getErrorClass());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "SELECT";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("multi select", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = "BEGIN SELECT 1;SELECT 2; END";
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$6(x$1))), "tree.collection.forall(((x$1: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$1.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sqlScriptText.split(";")), (Function1 & Serializable)statementStr -> this.cleanupStatementString((String)statementStr), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)tree.collection())), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String statementText;
                    String expected = (String)tuple2._1();
                    CompoundPlanStatement statement = (CompoundPlanStatement)tuple2._2();
                    SingleStatement sparkStatement = (SingleStatement)statement;
                    String $org_scalatest_assert_macro_left = statementText = sparkStatement.getText();
                    String $org_scalatest_assert_macro_right = expected;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("empty BEGIN END block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("multiple ; in row - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;;\n        |  SELECT 2;\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getErrorClass());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "at or near ';'";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("without ; in last statement - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getErrorClass());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            String $org_scalatest_assert_macro_left3 = e.getMessage();
            String $org_scalatest_assert_macro_right3 = "at or near end of input";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("multi statement", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$15(x$2))), "tree.collection.forall(((x$2: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$2.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])sqlScriptText.split(";")), (Function1 & Serializable)statementStr -> this.cleanupStatementString((String)statementStr), ClassTag$.MODULE$.apply(String.class))), (IterableOnce)tree.collection())), (Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String statementText;
                    String expected = (String)tuple2._1();
                    CompoundPlanStatement statement = (CompoundPlanStatement)tuple2._2();
                    SingleStatement sparkStatement = (SingleStatement)statement;
                    String $org_scalatest_assert_macro_left = statementText = sparkStatement.getText();
                    String $org_scalatest_assert_macro_right = expected;
                    String string = $org_scalatest_assert_macro_left;
                    String string2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                }
                throw new MatchError((Object)tuple2);
            });
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        this.test("nested begin end", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  BEGIN\n        |  SELECT 1;\n        |  END;\n        |  BEGIN\n        |    BEGIN\n        |      SELECT 2;\n        |      SELECT 3;\n        |    END;\n        |  END;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left2 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            CompoundBody body1 = (CompoundBody)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = body1.collection();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            String $org_scalatest_assert_macro_left4 = ((SingleStatement)body1.collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            CompoundBody body2 = (CompoundBody)tree.collection().apply(1);
            Seq $org_scalatest_assert_macro_left5 = body2.collection();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)body2.collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left6 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            CompoundBody nestedBody = (CompoundBody)body2.collection().head();
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)nestedBody.collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 2";
            String string3 = $org_scalatest_assert_macro_left7;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)nestedBody.collection().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 3";
            String string5 = $org_scalatest_assert_macro_left8;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("compound: beginLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$20(x$3))), "tree.collection.forall(((x$3: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$3.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Option $org_scalatest_assert_macro_left2 = tree.label();
            String $org_scalatest_assert_macro_right2 = "lbl";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("compound: beginLabel + endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END lbl"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$22(x$4))), "tree.collection.forall(((x$4: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$4.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Option $org_scalatest_assert_macro_left2 = tree.label();
            String $org_scalatest_assert_macro_right2 = "lbl";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("compound: beginLabel + endLabel with different values", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl_begin: BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END lbl_end"));
            SqlScriptingException x$1 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            String x$2 = "LABELS_MISMATCH";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"beginLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_begin")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl_end"))}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "LABELS_MISMATCH", x$4, x$3, x$5, x$6);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("compound: endLabel", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END lbl"));
            SqlScriptingException x$7 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            String x$8 = "END_LABEL_WITHOUT_BEGIN_LABEL";
            Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId("lbl"))}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "END_LABEL_WITHOUT_BEGIN_LABEL", x$10, x$9, x$11, x$12);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 8;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("compound: beginLabel + endLabel with different casing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |LBL: BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END lbl"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$28(x$5))), "tree.collection.forall(((x$5: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$5.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            Option $org_scalatest_assert_macro_left2 = tree.label();
            String $org_scalatest_assert_macro_right2 = "lbl";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("compound: no labels provided", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  SELECT 2;\n        |  INSERT INTO A VALUES (a, b, 3);\n        |  SELECT a, b, c FROM T;\n        |  SELECT * FROM T;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$30(x$6))), "tree.collection.forall(((x$6: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$6.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
            Option $org_scalatest_assert_macro_left2 = tree.label();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("declare at the beginning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE testVariable1 VARCHAR(50);\n        |  DECLARE testVariable2 INTEGER;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$32(x$7))), "tree.collection.forall(((x$7: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$7.isInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement]))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(tree.collection().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$33(x$8))), "tree.collection.forall(((x$8: org.apache.spark.sql.catalyst.parser.CompoundPlanStatement) => x$8.asInstanceOf[org.apache.spark.sql.catalyst.parser.SingleStatement].parsedPlan.isInstanceOf[org.apache.spark.sql.catalyst.plans.logical.CreateVariable]))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("declare after beginning", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  SELECT 1;\n        |  DECLARE testVariable INTEGER;\n        |END"));
            SqlScriptingException x$13 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            String x$14 = "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)"`testVariable`")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING", x$16, x$15, x$17, x$18);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.test("declare in wrong scope", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            SqlScriptingException exception;
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   DECLARE testVariable INTEGER;\n        | END IF;\n        |END"));
            SqlScriptingException x$19 = exception = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            String x$20 = "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE";
            Map x$21 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)"`testVariable`")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE", x$22, x$21, x$23, x$24);
            Option $org_scalatest_assert_macro_left = exception.origin().line();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("SET VAR statement test", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET VAR totalInsCnt = (SELECT x FROM y WHERE id = 1);\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        this.test("SET VARIABLE statement test", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET VARIABLE totalInsCnt = (SELECT x FROM y WHERE id = 1);\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("SET statement test", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET totalInsCnt = (SELECT x FROM y WHERE id = 1);\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("SET statement test - should fail", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  DECLARE totalInsCnt = 0;\n        |  SET totalInsCnt = (SELECT x FROMERROR y WHERE id = 1);\n        |END"));
            ParseException e = (ParseException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(ParseException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getErrorClass());
            String $org_scalatest_assert_macro_right = "PARSE_SYNTAX_ERROR";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "Syntax error";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("if", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   SELECT 42;\n        | END IF;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1=1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        this.test("if else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSE\n        |  SELECT 2;\n        |END IF;\n        |END\n        "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            SingleStatement $org_scalatest_assert_macro_left5 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
            Seq $org_scalatest_assert_macro_left7 = ((CompoundBody)ifStmt.conditionalBodies().head()).collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            Seq $org_scalatest_assert_macro_left10 = ((CompoundBody)ifStmt.elseBody().get()).collection();
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string5 = $org_scalatest_assert_macro_left12;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
        this.test("if else if", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSE IF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSE\n        |  SELECT 3;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
            SingleStatement $org_scalatest_assert_macro_left5 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            SingleStatement $org_scalatest_assert_macro_left9 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 3";
            String string9 = $org_scalatest_assert_macro_left14;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        this.test("if multi else if", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |IF 1 = 1 THEN\n        |  SELECT 1;\n        |ELSE IF 2 = 2 THEN\n        |  SELECT 2;\n        |ELSE IF 3 = 3 THEN\n        |  SELECT 3;\n        |END IF;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 479));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "2 = 2";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            SingleStatement $org_scalatest_assert_macro_left14 = (SingleStatement)ifStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)ifStmt.conditions().apply(2)).getText();
            String $org_scalatest_assert_macro_right8 = "3 = 3";
            String string9 = $org_scalatest_assert_macro_left15;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 3";
            String string11 = $org_scalatest_assert_macro_left17;
            String string12 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right9, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        this.test("if nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | IF 1=1 THEN\n        |   IF 2=1 THEN\n        |     SELECT 41;\n        |   ELSE\n        |     SELECT 42;\n        |   END IF;\n        | END IF;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 522));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left2 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 523));
            IfElseStatement ifStmt = (IfElseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            Seq $org_scalatest_assert_macro_left4 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
            Option $org_scalatest_assert_macro_left5 = ifStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1=1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left8 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            IfElseStatement nestedIfStmt = (IfElseStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left9 = nestedIfStmt.conditions();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 536));
            Seq $org_scalatest_assert_macro_left10 = nestedIfStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(nestedIfStmt.elseBody().isDefined(), "nestedIfStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            SingleStatement $org_scalatest_assert_macro_left11 = (SingleStatement)nestedIfStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)nestedIfStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right7 = "2=1";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedIfStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedIfStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 41";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedIfStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedIfStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string7 = $org_scalatest_assert_macro_left16;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
        this.test("while", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  SELECT 1;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
            Option $org_scalatest_assert_macro_left9 = whileStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
        this.test("while with complex condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |BEGIN\n      |CREATE TABLE t (a INT, b STRING, c DOUBLE) USING parquet;\n      |WHILE (SELECT COUNT(*) < 2 FROM t) DO\n      |  SELECT 42;\n      |END WHILE;\n      |END\n      |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 588));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
            WhileStatement whileStmt = (WhileStatement)tree.collection().apply(1);
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "(SELECT COUNT(*) < 2 FROM t)";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        this.test("while with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  IF 1 = 1 THEN\n        |    SELECT 1;\n        |  ELSE\n        |    SELECT 2;\n        |  END IF;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left7 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623));
            IfElseStatement ifStmt = (IfElseStatement)whileStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left8 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 626));
            Seq $org_scalatest_assert_macro_left9 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 627));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right6 = "1 = 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left15;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            Option $org_scalatest_assert_macro_left16 = whileStmt.label();
            String $org_scalatest_assert_macro_right9 = "lbl";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left16.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
        this.test("nested while", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: WHILE 1 = 1 DO\n        |  WHILE 2 = 2 DO\n        |    SELECT 42;\n        |  END WHILE;\n        |END WHILE lbl;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 662));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 663));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left7 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            String $org_scalatest_assert_macro_left9 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            CompoundBody $org_scalatest_assert_macro_left10 = nestedWhileStmt.body();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left10 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
            Seq $org_scalatest_assert_macro_left11 = nestedWhileStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
            Option $org_scalatest_assert_macro_left14 = whileStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
        this.test("leave compound block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |  LEAVE lbl;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left2 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            CompoundPlanStatement $org_scalatest_assert_macro_left3 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.LeaveStatement", $org_scalatest_assert_macro_left3 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
        this.test("leave while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)whileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.LeaveStatement", $org_scalatest_assert_macro_left9 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715));
            String $org_scalatest_assert_macro_left10 = ((LeaveStatement)whileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
        this.test("leave repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    SELECT 1;\n        |    LEAVE lbl;\n        |  UNTIL 1 = 2\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 734));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 2";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)repeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.LeaveStatement", $org_scalatest_assert_macro_left9 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
            String $org_scalatest_assert_macro_left10 = ((LeaveStatement)repeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 719));
        this.test("iterate compound block - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |  ITERATE lbl;\n        |END"));
            SqlScriptingException x$25 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
            String x$26 = "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND";
            Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"LBL")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND", x$28, x$27, x$29, x$30);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("iterate while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 782));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)whileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 783));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)whileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IterateStatement", $org_scalatest_assert_macro_left9 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
            String $org_scalatest_assert_macro_left10 = ((IterateStatement)whileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
        this.test("iterate repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    SELECT 1;\n        |    ITERATE lbl;\n        |  UNTIL 1 = 2\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 2";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 805));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)repeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IterateStatement", $org_scalatest_assert_macro_left9 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
            String $org_scalatest_assert_macro_left10 = ((IterateStatement)repeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 814));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
        this.test("leave with wrong label - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |  LEAVE randomlbl;\n        |END"));
            SqlScriptingException x$31 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
            String x$32 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
            Map x$33 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"RANDOMLBL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)"LEAVE")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "INVALID_LABEL_USAGE.DOES_NOT_EXIST", x$34, x$33, x$35, x$36);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
        this.test("iterate with wrong label - should fail", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |lbl: BEGIN\n        |  SELECT 1;\n        |  ITERATE randomlbl;\n        |END"));
            SqlScriptingException x$37 = (SqlScriptingException)this.intercept((Function0 & Serializable)() -> CatalystSqlParser$.MODULE$.parseScript(sqlScriptText), ClassTag$.MODULE$.apply(SqlScriptingException.class), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
            String x$38 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
            Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)"RANDOMLBL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)"ITERATE")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, "INVALID_LABEL_USAGE.DOES_NOT_EXIST", x$40, x$39, x$41, x$42);
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 832));
        this.test("leave outer loop from nested while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    lbl2: WHILE 2 = 2 DO\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    END WHILE;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 863));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 867));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
            String $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedWhileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.LeaveStatement", $org_scalatest_assert_macro_left11 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
            String $org_scalatest_assert_macro_left12 = ((LeaveStatement)nestedWhileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
        this.test("leave outer loop from nested repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    lbl2: REPEAT\n        |      SELECT 1;\n        |      LEAVE lbl;\n        |    UNTIL 2 = 2\n        |    END REPEAT;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 894));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 895));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            RepeatStatement nestedRepeatStmt = (RepeatStatement)repeatStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedRepeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
            String $org_scalatest_assert_macro_left8 = nestedRepeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedRepeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.LeaveStatement", $org_scalatest_assert_macro_left11 instanceof LeaveStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
            String $org_scalatest_assert_macro_left12 = ((LeaveStatement)nestedRepeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880));
        this.test("iterate outer loop from nested while loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: WHILE 1 = 1 DO\n        |    lbl2: WHILE 2 = 2 DO\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    END WHILE;\n        |  END WHILE;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 928));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.WhileStatement", $org_scalatest_assert_macro_left2 instanceof WhileStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
            WhileStatement whileStmt = (WhileStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 932));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 933));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 936));
            WhileStatement nestedWhileStmt = (WhileStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939));
            String $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 943));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedWhileStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IterateStatement", $org_scalatest_assert_macro_left11 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 945));
            String $org_scalatest_assert_macro_left12 = ((IterateStatement)nestedWhileStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 946));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
        this.test("iterate outer loop from nested repeat loop", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |  lbl: REPEAT\n        |    lbl2: REPEAT\n        |      SELECT 1;\n        |      ITERATE lbl;\n        |    UNTIL 2 = 2\n        |    END REPEAT;\n        |  UNTIL 1 = 1\n        |  END REPEAT;\n        |END"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 963));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 967));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 968));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 970));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 971));
            RepeatStatement nestedRepeatStmt = (RepeatStatement)repeatStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left7 = nestedRepeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974));
            String $org_scalatest_assert_macro_left8 = nestedRepeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
            CompoundPlanStatement $org_scalatest_assert_macro_left9 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 977));
            String $org_scalatest_assert_macro_left10 = ((SingleStatement)nestedRepeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left10;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 978));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)nestedRepeatStmt.body().collection().apply(1);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IterateStatement", $org_scalatest_assert_macro_left11 instanceof IterateStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 981));
            String $org_scalatest_assert_macro_left12 = ((IterateStatement)nestedRepeatStmt.body().collection().apply(1)).label();
            String $org_scalatest_assert_macro_right6 = "lbl";
            String string7 = $org_scalatest_assert_macro_left12;
            String string8 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 982));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 949));
        this.test("repeat", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  SELECT 1;\n        | UNTIL 1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 995));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 996));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 999));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1000));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1002));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1003));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005));
            Option $org_scalatest_assert_macro_left9 = repeatStmt.label();
            String $org_scalatest_assert_macro_right5 = "lbl";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1007));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 985));
        this.test("repeat with complex condition", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        |CREATE TABLE t (a INT, b STRING, c DOUBLE) USING parquet;\n        |REPEAT\n        | SELECT 42;\n        |UNTIL\n        | (SELECT COUNT(*) < 2 FROM t)\n        |END REPEAT;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().apply(1);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1025));
            RepeatStatement repeatStmt = (RepeatStatement)tree.collection().apply(1);
            SingleStatement $org_scalatest_assert_macro_left3 = repeatStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
            String $org_scalatest_assert_macro_left4 = repeatStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "(SELECT COUNT(*) < 2 FROM t)";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1029));
            CompoundBody $org_scalatest_assert_macro_left5 = repeatStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1031));
            Seq $org_scalatest_assert_macro_left6 = repeatStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1032));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)repeatStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1033));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)repeatStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left8;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1034));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1010));
        this.test("repeat with if else block", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  IF 1 = 1 THEN\n        |    SELECT 1;\n        |  ELSE\n        |    SELECT 2;\n        |  END IF;\n        |UNTIL\n        |  1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1052));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1053));
            RepeatStatement whileStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1056));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1057));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1059));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1060));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.IfElseStatement", $org_scalatest_assert_macro_left7 instanceof IfElseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1061));
            IfElseStatement ifStmt = (IfElseStatement)whileStmt.body().collection().head();
            Seq $org_scalatest_assert_macro_left8 = ifStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
            Seq $org_scalatest_assert_macro_left9 = ifStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1065));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(ifStmt.elseBody().isDefined(), "ifStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1066));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)ifStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1068));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)ifStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right6 = "1 = 1";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1069));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1071));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)ifStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 1";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
            CompoundPlanStatement $org_scalatest_assert_macro_left14 = (CompoundPlanStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1075));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)((CompoundBody)ifStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 2";
            String string7 = $org_scalatest_assert_macro_left15;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1076));
            Option $org_scalatest_assert_macro_left16 = whileStmt.label();
            String $org_scalatest_assert_macro_right9 = "lbl";
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left16.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1079));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1037));
        this.test("nested repeat", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("BEGIN\n        |lbl: REPEAT\n        |  REPEAT\n        |    SELECT 42;\n        |  UNTIL\n        |    2 = 2\n        |  END REPEAT;\n        |UNTIL\n        |   1 = 1\n        |END REPEAT lbl;\n        |END\n      "));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1097));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left2 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1098));
            RepeatStatement whileStmt = (RepeatStatement)tree.collection().head();
            SingleStatement $org_scalatest_assert_macro_left3 = whileStmt.condition();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left3 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1101));
            String $org_scalatest_assert_macro_left4 = whileStmt.condition().getText();
            String $org_scalatest_assert_macro_right2 = "1 = 1";
            String string = $org_scalatest_assert_macro_left4;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
            CompoundBody $org_scalatest_assert_macro_left5 = whileStmt.body();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left5 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1104));
            Seq $org_scalatest_assert_macro_left6 = whileStmt.body().collection();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1105));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)whileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.RepeatStatement", $org_scalatest_assert_macro_left7 instanceof RepeatStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1106));
            RepeatStatement nestedWhileStmt = (RepeatStatement)whileStmt.body().collection().head();
            SingleStatement $org_scalatest_assert_macro_left8 = nestedWhileStmt.condition();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1109));
            String $org_scalatest_assert_macro_left9 = nestedWhileStmt.condition().getText();
            String $org_scalatest_assert_macro_right4 = "2 = 2";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1110));
            CompoundBody $org_scalatest_assert_macro_left10 = nestedWhileStmt.body();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CompoundBody", $org_scalatest_assert_macro_left10 instanceof CompoundBody, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1112));
            Seq $org_scalatest_assert_macro_left11 = nestedWhileStmt.body().collection();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left11, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left11.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1113));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)nestedWhileStmt.body().collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1114));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)nestedWhileStmt.body().collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left13;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1115));
            Option $org_scalatest_assert_macro_left14 = whileStmt.label();
            String $org_scalatest_assert_macro_right7 = "lbl";
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left14.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1118));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1082));
        this.test("searched case statement", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1133));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1134));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1136));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1137));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1 = 1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1138));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1122));
        this.test("searched case statement - multi when", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 IN (1,2,3) THEN\n        |     SELECT 1;\n        |   WHEN (SELECT * FROM t) THEN\n        |     SELECT * FROM b;\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1157));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1158));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1161));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1162));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1163));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1165));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 IN (1,2,3)";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1166));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left8 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1168));
            String $org_scalatest_assert_macro_left9 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT 1";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1169));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)caseStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1172));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)caseStmt.conditions().apply(1)).getText();
            String $org_scalatest_assert_macro_right6 = "(SELECT * FROM t)";
            String string5 = $org_scalatest_assert_macro_left11;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1173));
            CompoundPlanStatement $org_scalatest_assert_macro_left12 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1175));
            String $org_scalatest_assert_macro_left13 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT * FROM b";
            String string7 = $org_scalatest_assert_macro_left13;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1176));
            SingleStatement $org_scalatest_assert_macro_left14 = (SingleStatement)caseStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left14, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left14 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1179));
            String $org_scalatest_assert_macro_left15 = ((SingleStatement)caseStmt.conditions().apply(2)).getText();
            String $org_scalatest_assert_macro_right8 = "1 = 1";
            String string9 = $org_scalatest_assert_macro_left15;
            String string10 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "==", (Object)$org_scalatest_assert_macro_right8, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1180));
            CompoundPlanStatement $org_scalatest_assert_macro_left16 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left16, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left16 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1182));
            String $org_scalatest_assert_macro_left17 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string11 = $org_scalatest_assert_macro_left17;
            String string12 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "==", (Object)$org_scalatest_assert_macro_right9, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1183));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1141));
        this.test("searched case statement with else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     SELECT 42;\n        |   ELSE\n        |     SELECT 43;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1200));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1201));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(caseStmt.elseBody().isDefined(), "caseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1203));
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1204));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1205));
            String $org_scalatest_assert_macro_left5 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right3 = "1 = 1";
            String string = $org_scalatest_assert_macro_left5;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1206));
            CompoundPlanStatement $org_scalatest_assert_macro_left6 = (CompoundPlanStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1208));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 43";
            String string3 = $org_scalatest_assert_macro_left7;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1209));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1187));
        this.test("searched case statement nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE\n        |   WHEN 1 = 1 THEN\n        |     CASE\n        |       WHEN 2 = 1 THEN\n        |         SELECT 41;\n        |       ELSE\n        |         SELECT 42;\n        |     END CASE;\n        |  END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1229));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1230));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1233));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1234));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1235));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
            String $org_scalatest_assert_macro_left7 = ((SingleStatement)caseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right4 = "1 = 1";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1238));
            CompoundPlanStatement $org_scalatest_assert_macro_left8 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left8, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left8 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1240));
            CaseStatement nestedCaseStmt = (CaseStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left9 = nestedCaseStmt.conditions();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1244));
            Seq $org_scalatest_assert_macro_left10 = nestedCaseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left10, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1245));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(nestedCaseStmt.elseBody().isDefined(), "nestedCaseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1246));
            SingleStatement $org_scalatest_assert_macro_left11 = (SingleStatement)nestedCaseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1248));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)nestedCaseStmt.conditions().head()).getText();
            String $org_scalatest_assert_macro_right7 = "2 = 1";
            String string3 = $org_scalatest_assert_macro_left12;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1249));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1251));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right8 = "SELECT 41";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1252));
            CompoundPlanStatement $org_scalatest_assert_macro_left15 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left15, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left15 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1255));
            String $org_scalatest_assert_macro_left16 = ((SingleStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right9 = "SELECT 42";
            String string7 = $org_scalatest_assert_macro_left16;
            String string8 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "==", (Object)$org_scalatest_assert_macro_right9, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1256));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1213));
        this.test("simple case statement", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 1;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1271));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1272));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1274));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1275));
            this.checkSimpleCaseStatementCondition((SingleStatement)caseStmt.conditions().head(), (Function1<Expression, Object>)(Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$76(x$9)), (Function1<Expression, Object>)(Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$77(x$10)));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
        this.test("simple case statement - multi when", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 1;\n        |   WHEN (SELECT 2) THEN\n        |     SELECT * FROM b;\n        |   WHEN 3 IN (1,2,3) THEN\n        |     SELECT 42;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1296));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1297));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1300));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1301));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1302));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1304));
            this.checkSimpleCaseStatementCondition((SingleStatement)caseStmt.conditions().head(), (Function1<Expression, Object>)(Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$79(x$11)), (Function1<Expression, Object>)(Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$80(x$12)));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left7 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
            String $org_scalatest_assert_macro_left8 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right4 = "SELECT 1";
            String string = $org_scalatest_assert_macro_left8;
            String string2 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1308));
            SingleStatement $org_scalatest_assert_macro_left9 = (SingleStatement)caseStmt.conditions().apply(1);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left9, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left9 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1311));
            this.checkSimpleCaseStatementCondition((SingleStatement)caseStmt.conditions().apply(1), (Function1<Expression, Object>)(Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$81(x$13)), (Function1<Expression, Object>)(Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$82(x$14)));
            CompoundPlanStatement $org_scalatest_assert_macro_left10 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1315));
            String $org_scalatest_assert_macro_left11 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(1)).collection().head()).getText();
            String $org_scalatest_assert_macro_right5 = "SELECT * FROM b";
            String string3 = $org_scalatest_assert_macro_left11;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1316));
            SingleStatement $org_scalatest_assert_macro_left12 = (SingleStatement)caseStmt.conditions().apply(2);
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left12, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left12 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1319));
            this.checkSimpleCaseStatementCondition((SingleStatement)caseStmt.conditions().apply(2), (Function1<Expression, Object>)(Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$83(x$15)), (Function1<Expression, Object>)(Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$84(x$16)));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1323));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)caseStmt.conditionalBodies().apply(2)).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 42";
            String string5 = $org_scalatest_assert_macro_left14;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1324));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1280));
        this.test("simple case statement with else", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE 1\n        |   WHEN 1 THEN\n        |     SELECT 42;\n        |   ELSE\n        |     SELECT 43;\n        | END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1341));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1342));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(caseStmt.elseBody().isDefined(), "caseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1344));
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1345));
            SingleStatement $org_scalatest_assert_macro_left4 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left4, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left4 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1346));
            this.checkSimpleCaseStatementCondition((SingleStatement)caseStmt.conditions().head(), (Function1<Expression, Object>)(Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$86(x$17)), (Function1<Expression, Object>)(Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$87(x$18)));
            CompoundPlanStatement $org_scalatest_assert_macro_left5 = (CompoundPlanStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left5 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1349));
            String $org_scalatest_assert_macro_left6 = ((SingleStatement)((CompoundBody)caseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right3 = "SELECT 43";
            String string = $org_scalatest_assert_macro_left6;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1350));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1328));
        this.test("simple case statement nested", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String sqlScriptText = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |BEGIN\n        | CASE (SELECT 1)\n        |   WHEN 1 THEN\n        |     CASE 2\n        |       WHEN 2 THEN\n        |         SELECT 41;\n        |       ELSE\n        |         SELECT 42;\n        |     END CASE;\n        |  END CASE;\n        |END\n        |"));
            CompoundBody tree = CatalystSqlParser$.MODULE$.parseScript(sqlScriptText);
            Seq $org_scalatest_assert_macro_left = tree.collection();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
            CompoundPlanStatement $org_scalatest_assert_macro_left2 = (CompoundPlanStatement)tree.collection().head();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left2 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1371));
            CaseStatement caseStmt = (CaseStatement)tree.collection().head();
            Seq $org_scalatest_assert_macro_left3 = caseStmt.conditions();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1374));
            Seq $org_scalatest_assert_macro_left4 = caseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1375));
            Option $org_scalatest_assert_macro_left5 = caseStmt.elseBody();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "isEmpty", $org_scalatest_assert_macro_left5.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1376));
            SingleStatement $org_scalatest_assert_macro_left6 = (SingleStatement)caseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left6, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left6 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1378));
            this.checkSimpleCaseStatementCondition((SingleStatement)caseStmt.conditions().head(), (Function1<Expression, Object>)(Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$89(x$19)), (Function1<Expression, Object>)(Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$90(x$20)));
            CompoundPlanStatement $org_scalatest_assert_macro_left7 = (CompoundPlanStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left7, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.CaseStatement", $org_scalatest_assert_macro_left7 instanceof CaseStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1382));
            CaseStatement nestedCaseStmt = (CaseStatement)((CompoundBody)caseStmt.conditionalBodies().head()).collection().head();
            Seq $org_scalatest_assert_macro_left8 = nestedCaseStmt.conditions();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
            Seq $org_scalatest_assert_macro_left9 = nestedCaseStmt.conditionalBodies();
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left9, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left9.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1387));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(nestedCaseStmt.elseBody().isDefined(), "nestedCaseStmt.elseBody.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1388));
            SingleStatement $org_scalatest_assert_macro_left10 = (SingleStatement)nestedCaseStmt.conditions().head();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left10 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1390));
            this.checkSimpleCaseStatementCondition((SingleStatement)nestedCaseStmt.conditions().head(), (Function1<Expression, Object>)(Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$91(x$21)), (Function1<Expression, Object>)(Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)SqlScriptingParserSuite.$anonfun$new$92(x$22)));
            CompoundPlanStatement $org_scalatest_assert_macro_left11 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head();
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left11, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left11 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
            String $org_scalatest_assert_macro_left12 = ((SingleStatement)((CompoundBody)nestedCaseStmt.conditionalBodies().head()).collection().head()).getText();
            String $org_scalatest_assert_macro_right6 = "SELECT 41";
            String string = $org_scalatest_assert_macro_left12;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1395));
            CompoundPlanStatement $org_scalatest_assert_macro_left13 = (CompoundPlanStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head();
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left13, "isInstanceOf", "org.apache.spark.sql.catalyst.parser.SingleStatement", $org_scalatest_assert_macro_left13 instanceof SingleStatement, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
            String $org_scalatest_assert_macro_left14 = ((SingleStatement)((CompoundBody)nestedCaseStmt.elseBody().get()).collection().head()).getText();
            String $org_scalatest_assert_macro_right7 = "SELECT 42";
            String string3 = $org_scalatest_assert_macro_left14;
            String string4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "==", (Object)$org_scalatest_assert_macro_right7, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1399));
        }, new Position("SqlScriptingParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1354));
    }
}

