/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Unpivot;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000553A\u0001B\u0003\u0001%!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0005E!)\u0001\t\u0001C\u0005\u0003\n\u0011RK\u001c9jm>$\b+\u0019:tKJ\u001cV/\u001b;f\u0015\t1q!\u0001\u0004qCJ\u001cXM\u001d\u0006\u0003\u0011%\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u0005Y\u0011B\u0001\f\f\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u0011\u0001dG\u0007\u00023)\u0011!dB\u0001\tC:\fG._:jg&\u0011A$\u0007\u0002\r\u0003:\fG._:jgR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\u0015\t1\"Y:tKJ$X)];bYR\u00191%\u000b\u001c\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006U\t\u0001\raK\u0001\u000bgFd7i\\7nC:$\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002/K5\tqF\u0003\u00021#\u00051AH]8pizJ!AM\u0013\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003e\u0015BQa\u000e\u0002A\u0002a\nA\u0001\u001d7b]B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\bY><\u0017nY1m\u0015\tit!A\u0003qY\u0006t7/\u0003\u0002@u\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0006\u0003$\u0005\u000eC\u0005\"\u0002\u0016\u0004\u0001\u0004Y\u0003\"\u0002#\u0004\u0001\u0004)\u0015!C2p]\u0012LG/[8o!\r!ciK\u0005\u0003\u000f\u0016\u0012aa\u00149uS>t\u0007\"B%\u0004\u0001\u0004Q\u0015\u0001C7fgN\fw-Z:\u0011\u0007\u0011Z5&\u0003\u0002MK\tQAH]3qK\u0006$X\r\u001a ")
public class UnpivotParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public Seq<Rule<LogicalPlan>> extendedAnalysisRules() {
        return AnalysisTest.extendedAnalysisRules$(this);
    }

    @Override
    public void createTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public void createGlobalTempView(SessionCatalog catalog, String name, LogicalPlan plan, boolean overrideIfExists) {
        AnalysisTest.createGlobalTempView$(this, catalog, name, plan, overrideIfExists);
    }

    @Override
    public Analyzer getAnalyzer() {
        return AnalysisTest.getAnalyzer$(this);
    }

    @Override
    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$(this, inputPlan, expectedPlan, caseSensitive);
    }

    @Override
    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$(this);
    }

    @Override
    public void checkAnalysisWithoutViewWrapper(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive, boolean inlineCTE) {
        AnalysisTest.checkAnalysisWithoutViewWrapper$(this, inputPlan, expectedPlan, caseSensitive, inlineCTE);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$3() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$3$(this);
    }

    @Override
    public boolean checkAnalysisWithoutViewWrapper$default$4() {
        return AnalysisTest.checkAnalysisWithoutViewWrapper$default$4$(this);
    }

    @Override
    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$(this, plan1, plan2, checkAnalysis);
    }

    @Override
    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$(this);
    }

    @Override
    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$(this, inputPlan, caseSensitive);
    }

    @Override
    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$(this);
    }

    @Override
    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$(this, inputPlan, expectedErrors, caseSensitive);
    }

    @Override
    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$(this);
    }

    @Override
    public void assertAnalysisErrorCondition(LogicalPlan inputPlan, String expectedErrorCondition, Map<String, String> expectedMessageParameters, SparkFunSuite.ExpectedContext[] queryContext, boolean caseSensitive) {
        AnalysisTest.assertAnalysisErrorCondition$(this, inputPlan, expectedErrorCondition, expectedMessageParameters, queryContext, caseSensitive);
    }

    @Override
    public SparkFunSuite.ExpectedContext[] assertAnalysisErrorCondition$default$4() {
        return AnalysisTest.assertAnalysisErrorCondition$default$4$(this);
    }

    @Override
    public boolean assertAnalysisErrorCondition$default$5() {
        return AnalysisTest.assertAnalysisErrorCondition$default$5$(this);
    }

    @Override
    public void interceptParseException(Function1<String, Object> parser, String sqlCommand, Seq<String> messages, Option<String> condition) {
        AnalysisTest.interceptParseException$(this, parser, sqlCommand, messages, condition);
    }

    @Override
    public Option<String> interceptParseException$default$4(Function1<String, Object> parser, String sqlCommand, Seq<String> messages) {
        return AnalysisTest.interceptParseException$default$4$(this, parser, sqlCommand, messages);
    }

    @Override
    public ParseException parseException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.parseException$(this, parser, sqlText);
    }

    @Override
    public SparkException internalException(Function1<String, Object> parser, String sqlText) {
        return AnalysisTest.internalException$(this, parser, sqlText);
    }

    @Override
    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$(this, plan);
    }

    @Override
    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$(this, plan);
    }

    @Override
    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$(this, plan);
    }

    @Override
    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$(this, e1, e2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private String sparkHome$lzycompute() {
        UnpivotParserSuite unpivotParserSuite = this;
        synchronized (unpivotParserSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        this.comparePlans(CatalystSqlParser$.MODULE$.parsePlan(sqlCommand), plan, false);
    }

    private void intercept(String sqlCommand, Option<String> condition, Seq<String> messages) {
        this.interceptParseException((Function1<String, Object>)(Function1 & Serializable)sqlText -> CatalystSqlParser$.MODULE$.parsePlan(sqlText), sqlCommand, messages, condition);
    }

    public UnpivotParserSuite() {
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        PlanTestBase.$init$(this);
        AnalysisTest.$init$(this);
        this.test("unpivot - single value", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual("SELECT * FROM t UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("unpivot - single value with alias", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"SELECT * FROM t UNPIVOT (val FOR col in (a A, b))", (List)new .colon.colon((Object)"SELECT * FROM t UNPIVOT (val FOR col in (a AS A, b))", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sql -> {
            this.withClue(sql, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual(sql, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)new Some((Object)new .colon.colon((Object)new Some((Object)"A"), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))));
            return BoxedUnit.UNIT;
        }), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("unpivot - multiple values", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual("SELECT * FROM t UNPIVOT ((val1, val2) FOR col in ((a, b), (c, d)))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val1", (List)new .colon.colon((Object)"val2", (List)Nil$.MODULE$)), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val2"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("unpivot - multiple values with alias", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"SELECT * FROM t UNPIVOT ((val1, val2) FOR col in ((a, b) first, (c, d)))", (List)new .colon.colon((Object)"SELECT * FROM t UNPIVOT ((val1, val2) FOR col in ((a, b) AS first, (c, d)))", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sql -> {
            this.withClue(sql, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual(sql, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$), (List)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))), (Option)new Some((Object)new .colon.colon((Object)new Some((Object)"first"), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$))), "col", (Seq)new .colon.colon((Object)"val1", (List)new .colon.colon((Object)"val2", (List)Nil$.MODULE$)), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val1"}))).$((Seq)Nil$.MODULE$), package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val2"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))));
            return BoxedUnit.UNIT;
        }), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("unpivot - multiple values with inner alias", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"SELECT * FROM t UNPIVOT ((val1, val2) FOR col in ((a A, b), (c, d)))", (List)new .colon.colon((Object)"SELECT * FROM t UNPIVOT ((val1, val2) FOR col in ((a AS A, b), (c, d)))", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sql -> {
            this.withClue(sql, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.intercept(sql, (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near "})));
            return BoxedUnit.UNIT;
        }), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("unpivot - alias", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"SELECT up.* FROM t UNPIVOT (val FOR col in (a, b)) up", (List)new .colon.colon((Object)"SELECT up.* FROM t UNPIVOT (val FOR col in (a, b)) AS up", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)sql -> {
            this.withClue(sql, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual(sql, package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).subquery("up")).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"up"}))}))));
            return BoxedUnit.UNIT;
        }), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("unpivot - no unpivot value names", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.intercept("SELECT * FROM t UNPIVOT (() FOR col in ((a, b), (c, d)))", (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near "})), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("unpivot - no unpivot columns", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)"SELECT * FROM t UNPIVOT (val FOR col in ())", (List)new .colon.colon((Object)"SELECT * FROM t UNPIVOT ((val1, val2) FOR col in ())", (List)new .colon.colon((Object)"SELECT * FROM t UNPIVOT ((val1, val2) FOR col in (()))", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)sql -> {
            this.withClue(sql, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.intercept(sql, (Option<String>)new Some((Object)"PARSE_SYNTAX_ERROR"), (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Syntax error at or near "})));
            return BoxedUnit.UNIT;
        }), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("unpivot - exclude nulls", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual("SELECT * FROM t UNPIVOT EXCLUDE NULLS (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        this.test("unpivot - include nulls", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual("SELECT * FROM t UNPIVOT INCLUDE NULLS (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t"})))).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("unpivot - with joins", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.plans$.DslLogicalPlan qual$1 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull()));
            LogicalPlan x$1 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            JoinType x$2 = qual$1.join$default$2();
            Option x$3 = qual$1.join$default$3();
            this.assertEqual("SELECT * FROM t1 UNPIVOT (val FOR col in (a, b)) JOIN t2", package.plans$.MODULE$.DslLogicalPlan(qual$1.join(x$1, x$2, x$3)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$2 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$4 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            JoinType x$5 = qual$2.join$default$2();
            Option x$6 = qual$2.join$default$3();
            this.assertEqual("SELECT * FROM t1 JOIN t2 UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), qual$2.join(x$4, x$5, x$6))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$3 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$7 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull());
            JoinType x$8 = qual$3.join$default$2();
            Option x$9 = qual$3.join$default$3();
            this.assertEqual("SELECT * FROM t1 JOIN (t2 UNPIVOT (val FOR col in (a, b)))", package.plans$.MODULE$.DslLogicalPlan(qual$3.join(x$7, x$8, x$9)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
        }, new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test("unpivot - with implicit joins", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package.plans$.DslLogicalPlan qual$4 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull()));
            LogicalPlan x$10 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            JoinType x$11 = qual$4.join$default$2();
            Option x$12 = qual$4.join$default$3();
            this.assertEqual("SELECT * FROM t1 UNPIVOT (val FOR col in (a, b)), t2", package.plans$.MODULE$.DslLogicalPlan(qual$4.join(x$10, x$11, x$12)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$5 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$13 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            JoinType x$14 = qual$5.join$default$2();
            Option x$15 = qual$5.join$default$3();
            this.assertEqual("SELECT * FROM t1, t2 UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), qual$5.join(x$13, x$14, x$15))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_RELATION_PRECEDENCE().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                package.plans$.DslLogicalPlan qual$6 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
                LogicalPlan x$16 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull());
                JoinType x$17 = qual$6.join$default$2();
                Option x$18 = qual$6.join$default$3();
                this.assertEqual("SELECT * FROM t1, t2 UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(qual$6.join(x$16, x$17, x$18)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            });
            package.plans$.DslLogicalPlan qual$7 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$19 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull());
            JoinType x$20 = qual$7.join$default$2();
            Option x$21 = qual$7.join$default$3();
            this.assertEqual("SELECT * FROM t1, (t2 UNPIVOT (val FOR col in (a, b)))", package.plans$.MODULE$.DslLogicalPlan(qual$7.join(x$19, x$20, x$21)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            package.plans$.DslLogicalPlan qual$8 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
            LogicalPlan x$22 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"}));
            JoinType x$23 = qual$8.join$default$2();
            Option x$24 = qual$8.join$default$3();
            package.plans$.DslLogicalPlan qual$9 = package.plans$.MODULE$.DslLogicalPlan(qual$8.join(x$22, x$23, x$24));
            LogicalPlan x$25 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}));
            JoinType x$26 = qual$9.join$default$2();
            Option x$27 = qual$9.join$default$3();
            this.assertEqual("SELECT * FROM t1, t2 JOIN t3 UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), qual$9.join(x$25, x$26, x$27))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_ENABLED().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ANSI_RELATION_PRECEDENCE().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                package.plans$.DslLogicalPlan qual$10 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})));
                package.plans$.DslLogicalPlan qual$11 = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t2"})));
                LogicalPlan x$28 = package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t3"}));
                JoinType x$29 = qual$11.join$default$2();
                Option x$30 = qual$11.join$default$3();
                LogicalPlan x$31 = package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), qual$11.join(x$28, x$29, x$30))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull());
                JoinType x$32 = qual$10.join$default$2();
                Option x$33 = qual$10.join$default$3();
                this.assertEqual("SELECT * FROM t1, t2 JOIN t3 UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(qual$10.join(x$31, x$32, x$33)).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)})));
            });
        }, new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("unpivot - nested unpivot", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertEqual("SELECT * FROM t1 UNPIVOT (val FOR col in (a, b)) UNPIVOT (val FOR col in (a, b))", package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)new Unpivot((Option)None$.MODULE$, (Option)new Some((Object)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))).$((Seq)Nil$.MODULE$), (List)Nil$.MODULE$), (List)Nil$.MODULE$))), (Option)None$.MODULE$, "col", (Seq)new .colon.colon((Object)"val", (List)Nil$.MODULE$), package.plans$.MODULE$.table((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"t1"})))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull()))).where((Expression)package.expressions$.MODULE$.DslExpression(package.expressions$.MODULE$.coalesce((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.StringToAttributeConversionHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"val"}))).$((Seq)Nil$.MODULE$)}))).isNotNull())).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{package.expressions$.MODULE$.star((Seq)Nil$.MODULE$)}))), new Position("UnpivotParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
    }
}

