/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.streaming;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.streaming.InternalOutputModes$;
import org.apache.spark.sql.streaming.OutputMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\tA\u0012J\u001c;fe:\fGnT;uaV$Xj\u001c3fgN+\u0018\u000e^3\u000b\u0005\u0011)\u0011!C:ue\u0016\fW.\u001b8h\u0015\t1q!\u0001\u0005dCR\fG._:u\u0015\tA\u0011\"A\u0002tc2T!AC\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u00051i\u0011AB1qC\u000eDWMC\u0001\u000f\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"A\u0002")
public class InternalOutputModesSuite
extends SparkFunSuite {
    private final void testMode$1(String outputMode, OutputMode expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(InternalOutputModes$.MODULE$.apply(outputMode));
        OutputMode $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("InternalOutputModesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
    }

    public InternalOutputModesSuite() {
        this.test("supported strings", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testMode$1("append", OutputMode.Append());
            this.testMode$1("Append", OutputMode.Append());
            this.testMode$1("complete", OutputMode.Complete());
            this.testMode$1("Complete", OutputMode.Complete());
            this.testMode$1("update", OutputMode.Update());
            this.testMode$1("Update", OutputMode.Update());
        }, new Position("InternalOutputModesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("unsupported strings", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String outputMode = "Xyz";
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> InternalOutputModes$.MODULE$.apply(outputMode), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("InternalOutputModesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41))));
            String x$2 = "STREAMING_OUTPUT_MODE.INVALID";
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"outputMode"), (Object)outputMode)}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "STREAMING_OUTPUT_MODE.INVALID", x$4, x$3, x$5, x$6);
        }, new Position("InternalOutputModesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }
}

