/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalStringStyles$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple10;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\t\u0013\u0001}AQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005\n=BQ!\u0014\u0001\u0005\n9CQ\u0001\u0015\u0001\u0005\nECQa\u0015\u0001\u0005\nQCQ\u0001\u0017\u0001\u0005\neCQ!\u0018\u0001\u0005\nyCQ\u0001\u0019\u0001\u0005\n\u0005DQ!\u001a\u0001\u0005\n\u0019DQ!\u001b\u0001\u0005\n)DQA\u001c\u0001\u0005\n=DQA\u001d\u0001\u0005\nMDQa\u001e\u0001\u0005\naDQa\u001f\u0001\u0005\nqDaa \u0001\u0005\n\u0005\u0005\u0001bBA\n\u0001\u0011%\u0011Q\u0003\u0002\u0013\u0013:$XM\u001d<bYV#\u0018\u000e\\:Tk&$XM\u0003\u0002\u0014)\u0005!Q\u000f^5m\u0015\t)b#\u0001\u0005dCR\fG._:u\u0015\t9\u0002$A\u0002tc2T!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0005\n\t\u0003C\tj\u0011\u0001G\u0005\u0003Ga\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0015\u0003\u0015\u0001H.\u00198t\u0013\tIcEA\u0005T#2CU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012\u0001\f\t\u0003[\u0001i\u0011AE\u0001\u0010G\",7m\u001b$s_6\u001cFO]5oOR\u0019\u0001GN\"\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006o\t\u0001\r\u0001O\u0001\u0006S:\u0004X\u000f\u001e\t\u0003s\u0001s!A\u000f \u0011\u0005m\u0012T\"\u0001\u001f\u000b\u0005ur\u0012A\u0002\u001fs_>$h(\u0003\u0002@e\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\ty$\u0007C\u0003E\u0005\u0001\u0007Q)\u0001\u0005fqB,7\r^3e!\t15*D\u0001H\u0015\tA\u0015*A\u0003usB,7O\u0003\u0002K1\u00051QO\\:bM\u0016L!\u0001T$\u0003!\r\u000bG.\u001a8eCJLe\u000e^3sm\u0006d\u0017AG2iK\u000e\\gI]8n\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4Ok2dGC\u0001\u0019P\u0011\u001594\u00011\u00019\u0003m\u0019\u0007.Z2l\rJ|W.\u00138wC2LGm\u0015;sS:<W)\u001c9usR\u0011\u0001G\u0015\u0005\u0006o\u0011\u0001\r\u0001O\u0001$G\",7m\u001b$s_6LeN^1mS\u0012\u001cFO]5oO&sg/\u00197jIB\u0013XMZ5y)\r\u0001TK\u0016\u0005\u0006o\u0015\u0001\r\u0001\u000f\u0005\u0006/\u0016\u0001\r\u0001O\u0001\u0007aJ,g-\u001b=\u0002Q\rDWmY6Ge>l\u0017J\u001c<bY&$7\u000b\u001e:j]\u001e,fN]3d_\u001et\u0017N_3e\u001dVl'-\u001a:\u0015\u0007AR6\fC\u00038\r\u0001\u0007\u0001\bC\u0003]\r\u0001\u0007\u0001(\u0001\u0004ok6\u0014WM]\u0001*G\",7m\u001b$s_6LeN^1mS\u0012\u001cFO]5oO\u0006\u0013\u0018\u000e\u001e5nKRL7-\u0012=dKB$\u0018n\u001c8\u0015\u0005Az\u0006\"B\u001c\b\u0001\u0004A\u0014AI2iK\u000e\\gI]8n\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4J]Z\fG.\u001b3WC2,X\rF\u00021E\u000eDQa\u000e\u0005A\u0002aBQ\u0001\u001a\u0005A\u0002a\nQA^1mk\u0016\fae\u00195fG.4%o\\7J]Z\fG.\u001b3TiJLgnZ%om\u0006d\u0017\u000e\u001a)sK\u000eL7/[8o)\r\u0001t\r\u001b\u0005\u0006o%\u0001\r\u0001\u000f\u0005\u0006I&\u0001\r\u0001O\u0001&G\",7m\u001b$s_6LeN^1mS\u0012\u001cFO]5oO&sg/\u00197jI\u001a\u0013\u0018m\u0019;j_:$2\u0001M6m\u0011\u00159$\u00021\u00019\u0011\u0015i'\u00021\u00019\u0003\u0011)h.\u001b;\u0002C\rDWmY6Ge>l\u0017J\u001c<bY&$7\u000b\u001e:j]\u001eLeN^1mS\u0012,f.\u001b;\u0015\u0007A\u0002\u0018\u000fC\u00038\u0017\u0001\u0007\u0001\bC\u0003n\u0017\u0001\u0007\u0001(A\u0012dQ\u0016\u001c7N\u0012:p[&sg/\u00197jIN#(/\u001b8h\u001b&\u001c8/\u001b8h\u001dVl'-\u001a:\u0015\u0007A\"X\u000fC\u00038\u0019\u0001\u0007\u0001\bC\u0003w\u0019\u0001\u0007\u0001(\u0001\u0003x_J$\u0017!I2iK\u000e\\gI]8n\u0013:4\u0018\r\\5e'R\u0014\u0018N\\4NSN\u001c\u0018N\\4V]&$Hc\u0001\u0019zu\")q'\u0004a\u0001q!)a/\u0004a\u0001q\u0005\u00113\r[3dW\u001a\u0013x.\\%om\u0006d\u0017\u000eZ*ue&tw-\u00168l]><h.\u0012:s_J$2\u0001M?\u007f\u0011\u00159d\u00021\u00019\u0011\u00151h\u00021\u00019\u0003a1\u0017-\u001b7Gk:\u001cw+\u001b;i\u0013:4\u0018\r\\5e\u0013:\u0004X\u000f\u001e\u000b\ba\u0005\r\u0011QAA\u0005\u0011\u00159t\u00021\u00019\u0011\u0019\t9a\u0004a\u0001q\u0005AQM\u001d:pe6\u001bx\rC\u0004\u0002\f=\u0001\r!!\u0004\u0002\u0013\r|gN^3si\u0016\u0014\b#B\u0019\u0002\u0010a*\u0015bAA\te\tIa)\u001e8di&|g.M\u0001\u000fi\u0016\u001cHoU5oO2,WK\\5u)-\u0001\u0014qCA\r\u0003C\t)#!\u000b\t\u000b5\u0004\u0002\u0019\u0001\u001d\t\rq\u0003\u0002\u0019AA\u000e!\r\t\u0014QD\u0005\u0004\u0003?\u0011$aA%oi\"9\u00111\u0005\tA\u0002\u0005m\u0011AB7p]RD7\u000fC\u0004\u0002(A\u0001\r!a\u0007\u0002\t\u0011\f\u0017p\u001d\u0005\b\u0003W\u0001\u0002\u0019AA\u0017\u00031i\u0017n\u0019:pg\u0016\u001cwN\u001c3t!\r\t\u0014qF\u0005\u0004\u0003c\u0011$\u0001\u0002'p]\u001e\u0004")
public class IntervalUtilsSuite
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$(this, f);
    }

    @Override
    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$(this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    private String sparkHome$lzycompute() {
        IntervalUtilsSuite intervalUtilsSuite = this;
        synchronized (intervalUtilsSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    @Override
    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private void checkFromString(String input, CalendarInterval expected) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)));
        CalendarInterval $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        CalendarInterval $org_scalatest_assert_macro_right2 = expected;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
    }

    private void checkFromInvalidStringNull(String input) {
        SparkIllegalArgumentException x$12 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44)));
        String x$2 = "INVALID_INTERVAL_FORMAT.INPUT_IS_NULL";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable)() -> "null"))}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$12, "INVALID_INTERVAL_FORMAT.INPUT_IS_NULL", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
    }

    private void checkFromInvalidStringEmpty(String input) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55)));
        String x$22 = "INVALID_INTERVAL_FORMAT.INPUT_IS_EMPTY";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable)() -> "null"))}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.INPUT_IS_EMPTY", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
    }

    private void checkFromInvalidStringInvalidPrefix(String input, String prefix) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)));
        String x$2 = "INVALID_INTERVAL_FORMAT.INVALID_PREFIX";
        Map x$32 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefix"), (Object)prefix)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.INVALID_PREFIX", x$4, x$32, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
    }

    private void checkFromInvalidStringUnrecognizedNumber(String input, String number) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78)));
        String x$2 = "INVALID_INTERVAL_FORMAT.UNRECOGNIZED_NUMBER";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$4 -> x$4.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"number"), (Object)number)}));
        Option x$42 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.UNRECOGNIZED_NUMBER", x$42, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    private void checkFromInvalidStringArithmeticException(String input) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90)));
        String x$2 = "INVALID_INTERVAL_FORMAT.ARITHMETIC_EXCEPTION";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$5 -> x$5.toString()).getOrElse((Function0 & Serializable)() -> "null"))}));
        Option x$4 = this.checkError$default$3();
        boolean x$52 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.ARITHMETIC_EXCEPTION", x$4, x$3, x$52, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
    }

    private void checkFromInvalidStringInvalidValue(String input, String value) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101)));
        String x$2 = "INVALID_INTERVAL_FORMAT.INVALID_VALUE";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$6 -> x$6.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$62 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.INVALID_VALUE", x$4, x$3, x$5, x$62);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
    }

    private void checkFromInvalidStringInvalidPrecision(String input, String value) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113)));
        String x$2 = "INVALID_INTERVAL_FORMAT.INVALID_PRECISION";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$7 -> x$7.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.INVALID_PRECISION", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
    }

    private void checkFromInvalidStringInvalidFraction(String input, String unit) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125)));
        String x$2 = "INVALID_INTERVAL_FORMAT.INVALID_FRACTION";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$8 -> x$8.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unit"), (Object)unit)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.INVALID_FRACTION", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    private void checkFromInvalidStringInvalidUnit(String input, String unit) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137)));
        String x$2 = "INVALID_INTERVAL_FORMAT.INVALID_UNIT";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$9 -> x$9.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unit"), (Object)unit)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.INVALID_UNIT", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    private void checkFromInvalidStringMissingNumber(String input, String word) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149)));
        String x$2 = "INVALID_INTERVAL_FORMAT.MISSING_NUMBER";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$10 -> x$10.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word"), (Object)word)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.MISSING_NUMBER", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
    }

    private void checkFromInvalidStringMissingUnit(String input, String word) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161)));
        String x$2 = "INVALID_INTERVAL_FORMAT.MISSING_UNIT";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$11 -> x$11.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word"), (Object)word)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.MISSING_UNIT", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
    }

    private void checkFromInvalidStringUnknownError(String input, String word) {
        SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)input)), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173)));
        String x$2 = "INVALID_INTERVAL_FORMAT.UNKNOWN_PARSING_ERROR";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), Option$.MODULE$.apply((Object)input).map((Function1 & Serializable)x$12 -> x$12.toString()).getOrElse((Function0 & Serializable)() -> "null")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"word"), (Object)word)}));
        Option x$4 = this.checkError$default$3();
        boolean x$5 = this.checkError$default$5();
        SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
        this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.UNKNOWN_PARSING_ERROR", x$4, x$3, x$5, x$6);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.safeStringToInterval(UTF8String.fromString((String)input)));
        Null$ $org_scalatest_assert_macro_right = null;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
    }

    private void failFuncWithInvalidInput(String input, String errorMsg, Function1<String, CalendarInterval> converter) {
        this.withClue("Expected to throw an exception for the invalid input", (Function0 & Serializable)() -> {
            IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable)() -> (CalendarInterval)converter.apply((Object)input), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = errorMsg;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        });
    }

    private void testSingleUnit(String unit, int number, int months, int days, long microseconds) {
        new .colon.colon((Object)"interval ", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)prefix -> {
            IntervalUtilsSuite.$anonfun$testSingleUnit$1(this, number, unit, months, days, microseconds, prefix);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testSingleUnit$1(IntervalUtilsSuite $this, int number$1, String unit$1, int months$1, int days$1, long microseconds$1, String prefix) {
        String input1 = prefix + number$1 + " " + unit$1;
        String input2 = prefix + number$1 + " " + unit$1 + "s";
        CalendarInterval result = new CalendarInterval(months$1, days$1, microseconds$1);
        $this.checkFromString(input1, result);
        $this.checkFromString(input2, result);
    }

    public static final /* synthetic */ void $anonfun$new$4(IntervalUtilsSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String input = (String)tuple2._1();
            CalendarInterval expected = (CalendarInterval)tuple2._2();
            $this.checkFromString(input, expected);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final long duration$1(String s, TimeUnit unit, int daysPerMonth) {
        return IntervalUtils$.MODULE$.getDuration(IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)s)), unit, daysPerMonth);
    }

    private static final boolean isNegative$1(String s, int daysPerMonth) {
        return IntervalUtils$.MODULE$.isNegative(IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)s)), daysPerMonth);
    }

    private final void check$1(String input, byte from, byte to, String expected) {
        this.withClue("from = " + from + ", to = " + to, (Function0 & Serializable)() -> {
            UTF8String expectedUtf8 = UTF8String.fromString((String)expected);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString(input, from, to));
            CalendarInterval $org_scalatest_assert_macro_right = IntervalUtils$.MODULE$.safeStringToInterval(expectedUtf8);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        });
    }

    private final void checkFail$1(String input, byte from, byte to, String errMsg) {
        this.failFuncWithInvalidInput(input, errMsg, (Function1<String, CalendarInterval>)(Function1 & Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s, from, to));
    }

    public static final /* synthetic */ Assertion $anonfun$new$66(IntervalUtilsSuite $this, long micros) {
        Duration duration = IntervalUtils$.MODULE$.microsToDuration(micros);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(duration)));
        long $org_scalatest_assert_macro_right = micros;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
    }

    public static final /* synthetic */ Assertion $anonfun$new$68(IntervalUtilsSuite $this, int months) {
        Period period = IntervalUtils$.MODULE$.monthsToPeriod(months);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(period)));
        int $org_scalatest_assert_macro_right = months;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
    }

    public static final /* synthetic */ void $anonfun$new$84(IntervalUtilsSuite $this, Tuple4 x0$8) {
        Tuple4 tuple4 = x0$8;
        if (tuple4 != null) {
            String input = (String)tuple4._1();
            int second = BoxesRunTime.unboxToInt((Object)tuple4._2());
            byte from = BoxesRunTime.unboxToByte((Object)tuple4._3());
            byte to = BoxesRunTime.unboxToByte((Object)tuple4._4());
            $this.failFuncWithInvalidInput(input, "second " + second + " outside range [0, 59]", (Function1<String, CalendarInterval>)(Function1 & Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s, from, to));
            return;
        }
        throw new MatchError((Object)tuple4);
    }

    public IntervalUtilsSuite() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$(this);
        this.test("string to interval: basic", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.testSingleUnit("YEAR", 3, 36, 0, 0L);
            this.testSingleUnit("Month", 3, 3, 0, 0L);
            this.testSingleUnit("Week", 3, 0, 21, 0L);
            this.testSingleUnit("DAY", 3, 0, 3, 0L);
            this.testSingleUnit("HouR", 3, 0, 0, 10800000000L);
            this.testSingleUnit("MiNuTe", 3, 0, 0, 180000000L);
            this.testSingleUnit("Second", 3, 0, 0, 3000000L);
            this.testSingleUnit("MilliSecond", 3, 0, 0, DateTimeUtils$.MODULE$.millisToMicros(3L));
            this.testSingleUnit("MicroSecond", 3, 0, 0, 3L);
            this.checkFromInvalidStringNull(null);
            this.checkFromInvalidStringEmpty("");
            this.checkFromInvalidStringEmpty("interval");
            this.checkFromInvalidStringUnrecognizedNumber("foo", "foo");
            this.checkFromInvalidStringUnrecognizedNumber("foo 1 day", "foo");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("string to interval: interval with dangling parts should not results null", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkFromInvalidStringMissingNumber("+", "+");
            this.checkFromInvalidStringMissingNumber("-", "-");
            this.checkFromInvalidStringMissingUnit("+ 2", "2");
            this.checkFromInvalidStringMissingUnit("- 1", "1");
            this.checkFromInvalidStringMissingUnit("1", "1");
            this.checkFromInvalidStringMissingUnit("1.2", "1.2");
            this.checkFromInvalidStringMissingUnit("1 day 2", "2");
            this.checkFromInvalidStringMissingUnit("1 day 2.2", "2.2");
            this.checkFromInvalidStringMissingNumber("1 day -", "-");
            this.checkFromInvalidStringMissingUnit("-.", "-.");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("string to interval: multiple units", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-1 MONTH 1 day -1 microseconds"), (Object)new CalendarInterval(-1, 1, -1L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)" 123 MONTHS        123 DAYS  123 Microsecond    "), (Object)new CalendarInterval(123, 123, 123L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval -1 day +3 Microseconds"), (Object)new CalendarInterval(0, -1, 3L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"interval -   1 day +     3 Microseconds"), (Object)new CalendarInterval(0, -1, 3L)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"  interval  8  years -11 months 123  weeks   -1 day 23 hours -22 minutes 1 second  -123  millisecond    567 microseconds "), (Object)new CalendarInterval(85, 860, 81480877567L)), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$1 -> {
            IntervalUtilsSuite.$anonfun$new$4(this, x0$1);
            return BoxedUnit.UNIT;
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        this.test("string to interval: special cases", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkFromString("1 day 1 year", new CalendarInterval(12, 1, 0L));
            this.checkFromString("1 day 10 day", new CalendarInterval(0, 11, 0L));
            this.checkFromInvalidStringInvalidFraction("1.5 days", "days");
            this.checkFromInvalidStringInvalidFraction("1. hour", "hour");
            this.checkFromInvalidStringInvalidUnit("1 hourX", "hourx");
            this.checkFromInvalidStringUnrecognizedNumber("~1 hour", "~1");
            this.checkFromInvalidStringInvalidUnit("1 Mour", "mour");
            this.checkFromInvalidStringInvalidUnit("1 aour", "aour");
            this.checkFromInvalidStringInvalidValue("1a1 hour", "1a1");
            this.checkFromInvalidStringInvalidValue("1.1a1 seconds", "1.1a1");
            this.checkFromInvalidStringArithmeticException("2234567890 days");
            this.checkFromInvalidStringInvalidValue(". seconds", ".");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("string to interval: whitespaces", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkFromInvalidStringEmpty(" ");
            this.checkFromInvalidStringEmpty("\n");
            this.checkFromInvalidStringEmpty("\t");
            this.checkFromString("1 \t day \n 2 \r hour", new CalendarInterval(0, 1, 7200000000L));
            this.checkFromInvalidStringInvalidPrefix("interval1 \t day \n 2 \r hour", "interval1");
            this.checkFromString("interval\r1\tday", new CalendarInterval(0, 1, 0L));
            this.checkFromInvalidStringUnrecognizedNumber("\u4e2d\u56fd interval 1 day", "\u4e2d\u56fd");
            this.checkFromInvalidStringInvalidPrefix("interval\u6d59\u6c5f 1 day", "interval\u6d59\u6c5f");
            this.checkFromInvalidStringInvalidValue("interval 1\u676d\u5dde day", "1\u676d\u5dde");
            this.checkFromInvalidStringInvalidUnit("interval 1 \u6ee8\u6c5fday", "\u6ee8\u6c5fday");
            this.checkFromInvalidStringInvalidUnit("interval 1 day\u957f\u6cb3", "day\u957f\u6cb3");
            this.checkFromInvalidStringUnrecognizedNumber("interval 1 day \u7f51\u5546\u8def", "\u7f51\u5546\u8def");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("string to interval: seconds with fractional part", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.checkFromString("0.1 seconds", new CalendarInterval(0, 0, 100000L));
            this.checkFromString("1. seconds", new CalendarInterval(0, 0, 1000000L));
            this.checkFromString("123.001 seconds", new CalendarInterval(0, 0, 123001000L));
            this.checkFromString("1.001001 seconds", new CalendarInterval(0, 0, 1001001L));
            this.checkFromString("1 minute 1.001001 seconds", new CalendarInterval(0, 0, 61001001L));
            this.checkFromString("-1.5 seconds", new CalendarInterval(0, 0, -1500000L));
            this.checkFromString("0.999999999 seconds", new CalendarInterval(0, 0, 999999L));
            this.checkFromString(".999999999 seconds", new CalendarInterval(0, 0, 999999L));
            this.checkFromInvalidStringInvalidPrecision("0.123456789123 seconds", "0.123456789123");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("from year-month string", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String e2;
            String e1;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("99-10"));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("+99-10"));
            CalendarInterval $org_scalatest_assert_macro_right2 = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("-8-10"));
            CalendarInterval $org_scalatest_assert_macro_right3 = new CalendarInterval(-106, 0, 0L);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
            this.failFuncWithInvalidInput("99-15", "year-month", (Function1<String, CalendarInterval>)(Function1 & Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            this.failFuncWithInvalidInput("9a9-15", "Interval string does not match year-month format", (Function1<String, CalendarInterval>)(Function1 & Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("99-10 "));
            CalendarInterval $org_scalatest_assert_macro_right4 = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("+99-10\t"));
            CalendarInterval $org_scalatest_assert_macro_right5 = new CalendarInterval(1198, 0, 0L);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromYearMonthString("\t\t-8-10\t"));
            CalendarInterval $org_scalatest_assert_macro_right6 = new CalendarInterval(-106, 0, 0L);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            this.failFuncWithInvalidInput("99\t-15", "Interval string does not match year-month format", (Function1<String, CalendarInterval>)(Function1 & Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            this.failFuncWithInvalidInput("-\t99-15", "Interval string does not match year-month format", (Function1<String, CalendarInterval>)(Function1 & Serializable)input -> IntervalUtils$.MODULE$.fromYearMonthString(input));
            CalendarInterval $org_scalatest_assert_macro_left7 = IntervalUtils$.MODULE$.fromYearMonthString("178956970-6");
            CalendarInterval $org_scalatest_assert_macro_right7 = new CalendarInterval(0x7FFFFFFE, 0, 0L);
            CalendarInterval calendarInterval = $org_scalatest_assert_macro_left7;
            CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            CalendarInterval $org_scalatest_assert_macro_left8 = IntervalUtils$.MODULE$.fromYearMonthString("178956970-7");
            CalendarInterval $org_scalatest_assert_macro_right8 = new CalendarInterval(Integer.MAX_VALUE, 0, 0L);
            CalendarInterval calendarInterval3 = $org_scalatest_assert_macro_left8;
            CalendarInterval calendarInterval4 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(calendarInterval3 != null ? !calendarInterval3.equals(calendarInterval4) : calendarInterval4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
            String $org_scalatest_assert_macro_left9 = e1 = ((Throwable)this.intercept((Function0 & Serializable)() -> {
                CalendarInterval $org_scalatest_assert_macro_left = IntervalUtils$.MODULE$.fromYearMonthString("178956970-8");
                CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314))).getMessage();
            String $org_scalatest_assert_macro_right9 = "year-month";
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.contains($org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
            CalendarInterval $org_scalatest_assert_macro_left10 = IntervalUtils$.MODULE$.fromYearMonthString("-178956970-8");
            CalendarInterval $org_scalatest_assert_macro_right10 = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
            CalendarInterval calendarInterval5 = $org_scalatest_assert_macro_left10;
            CalendarInterval calendarInterval6 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "==", (Object)$org_scalatest_assert_macro_right10, !(calendarInterval5 != null ? !calendarInterval5.equals(calendarInterval6) : calendarInterval6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            String $org_scalatest_assert_macro_left11 = e2 = ((Throwable)this.intercept((Function0 & Serializable)() -> {
                CalendarInterval $org_scalatest_assert_macro_left = IntervalUtils$.MODULE$.fromYearMonthString("-178956970-9");
                CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
                CalendarInterval calendarInterval = $org_scalatest_assert_macro_left;
                CalendarInterval calendarInterval2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(calendarInterval != null ? !calendarInterval.equals(calendarInterval2) : calendarInterval2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319))).getMessage();
            String $org_scalatest_assert_macro_right11 = "year-month";
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "contains", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.contains($org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("from day-time string - legacy", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_FROM_DAYTIME_STRING().key()), (Object)"true")}), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString("5 12:40:30.999999999"));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(0, 5, 45630999999L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString("10 0:12:0.888"));
            CalendarInterval $org_scalatest_assert_macro_right2 = new CalendarInterval(0, 10, 720000000L + DateTimeUtils$.MODULE$.millisToMicros(888L));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.fromDayTimeString("-3 0:0:0"));
            CalendarInterval $org_scalatest_assert_macro_right3 = new CalendarInterval(0, -3, 0L);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.fromDayTimeString("5 30:12:20"), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342)))));
            Map x$2 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)"requirement failed: hour 30 outside range [0, 23]"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)"5 30:12:20")}));
            String x$3 = "INVALID_INTERVAL_FORMAT.DAY_TIME_PARSING";
            Some x$4 = new Some((Object)"22006");
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "INVALID_INTERVAL_FORMAT.DAY_TIME_PARSING", (Option)x$4, x$2, x$5, x$6);
            SparkIllegalArgumentException x$7 = (SparkIllegalArgumentException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.fromDayTimeString("5 12:40:30.999999999", (byte)0, (byte)0), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353)))));
            Map x$8 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)"day"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)"day"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)"5 12:40:30.999999999")}));
            String x$9 = "INVALID_INTERVAL_FORMAT.UNSUPPORTED_FROM_TO_EXPRESSION";
            Some x$10 = new Some((Object)"22006");
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "INVALID_INTERVAL_FORMAT.UNSUPPORTED_FROM_TO_EXPRESSION", (Option)x$10, x$8, x$11, x$12);
            this.failFuncWithInvalidInput("5 30:12:20", "hour 30 outside range", (Function1<String, CalendarInterval>)(Function1 & Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s));
            this.failFuncWithInvalidInput("5 30-12", "must match day-time format", (Function1<String, CalendarInterval>)(Function1 & Serializable)s -> IntervalUtils$.MODULE$.fromDayTimeString(s));
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.test("interval duration", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("0 seconds", TimeUnit.MILLISECONDS, 31)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("1 month", TimeUnit.DAYS, 31)));
            int $org_scalatest_assert_macro_right2 = 31;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("1 microsecond", TimeUnit.MICROSECONDS, 30)));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtilsSuite.duration$1("1 month -30 days", TimeUnit.DAYS, 31)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            ArithmeticException e = (ArithmeticException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> IntervalUtilsSuite.duration$1(Integer.MAX_VALUE + " month", TimeUnit.SECONDS, 31), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            String $org_scalatest_assert_macro_left5 = e.getMessage();
            String $org_scalatest_assert_macro_right5 = "overflow";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.test("negative interval", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 months", 28), "isNegative(\"-1 months\", 28)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 microsecond", 30), "isNegative(\"-1 microsecond\", 30)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 month 30 days", 31), "isNegative(\"-1 month 30 days\", 31)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 392));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("2 months -61 days", 30), "isNegative(\"2 months -61 days\", 30)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 year -2 seconds", 30), "isNegative(\"-1 year -2 seconds\", 30)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("0 months", 28), "isNegative(\"0 months\", 28)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("1 year -360 days", 31), "isNegative(\"1 year -360 days\", 31)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(IntervalUtilsSuite.isNegative$1("-1 year 380 days", 31), "isNegative(\"-1 year 380 days\", 31)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("negate", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.negateExact(new CalendarInterval(1, 2, 3L)));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(-1, -2, -3L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.negate(new CalendarInterval(1, 2, 3L)));
            CalendarInterval $org_scalatest_assert_macro_right2 = new CalendarInterval(-1, -2, -3L);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
        this.test("parsing second_nano string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            SparkIllegalArgumentException x$13 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> IntervalUtils$.MODULE$.toDTInterval("12", "33.33.33", 1), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407))));
            String x$14 = "INVALID_INTERVAL_FORMAT.SECOND_NANO_FORMAT";
            Map x$15 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)"33.33.33")}));
            Some x$16 = new Some((Object)"22006");
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "INVALID_INTERVAL_FORMAT.SECOND_NANO_FORMAT", (Option)x$16, x$15, x$17, x$18);
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        this.test("subtract one interval by another", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CalendarInterval input1 = new CalendarInterval(3, 1, 3600000000L);
            CalendarInterval input2 = new CalendarInterval(2, 4, 360000000000L);
            CalendarInterval input3 = new CalendarInterval(-10, -30, -291600000000L);
            CalendarInterval input4 = new CalendarInterval(75, 150, 720000000000L);
            new .colon.colon((Function2 & Serializable)(left, right) -> IntervalUtils$.MODULE$.subtractExact(left, right), (List)new .colon.colon((Function2 & Serializable)(left, right) -> IntervalUtils$.MODULE$.subtract(left, right), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)func -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new CalendarInterval(1, -3, -356400000000L));
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)input1, (Object)input2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(-85, -180, -1011600000000L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)input3, (Object)input4);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("add two intervals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            CalendarInterval input1 = new CalendarInterval(3, 1, 3600000000L);
            CalendarInterval input2 = new CalendarInterval(2, 4, 360000000000L);
            CalendarInterval input3 = new CalendarInterval(-10, -30, -291600000000L);
            CalendarInterval input4 = new CalendarInterval(75, 150, 720000000000L);
            new .colon.colon((Function2 & Serializable)(left, right) -> IntervalUtils$.MODULE$.addExact(left, right), (List)new .colon.colon((Function2 & Serializable)(left, right) -> IntervalUtils$.MODULE$.add(left, right), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)func -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new CalendarInterval(5, 5, 363600000000L));
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)input1, (Object)input2);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(65, 120, 428400000000L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)input3, (Object)input4);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        this.test("multiply by num", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            new .colon.colon((Function2 & Serializable)(interval, num) -> IntervalUtils$.MODULE$.multiply(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)new .colon.colon((Function2 & Serializable)(interval, num) -> IntervalUtils$.MODULE$.multiplyExact(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)func -> {
                CalendarInterval interval = new CalendarInterval(0, 0, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(interval);
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)0.0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
                interval = new CalendarInterval(123, 456, 789L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(5166, 19152, 33138L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)42.0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
                interval = new CalendarInterval(-123, -456, -789L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new CalendarInterval(-5166, -19152, -33138L));
                CalendarInterval $org_scalatest_assert_macro_right3 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)42.0));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
                interval = new CalendarInterval(1, 5, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new CalendarInterval(1, 7, 43200000000L));
                CalendarInterval $org_scalatest_assert_macro_right4 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)1.5));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
                interval = new CalendarInterval(2, 2, 7200000000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new CalendarInterval(2, 2, 43200000000L));
                CalendarInterval $org_scalatest_assert_macro_right5 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)1.2));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
            });
            CalendarInterval interval2 = new CalendarInterval(2, 0, 0L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.multiply(interval2, 2.147483647E9));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MAX_VALUE, 0, 0L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            ArithmeticException e = (ArithmeticException)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.multiplyExact(interval2, 2.147483647E9), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
            String $org_scalatest_assert_macro_left2 = e.getMessage();
            String $org_scalatest_assert_macro_right2 = "overflow";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("divide by num", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            new .colon.colon((Function2 & Serializable)(interval, num) -> IntervalUtils$.MODULE$.divide(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)new .colon.colon((Function2 & Serializable)(interval, num) -> IntervalUtils$.MODULE$.divideExact(interval, BoxesRunTime.unboxToDouble((Object)num)), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)func -> {
                CalendarInterval interval = new CalendarInterval(0, 0, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(interval);
                CalendarInterval $org_scalatest_assert_macro_right = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)10.0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
                interval = new CalendarInterval(1, 3, 30000000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new CalendarInterval(0, 1, 43215000000L));
                CalendarInterval $org_scalatest_assert_macro_right2 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)2.0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new CalendarInterval(2, 6, 60000000L));
                CalendarInterval $org_scalatest_assert_macro_right3 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)0.5));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 467));
                interval = new CalendarInterval(-1, 0, -30000000L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new CalendarInterval(0, 0, -15000000L));
                CalendarInterval $org_scalatest_assert_macro_right4 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)2.0));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new CalendarInterval(-2, 0, -60000000L));
                CalendarInterval $org_scalatest_assert_macro_right5 = (CalendarInterval)func.apply((Object)interval, (Object)BoxesRunTime.boxToDouble((double)0.5));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
            });
            ObjectRef interval2 = ObjectRef.create((Object)new CalendarInterval(Integer.MAX_VALUE, Integer.MAX_VALUE, 0L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.divide((CalendarInterval)interval2.elem, 0.9));
            CalendarInterval $org_scalatest_assert_macro_right = new CalendarInterval(Integer.MAX_VALUE, Integer.MAX_VALUE, RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(2.06158430112E19)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            ArithmeticException e1 = (ArithmeticException)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.divideExact((CalendarInterval)interval$2.elem, 0.9), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
            String $org_scalatest_assert_macro_left2 = e1.getMessage();
            String $org_scalatest_assert_macro_right2 = "integer overflow";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
            interval2.elem = new CalendarInterval(123, 456, 789L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.divide((CalendarInterval)interval2.elem, 0.0));
            Null$ $org_scalatest_assert_macro_right3 = null;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", null, $org_scalatest_assert_macro_left3.$eq$eq$eq($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
            ArithmeticException e2 = (ArithmeticException)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.divideExact((CalendarInterval)interval$2.elem, 0.0), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 481));
            String $org_scalatest_assert_macro_left4 = e2.getMessage();
            String $org_scalatest_assert_macro_right4 = "Division by zero";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        this.test("from day-time string", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            this.check$1("12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "12 hours 40 minutes");
            this.check$1("+12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "12 hours 40 minutes");
            this.check$1("-12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "-12 hours -40 minutes");
            this.checkFail$1("5 12:40", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE(), "Interval string does not match day-time format");
            this.check$1("12:40:30.999999999", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "12 hours 40 minutes 30.999999 seconds");
            this.check$1("+12:40:30.123456789", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "12 hours 40 minutes 30.123456 seconds");
            this.check$1("-12:40:30.123456789", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "-12 hours -40 minutes -30.123456 seconds");
            this.checkFail$1("5 12:40:30", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.checkFail$1("12:40:30.0123456789", DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.check$1("40:30.123456789", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "40 minutes 30.123456 seconds");
            this.check$1("+40:30.123456789", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "40 minutes 30.123456 seconds");
            this.check$1("-40:30.123456789", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "-40 minutes -30.123456 seconds");
            this.checkFail$1("12:40:30", DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.check$1("5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "5 days 12 hours");
            this.check$1("+5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "5 days 12 hours");
            this.check$1("-5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "-5 days -12 hours");
            this.checkFail$1("5 12:30", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR(), "Interval string does not match day-time format");
            this.check$1("5 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "5 days 12 hours 40 minutes");
            this.check$1("+5 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "5 days 12 hours 40 minutes");
            this.check$1("-5 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "-5 days -12 hours -40 minutes");
            this.checkFail$1("5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "Interval string does not match day-time format");
            this.check$1("5 12:40:30.123", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "5 days 12 hours 40 minutes 30.123 seconds");
            this.check$1("+5 12:40:30.123456", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "5 days 12 hours 40 minutes 30.123456 seconds");
            this.check$1("-5 12:40:30.123456789", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "-5 days -12 hours -40 minutes -30.123456 seconds");
            this.checkFail$1("5 12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.checkFail$1("5 30:12:20", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "hour 30 outside range");
            this.checkFail$1("5 30-12", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND(), "Interval string does not match day-time format");
            this.check$1("\t +5 12:40\t ", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "5 days 12 hours 40 minutes");
            this.checkFail$1("+5\t 12:40", DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE(), "Interval string does not match day-time format");
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        this.test("interval overflow check", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            CalendarInterval maxMonth = new CalendarInterval(Integer.MAX_VALUE, 0, 0L);
            CalendarInterval minMonth = new CalendarInterval(Integer.MIN_VALUE, 0, 0L);
            CalendarInterval oneMonth = new CalendarInterval(1, 0, 0L);
            CalendarInterval maxDay = new CalendarInterval(0, Integer.MAX_VALUE, 0L);
            CalendarInterval minDay = new CalendarInterval(0, Integer.MIN_VALUE, 0L);
            CalendarInterval oneDay = new CalendarInterval(0, 1, 0L);
            CalendarInterval maxMicros = new CalendarInterval(0, 0, Long.MAX_VALUE);
            CalendarInterval minMicros = new CalendarInterval(0, 0, Long.MIN_VALUE);
            CalendarInterval oneMicros = new CalendarInterval(0, 0, 1L);
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.negateExact(minMonth), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.negate(minMonth));
            CalendarInterval $org_scalatest_assert_macro_right = minMonth;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.addExact(maxMonth, oneMonth), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.addExact(maxDay, oneDay), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.addExact(maxMicros, oneMicros), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.add(maxMonth, oneMonth));
            CalendarInterval $org_scalatest_assert_macro_right2 = minMonth;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.add(maxDay, oneDay));
            CalendarInterval $org_scalatest_assert_macro_right3 = minDay;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 554));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.add(maxMicros, oneMicros));
            CalendarInterval $org_scalatest_assert_macro_right4 = minMicros;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.subtractExact(minDay, oneDay), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.subtractExact(minMonth, oneMonth), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.subtractExact(minMicros, oneMicros), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 559));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.subtract(minMonth, oneMonth));
            CalendarInterval $org_scalatest_assert_macro_right5 = maxMonth;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.subtract(minDay, oneDay));
            CalendarInterval $org_scalatest_assert_macro_right6 = maxDay;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(IntervalUtils$.MODULE$.subtract(minMicros, oneMicros));
            CalendarInterval $org_scalatest_assert_macro_right7 = maxMicros;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
            this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.multiplyExact(maxMonth, 2.0), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
            return (ArithmeticException)this.intercept((Function0 & Serializable)() -> IntervalUtils$.MODULE$.divideExact(maxDay, 0.5), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("SPARK-34605: microseconds to duration", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(IntervalUtils$.MODULE$.microsToDuration(0L).isZero(), "org.apache.spark.sql.catalyst.util.IntervalUtils.microsToDuration(0L).isZero()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 569));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(-1L).toNanos()));
            int $org_scalatest_assert_macro_right = -1000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(1L).toNanos()));
            int $org_scalatest_assert_macro_right2 = 1000;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(Long.MAX_VALUE).toDays()));
            int $org_scalatest_assert_macro_right3 = 106751991;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.microsToDuration(Long.MIN_VALUE).toDays()));
            int $org_scalatest_assert_macro_right4 = -106751991;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
        this.test("SPARK-34605: duration to microseconds", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String errMsg;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ZERO)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 577));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ofSeconds(-1L))));
            int $org_scalatest_assert_macro_right2 = -1000000;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ofNanos(123456L))));
            int $org_scalatest_assert_macro_right3 = 123;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 579));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)IntervalUtils$.MODULE$.durationToMicros(Duration.ofDays(106751991L))));
            long $org_scalatest_assert_macro_right4 = 9223372022400000000L;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
            String $org_scalatest_assert_macro_left5 = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable)() -> IntervalUtils$.MODULE$.durationToMicros(Duration.ofDays(106751992L)), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583))).getMessage();
            String $org_scalatest_assert_macro_right5 = "long overflow";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        this.test("SPARK-34615: period to months", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String errMsg;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.ZERO)));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -1, 0))));
            int $org_scalatest_assert_macro_right2 = -1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -11, 0))));
            int $org_scalatest_assert_macro_right3 = -11;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 592));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -12, 0))));
            int $org_scalatest_assert_macro_right4 = -12;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 593));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -13, 0))));
            int $org_scalatest_assert_macro_right5 = -13;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, 11, 0), YearMonthIntervalType$.MODULE$.YEAR())));
            int $org_scalatest_assert_macro_right6 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -11, 0), YearMonthIntervalType$.MODULE$.YEAR())));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 596));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, 12, 0), YearMonthIntervalType$.MODULE$.YEAR())));
            int $org_scalatest_assert_macro_right8 = 12;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -12, 0), YearMonthIntervalType$.MODULE$.YEAR())));
            int $org_scalatest_assert_macro_right9 = -12;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, 13, 0), YearMonthIntervalType$.MODULE$.YEAR())));
            int $org_scalatest_assert_macro_right10 = 12;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, -13, 0), YearMonthIntervalType$.MODULE$.YEAR())));
            int $org_scalatest_assert_macro_right11 = -12;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(-1, 0, 10))));
            int $org_scalatest_assert_macro_right12 = -12;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 601));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0xAAAAAAA, 7, 0))));
            int $org_scalatest_assert_macro_right13 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(-178956970, -8, 123))));
            int $org_scalatest_assert_macro_right14 = Integer.MIN_VALUE;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)IntervalUtils$.MODULE$.periodToMonths(Period.of(0, Integer.MAX_VALUE, Integer.MAX_VALUE))));
            int $org_scalatest_assert_macro_right15 = Integer.MAX_VALUE;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
            String $org_scalatest_assert_macro_left16 = errMsg = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable)() -> IntervalUtils$.MODULE$.periodToMonths(Period.of(Integer.MAX_VALUE, 0, 0)), ClassTag$.MODULE$.apply(ArithmeticException.class), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606))).getMessage();
            String $org_scalatest_assert_macro_right16 = "integer overflow";
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "contains", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.contains($org_scalatest_assert_macro_right16), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        this.test("SPARK-34615: months to period", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(0));
            Period $org_scalatest_assert_macro_right = Period.ZERO;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(-11));
            Period $org_scalatest_assert_macro_right2 = Period.of(0, -11, 0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(11));
            Period $org_scalatest_assert_macro_right3 = Period.of(0, 11, 0);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(27));
            Period $org_scalatest_assert_macro_right4 = Period.of(2, 3, 0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(-13));
            Period $org_scalatest_assert_macro_right5 = Period.of(-1, -1, 0);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(Integer.MAX_VALUE));
            Period $org_scalatest_assert_macro_right6 = Period.ofYears(0xAAAAAAA).withMonths(7);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(Integer.MIN_VALUE));
            Period $org_scalatest_assert_macro_right7 = Period.ofYears(-178956970).withMonths(-8);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 619));
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("SPARK-34695: round trip conversion of micros -> duration -> micros", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 999999L, -999999L, 1000000L, -1000000L, 9223372036853775807L, -9223372036853775808L, Long.MAX_VALUE, Long.MIN_VALUE})).foreach((Function1 & Serializable)micros -> IntervalUtilsSuite.$anonfun$new$66(this, BoxesRunTime.unboxToLong((Object)micros))), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
        this.test("SPARK-34715: Add round trip tests for period <-> month and duration <-> micros", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 11, 13, 12, -12, 0x7FFFFFF3, -2147483636, Integer.MAX_VALUE, Integer.MIN_VALUE})).foreach((Function1 & Serializable)months -> IntervalUtilsSuite.$anonfun$new$68(this, BoxesRunTime.unboxToInt((Object)months)));
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Period[]{IntervalUtils$.MODULE$.monthsToPeriod(0), IntervalUtils$.MODULE$.monthsToPeriod(11), IntervalUtils$.MODULE$.monthsToPeriod(13), IntervalUtils$.MODULE$.monthsToPeriod(12), IntervalUtils$.MODULE$.monthsToPeriod(-12), IntervalUtils$.MODULE$.monthsToPeriod(0x7FFFFFF3), IntervalUtils$.MODULE$.monthsToPeriod(-2147483636), IntervalUtils$.MODULE$.monthsToPeriod(Integer.MAX_VALUE), IntervalUtils$.MODULE$.monthsToPeriod(Integer.MIN_VALUE)})).foreach((Function1 & Serializable)period -> {
                int months = IntervalUtils$.MODULE$.periodToMonths(period);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.monthsToPeriod(months));
                Period $org_scalatest_assert_macro_right = period;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 665));
            });
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Duration[]{IntervalUtils$.MODULE$.microsToDuration(0L), IntervalUtils$.MODULE$.microsToDuration(999999L), IntervalUtils$.MODULE$.microsToDuration(-999999L), IntervalUtils$.MODULE$.microsToDuration(1000000L), IntervalUtils$.MODULE$.microsToDuration(-1000000L), IntervalUtils$.MODULE$.microsToDuration(9223372036853775807L), IntervalUtils$.MODULE$.microsToDuration(-9223372036853775808L), IntervalUtils$.MODULE$.microsToDuration(Long.MAX_VALUE), IntervalUtils$.MODULE$.microsToDuration(Long.MIN_VALUE)})).foreach((Function1 & Serializable)duration -> {
                long micros = IntervalUtils$.MODULE$.durationToMicros(duration);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.microsToDuration(micros));
                Duration $org_scalatest_assert_macro_right = duration;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            });
        }, new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
        this.test("SPARK-35016: format year-month intervals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Tuple2((Object)"0-0", (Object)"INTERVAL '0-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-11)), (Object)new Tuple2((Object)"-0-11", (Object)"INTERVAL '-0-11' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new Tuple2((Object)"0-11", (Object)"INTERVAL '0-11' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-12)), (Object)new Tuple2((Object)"-1-0", (Object)"INTERVAL '-1-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)12)), (Object)new Tuple2((Object)"1-0", (Object)"INTERVAL '1-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-13)), (Object)new Tuple2((Object)"-1-1", (Object)"INTERVAL '-1-1' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)13)), (Object)new Tuple2((Object)"1-1", (Object)"INTERVAL '1-1' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-24)), (Object)new Tuple2((Object)"-2-0", (Object)"INTERVAL '-2-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)24)), (Object)new Tuple2((Object)"2-0", (Object)"INTERVAL '2-0' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)), (Object)new Tuple2((Object)"-178956970-8", (Object)"INTERVAL '-178956970-8' YEAR TO MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Object)new Tuple2((Object)"178956970-7", (Object)"INTERVAL '178956970-7' YEAR TO MONTH"))})).foreach((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int months = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String hiveIntervalStr = (String)tuple22._1();
                    String ansiIntervalStr = (String)tuple22._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right = ansiIntervalStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.HIVE_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right2 = hiveIntervalStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        this.test("SPARK-49208 format year-month intervals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Tuple2((Object)"0-0", (Object)"INTERVAL '0' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-11)), (Object)new Tuple2((Object)"-0-11", (Object)"INTERVAL '-11' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new Tuple2((Object)"0-11", (Object)"INTERVAL '11' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-12)), (Object)new Tuple2((Object)"-1-0", (Object)"INTERVAL '-12' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)12)), (Object)new Tuple2((Object)"1-0", (Object)"INTERVAL '12' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-13)), (Object)new Tuple2((Object)"-1-1", (Object)"INTERVAL '-13' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)13)), (Object)new Tuple2((Object)"1-1", (Object)"INTERVAL '13' MONTH")), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int months = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String hiveIntervalStr = (String)tuple22._1();
                    String ansiIntervalStr = (String)tuple22._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right = ansiIntervalStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.HIVE_STYLE(), YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right2 = hiveIntervalStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
        this.test("SPARK-35016: format day-time intervals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)new Tuple2((Object)"0 00:00:00.000000000", (Object)"INTERVAL '0 00:00:00' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)new Tuple2((Object)"-0 00:00:00.000001000", (Object)"INTERVAL '-0 00:00:00.000001' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)10000L)), (Object)new Tuple2((Object)"0 00:00:00.010000000", (Object)"INTERVAL '0 00:00:00.01' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-10627203000000L)), (Object)new Tuple2((Object)"-123 00:00:03.000000000", (Object)"INTERVAL '-123 00:00:03' DAY TO SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Object)new Tuple2((Object)"-106751991 04:00:54.775808000", (Object)"INTERVAL '-106751991 04:00:54.775808' DAY TO SECOND")), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                long micros = tuple2._1$mcJ$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String hiveIntervalStr = (String)tuple22._1();
                    String ansiIntervalStr = (String)tuple22._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right = ansiIntervalStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.HIVE_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right2 = hiveIntervalStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        this.test("SPARK-49208: format negative month intervals", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Tuple2((Object)"0-0", (Object)"INTERVAL '0' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-11)), (Object)new Tuple2((Object)"-0-11", (Object)"INTERVAL '-11' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new Tuple2((Object)"0-11", (Object)"INTERVAL '11' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-12)), (Object)new Tuple2((Object)"-1-0", (Object)"INTERVAL '-12' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)12)), (Object)new Tuple2((Object)"1-0", (Object)"INTERVAL '12' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-13)), (Object)new Tuple2((Object)"-1-1", (Object)"INTERVAL '-13' MONTH")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)13)), (Object)new Tuple2((Object)"1-1", (Object)"INTERVAL '13' MONTH")), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 != null) {
                int months = tuple2._1$mcI$sp();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String hiveIntervalStr = (String)tuple22._1();
                    String ansiIntervalStr = (String)tuple22._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right = ansiIntervalStr;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.HIVE_STYLE(), YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right2 = hiveIntervalStr;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
        this.test("SPARK-35734: Format day-time intervals using type fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L)), (Object)new Tuple10((Object)"INTERVAL '0 00:00:00' DAY TO SECOND", (Object)"INTERVAL '0 00:00' DAY TO MINUTE", (Object)"INTERVAL '0 00' DAY TO HOUR", (Object)"INTERVAL '00:00:00' HOUR TO SECOND", (Object)"INTERVAL '00:00' HOUR TO MINUTE", (Object)"INTERVAL '00:00' MINUTE TO SECOND", (Object)"INTERVAL '0' DAY", (Object)"INTERVAL '00' HOUR", (Object)"INTERVAL '00' MINUTE", (Object)"INTERVAL '00' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-1L)), (Object)new Tuple10((Object)"INTERVAL '-0 00:00:00.000001' DAY TO SECOND", (Object)"INTERVAL '-0 00:00' DAY TO MINUTE", (Object)"INTERVAL '-0 00' DAY TO HOUR", (Object)"INTERVAL '-00:00:00.000001' HOUR TO SECOND", (Object)"INTERVAL '-00:00' HOUR TO MINUTE", (Object)"INTERVAL '-00:00.000001' MINUTE TO SECOND", (Object)"INTERVAL '-0' DAY", (Object)"INTERVAL '-00' HOUR", (Object)"INTERVAL '-00' MINUTE", (Object)"INTERVAL '-00.000001' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)10000L)), (Object)new Tuple10((Object)"INTERVAL '0 00:00:00.01' DAY TO SECOND", (Object)"INTERVAL '0 00:00' DAY TO MINUTE", (Object)"INTERVAL '0 00' DAY TO HOUR", (Object)"INTERVAL '00:00:00.01' HOUR TO SECOND", (Object)"INTERVAL '00:00' HOUR TO MINUTE", (Object)"INTERVAL '00:00.01' MINUTE TO SECOND", (Object)"INTERVAL '0' DAY", (Object)"INTERVAL '00' HOUR", (Object)"INTERVAL '00' MINUTE", (Object)"INTERVAL '00.01' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-10627203000000L)), (Object)new Tuple10((Object)"INTERVAL '-123 00:00:03' DAY TO SECOND", (Object)"INTERVAL '-123 00:00' DAY TO MINUTE", (Object)"INTERVAL '-123 00' DAY TO HOUR", (Object)"INTERVAL '-2952:00:03' HOUR TO SECOND", (Object)"INTERVAL '-2952:00' HOUR TO MINUTE", (Object)"INTERVAL '-177120:03' MINUTE TO SECOND", (Object)"INTERVAL '-123' DAY", (Object)"INTERVAL '-2952' HOUR", (Object)"INTERVAL '-177120' MINUTE", (Object)"INTERVAL '-10627203' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Object)new Tuple10((Object)"INTERVAL '-106751991 04:00:54.775808' DAY TO SECOND", (Object)"INTERVAL '-106751991 04:00' DAY TO MINUTE", (Object)"INTERVAL '-106751991 04' DAY TO HOUR", (Object)"INTERVAL '-2562047788:00:54.775808' HOUR TO SECOND", (Object)"INTERVAL '-2562047788:00' HOUR TO MINUTE", (Object)"INTERVAL '-153722867280:54.775808' MINUTE TO SECOND", (Object)"INTERVAL '-106751991' DAY", (Object)"INTERVAL '-2562047788' HOUR", (Object)"INTERVAL '-153722867280' MINUTE", (Object)"INTERVAL '-9223372036854.775808' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)69159782123456L)), (Object)new Tuple10((Object)"INTERVAL '800 11:03:02.123456' DAY TO SECOND", (Object)"INTERVAL '800 11:03' DAY TO MINUTE", (Object)"INTERVAL '800 11' DAY TO HOUR", (Object)"INTERVAL '19211:03:02.123456' HOUR TO SECOND", (Object)"INTERVAL '19211:03' HOUR TO MINUTE", (Object)"INTERVAL '1152663:02.123456' MINUTE TO SECOND", (Object)"INTERVAL '800' DAY", (Object)"INTERVAL '19211' HOUR", (Object)"INTERVAL '1152663' MINUTE", (Object)"INTERVAL '69159782.123456' SECOND")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)-69159782123456L)), (Object)new Tuple10((Object)"INTERVAL '-800 11:03:02.123456' DAY TO SECOND", (Object)"INTERVAL '-800 11:03' DAY TO MINUTE", (Object)"INTERVAL '-800 11' DAY TO HOUR", (Object)"INTERVAL '-19211:03:02.123456' HOUR TO SECOND", (Object)"INTERVAL '-19211:03' HOUR TO MINUTE", (Object)"INTERVAL '-1152663:02.123456' MINUTE TO SECOND", (Object)"INTERVAL '-800' DAY", (Object)"INTERVAL '-19211' HOUR", (Object)"INTERVAL '-1152663' MINUTE", (Object)"INTERVAL '-69159782.123456' SECOND")), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                long micros = tuple2._1$mcJ$sp();
                Tuple10 tuple10 = (Tuple10)tuple2._2();
                if (tuple10 != null) {
                    String dayToSec = (String)tuple10._1();
                    String dayToMinute = (String)tuple10._2();
                    String dayToHour = (String)tuple10._3();
                    String hourToSec = (String)tuple10._4();
                    String hourToMinute = (String)tuple10._5();
                    String minuteToSec = (String)tuple10._6();
                    String day = (String)tuple10._7();
                    String hour = (String)tuple10._8();
                    String minute = (String)tuple10._9();
                    String sec = (String)tuple10._10();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right = dayToSec;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.MINUTE()));
                    String $org_scalatest_assert_macro_right2 = dayToMinute;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.HOUR()));
                    String $org_scalatest_assert_macro_right3 = dayToHour;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right4 = hourToSec;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.MINUTE()));
                    String $org_scalatest_assert_macro_right5 = hourToMinute;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 843));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right6 = minuteToSec;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.DAY(), DayTimeIntervalType$.MODULE$.DAY()));
                    String $org_scalatest_assert_macro_right7 = day;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.HOUR(), DayTimeIntervalType$.MODULE$.HOUR()));
                    String $org_scalatest_assert_macro_right8 = hour;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.MINUTE(), DayTimeIntervalType$.MODULE$.MINUTE()));
                    String $org_scalatest_assert_macro_right9 = minute;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(IntervalUtils$.MODULE$.toDayTimeIntervalString(micros, IntervalStringStyles$.MODULE$.ANSI_STYLE(), DayTimeIntervalType$.MODULE$.SECOND(), DayTimeIntervalType$.MODULE$.SECOND()));
                    String $org_scalatest_assert_macro_right10 = sec;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("SPARK-35771: Format year-month intervals using type fields", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Tuple3((Object)"INTERVAL '0-0' YEAR TO MONTH", (Object)"INTERVAL '0' YEAR", (Object)"INTERVAL '0' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-11)), (Object)new Tuple3((Object)"INTERVAL '-0-11' YEAR TO MONTH", (Object)"INTERVAL '-0' YEAR", (Object)"INTERVAL '-11' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new Tuple3((Object)"INTERVAL '0-11' YEAR TO MONTH", (Object)"INTERVAL '0' YEAR", (Object)"INTERVAL '11' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-12)), (Object)new Tuple3((Object)"INTERVAL '-1-0' YEAR TO MONTH", (Object)"INTERVAL '-1' YEAR", (Object)"INTERVAL '-12' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)12)), (Object)new Tuple3((Object)"INTERVAL '1-0' YEAR TO MONTH", (Object)"INTERVAL '1' YEAR", (Object)"INTERVAL '12' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-13)), (Object)new Tuple3((Object)"INTERVAL '-1-1' YEAR TO MONTH", (Object)"INTERVAL '-1' YEAR", (Object)"INTERVAL '-13' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)13)), (Object)new Tuple3((Object)"INTERVAL '1-1' YEAR TO MONTH", (Object)"INTERVAL '1' YEAR", (Object)"INTERVAL '13' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-24)), (Object)new Tuple3((Object)"INTERVAL '-2-0' YEAR TO MONTH", (Object)"INTERVAL '-2' YEAR", (Object)"INTERVAL '-24' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)24)), (Object)new Tuple3((Object)"INTERVAL '2-0' YEAR TO MONTH", (Object)"INTERVAL '2' YEAR", (Object)"INTERVAL '24' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)), (Object)new Tuple3((Object)"INTERVAL '-178956970-8' YEAR TO MONTH", (Object)"INTERVAL '-178956970' YEAR", (Object)"INTERVAL '-2147483648' MONTH")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Object)new Tuple3((Object)"INTERVAL '178956970-7' YEAR TO MONTH", (Object)"INTERVAL '178956970' YEAR", (Object)"INTERVAL '2147483647' MONTH"))})).foreach((Function1 & Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 != null) {
                int months = tuple2._1$mcI$sp();
                Tuple3 tuple3 = (Tuple3)tuple2._2();
                if (tuple3 != null) {
                    String yearToMonth = (String)tuple3._1();
                    String year = (String)tuple3._2();
                    String month = (String)tuple3._3();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right = yearToMonth;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.YEAR(), YearMonthIntervalType$.MODULE$.YEAR()));
                    String $org_scalatest_assert_macro_right2 = year;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(IntervalUtils$.MODULE$.toYearMonthIntervalString(months, IntervalStringStyles$.MODULE$.ANSI_STYLE(), YearMonthIntervalType$.MODULE$.MONTH(), YearMonthIntervalType$.MODULE$.MONTH()));
                    String $org_scalatest_assert_macro_right3 = month;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
                }
            }
            throw new MatchError((Object)tuple2);
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852));
        this.test("SPARK-38324: The second range is not [0, 59] in the day time ANSI interval", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"10 12:40:60", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"10 12:40:60.999999999", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"10 12:40:99.999999999", (Object)BoxesRunTime.boxToInteger((int)99), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.DAY()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"12:40:60", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"12:40:60.999999999", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"12:40:99.999999999", (Object)BoxesRunTime.boxToInteger((int)99), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.HOUR()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"40:60", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"40:60.999999999", (Object)BoxesRunTime.boxToInteger((int)60), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND())), new Tuple4((Object)"40:99.999999999", (Object)BoxesRunTime.boxToInteger((int)99), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.MINUTE()), (Object)BoxesRunTime.boxToByte((byte)DayTimeIntervalType$.MODULE$.SECOND()))})).foreach((Function1 & Serializable)x0$8 -> {
            IntervalUtilsSuite.$anonfun$new$84(this, x0$8);
            return BoxedUnit.UNIT;
        }), new Position("IntervalUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
    }
}

