/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.UnsafeRowUtils$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005Y3Aa\u0003\u0007\u00013!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0003\u0019\u0003B\u0002\u001e\u0001A\u0003%A\u0005C\u0004<\u0001\t\u0007I\u0011A\u0012\t\rq\u0002\u0001\u0015!\u0003%\u0011\u001di\u0004A1A\u0005\u0002yBa!\u0012\u0001!\u0002\u0013y\u0004b\u0002$\u0001\u0005\u0004%\ta\u0012\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002%\t\u000b=\u0003A\u0011\u0002)\u0003'Us7/\u00194f%><X\u000b^5mgN+\u0018\u000e^3\u000b\u00055q\u0011\u0001B;uS2T!a\u0004\t\u0002\u0011\r\fG/\u00197zgRT!!\u0005\n\u0002\u0007M\fHN\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u0007CB\f7\r[3\u000b\u0003]\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005maR\"\u0001\n\n\u0005u\u0011\"!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\u0019\u0005AA/Z:u\u0017\u0016L8/F\u0001%!\r)sF\r\b\u0003M1r!a\n\u0016\u000e\u0003!R!!\u000b\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0013!B:dC2\f\u0017BA\u0017/\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aK\u0005\u0003aE\u00121aU3r\u0015\tic\u0006\u0005\u00024o9\u0011A'\u000e\t\u0003O9J!A\u000e\u0018\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m9\n\u0011\u0002^3ti.+\u0017p\u001d\u0011\u0002\u0015Q,7\u000f\u001e,bYV,7/A\u0006uKN$h+\u00197vKN\u0004\u0013\u0001\u0005;fgR|U\u000f\u001e9viN\u001b\u0007.Z7b+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"\u0011\u0003\u0015!\u0018\u0010]3t\u0013\t!\u0015I\u0001\u0006TiJ,8\r\u001e+za\u0016\f\u0011\u0003^3ti>+H\u000f];u'\u000eDW-\\1!\u0003\u001d!Xm\u001d;S_^,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017:\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011QJ\u0013\u0002\n+:\u001c\u0018MZ3S_^\f\u0001\u0002^3tiJ{w\u000fI\u0001\u0013GJ,\u0017\r^3J]R,w-\u001a:GS\u0016dG\r\u0006\u0002R)B\u0011\u0001IU\u0005\u0003'\u0006\u00131b\u0015;sk\u000e$h)[3mI\")QK\u0003a\u0001e\u0005!a.Y7f\u0001")
public class UnsafeRowUtilsSuite
extends SparkFunSuite {
    private final Seq<String> testKeys = new .colon.colon((Object)"key1", (List)new .colon.colon((Object)"key2", (List)Nil$.MODULE$));
    private final Seq<String> testValues = new .colon.colon((Object)"sum(key1)", (List)new .colon.colon((Object)"sum(key2)", (List)Nil$.MODULE$));
    private final StructType testOutputSchema = StructType$.MODULE$.apply((Seq)((IterableOps)this.testKeys().map((Function1 & Serializable)name -> this.createIntegerField((String)name))).$plus$plus((IterableOnce)this.testValues().map((Function1 & Serializable)name -> this.createIntegerField((String)name))));
    private final UnsafeRow testRow;

    public Seq<String> testKeys() {
        return this.testKeys;
    }

    public Seq<String> testValues() {
        return this.testValues;
    }

    public StructType testOutputSchema() {
        return this.testOutputSchema;
    }

    public UnsafeRow testRow() {
        return this.testRow;
    }

    private StructField createIntegerField(String name) {
        return new StructField(name, (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ void $anonfun$testRow$1(UnsafeRow row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            row$1.setInt(index, index);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public UnsafeRowUtilsSuite() {
        void var2_2;
        UnsafeProjection unsafeRowProjection = UnsafeProjection$.MODULE$.create(this.testOutputSchema());
        UnsafeRow row = unsafeRowProjection.apply((InternalRow)new SpecificInternalRow(this.testOutputSchema()));
        ((IterableOnceOps)((IterableOps)this.testKeys().$plus$plus(this.testValues())).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            UnsafeRowUtilsSuite.$anonfun$testRow$1(row, x0$1);
            return BoxedUnit.UNIT;
        });
        this.testRow = var2_2;
        this.test("UnsafeRow format invalidation", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option $org_scalatest_assert_macro_left = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(this.testRow(), this.testOutputSchema());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(this.testRow(), StructType$.MODULE$.apply((Seq)this.testKeys().map((Function1 & Serializable)name -> this.createIntegerField((String)name)))).isDefined(), "UnsafeRowUtils.validateStructuralIntegrityWithReason(UnsafeRowUtilsSuite.this.testRow, org.apache.spark.sql.types.StructType.apply(UnsafeRowUtilsSuite.this.testKeys.map[org.apache.spark.sql.types.StructField](((name: String) => UnsafeRowUtilsSuite.this.createIntegerField(name))))).isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            StructType invalidSchema = StructType$.MODULE$.apply((Seq)((IterableOps)this.testKeys().map((Function1 & Serializable)name -> this.createIntegerField((String)name))).$plus$plus((IterableOnce)new .colon.colon((Object)new StructField("struct", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("value1", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("value2", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(this.testRow(), invalidSchema).isDefined(), "UnsafeRowUtils.validateStructuralIntegrityWithReason(UnsafeRowUtilsSuite.this.testRow, invalidSchema).isDefined", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        }, new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Handle special case for null variable-length Decimal", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Bool bool;
            Bool bool2;
            Bool bool3;
            Bool bool4;
            StructField structField = new StructField("d", (DataType)new DecimalType(19, 0), true, StructField$.MODULE$.apply$default$4());
            StructType schema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
            UnsafeProjection unsafeRowProjection = UnsafeProjection$.MODULE$.create(schema);
            UnsafeRow row = unsafeRowProjection.apply((InternalRow)new SpecificInternalRow(schema));
            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left.value()) {
                Tuple2 $org_scalatest_assert_macro_left2 = UnsafeRowUtils$.MODULE$.getOffsetAndSize(row, 0);
                Tuple2.mcII.sp $org_scalatest_assert_macro_right = new Tuple2.mcII.sp(16, 0);
                Tuple2 tuple2 = $org_scalatest_assert_macro_left2;
                Tuple2.mcII.sp sp2 = $org_scalatest_assert_macro_right;
                bool4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(tuple2 != null ? !tuple2.equals(sp2) : sp2 != null), Prettifier$.MODULE$.default());
            } else {
                bool4 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right = bool4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Option $org_scalatest_assert_macro_left3 = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(row, schema);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            Decimal bigDecimalVal = Decimal$.MODULE$.apply(new BigDecimal("12345678901234567890"));
            row.setDecimal(0, bigDecimalVal, 19);
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left4.value()) {
                Tuple2 $org_scalatest_assert_macro_left5 = UnsafeRowUtils$.MODULE$.getOffsetAndSize(row, 0);
                Tuple2.mcII.sp $org_scalatest_assert_macro_right2 = new Tuple2.mcII.sp(16, 0);
                Tuple2 tuple2 = $org_scalatest_assert_macro_left5;
                Tuple2.mcII.sp sp3 = $org_scalatest_assert_macro_right2;
                bool3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right2, !(tuple2 != null ? !tuple2.equals(sp3) : sp3 != null), Prettifier$.MODULE$.default());
            } else {
                bool3 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            Option $org_scalatest_assert_macro_left6 = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(row, schema);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            Decimal bigDecimalVal2 = Decimal$.MODULE$.apply(new BigDecimal("1234567890123456789"));
            row.setDecimal(0, bigDecimalVal2, 19);
            Bool $org_scalatest_assert_macro_left7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left7.value()) {
                Tuple2 $org_scalatest_assert_macro_left8 = UnsafeRowUtils$.MODULE$.getOffsetAndSize(row, 0);
                Tuple2.mcII.sp $org_scalatest_assert_macro_right4 = new Tuple2.mcII.sp(16, 8);
                Tuple2 tuple2 = $org_scalatest_assert_macro_left8;
                Tuple2.mcII.sp sp4 = $org_scalatest_assert_macro_right4;
                bool2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right4, !(tuple2 != null ? !tuple2.equals(sp4) : sp4 != null), Prettifier$.MODULE$.default());
            } else {
                bool2 = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right5 = bool2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            Option $org_scalatest_assert_macro_left9 = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(row, schema);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            row.setNullAt(0);
            Bool $org_scalatest_assert_macro_left10 = Bool$.MODULE$.simpleMacroBool(row.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left10.value()) {
                Tuple2 $org_scalatest_assert_macro_left11 = UnsafeRowUtils$.MODULE$.getOffsetAndSize(row, 0);
                Tuple2.mcII.sp $org_scalatest_assert_macro_right6 = new Tuple2.mcII.sp(0, 0);
                Tuple2 tuple2 = $org_scalatest_assert_macro_left11;
                Tuple2.mcII.sp sp5 = $org_scalatest_assert_macro_right6;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right6, !(tuple2 != null ? !tuple2.equals(sp5) : sp5 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right7 = bool;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "&&", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left10.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Option $org_scalatest_assert_macro_left12 = UnsafeRowUtils$.MODULE$.validateStructuralIntegrityWithReason(row, schema);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left12, "isEmpty", $org_scalatest_assert_macro_left12.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        }, new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("Better schema status message", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            String $org_scalatest_assert_macro_left = UnsafeRowUtils$.MODULE$.getStructuralIntegrityStatus(this.testRow(), this.testOutputSchema());
            String $org_scalatest_assert_macro_right = "[UnsafeRowStatus] expectedSchema: StructType(StructField(key1,IntegerType,false),StructField(key2,IntegerType,false),StructField(sum(key1),IntegerType,false),StructField(sum(key2),IntegerType,false)), expectedSchemaNumFields: 4, numFields: 4, bitSetWidthInBytes: 8, rowSizeInBytes: 40\nfieldStatus:\n[UnsafeRowFieldStatus] index: 0, expectedFieldType: IntegerType,";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("isBinaryStable on complex types containing collated strings", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            StringType nonBinaryStringType = StringType$.MODULE$.apply(CollationFactory.collationNameToId((String)"UTF8_LCASE"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)IntegerType$.MODULE$), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.IntegerType)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StringType$.MODULE$), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StringType)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)nonBinaryStringType), "UnsafeRowUtils.isBinaryStable(nonBinaryStringType)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StringType))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)nonBinaryStringType)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(nonBinaryStringType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.StringType))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)nonBinaryStringType, (DataType)StringType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(nonBinaryStringType, org.apache.spark.sql.types.StringType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)nonBinaryStringType)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StringType, nonBinaryStringType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)nonBinaryStringType, (DataType)nonBinaryStringType)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(nonBinaryStringType, nonBinaryStringType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)nonBinaryStringType, (DataType)IntegerType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(nonBinaryStringType, org.apache.spark.sql.types.IntegerType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)nonBinaryStringType)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, nonBinaryStringType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
            StructField structField = new StructField("field", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$2: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$2)\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            StructField structField2 = new StructField("field", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$3: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$3)\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            StructField structField3 = new StructField("field", (DataType)nonBinaryStringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$4: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", nonBinaryStringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$4)\n}))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StringType)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.IntegerType)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            StructField structField4 = new StructField("field", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4)))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$5: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$5)\n})))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)nonBinaryStringType))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.ArrayType.apply(nonBinaryStringType)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)nonBinaryStringType))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, nonBinaryStringType)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)nonBinaryStringType)))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.ArrayType.apply(nonBinaryStringType))))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            StructField structField5 = new StructField("field", (DataType)nonBinaryStringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5)))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$6: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", nonBinaryStringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$6)\n})))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("second", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("second", (DataType)nonBinaryStringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StructType.apply(scala.`package`.Seq.apply[org.apache.spark.sql.types.StructField](org.apache.spark.sql.types.StructField.apply(\"second\", org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4), org.apache.spark.sql.types.StructField.apply(\"second\", nonBinaryStringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4)))))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$), (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.StringType), org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$), (DataType)IntegerType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.StringType), org.apache.spark.sql.types.IntegerType))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            StructField structField6 = new StructField("field", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6)), (DataType)IntegerType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$7: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$7)\n}), org.apache.spark.sql.types.IntegerType))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)nonBinaryStringType), (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.ArrayType.apply(nonBinaryStringType), org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)ArrayType$.MODULE$.apply((DataType)nonBinaryStringType))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.ArrayType.apply(nonBinaryStringType)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)nonBinaryStringType), (DataType)IntegerType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.IntegerType, nonBinaryStringType), org.apache.spark.sql.types.IntegerType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
            StructField structField7 = new StructField("field", (DataType)nonBinaryStringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)MapType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7)), (DataType)IntegerType$.MODULE$)), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$8: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", nonBinaryStringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$8)\n}), org.apache.spark.sql.types.IntegerType))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            StructField structField8 = new StructField("field", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField8))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$9: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.ArrayType.apply(org.apache.spark.sql.types.IntegerType), org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$9)\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            StructField structField9 = new StructField("field", (DataType)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField9))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$10: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.MapType.apply(org.apache.spark.sql.types.StringType, org.apache.spark.sql.types.IntegerType), org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$10)\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            StructField structField10 = new StructField("sub", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField11 = new StructField("field", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField10)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField11))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$12: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.StructType.apply({\n    final <synthetic> <artifact> val rassoc$11: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"sub\", org.apache.spark.sql.types.IntegerType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n    scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$11)\n  }), org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$12)\n}))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            StructField structField12 = new StructField("field", (DataType)ArrayType$.MODULE$.apply((DataType)nonBinaryStringType), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField12))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$13: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.ArrayType.apply(nonBinaryStringType), org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$13)\n}))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            StructField structField13 = new StructField("field", (DataType)MapType$.MODULE$.apply((DataType)nonBinaryStringType, (DataType)IntegerType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField13))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$14: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.MapType.apply(nonBinaryStringType, org.apache.spark.sql.types.IntegerType), org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$14)\n}))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            StructField structField14 = new StructField("sub", (DataType)nonBinaryStringType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            StructField structField15 = new StructField("field", (DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField14)), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(UnsafeRowUtils$.MODULE$.isBinaryStable((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField15))), "UnsafeRowUtils.isBinaryStable(org.apache.spark.sql.types.StructType.apply({\n  final <synthetic> <artifact> val rassoc$16: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"field\", org.apache.spark.sql.types.StructType.apply({\n    final <synthetic> <artifact> val rassoc$15: org.apache.spark.sql.types.StructField = org.apache.spark.sql.types.StructField.apply(\"sub\", nonBinaryStringType, org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n    scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$15)\n  }), org.apache.spark.sql.types.StructField.apply$default$3, org.apache.spark.sql.types.StructField.apply$default$4);\n  scala.`package`.Nil.::[org.apache.spark.sql.types.StructField](rassoc$16)\n}))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"", Prettifier$.MODULE$.default(), new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("UnsafeRowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
    }
}

