/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import org.apache.spark.SparkException;
import org.apache.spark.sql.connector.catalog.AccessErrorCatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogNotFoundException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Catalogs;
import org.apache.spark.sql.connector.catalog.ClassFoundCatalogPlugin;
import org.apache.spark.sql.connector.catalog.ConstructorFailureCatalogPlugin;
import org.apache.spark.sql.connector.catalog.InvalidCatalogPlugin;
import org.apache.spark.sql.connector.catalog.TestCatalogPlugin;
import org.apache.spark.sql.internal.SQLConf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CatalogLoadingSuite {
    @Test
    public void testLoad() throws SparkException {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.test-name", TestCatalogPlugin.class.getCanonicalName());
        CatalogPlugin plugin = Catalogs.load((String)"test-name", (SQLConf)conf);
        Assertions.assertNotNull((Object)plugin, (String)"Should instantiate a non-null plugin");
        Assertions.assertEquals(TestCatalogPlugin.class, plugin.getClass(), (String)"Plugin should have correct implementation");
        TestCatalogPlugin testPlugin = (TestCatalogPlugin)plugin;
        Assertions.assertEquals((int)0, (int)testPlugin.options.size(), (String)"Options should contain no keys");
        Assertions.assertEquals((Object)"test-name", (Object)testPlugin.name(), (String)"Catalog should have correct name");
    }

    @Test
    public void testIllegalCatalogName() {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.test.name", TestCatalogPlugin.class.getCanonicalName());
        SparkException exc = (SparkException)Assertions.assertThrows(SparkException.class, () -> Catalogs.load((String)"test.name", (SQLConf)conf));
        Assertions.assertTrue((boolean)exc.getMessage().contains("Invalid catalog name: test.name"), (String)"Catalog name should not contain '.'");
    }

    @Test
    public void testInitializationOptions() throws SparkException {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.test-name", TestCatalogPlugin.class.getCanonicalName());
        conf.setConfString("spark.sql.catalog.test-name.name", "not-catalog-name");
        conf.setConfString("spark.sql.catalog.test-name.kEy", "valUE");
        CatalogPlugin plugin = Catalogs.load((String)"test-name", (SQLConf)conf);
        Assertions.assertNotNull((Object)plugin, (String)"Should instantiate a non-null plugin");
        Assertions.assertEquals(TestCatalogPlugin.class, plugin.getClass(), (String)"Plugin should have correct implementation");
        TestCatalogPlugin testPlugin = (TestCatalogPlugin)plugin;
        Assertions.assertEquals((int)2, (int)testPlugin.options.size(), (String)"Options should contain only two keys");
        Assertions.assertEquals((Object)"not-catalog-name", (Object)testPlugin.options.get((Object)"name"), (String)"Options should contain correct value for name (not overwritten)");
        Assertions.assertEquals((Object)"valUE", (Object)testPlugin.options.get((Object)"key"), (String)"Options should contain correct value for key");
    }

    @Test
    public void testLoadWithoutConfig() {
        SQLConf conf = new SQLConf();
        SparkException exc = (SparkException)Assertions.assertThrows(CatalogNotFoundException.class, () -> Catalogs.load((String)"missing", (SQLConf)conf));
        Assertions.assertEquals((Object)exc.getErrorClass(), (Object)"CATALOG_NOT_FOUND");
        Assertions.assertEquals(exc.getMessageParameters().get("catalogName"), (Object)"`missing`");
    }

    @Test
    public void testLoadMissingClass() {
        SQLConf conf = new SQLConf();
        conf.setConfString("spark.sql.catalog.missing", "com.example.NoSuchCatalogPlugin");
        SparkException exc = (SparkException)Assertions.assertThrows(SparkException.class, () -> Catalogs.load((String)"missing", (SQLConf)conf));
        Assertions.assertTrue((boolean)exc.getMessage().contains("Cannot find catalog plugin class"), (String)"Should complain that the class is not found");
        Assertions.assertTrue((boolean)exc.getMessage().contains("missing"), (String)"Should identify the catalog by name");
        Assertions.assertTrue((boolean)exc.getMessage().contains("com.example.NoSuchCatalogPlugin"), (String)"Should identify the missing class");
    }

    @Test
    public void testLoadMissingDependentClasses() {
        SQLConf conf = new SQLConf();
        String catalogClass = ClassFoundCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.missing", catalogClass);
        SparkException exc = (SparkException)Assertions.assertThrows(SparkException.class, () -> Catalogs.load((String)"missing", (SQLConf)conf));
        Assertions.assertTrue((boolean)(exc.getCause() instanceof ClassNotFoundException));
        Assertions.assertTrue((boolean)exc.getCause().getMessage().contains(catalogClass + "Dep"));
    }

    @Test
    public void testLoadNonCatalogPlugin() {
        SQLConf conf = new SQLConf();
        String invalidClassName = InvalidCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.invalid", invalidClassName);
        SparkException exc = (SparkException)Assertions.assertThrows(SparkException.class, () -> Catalogs.load((String)"invalid", (SQLConf)conf));
        Assertions.assertTrue((boolean)exc.getMessage().contains("does not implement CatalogPlugin"), (String)"Should complain that class does not implement CatalogPlugin");
        Assertions.assertTrue((boolean)exc.getMessage().contains("invalid"), (String)"Should identify the catalog by name");
        Assertions.assertTrue((boolean)exc.getMessage().contains(invalidClassName), (String)"Should identify the class");
    }

    @Test
    public void testLoadConstructorFailureCatalogPlugin() {
        SQLConf conf = new SQLConf();
        String invalidClassName = ConstructorFailureCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.invalid", invalidClassName);
        SparkException exc = (SparkException)Assertions.assertThrows(SparkException.class, () -> Catalogs.load((String)"invalid", (SQLConf)conf));
        Assertions.assertTrue((boolean)exc.getMessage().contains("Failed during instantiating constructor for catalog"), (String)"Should identify the constructor error");
        Assertions.assertTrue((boolean)exc.getCause().getMessage().contains("Expected failure"), (String)"Should have expected error message");
    }

    @Test
    public void testLoadAccessErrorCatalogPlugin() {
        SQLConf conf = new SQLConf();
        String invalidClassName = AccessErrorCatalogPlugin.class.getCanonicalName();
        conf.setConfString("spark.sql.catalog.invalid", invalidClassName);
        SparkException exc = (SparkException)Assertions.assertThrows(SparkException.class, () -> Catalogs.load((String)"invalid", (SQLConf)conf));
        Assertions.assertTrue((boolean)exc.getMessage().contains("Failed to call public no-arg constructor for catalog"), (String)"Should complain that no public constructor is provided");
        Assertions.assertTrue((boolean)exc.getMessage().contains("invalid"), (String)"Should identify the catalog by name");
        Assertions.assertTrue((boolean)exc.getMessage().contains(invalidClassName), (String)"Should identify the class");
    }
}

