/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.connector.catalog.BufferedRows;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Catalogs$;
import org.apache.spark.sql.connector.catalog.Column;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005q4A!\u0006\f\u0001G!)\u0001\u0006\u0001C\u0001S!9A\u0006\u0001b\u0001\n\u0013i\u0003BB\"\u0001A\u0003%a\u0006C\u0004E\u0001\t\u0007I\u0011B#\t\rA\u0003\u0001\u0015!\u0003G\u0011\u001d\t\u0006A1A\u0005\nICaa\u0016\u0001!\u0002\u0013\u0019\u0006\"\u0002-\u0001\t\u0013I\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B0\t\u000f\u0019\u0004!\u0019!C\u0005O\"11\u000e\u0001Q\u0001\n!Dq\u0001\u001c\u0001C\u0002\u0013%Q\u000e\u0003\u0004o\u0001\u0001\u0006IA\u000e\u0005\b_\u0002\u0011\r\u0011\"\u0003h\u0011\u0019\u0001\b\u0001)A\u0005Q\"9\u0011\u000f\u0001b\u0001\n\u0013i\u0007B\u0002:\u0001A\u0003%a\u0007C\u0004t\u0001\t\u0007I\u0011\u0001;\t\rm\u0004\u0001\u0015!\u0003v\u00051\u0019\u0015\r^1m_\u001e\u001cV/\u001b;f\u0015\t9\u0002$A\u0004dCR\fGn\\4\u000b\u0005eQ\u0012!C2p]:,7\r^8s\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0005\u0005\u0002&M5\tA$\u0003\u0002(9\ti1\u000b]1sW\u001a+hnU;ji\u0016\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005-\u0002Q\"\u0001\f\u0002\u0015\u0015l\u0007\u000f^=Qe>\u00048/F\u0001/!\u0011yCG\u000e\u001c\u000e\u0003AR!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0005!!.\u0019<b\u0013\t)\u0004GA\u0002NCB\u0004\"a\u000e!\u000f\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e#\u0003\u0019a$o\\8u})\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\u00051\u0001K]3eK\u001aL!!\u0011\"\u0003\rM#(/\u001b8h\u0015\tyD(A\u0006f[B$\u0018\u0010\u0015:paN\u0004\u0013AC3naRLHK]1ogV\ta\tE\u0002H\u0011*k\u0011\u0001P\u0005\u0003\u0013r\u0012Q!\u0011:sCf\u0004\"a\u0013(\u000e\u00031S!!\u0014\r\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003\u001f2\u0013\u0011\u0002\u0016:b]N4wN]7\u0002\u0017\u0015l\u0007\u000f^=Ue\u0006t7\u000fI\u0001\bG>dW/\u001c8t+\u0005\u0019\u0006cA$I)B\u00111&V\u0005\u0003-Z\u0011aaQ8mk6t\u0017\u0001C2pYVlgn\u001d\u0011\u0002\u00159,woQ1uC2|w\rF\u0001[!\tY3,\u0003\u0002]-\ty\u0011J\\'f[>\u0014\u0018pQ1uC2|w-\u0001\u0004uKN$hj]\u000b\u0002?B\u0019q\t\u00131\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r\u0014\u0014\u0001\u00027b]\u001eL!!\u00112\u0002\u000fQ,7\u000f\u001e(tA\u0005IA/Z:u\u0013\u0012,g\u000e^\u000b\u0002QB\u00111&[\u0005\u0003UZ\u0011!\"\u00133f]RLg-[3s\u0003)!Xm\u001d;JI\u0016tG\u000fI\u0001\u0010i\u0016\u001cH/\u00133f]R\fVo\u001c;fIV\ta'\u0001\tuKN$\u0018\nZ3oiF+x\u000e^3eA\u0005aA/Z:u\u0013\u0012,g\u000e\u001e(fo\u0006iA/Z:u\u0013\u0012,g\u000e\u001e(fo\u0002\n!\u0003^3ti&#WM\u001c;OK^\fVo\u001c;fI\u0006\u0019B/Z:u\u0013\u0012,g\u000e\u001e(foF+x\u000e^3eA\u0005Aa-\u001e8di&|g.F\u0001v!\t1\u00180D\u0001x\u0015\tAh#A\u0005gk:\u001cG/[8og&\u0011!p\u001e\u0002\u0010+:\u0014w.\u001e8e\rVt7\r^5p]\u0006Ia-\u001e8di&|g\u000e\t")
public class CatalogSuite
extends SparkFunSuite {
    private final java.util.Map<String, String> emptyProps = Collections.emptyMap();
    private final Transform[] emptyTrans = (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class));
    private final Column[] columns = (Column[])((Object[])new Column[]{Column.create((String)"id", (DataType)IntegerType$.MODULE$), Column.create((String)"data", (DataType)StringType$.MODULE$)});
    private final String[] testNs = (String[])((Object[])new String[]{"`", "."});
    private final Identifier testIdent = Identifier.of((String[])this.testNs(), (String)"test_table");
    private final String testIdentQuoted = ((IterableOnceOps)CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdent()).asMultipartIdentifier().map((Function1 & Serializable)part -> package$.MODULE$.quoteIdentifier(part))).mkString(".");
    private final Identifier testIdentNew = Identifier.of((String[])this.testNs(), (String)"test_table_new");
    private final String testIdentNewQuoted = ((IterableOnceOps)CatalogV2Implicits$.MODULE$.IdentifierHelper(this.testIdentNew()).asMultipartIdentifier().map((Function1 & Serializable)part -> package$.MODULE$.quoteIdentifier(part))).mkString(".");
    private final UnboundFunction function;

    private java.util.Map<String, String> emptyProps() {
        return this.emptyProps;
    }

    private Transform[] emptyTrans() {
        return this.emptyTrans;
    }

    private Column[] columns() {
        return this.columns;
    }

    private InMemoryCatalog newCatalog() {
        InMemoryCatalog newCatalog = new InMemoryCatalog();
        newCatalog.initialize("test", CaseInsensitiveStringMap.empty());
        return newCatalog;
    }

    private String[] testNs() {
        return this.testNs;
    }

    private Identifier testIdent() {
        return this.testIdent;
    }

    private String testIdentQuoted() {
        return this.testIdentQuoted;
    }

    private Identifier testIdentNew() {
        return this.testIdentNew;
    }

    private String testIdentNewQuoted() {
        return this.testIdentNewQuoted;
    }

    public UnboundFunction function() {
        return this.function;
    }

    public CatalogSuite() {
        this.test("Catalogs can load the catalog", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            SQLConf conf = new SQLConf();
            conf.setConfString("spark.sql.catalog.test", catalog.getClass().getName());
            CatalogPlugin loaded = Catalogs$.MODULE$.load("test", conf);
            Class<?> $org_scalatest_assert_macro_left = loaded.getClass();
            Class<?> $org_scalatest_assert_macro_right = catalog.getClass();
            Class<?> clazz = $org_scalatest_assert_macro_left;
            Class<?> clazz2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("listTables", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"test_table_2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns2"})), (String)"test_table_1");
            this.intercept((Function0 & Serializable)() -> catalog.listTables((String[])((Object[])new String[]{"ns"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            catalog.createTable(ident1, this.columns(), this.emptyTrans(), this.emptyProps());
            Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"}))).toSet();
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            this.intercept((Function0 & Serializable)() -> catalog.listTables((String[])((Object[])new String[]{"ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            catalog.createTable(ident3, this.columns(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(ident2, this.columns(), this.emptyTrans(), this.emptyProps());
            Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"}))).toSet();
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Set $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"}))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            catalog.dropTable(ident1);
            Set $org_scalatest_assert_macro_left4 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"}))).toSet();
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident2}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            catalog.dropTable(ident2);
            Object $org_scalatest_assert_macro_left5 = Predef$.MODULE$.refArrayOps((Object[])catalog.listTables((String[])((Object[])new String[]{"ns"})));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left5), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            Set $org_scalatest_assert_macro_left6 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listTables((String[])((Object[])new String[]{"ns2"}))).toSet();
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Set set9 = $org_scalatest_assert_macro_left6;
            Set set10 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(set9 != null ? !set9.equals(set10) : set10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("createTable: non-partitioned table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq parsed;
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right2 = this.columns();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("createTable: partitioned table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq parsed;
            InMemoryPartitionTableCatalog partCatalog = new InMemoryPartitionTableCatalog();
            partCatalog.initialize("test", CaseInsensitiveStringMap.empty());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partCatalog.tableExists(this.testIdent()), "partCatalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            Column[] columns = (Column[])((Object[])new Column[]{Column.create((String)"col0", (DataType)IntegerType$.MODULE$), Column.create((String)"part0", (DataType)IntegerType$.MODULE$)});
            Table table = partCatalog.createTable(this.testIdent(), columns, (Transform[])((Object[])new Transform[]{Expressions.identity((String)"part0")}), Collections.emptyMap());
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right2 = columns;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(partCatalog.tableExists(this.testIdent()), "partCatalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        this.test("createTable: with properties", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq parsed;
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("property", "value");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), properties);
            Seq $org_scalatest_assert_macro_left = parsed = CatalystSqlParser$.MODULE$.parseMultipartIdentifier(table.name());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"test", (List)new .colon.colon((Object)"`", (List)new .colon.colon((Object)".", (List)new .colon.colon((Object)"test_table", (List)Nil$.MODULE$))));
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right2 = this.columns();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            HashMap<String, String> $org_scalatest_assert_macro_right3 = properties;
            java.util.Map map = $org_scalatest_assert_macro_left3;
            HashMap<String, String> hashMap = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", $org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(hashMap) : hashMap != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        this.test("createTable: table already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable)() -> catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            this.checkErrorTableAlreadyExists((SparkThrowable)exc, this.testIdentQuoted());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("tableExists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test("loadTable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.test("loadTable: table does not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable)() -> catalog.loadTable(this.testIdent()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            this.checkErrorTableNotFound((SparkThrowable)exc, this.testIdentQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("invalidateTable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            catalog.invalidateTable(this.testIdent());
            Table loaded = catalog.loadTable(this.testIdent());
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = loaded.name();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            StructType $org_scalatest_assert_macro_left2 = table.schema();
            StructType $org_scalatest_assert_macro_right2 = loaded.schema();
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right3 = loaded.properties();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        this.test("invalidateTable: table does not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.tableExists(this.testIdent())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            catalog.invalidateTable(this.testIdent());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("alterTable: add property", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-1", (String)"1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = CollectionConverters$.MODULE$.MapHasAsScala(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = CollectionConverters$.MODULE$.MapHasAsScala(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
        this.test("alterTable: add property to existing", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop-2", (String)"2")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = CollectionConverters$.MODULE$.MapHasAsScala(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = CollectionConverters$.MODULE$.MapHasAsScala(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-2"), (Object)"2")}));
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        this.test("alterTable: remove existing property", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("prop-1", "1");
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), properties);
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = CollectionConverters$.MODULE$.MapHasAsScala(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = CollectionConverters$.MODULE$.MapHasAsScala(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prop-1"), (Object)"1")}));
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        this.test("alterTable: remove missing property", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Map map2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.removeProperty((String)"prop-1")}));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left2 = CollectionConverters$.MODULE$.MapHasAsScala(updated.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Map map4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            Table loaded = catalog.loadTable(this.testIdent());
            scala.collection.mutable.Map $org_scalatest_assert_macro_left3 = CollectionConverters$.MODULE$.MapHasAsScala(loaded.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Map map6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map5 != null ? !map5.equals(map6) : map6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            scala.collection.mutable.Map $org_scalatest_assert_macro_left4 = CollectionConverters$.MODULE$.MapHasAsScala(table.properties()).asScala();
            scala.collection.immutable.Map $org_scalatest_assert_macro_right4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            scala.collection.mutable.Map map7 = $org_scalatest_assert_macro_left4;
            scala.collection.immutable.Map map8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(map7 != null ? !map7.equals(map8) : map8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("alterTable: add top-level column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$)}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"ts", (DataType)TimestampType$.MODULE$), ClassTag$.MODULE$.apply(Column.class));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("alterTable: add required column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false)}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"ts", (DataType)TimestampType$.MODULE$, (boolean)false), ClassTag$.MODULE$.apply(Column.class));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("alterTable: add column with comment", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"ts"})), (DataType)TimestampType$.MODULE$, (boolean)false, (String)"comment text")}));
            Column tsColumn = Column.create((String)"ts", (DataType)TimestampType$.MODULE$, (boolean)false, (String)"comment text", null);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)tsColumn, ClassTag$.MODULE$.apply(Column.class));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("alterTable: add nested column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] tableColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct), ClassTag$.MODULE$.apply(Column.class));
            Table table = catalog.createTable(this.testIdent(), tableColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = tableColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (DataType)DoubleType$.MODULE$)}));
            Column[] expectedColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct.add("z", (DataType)DoubleType$.MODULE$)), ClassTag$.MODULE$.apply(Column.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = expectedColumns;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
        this.test("alterTable: add column to primitive field fails", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            SparkIllegalArgumentException x$1 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"data", "ts"})), (DataType)TimestampType$.MODULE$)})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362))));
            String x$2 = "_LEGACY_ERROR_TEMP_3229";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"data")}));
            Option x$4 = this.checkError$default$3();
            boolean x$5 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$6 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$1, "_LEGACY_ERROR_TEMP_3229", x$4, x$3, x$5, x$6);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.loadTable(this.testIdent()).columns());
            Column[] $org_scalatest_assert_macro_right2 = this.columns();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        this.test("alterTable: add field to missing column fails", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 377));
            SparkIllegalArgumentException x$7 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.addColumn((String[])((String[])((Object[])new String[]{"missing_col", "new_field"})), (DataType)StringType$.MODULE$)})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380))));
            String x$8 = "_LEGACY_ERROR_TEMP_3227";
            scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"missing_col")}));
            Option x$10 = this.checkError$default$3();
            boolean x$11 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$12 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$7, "_LEGACY_ERROR_TEMP_3227", x$10, x$9, x$11, x$12);
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
        this.test("alterTable: update column data type", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"id"})), (DataType)LongType$.MODULE$)}));
            StructType expectedSchema = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("alterTable: update column nullability", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Column[] originalColumns = (Column[])((Object[])new Column[]{Column.create((String)"id", (DataType)IntegerType$.MODULE$, (boolean)false), Column.create((String)"data", (DataType)StringType$.MODULE$)});
            Table table = catalog.createTable(this.testIdent(), originalColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = originalColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnNullability((String[])((String[])((Object[])new String[]{"id"})), (boolean)true)}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        this.test("alterTable: update missing column fails", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            SparkIllegalArgumentException x$13 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnType((String[])((String[])((Object[])new String[]{"missing_col"})), (DataType)LongType$.MODULE$)})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426))));
            String x$14 = "_LEGACY_ERROR_TEMP_3227";
            scala.collection.immutable.Map x$15 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"missing_col")}));
            Option x$16 = this.checkError$default$3();
            boolean x$17 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$18 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$13, "_LEGACY_ERROR_TEMP_3227", x$16, x$15, x$17, x$18);
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
        this.test("alterTable: add comment", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "comment text").add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 434));
        this.test("alterTable: replace comment", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 455));
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"comment text")}));
            StructType expectedSchema = new StructType().add("id", (DataType)IntegerType$.MODULE$, true, "replacement comment").add("data", (DataType)StringType$.MODULE$);
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"id"})), (String)"replacement comment")}));
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        this.test("alterTable: add comment to missing column fails", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            SparkIllegalArgumentException x$19 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.updateColumnComment((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"comment")})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477))));
            String x$20 = "_LEGACY_ERROR_TEMP_3227";
            scala.collection.immutable.Map x$21 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"missing_col")}));
            Option x$22 = this.checkError$default$3();
            boolean x$23 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$24 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$19, "_LEGACY_ERROR_TEMP_3227", x$22, x$21, x$23, x$24);
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.test("alterTable: rename top-level column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"id"})), (String)"some_id")}));
            StructType expectedSchema = new StructType().add("some_id", (DataType)IntegerType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        this.test("alterTable: rename nested column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] tableColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct), ClassTag$.MODULE$.apply(Column.class));
            Table table = catalog.createTable(this.testIdent(), tableColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = tableColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] expectedColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)newPointStruct), ClassTag$.MODULE$.apply(Column.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = expectedColumns;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("alterTable: rename struct column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] tableColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct), ClassTag$.MODULE$.apply(Column.class));
            Table table = catalog.createTable(this.testIdent(), tableColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = tableColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point"})), (String)"p")}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] expectedColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"p", (DataType)newPointStruct), ClassTag$.MODULE$.apply(Column.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = expectedColumns;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        this.test("alterTable: rename missing column fails", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
            SparkIllegalArgumentException x$25 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (String)"new_name")})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545))));
            String x$26 = "_LEGACY_ERROR_TEMP_3227";
            scala.collection.immutable.Map x$27 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"missing_col")}));
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "_LEGACY_ERROR_TEMP_3227", x$28, x$27, x$29, x$30);
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("alterTable: multiple changes", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] tableColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct), ClassTag$.MODULE$.apply(Column.class));
            Table table = catalog.createTable(this.testIdent(), tableColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = tableColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "x"})), (String)"first"), TableChange.renameColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (String)"second")}));
            StructType newPointStruct = new StructType().add("first", (DataType)DoubleType$.MODULE$).add("second", (DataType)DoubleType$.MODULE$);
            Column[] expectedColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)newPointStruct), ClassTag$.MODULE$.apply(Column.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = expectedColumns;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 570));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
        this.test("alterTable: delete top-level column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"id"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))}));
            StructType expectedSchema = new StructType().add("data", (DataType)StringType$.MODULE$);
            StructType $org_scalatest_assert_macro_left2 = updated.schema();
            StructType $org_scalatest_assert_macro_right2 = expectedSchema;
            StructType structType = $org_scalatest_assert_macro_left2;
            StructType structType2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 573));
        this.test("alterTable: delete nested column", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] tableColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct), ClassTag$.MODULE$.apply(Column.class));
            Table table = catalog.createTable(this.testIdent(), tableColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = tableColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 595));
            Table updated = catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "y"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))}));
            StructType newPointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$);
            Column[] expectedColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)newPointStruct), ClassTag$.MODULE$.apply(Column.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(updated.columns());
            Column[] $org_scalatest_assert_macro_right2 = expectedColumns;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        this.test("alterTable: delete missing column fails", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Table table = catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = this.columns();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
            SparkIllegalArgumentException x$31 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614))));
            String x$32 = "_LEGACY_ERROR_TEMP_3227";
            scala.collection.immutable.Map x$33 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"missing_col")}));
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "_LEGACY_ERROR_TEMP_3227", x$34, x$33, x$35, x$36);
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"missing_col"})), (Boolean)Predef$.MODULE$.boolean2Boolean(true))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right2 = this.columns();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 622));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        this.test("alterTable: delete missing nested column fails", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            StructType pointStruct = new StructType().add("x", (DataType)DoubleType$.MODULE$).add("y", (DataType)DoubleType$.MODULE$);
            Column[] tableColumns = (Column[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.columns()), (Object)Column.create((String)"point", (DataType)pointStruct), ClassTag$.MODULE$.apply(Column.class));
            Table table = catalog.createTable(this.testIdent(), tableColumns, this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right = tableColumns;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 633));
            SparkIllegalArgumentException x$37 = (SparkIllegalArgumentException)((Object)((Object)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (Boolean)Predef$.MODULE$.boolean2Boolean(false))})), ClassTag$.MODULE$.apply(SparkIllegalArgumentException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636))));
            String x$38 = "_LEGACY_ERROR_TEMP_3227";
            scala.collection.immutable.Map x$39 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fieldName"), (Object)"z")}));
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, "_LEGACY_ERROR_TEMP_3227", x$40, x$39, x$41, x$42);
            catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.deleteColumn((String[])((String[])((Object[])new String[]{"point", "z"})), (Boolean)Predef$.MODULE$.boolean2Boolean(true))}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(table.columns());
            Column[] $org_scalatest_assert_macro_right2 = tableColumns;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
        this.test("alterTable: table does not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0 & Serializable)() -> catalog.alterTable(this.testIdent(), (Seq<TableChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableChange[]{TableChange.setProperty((String)"prop", (String)"val")})), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
            this.checkErrorTableNotFound((SparkThrowable)exc, this.testIdentQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
        this.test("dropTable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 664));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 657));
        this.test("dropTable: table does not exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
            boolean wasDropped = catalog.dropTable(this.testIdent());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(wasDropped, "wasDropped", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672));
        this.test("purgeTable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            return (SparkUnsupportedOperationException)this.intercept((Function0)(JFunction0.mcZ.sp & Serializable)() -> catalog.purgeTable(this.testIdent()), ClassTag$.MODULE$.apply(SparkUnsupportedOperationException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
        this.test("renameTable", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
            catalog.renameTable(this.testIdent(), this.testIdentNew());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        this.test("renameTable: fail if table does not exist", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchTableException exc = (NoSuchTableException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(NoSuchTableException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            this.checkErrorTableNotFound((SparkThrowable)exc, this.testIdentQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("renameTable: fail if new table name already exists", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(this.testIdentNew(), this.columns(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdent()), "catalog.tableExists(CatalogSuite.this.testIdent)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.tableExists(this.testIdentNew()), "catalog.tableExists(CatalogSuite.this.testIdentNew)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.renameTable(this.testIdent(), this.testIdentNew()), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
            this.checkErrorTableAlreadyExists((SparkThrowable)exc, this.testIdentNewQuoted());
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
        this.test("listNamespaces: list namespaces from metadata", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace((String[])((Object[])new String[]{"ns1"}), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 736));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 737));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            Object[] $org_scalatest_assert_macro_right3 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 732));
        this.test("listNamespaces: list namespaces from tables", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_2");
            catalog.createTable(ident1, this.columns(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(ident2, this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            String[][] $org_scalatest_assert_macro_right3 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1", "ns2"})});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1", "ns2"})));
            Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
        this.test("listNamespaces: list namespaces from metadata and tables", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"test_table_2");
            catalog.createNamespace((String[])((Object[])new String[]{"ns1"}), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(ident1, this.columns(), this.emptyTrans(), this.emptyProps());
            catalog.createTable(ident2, this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(catalog.listNamespaces());
            String[][] $org_scalatest_assert_macro_right = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalog.listNamespaces((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1"})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1"})));
            String[][] $org_scalatest_assert_macro_right3 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"ns1", "ns2"})});
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalog.listNamespaces((String[])((Object[])new String[]{"ns1", "ns2"})));
            Object[] $org_scalatest_assert_macro_right4 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
        this.test("loadNamespaceMetadata: fail if no metadata or tables exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchNamespaceException exc = (NoSuchNamespaceException)this.intercept((Function0 & Serializable)() -> catalog.loadNamespaceMetadata(this.testNs()), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 770));
        this.test("loadNamespaceMetadata: no metadata, table exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        this.test("loadNamespaceMetadata: metadata exists, no tables", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        this.test("loadNamespaceMetadata: metadata and table exist", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            java.util.Map<String, String> metadata = catalog.loadNamespaceMetadata(this.testNs());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(metadata).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
        this.test("createNamespace: basic behavior", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 817));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("createNamespace: fail if metadata already exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            NamespaceAlreadyExistsException exc = (NamespaceAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava()), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 825));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
        this.test("createNamespace: fail if namespace already exists from table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 840));
            NamespaceAlreadyExistsException exc = (NamespaceAlreadyExistsException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava()), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            String $org_scalatest_assert_macro_left3 = exc.getMessage();
            String $org_scalatest_assert_macro_right3 = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 846));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right4 = true;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Map().empty();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 848));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 834));
        this.test("dropNamespace: drop missing namespace", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 854));
            boolean ret = catalog.dropNamespace(this.testNs(), false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret));
            boolean $org_scalatest_assert_macro_right2 = false;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 858));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
        this.test("dropNamespace: drop empty namespace", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 867));
            boolean ret = catalog.dropNamespace(this.testNs(), false);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)ret));
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 871));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)catalog.namespaceExists(this.testNs())));
            boolean $org_scalatest_assert_macro_right4 = false;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
        this.test("dropNamespace: drop even if it's not empty", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.dropNamespace(this.testNs(), true), "catalog.dropNamespace(CatalogSuite.this.testNs, true)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.namespaceExists(this.testNs()), "catalog.namespaceExists(CatalogSuite.this.testNs)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883));
            return (NoSuchNamespaceException)this.intercept((Function0 & Serializable)() -> catalog.listTables(this.testNs()), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 884));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
        this.test("alterNamespace: basic behavior", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createNamespace(this.testNs(), CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}))).asJava());
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property2", (String)"value2")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property2"), (Object)"value2")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.removeProperty((String)"property2"), NamespaceChange.setProperty((String)"property3", (String)"value3")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property3"), (Object)"value3")}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.removeProperty((String)"property3")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 903));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 887));
        this.test("alterNamespace: create metadata if missing and table exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property", (String)"value")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(CollectionConverters$.MODULE$.MapHasAsScala(catalog.loadNamespaceMetadata(this.testNs())).asScala());
            scala.collection.immutable.Map $org_scalatest_assert_macro_right = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)"value")}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 913));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 906));
        this.test("alterNamespace: fail if no metadata or table exists", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            NoSuchNamespaceException exc = (NoSuchNamespaceException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> catalog.alterNamespace(this.testNs(), (Seq<NamespaceChange>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamespaceChange[]{NamespaceChange.setProperty((String)"property", (String)"value")})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 919));
            String $org_scalatest_assert_macro_left = exc.getMessage();
            String $org_scalatest_assert_macro_right = CatalogV2Implicits$.MODULE$.NamespaceHelper(this.testNs()).quoted();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916));
        this.test("truncate non-partitioned table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            InMemoryTable table = (InMemoryTable)catalog.createTable(this.testIdent(), this.columns(), this.emptyTrans(), this.emptyProps());
            table.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("3")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), "abc", "3"}))), new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("4")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "def", "4"})))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(table.truncateTable(), "table.truncateTable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 934));
            Seq<InternalRow> $org_scalatest_assert_macro_left = table.rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 935));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 926));
        this.test("truncate partitioned table", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryPartitionTableCatalog partCatalog = new InMemoryPartitionTableCatalog();
            partCatalog.initialize("test", CaseInsensitiveStringMap.empty());
            Table table = partCatalog.createTable(this.testIdent(), (Column[])((Object[])new Column[]{Column.create((String)"col0", (DataType)IntegerType$.MODULE$), Column.create((String)"part0", (DataType)IntegerType$.MODULE$)}), (Transform[])((Object[])new Transform[]{LogicalExpressions$.MODULE$.identity(LogicalExpressions$.MODULE$.parseReference("part0"))}), Collections.emptyMap());
            InMemoryPartitionTable partTable = (InMemoryPartitionTable)table;
            InternalRow partIdent = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}));
            InternalRow partIdent1 = InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            partTable.createPartition(partIdent, new HashMap<String, String>());
            partTable.createPartition(partIdent1, new HashMap<String, String>());
            partTable.withData((BufferedRows[])((Object[])new BufferedRows[]{new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("0")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}))), new BufferedRows((Seq<Object>)Predef$.MODULE$.wrapString("1")).withRow(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)})))}));
            InternalRow[] $org_scalatest_assert_macro_left = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 958));
            Seq<InternalRow> $org_scalatest_assert_macro_left2 = partTable.rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 959));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.truncateTable(), "partTable.truncateTable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 960));
            InternalRow[] $org_scalatest_assert_macro_left3 = partTable.listPartitionIdentifiers((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), InternalRow$.MODULE$.empty());
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
            Seq<InternalRow> $org_scalatest_assert_macro_left4 = partTable.rows();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 962));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
        this.function = new UnboundFunction(null){

            public BoundFunction bind(StructType inputType) {
                return new ScalarFunction<Object>(null){

                    public Object produceResult(InternalRow x$1) {
                        return super.produceResult(x$1);
                    }

                    public DataType[] inputTypes() {
                        return (DataType[])((Object[])new DataType[]{IntegerType$.MODULE$});
                    }

                    public DataType resultType() {
                        return IntegerType$.MODULE$;
                    }

                    public String name() {
                        return "my_bound_function";
                    }
                };
            }

            public String description() {
                return "my_function";
            }

            public String name() {
                return "my_function";
            }
        };
        this.test("list functions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident1 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"func1");
            Identifier ident2 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"func2");
            Identifier ident3 = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns3"})), (String)"func3");
            catalog.createNamespace((String[])((Object[])new String[]{"ns1", "ns2"}), this.emptyProps());
            catalog.createNamespace((String[])((Object[])new String[]{"ns1", "ns3"}), this.emptyProps());
            catalog.createFunction(ident1, this.function());
            catalog.createFunction(ident2, this.function());
            catalog.createFunction(ident3, this.function());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1", "ns2"}))).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident1, ident2}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(Predef$.MODULE$.wrapRefArray((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1", "ns3"}))).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Identifier[]{ident3}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 988));
            Set $org_scalatest_assert_macro_left3 = Predef$.MODULE$.wrapRefArray((Object[])catalog.listFunctions((String[])((Object[])new String[]{"ns1"}))).toSet();
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            Set set = $org_scalatest_assert_macro_left3;
            Set set2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 989));
            return (NoSuchNamespaceException)this.intercept((Function0 & Serializable)() -> catalog.listFunctions((String[])((Object[])new String[]{"ns2"})), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 990));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        this.test("lookup function", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InMemoryCatalog catalog = this.newCatalog();
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"func");
            catalog.createNamespace((String[])((Object[])new String[]{"ns"}), this.emptyProps());
            catalog.createFunction(ident, this.function());
            UnboundFunction $org_scalatest_assert_macro_left = catalog.loadFunction(ident);
            UnboundFunction $org_scalatest_assert_macro_right = this.function();
            UnboundFunction unboundFunction = $org_scalatest_assert_macro_left;
            UnboundFunction unboundFunction2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(unboundFunction != null ? !unboundFunction.equals(unboundFunction2) : unboundFunction2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 999));
            this.intercept((Function0 & Serializable)() -> catalog.loadFunction(Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"func1")), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1000));
            return (NoSuchFunctionException)this.intercept((Function0 & Serializable)() -> catalog.loadFunction(Identifier.of((String[])((String[])((Object[])new String[]{"ns1"})), (String)"func")), ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1001));
        }, new Position("CatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
    }
}

