/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.expressions;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.connector.expressions.BucketTransform;
import org.apache.spark.sql.connector.expressions.BucketTransform$;
import org.apache.spark.sql.connector.expressions.ClusterByTransform;
import org.apache.spark.sql.connector.expressions.ClusterByTransform$;
import org.apache.spark.sql.connector.expressions.DaysTransform$;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.HoursTransform$;
import org.apache.spark.sql.connector.expressions.IdentityTransform$;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.connector.expressions.LogicalExpressions$;
import org.apache.spark.sql.connector.expressions.MonthsTransform$;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.SortedBucketTransform;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.expressions.YearsTransform$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.util.ArrayImplicits$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005=3A!\u0002\u0004\u0001'!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0005;!)!\u0007\u0001C\u0005g!)q\t\u0001C\u0005\u0011\n9BK]1og\u001a|'/\\#yiJ\f7\r^8s'VLG/\u001a\u0006\u0003\u000f!\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011BC\u0001\nG>tg.Z2u_JT!a\u0003\u0007\u0002\u0007M\fHN\u0003\u0002\u000e\u001d\u0005)1\u000f]1sW*\u0011q\u0002E\u0001\u0007CB\f7\r[3\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005U1R\"\u0001\u0007\n\u0005]a!!D*qCJ\\g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\r\u0005\u0019A.\u001b;\u0016\u0005y!CCA\u00101!\rY\u0002EI\u0005\u0003C\u0019\u0011q\u0001T5uKJ\fG\u000e\u0005\u0002$I1\u0001A!B\u0013\u0003\u0005\u00041#!\u0001+\u0012\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#a\u0002(pi\"Lgn\u001a\t\u0003Q9J!aL\u0015\u0003\u0007\u0005s\u0017\u0010C\u00032\u0005\u0001\u0007!%A\u0004mSR,'/\u00197\u0002\u0007I,g\r\u0006\u00025oA\u00111$N\u0005\u0003m\u0019\u0011aBT1nK\u0012\u0014VMZ3sK:\u001cW\rC\u00039\u0007\u0001\u0007\u0011(A\u0003oC6,7\u000fE\u0002)uqJ!aO\u0015\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002>\t:\u0011aH\u0011\t\u0003\u007f%j\u0011\u0001\u0011\u0006\u0003\u0003J\ta\u0001\u0010:p_Rt\u0014BA\"*\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\rK\u0013!\u0003;sC:\u001chm\u001c:n)\rIEJ\u0014\t\u00037)K!a\u0013\u0004\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007\"B'\u0005\u0001\u0004a\u0014\u0001\u00024v]\u000eDQA\r\u0003A\u0002Q\u0002")
public class TransformExtractorSuite
extends SparkFunSuite {
    public <T> Literal<T> org$apache$spark$sql$connector$expressions$TransformExtractorSuite$$lit(T literal) {
        return new Literal<T>(null, literal){
            private final Object literal$1;

            public Expression[] children() {
                return super.children();
            }

            public T value() {
                return (T)this.literal$1;
            }

            public DataType dataType() {
                return Literal$.MODULE$.apply(this.literal$1).dataType();
            }

            public String toString() {
                return this.literal$1.toString();
            }
            {
                this.literal$1 = literal$1;
            }
        };
    }

    private NamedReference ref(Seq<String> names) {
        return new NamedReference(null, names){
            private final Seq names$1;

            public Expression[] children() {
                return super.children();
            }

            public NamedReference[] references() {
                return super.references();
            }

            public String[] fieldNames() {
                return (String[])this.names$1.toArray(ClassTag$.MODULE$.apply(String.class));
            }

            public String toString() {
                return this.names$1.mkString(".");
            }
            {
                this.names$1 = names$1;
            }
        };
    }

    private Transform transform(String func, NamedReference ref) {
        return new Transform(null, func, ref){
            private final String func$1;
            private final NamedReference ref$1;

            public Expression[] children() {
                return super.children();
            }

            public String name() {
                return this.func$1;
            }

            public Expression[] arguments() {
                return (Expression[])((Object[])new Expression[]{this.ref$1});
            }

            public String toString() {
                return this.ref$1.describe();
            }
            {
                this.func$1 = func$1;
                this.ref$1 = ref$1;
            }
        };
    }

    public TransformExtractorSuite() {
        this.test("Identity extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            FieldReference fieldReference;
            Option option;
            FieldReference fieldReference2;
            Option option2;
            Transform transform = this.transform("identity", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform == null || (option2 = IdentityTransform$.MODULE$.unapply(transform)).isEmpty() || (fieldReference2 = (FieldReference)option2.get()) == null) {
                throw this.fail("Did not match IdentityTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = IdentityTransform$.MODULE$.unapply(transform2)).isEmpty() && (fieldReference = (FieldReference)option.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("Years extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            FieldReference fieldReference;
            Option option;
            FieldReference fieldReference2;
            Option option2;
            Transform transform = this.transform("years", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform == null || (option2 = YearsTransform$.MODULE$.unapply(transform)).isEmpty() || (fieldReference2 = (FieldReference)option2.get()) == null) {
                throw this.fail("Did not match YearsTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = YearsTransform$.MODULE$.unapply(transform2)).isEmpty() && (fieldReference = (FieldReference)option.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Months extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            FieldReference fieldReference;
            Option option;
            FieldReference fieldReference2;
            Option option2;
            Transform transform = this.transform("months", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform == null || (option2 = MonthsTransform$.MODULE$.unapply(transform)).isEmpty() || (fieldReference2 = (FieldReference)option2.get()) == null) {
                throw this.fail("Did not match MonthsTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = MonthsTransform$.MODULE$.unapply(transform2)).isEmpty() && (fieldReference = (FieldReference)option.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("Days extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            FieldReference fieldReference;
            Option option;
            FieldReference fieldReference2;
            Option option2;
            Transform transform = this.transform("days", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform == null || (option2 = DaysTransform$.MODULE$.unapply(transform)).isEmpty() || (fieldReference2 = (FieldReference)option2.get()) == null) {
                throw this.fail("Did not match DaysTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = DaysTransform$.MODULE$.unapply(transform2)).isEmpty() && (fieldReference = (FieldReference)option.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("Hours extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            FieldReference fieldReference;
            Option option;
            FieldReference fieldReference2;
            Option option2;
            Transform transform = this.transform("hours", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform == null || (option2 = HoursTransform$.MODULE$.unapply(transform)).isEmpty() || (fieldReference2 = (FieldReference)option2.get()) == null) {
                throw this.fail("Did not match HoursTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            }
            Seq seq = fieldReference2.parts();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(seq);
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = HoursTransform$.MODULE$.unapply(transform2)).isEmpty() && (fieldReference = (FieldReference)option.get()) != null) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("Bucket extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option option;
            Option option2;
            NamedReference col = this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Transform bucketTransform = new Transform(this, col){
                private final /* synthetic */ TransformExtractorSuite $outer;
                private final NamedReference col$1;

                public Expression[] children() {
                    return super.children();
                }

                public String name() {
                    return "bucket";
                }

                public NamedReference[] references() {
                    return (NamedReference[])((Object[])new NamedReference[]{this.col$1});
                }

                public Expression[] arguments() {
                    return (Expression[])((Object[])new Expression[]{this.$outer.org$apache$spark$sql$connector$expressions$TransformExtractorSuite$$lit(BoxesRunTime.boxToInteger((int)16)), this.col$1});
                }

                public String toString() {
                    return "bucket(16, " + this.col$1.describe() + ")";
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.col$1 = col$1;
                }
            };
            Transform transform = bucketTransform;
            if (transform == null || (option2 = BucketTransform$.MODULE$.unapply(transform)).isEmpty()) {
                throw this.fail("Did not match BucketTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            }
            int numBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
            Seq cols = (Seq)((Tuple3)option2.get())._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numBuckets));
            int $org_scalatest_assert_macro_right = 16;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((NamedReference)cols.apply(0)).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = BucketTransform$.MODULE$.unapply(transform2)).isEmpty()) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
        this.test("Sorted Bucket extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option option;
            NamedReference[] sortedCol;
            NamedReference[] col = (NamedReference[])((Object[])new NamedReference[]{this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))});
            Transform sortedBucketTransform = new Transform(this, col, sortedCol = (NamedReference[])((Object[])new NamedReference[]{this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))})){
                private final /* synthetic */ TransformExtractorSuite $outer;
                private final NamedReference[] col$2;
                private final NamedReference[] sortedCol$1;

                public Expression[] children() {
                    return super.children();
                }

                public String name() {
                    return "sorted_bucket";
                }

                public NamedReference[] references() {
                    return (NamedReference[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.col$2), (Object)this.sortedCol$1, ClassTag$.MODULE$.apply(NamedReference.class));
                }

                public Expression[] arguments() {
                    return (Expression[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])this.col$2), this.$outer.org$apache$spark$sql$connector$expressions$TransformExtractorSuite$$lit(BoxesRunTime.boxToInteger((int)16)), ClassTag$.MODULE$.apply(Expression.class))), (Object)this.sortedCol$1, ClassTag$.MODULE$.apply(Expression.class));
                }

                public String describe() {
                    return "bucket(16, " + this.col$2[0].describe() + ", " + this.col$2[1].describe() + " " + this.sortedCol$1[0].describe() + " " + this.sortedCol$1[1].describe() + ")";
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.col$2 = col$2;
                    this.sortedCol$1 = sortedCol$1;
                }
            };
            Transform transform = sortedBucketTransform;
            if (transform != null && !(option = BucketTransform$.MODULE$.unapply(transform)).isEmpty()) {
                int numBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._1());
                Seq cols = (Seq)((Tuple3)option.get())._2();
                Seq sortCols = (Seq)((Tuple3)option.get())._3();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numBuckets));
                int $org_scalatest_assert_macro_right = 16;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(cols.flatMap((Function1 & Serializable)c -> Predef$.MODULE$.wrapRefArray((Object[])c.fieldNames())));
                .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(sortCols.flatMap((Function1 & Serializable)c -> Predef$.MODULE$.wrapRefArray((Object[])c.fieldNames())));
                .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            }
            throw this.fail("Did not match BucketTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        this.test("test bucket", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression[] arguments2;
            NamedReference[] reference2;
            Expression[] arguments1;
            NamedReference[] reference1;
            NamedReference[] col = (NamedReference[])((Object[])new NamedReference[]{this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b"}))});
            NamedReference[] sortedCol = (NamedReference[])((Object[])new NamedReference[]{this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"d"}))});
            BucketTransform bucketTransform = LogicalExpressions$.MODULE$.bucket(16, col);
            NamedReference[] $org_scalatest_assert_macro_left = reference1 = bucketTransform.references();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(reference1[0].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(reference1[1].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)"b", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Expression[] $org_scalatest_assert_macro_left4 = arguments1 = bucketTransform.arguments();
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((LiteralValue)arguments1[0]).value());
            int $org_scalatest_assert_macro_right5 = 16;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((NamedReference)arguments1[1]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right6 = new .colon.colon((Object)"a", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(((NamedReference)arguments1[2]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right7 = new .colon.colon((Object)"b", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            Transform copied1 = bucketTransform.withReferences((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)reference1).toImmutableArraySeq());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(copied1.equals(bucketTransform), "copied1.equals(bucketTransform)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            SortedBucketTransform sortedBucketTransform = LogicalExpressions$.MODULE$.bucket(16, col, sortedCol);
            NamedReference[] $org_scalatest_assert_macro_left8 = reference2 = sortedBucketTransform.references();
            int $org_scalatest_assert_macro_right8 = 4;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left8, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(reference2[0].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right9 = new .colon.colon((Object)"a", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(reference2[1].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right10 = new .colon.colon((Object)"b", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(reference2[2].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right11 = new .colon.colon((Object)"c", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(reference2[3].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right12 = new .colon.colon((Object)"d", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            Expression[] $org_scalatest_assert_macro_left13 = arguments2 = sortedBucketTransform.arguments();
            int $org_scalatest_assert_macro_right13 = 5;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left13, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left13.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right13), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(((NamedReference)arguments2[0]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right14 = new .colon.colon((Object)"a", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(((NamedReference)arguments2[1]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right15 = new .colon.colon((Object)"b", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(((LiteralValue)arguments2[2]).value());
            int $org_scalatest_assert_macro_right16 = 16;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(((NamedReference)arguments2[3]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right17 = new .colon.colon((Object)"c", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right17, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right17, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.convertToEqualizer(((NamedReference)arguments2[4]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right18 = new .colon.colon((Object)"d", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            Transform copied2 = sortedBucketTransform.withReferences((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)reference2).toImmutableArraySeq());
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(copied2.equals(sortedBucketTransform), "copied2.equals(sortedBucketTransform)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        this.test("ClusterBySpec extractor", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Option option;
            Option option2;
            NamedReference col = this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
            Transform clusterByTransform = new Transform(null, col){
                private final NamedReference col$3;

                public Expression[] children() {
                    return super.children();
                }

                public String name() {
                    return "cluster_by";
                }

                public NamedReference[] references() {
                    return (NamedReference[])((Object[])new NamedReference[]{this.col$3});
                }

                public Expression[] arguments() {
                    return (Expression[])((Object[])new Expression[]{this.col$3});
                }

                public String toString() {
                    return this.name() + "(" + this.col$3.describe() + ")";
                }
                {
                    this.col$3 = col$3;
                }
            };
            Transform transform = clusterByTransform;
            if (transform == null || (option2 = ClusterByTransform$.MODULE$.unapply(transform)).isEmpty()) {
                throw this.fail("Did not match ClusterByTransform extractor", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            }
            Seq columnNames = (Seq)option2.get();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)columnNames.size()));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((NamedReference)columnNames.apply(0)).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            Transform transform2 = this.transform("unknown", this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
            if (transform2 != null && !(option = ClusterByTransform$.MODULE$.unapply(transform2)).isEmpty()) {
                throw this.fail("Matched unknown transform", new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
            }
            return BoxedUnit.UNIT;
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("test cluster by", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression[] arguments;
            NamedReference[] reference;
            NamedReference[] col = (NamedReference[])((Object[])new NamedReference[]{this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a a", "b"})), this.ref((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ts"}))});
            ClusterByTransform clusterByTransform = LogicalExpressions$.MODULE$.clusterBy(col);
            NamedReference[] $org_scalatest_assert_macro_left = reference = clusterByTransform.references();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(reference[0].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)"a a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(reference[1].fieldNames());
            .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)"ts", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Expression[] $org_scalatest_assert_macro_left4 = arguments = clusterByTransform.arguments();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(((NamedReference)arguments[0]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right5 = new .colon.colon((Object)"a a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(((NamedReference)arguments[1]).fieldNames());
            .colon.colon $org_scalatest_assert_macro_right6 = new .colon.colon((Object)"ts", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            Transform copied = clusterByTransform.withReferences((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)reference).toImmutableArraySeq());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(copied.equals(clusterByTransform), "copied.equals(clusterByTransform)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        }, new Position("TransformExtractorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
    }
}

