/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PreciseTimestampConversion;
import org.apache.spark.sql.catalyst.expressions.SessionWindow;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.TimeWindow;
import org.apache.spark.sql.catalyst.expressions.WindowTime;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;

public final class SessionWindowing$
extends Rule<LogicalPlan> {
    public static final SessionWindowing$ MODULE$ = new SessionWindowing$();

    private final String SESSION_COL_NAME() {
        return "session_window";
    }

    private final String SESSION_START() {
        return "start";
    }

    private final String SESSION_END() {
        return "end";
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        LogicalPlan logicalPlan;
        Object object = new Object();
        try {
            logicalPlan = plan2.resolveOperatorsUpWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.containsPattern(TreePattern$.MODULE$.SESSION_WINDOW())), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(object){
                private static final long serialVersionUID = 0L;
                private final Object nonLocalReturnKey2$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = x1;
                    if (A12 != null && (A1 = A12).children().size() == 1) {
                        LogicalPlan child = (LogicalPlan)A1.children().head();
                        Set sessionExpressions = ((IterableOnceOps)A1.expressions().flatMap((Function1 & Serializable)x$6 -> x$6.collect(new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof SessionWindow) {
                                    SessionWindow sessionWindow = (SessionWindow)A1;
                                    return (B1)sessionWindow;
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Expression x1) {
                                Expression expression = x1;
                                return expression instanceof SessionWindow;
                            }
                        }))).toSet();
                        int numWindowExpr = ((IterableOnceOps)A1.expressions().flatMap((Function1 & Serializable)x$7 -> x$7.collect(new Serializable(null){
                            private static final long serialVersionUID = 0L;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                A1 A1 = x2;
                                if (A1 instanceof SessionWindow) {
                                    SessionWindow sessionWindow = (SessionWindow)A1;
                                    return (B1)sessionWindow;
                                }
                                if (A1 instanceof TimeWindow) {
                                    TimeWindow timeWindow = (TimeWindow)A1;
                                    return (B1)timeWindow;
                                }
                                return (B1)function1.apply(x2);
                            }

                            public final boolean isDefinedAt(Expression x2) {
                                Expression expression = x2;
                                if (expression instanceof SessionWindow) {
                                    return true;
                                }
                                return expression instanceof TimeWindow;
                            }
                        }))).toSet().size();
                        if (numWindowExpr == 1 && sessionExpressions.nonEmpty() && ((SessionWindow)sessionExpressions.head()).timeColumn().resolved() && ((ExpectsInputTypes)sessionExpressions.head()).checkInputDataTypes().isSuccess()) {
                            CalendarInterval interval;
                            CreateNamedStruct literalSessionStruct;
                            Expression expression;
                            Metadata metadata;
                            SessionWindow session = (SessionWindow)sessionExpressions.head();
                            if (StructType$.MODULE$.acceptsType(session.timeColumn().dataType())) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey2$1, A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(null, session){
                                    private static final long serialVersionUID = 0L;
                                    private final SessionWindow session$1;

                                    public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                                        A1 A1 = x3;
                                        if (A1 instanceof SessionWindow) {
                                            SessionWindow sessionWindow = (SessionWindow)A1;
                                            return (B1)sessionWindow.copy(new WindowTime(this.session$1.timeColumn()), sessionWindow.copy$default$2());
                                        }
                                        return (B1)function1.apply(x3);
                                    }

                                    public final boolean isDefinedAt(Expression x3) {
                                        Expression expression = x3;
                                        return expression instanceof SessionWindow;
                                    }
                                    {
                                        this.session$1 = session$1;
                                    }
                                }));
                            }
                            Expression expression2 = session.timeColumn();
                            if (expression2 instanceof Attribute) {
                                Attribute attribute = (Attribute)expression2;
                                metadata = attribute.metadata();
                            } else {
                                metadata = Metadata$.MODULE$.empty();
                            }
                            Metadata metadata2 = metadata;
                            Metadata newMetadata = new MetadataBuilder().withMetadata(metadata2).putBoolean(SessionWindow$.MODULE$.marker(), true).build();
                            String x$1 = "session_window";
                            DataType x$2 = session.dataType();
                            Metadata x$3 = newMetadata;
                            boolean x$4 = AttributeReference$.MODULE$.apply$default$3();
                            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("session_window", x$2, x$4, x$3);
                            Seq<String> x$62 = AttributeReference$.MODULE$.apply$default$6("session_window", x$2, x$4, x$3);
                            AttributeReference sessionAttr = new AttributeReference("session_window", x$2, x$4, x$3, x$5, x$62);
                            PreciseTimestampConversion sessionStart = new PreciseTimestampConversion(session.timeColumn(), session.timeColumn().dataType(), (DataType)LongType$.MODULE$);
                            Expression expression3 = session.gapDuration();
                            DataType dataType = expression3.dataType();
                            CalendarIntervalType$ calendarIntervalType$ = CalendarIntervalType$.MODULE$;
                            if (!(dataType != null ? !dataType.equals(calendarIntervalType$) : calendarIntervalType$ != null)) {
                                expression = expression3;
                            } else if (Cast$.MODULE$.canCast(expression3.dataType(), (DataType)CalendarIntervalType$.MODULE$)) {
                                expression = new Cast(expression3, (DataType)CalendarIntervalType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            } else {
                                throw QueryCompilationErrors$.MODULE$.sessionWindowGapDurationDataTypeError(expression3.dataType());
                            }
                            Expression gapDuration = expression;
                            PreciseTimestampConversion sessionEnd = new PreciseTimestampConversion(package$expressions$.MODULE$.DslExpression(session.timeColumn()).$plus(gapDuration), session.timeColumn().dataType(), (DataType)LongType$.MODULE$);
                            Literal literal = Literal$.MODULE$.apply("start");
                            Expression expression4 = package$expressions$.MODULE$.DslExpression(new PreciseTimestampConversion(sessionStart, (DataType)LongType$.MODULE$, session.timeColumn().dataType())).castNullable();
                            Literal literal2 = Literal$.MODULE$.apply("end");
                            Expression expression5 = package$expressions$.MODULE$.DslExpression(new PreciseTimestampConversion(sessionEnd, (DataType)LongType$.MODULE$, session.timeColumn().dataType())).castNullable();
                            CreateNamedStruct x$72 = literalSessionStruct = new CreateNamedStruct((Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression5).$colon$colon((Object)literal2).$colon$colon((Object)expression4).$colon$colon((Object)literal));
                            String x$8 = "session_window";
                            ExprId x$9 = sessionAttr.exprId();
                            Some x$10 = new Some((Object)newMetadata);
                            Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$72, "session_window");
                            Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$72, "session_window");
                            Alias sessionStruct = new Alias(x$72, "session_window", x$9, x$11, (Option<Metadata>)x$10, x$12);
                            LogicalPlan replacedPlan = (LogicalPlan)A1.transformExpressions((PartialFunction<Expression, Expression>)new Serializable(null, sessionAttr){
                                private static final long serialVersionUID = 0L;
                                private final AttributeReference sessionAttr$1;

                                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                                    A1 A1 = x4;
                                    if (A1 instanceof SessionWindow) {
                                        return (B1)this.sessionAttr$1;
                                    }
                                    return (B1)function1.apply(x4);
                                }

                                public final boolean isDefinedAt(Expression x4) {
                                    Expression expression = x4;
                                    return expression instanceof SessionWindow;
                                }
                                {
                                    this.sessionAttr$1 = sessionAttr$1;
                                }
                            });
                            boolean filterByTimeRange = gapDuration.foldable() ? (interval = (CalendarInterval)gapDuration.eval(gapDuration.eval$default$1())) == null || (long)(interval.months + interval.days) + interval.microseconds <= 0L : true;
                            IsNotNull filterExpr = filterByTimeRange ? package$expressions$.MODULE$.DslExpression(new IsNotNull(session.timeColumn())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(sessionAttr).getField("end")).$greater(package$expressions$.MODULE$.DslExpression(sessionAttr).getField("start")))) : new IsNotNull(session.timeColumn());
                            Alias alias = sessionStruct;
                            Filter filter = new Filter(filterExpr, new Project((Seq<NamedExpression>)((Seq)child.output().$plus$colon((Object)alias)), child));
                            return (B1)replacedPlan.withNewChildren(Nil$.MODULE$.$colon$colon((Object)filter));
                        }
                        if (numWindowExpr > 1) {
                            throw QueryCompilationErrors$.MODULE$.multiTimeWindowExpressionsNotSupportedError(A1);
                        }
                        return (B1)A1;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan;
                    LogicalPlan logicalPlan2 = x1;
                    return logicalPlan2 != null && (logicalPlan = logicalPlan2).children().size() == 1;
                }
                {
                    this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                logicalPlan = (LogicalPlan)ex.value();
            }
            throw ex;
        }
        return logicalPlan;
    }

    private SessionWindowing$() {
    }
}

