/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.AesDecrypt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, key[, mode[, padding[, aad]]]) - Returns a decrypted value of `expr` using AES in `mode` with `padding`.\n      Key lengths of 16, 24 and 32 bits are supported. Supported combinations of (`mode`, `padding`) are ('ECB', 'PKCS'), ('GCM', 'NONE') and ('CBC', 'PKCS').\n      Optional additional authenticated data (AAD) is only supported for GCM. If provided for encryption, the identical AAD value must be provided for decryption.\n      The default mode is GCM.\n  ", arguments="\n    Arguments:\n      * expr - The binary value to decrypt.\n      * key - The passphrase to use to decrypt the data.\n      * mode - Specifies which block cipher mode should be used to decrypt messages.\n               Valid modes: ECB, GCM, CBC.\n      * padding - Specifies how to pad messages whose length is not a multiple of the block size.\n                  Valid values: PKCS, NONE, DEFAULT. The DEFAULT padding means PKCS for ECB, NONE for GCM and PKCS for CBC.\n      * aad - Optional additional authenticated data. Only supported for GCM mode. This can be any free-form input and\n              must be provided for both encryption and decryption.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(unhex('83F16B2AA704794132802D248E6BFD4E380078182D1544813898AC97E709B28A94'), '0000111122223333');\n       Spark\n      > SELECT _FUNC_(unhex('6E7CA17BBB468D3084B5744BCA729FB7B2B7BCB8E4472847D02670489D95FA97DBBA7D3210'), '0000111122223333', 'GCM');\n       Spark SQL\n      > SELECT _FUNC_(unbase64('3lmwu+Mw0H3fi5NDvcu9lg=='), '1234567890abcdef', 'ECB', 'PKCS');\n       Spark SQL\n      > SELECT _FUNC_(unbase64('2NYmDCjgXTbbxGA3/SnJEfFC/JQ7olk2VQWReIAAFKo='), '1234567890abcdef', 'CBC');\n       Apache Spark\n      > SELECT _FUNC_(unbase64('AAAAAAAAAAAAAAAAAAAAAPSd4mWyMZ5mhvjiAPQJnfg='), 'abcdefghijklmnop12345678ABCDEFGH', 'CBC', 'DEFAULT');\n       Spark\n      > SELECT _FUNC_(unbase64('AAAAAAAAAAAAAAAAQiYi+sTLm7KD9UcZ2nlRdYDe/PX4'), 'abcdefghijklmnop12345678ABCDEFGH', 'GCM', 'DEFAULT', 'This is an AAD mixed into the input');\n       Spark\n  ", since="3.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u0015*\u0001ZB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t+\u0002\u0011\t\u0012)A\u0005o!Aa\u000b\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005X\u0001\tE\t\u0015!\u00038\u0011!A\u0006A!f\u0001\n\u0003!\u0006\u0002C-\u0001\u0005#\u0005\u000b\u0011B\u001c\t\u0011i\u0003!Q3A\u0005\u0002QC\u0001b\u0017\u0001\u0003\u0012\u0003\u0006Ia\u000e\u0005\t9\u0002\u0011)\u001a!C\u0001)\"AQ\f\u0001B\tB\u0003%q\u0007C\u0003_\u0001\u0011\u0005q\f\u0003\u0005g\u0001!\u0015\r\u0011\"\u0011U\u0011\u0015q\u0006\u0001\"\u0001h\u0011\u0015q\u0006\u0001\"\u0001m\u0011\u0015q\u0006\u0001\"\u0001q\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\u0006\u0001\t#\nI\u0002C\u0005\u0002&\u0001\t\t\u0011\"\u0001\u0002(!I\u00111\u0007\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003\u0017\u0002\u0011\u0013!C\u0001\u0003kA\u0011\"!\u0014\u0001#\u0003%\t!!\u000e\t\u0013\u0005=\u0003!%A\u0005\u0002\u0005U\u0002\"CA)\u0001E\u0005I\u0011AA\u001b\u0011%\t\u0019\u0006AA\u0001\n\u0003\n)\u0006C\u0005\u0002f\u0001\t\t\u0011\"\u0001\u0002h!I\u0011q\u000e\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003{\u0002\u0011\u0011!C!\u0003\u007fB\u0011\"!$\u0001\u0003\u0003%\t!a$\t\u0013\u0005e\u0005!!A\u0005B\u0005m\u0005\"CAP\u0001\u0005\u0005I\u0011IAQ\u000f%\tY-KA\u0001\u0012\u0003\tiM\u0002\u0005)S\u0005\u0005\t\u0012AAh\u0011\u0019q&\u0005\"\u0001\u0002h\"I\u0011\u0011\u001e\u0012\u0002\u0002\u0013\u0015\u00131\u001e\u0005\n\u0003[\u0014\u0013\u0011!CA\u0003_D\u0011\"a?#\u0003\u0003%\t)!@\t\u0013\t=!%!A\u0005\n\tE!AC!fg\u0012+7M]=qi*\u0011!fK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002-[\u0005A1-\u0019;bYf\u001cHO\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001omr\u0014i\u0012\t\u0003qej\u0011!K\u0005\u0003u%\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tAD(\u0003\u0002>S\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\tAt(\u0003\u0002AS\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002C\u000b6\t1IC\u0001E\u0003\u0015\u00198-\u00197b\u0013\t15IA\u0004Qe>$Wo\u0019;\u0011\u0005!\u0003fBA%O\u001d\tQU*D\u0001L\u0015\taU'\u0001\u0004=e>|GOP\u0005\u0002\t&\u0011qjQ\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&K\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002P\u0007\u0006)\u0011N\u001c9viV\tq'\u0001\u0004j]B,H\u000fI\u0001\u0004W\u0016L\u0018\u0001B6fs\u0002\nA!\\8eK\u0006)Qn\u001c3fA\u00059\u0001/\u00193eS:<\u0017\u0001\u00039bI\u0012Lgn\u001a\u0011\u0002\u0007\u0005\fG-\u0001\u0003bC\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004aC\n\u001cG-\u001a\t\u0003q\u0001AQaU\u0006A\u0002]BQAV\u0006A\u0002]BQ\u0001W\u0006A\u0002]BQAW\u0006A\u0002]BQ\u0001X\u0006A\u0002]\n1B]3qY\u0006\u001cW-\\3oiR)\u0001\r[5kW\")1+\u0004a\u0001o!)a+\u0004a\u0001o!)\u0001,\u0004a\u0001o!)!,\u0004a\u0001oQ!\u0001-\u001c8p\u0011\u0015\u0019f\u00021\u00018\u0011\u00151f\u00021\u00018\u0011\u0015Af\u00021\u00018)\r\u0001\u0017O\u001d\u0005\u0006'>\u0001\ra\u000e\u0005\u0006->\u0001\raN\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A;\u0011\u0007!3\b0\u0003\u0002x%\n\u00191+Z9\u0011\u0005edX\"\u0001>\u000b\u0005ml\u0013!\u0002;za\u0016\u001c\u0018BA?{\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0001\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002K\u0007&\u0019\u0011\u0011B\"\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tIaQ\u0001\tG\"LG\u000e\u001a:f]V\u0011\u0011Q\u0003\t\u0004\u0011Z<\u0014aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r9\u00141\u0004\u0005\b\u0003;\u0019\u0002\u0019AA\u0010\u0003-qWm^\"iS2$'/\u001a8\u0011\t!\u000b\tcN\u0005\u0004\u0003G\u0011&AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)-\u0001\u0017\u0011FA\u0016\u0003[\ty#!\r\t\u000fM#\u0002\u0013!a\u0001o!9a\u000b\u0006I\u0001\u0002\u00049\u0004b\u0002-\u0015!\u0003\u0005\ra\u000e\u0005\b5R\u0001\n\u00111\u00018\u0011\u001daF\u0003%AA\u0002]\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00028)\u001aq'!\u000f,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0012D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002XA!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013\u0001\u00027b]\u001eT!!!\u0019\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\tY&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002jA\u0019!)a\u001b\n\u0007\u000554IA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002t\u0005e\u0004c\u0001\"\u0002v%\u0019\u0011qO\"\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002|q\t\t\u00111\u0001\u0002j\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!!\u0011\r\u0005\r\u0015\u0011RA:\u001b\t\t)IC\u0002\u0002\b\u000e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY)!\"\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003#\u000b9\nE\u0002C\u0003'K1!!&D\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u001f\u001f\u0003\u0003\u0005\r!a\u001d\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003/\ni\nC\u0005\u0002|}\t\t\u00111\u0001\u0002j\u00051Q-];bYN$B!!%\u0002$\"I\u00111\u0010\u0011\u0002\u0002\u0003\u0007\u00111\u000f\u0015\u0018\u0001\u0005\u001d\u0016QVAX\u0003g\u000b),!/\u0002<\u0006}\u0016\u0011YAc\u0003\u000f\u00042\u0001OAU\u0013\r\tY+\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t,AB_\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK3yaJd\u0003e[3z72\u0002Sn\u001c3f72\u0002\u0003/\u00193eS:<7\f\f\u0011bC\u0012lV,X\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t3fGJL\b\u000f^3eAY\fG.^3!_\u001a\u0004\u0003-\u001a=qe\u0002\u0004So]5oO\u0002\nUi\u0015\u0011j]\u0002\u0002Wn\u001c3fA\u0002:\u0018\u000e\u001e5!AB\fG\rZ5oO\u0002t#\u0002\t\u0011!A\u0001\u00023*Z=!Y\u0016tw\r\u001e5tA=4\u0007%\r\u001c-AI\"\u0004%\u00198eAM\u0012\u0004EY5ug\u0002\n'/\u001a\u0011tkB\u0004xN\u001d;fI:\u00023+\u001e9q_J$X\r\u001a\u0011d_6\u0014\u0017N\\1uS>t7\u000fI8gA!\u0002Wn\u001c3fA2\u0002\u0003\r]1eI&tw\rY\u0015!CJ,\u0007\u0005K\u0014F\u0007\n;C\u0006I\u0014Q\u0017\u000e\u001bv%\u000b\u0017!Q\u001d:5)T\u0014-A\u001druJT#(S\u0001\ng\u000e\u001a\u0011)O\r\u00135i\n\u0017!OA[5iU\u0014*])\u0001\u0003\u0005\t\u0011!A=\u0003H/[8oC2\u0004\u0013\r\u001a3ji&|g.\u00197!CV$\b.\u001a8uS\u000e\fG/\u001a3!I\u0006$\u0018\r\t\u0015B\u0003\u0012K\u0003%[:!_:d\u0017\u0010I:vaB|'\u000f^3eA\u0019|'\u000fI$D\u001b:\u0002\u0013J\u001a\u0011qe>4\u0018\u000eZ3eA\u0019|'\u000fI3oGJL\b\u000f^5p]2\u0002C\u000f[3!S\u0012,g\u000e^5dC2\u0004\u0013)\u0011#!m\u0006dW/\u001a\u0011nkN$\bEY3!aJ|g/\u001b3fI\u00022wN\u001d\u0011eK\u000e\u0014\u0018\u0010\u001d;j_:t#\u0002\t\u0011!A\u0001\u0002C\u000b[3!I\u00164\u0017-\u001e7uA5|G-\u001a\u0011jg\u0002:5)\u0014\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005]\u0016!b\b\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*\u0007\u0010\u001d:![\u0001\"\u0006.\u001a\u0011cS:\f'/\u001f\u0011wC2,X\r\t;pA\u0011,7M]=qi:R\u0001\u0005\t\u0011!A\u0001R\u0003e[3zA5\u0002C\u000b[3!a\u0006\u001c8\u000f\u001d5sCN,\u0007\u0005^8!kN,\u0007\u0005^8!I\u0016\u001c'/\u001f9uAQDW\r\t3bi\u0006t#\u0002\t\u0011!A\u0001\u0002#\u0006I7pI\u0016\u0004S\u0006I*qK\u000eLg-[3tA]D\u0017n\u00195!E2|7m\u001b\u0011dSBDWM\u001d\u0011n_\u0012,\u0007e\u001d5pk2$\u0007EY3!kN,G\r\t;pA\u0011,7M]=qi\u0002jWm]:bO\u0016\u001chF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011WC2LG\rI7pI\u0016\u001c(\bI#D\u00052\u0002siQ'-A\r\u00135I\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!a\u0006$G-\u001b8hA5\u00023\u000b]3dS\u001aLWm\u001d\u0011i_^\u0004Co\u001c\u0011qC\u0012\u0004S.Z:tC\u001e,7\u000fI<i_N,\u0007\u0005\\3oORD\u0007%[:!]>$\b%\u0019\u0011nk2$\u0018\u000e\u001d7fA=4\u0007\u0005\u001e5fA\tdwnY6!g&TXM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002c+\u00197jI\u00022\u0018\r\\;fgj\u0002\u0003kS\"TY\u0001ruJT#-A\u0011+e)Q+M):\u0002C\u000b[3!\t\u00163\u0015)\u0016'UAA\fG\rZ5oO\u0002jW-\u00198tAA[5i\u0015\u0011g_J\u0004Si\u0011\"-A9{e*\u0012\u0011g_J\u0004siQ'!C:$\u0007\u0005U&D'\u00022wN\u001d\u0011D\u0005\u000es#\u0002\t\u0011!A\u0001\u0002#\u0006I1bI\u0002j\u0003e\u00149uS>t\u0017\r\u001c\u0011bI\u0012LG/[8oC2\u0004\u0013-\u001e;iK:$\u0018nY1uK\u0012\u0004C-\u0019;b]\u0001ze\u000e\\=!gV\u0004\bo\u001c:uK\u0012\u0004cm\u001c:!\u000f\u000ek\u0005%\\8eK:\u0002C\u000b[5tA\r\fg\u000e\t2fA\u0005t\u0017\u0010\t4sK\u0016lcm\u001c:nA%t\u0007/\u001e;!C:$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\\;ti\u0002\u0012W\r\t9s_ZLG-\u001a3!M>\u0014\bEY8uQ\u0002*gn\u0019:zaRLwN\u001c\u0011b]\u0012\u0004C-Z2ssB$\u0018n\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0016A\"8\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUt\u0007.\u001a=)Oa\u001ad)\r\u001cCe\u0005\u000bu\u0007\r\u001b8sQ\n4G\r\u001d1e\u0011\u0013D\u0007O#7\u0005\u001a#E'R\u001a9aA:\u0004(\r\u001d3\tF*D\u0007\u000e\u001d2gaJ\u0004(Q\":o\u0015;\u0004'\u000f\"3q\u0005KDgJ\u0015-A\u001d\u0002\u0004\u0007\r\u00192cE\n$G\r\u001a3gM\u001a4gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QUt\u0007.\u001a=)OY*ugQ!2o\t\u0013%\t\u000e\u001c9\tN\u0002\u0004\b\u000e\"6oQ\"$iQ!8ee2%i\u000e\"3\u0005^\u00125I\u0011\u001dFiQ:$\u0007\u000f\u001b8\tB\u0012dg\u000e\u00195qe\"\u0015(\u000e$Bs]\"%IQ!8\tN\u0012\u0014\u0007M\u0014*Y\u0001:\u0003\u0007\r\u00191cE\n\u0014G\r\u001a3eM\u001a4gM\u0014-A\u001d:5)T\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0006/\u0019:lAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015v]\n\f7/\u001a\u001c5Q\u001d\u001aD.\\<vW5;\b\u0007S\u001agSVrEI^2vs1<W(P\u0014*Y\u0001:\u0013GM\u001a5kY:\u0004(\u000f\u0019bE\u000e$WMZ\u0014-A\u001d*5IQ\u0014-A\u001d\u00026jQ*(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sW\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)k:\u0014\u0017m]37i!:#GT-n\t\u000eSw\r\u0017+cEb<\u0015iM\u0018T]*+eMR\"0\u0015F;t\u000e\\63-F;&+Z%B\u0003\u001a[u.P\u0014*Y\u0001:\u0013GM\u001a5kY:\u0004(\u000f\u0019bE\u000e$WMZ\u0014-A\u001d\u001a%iQ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0005/Y2iK\u0002\u001a\u0006/\u0019:l\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"*hNY1tKZ\"\u0004fJ!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)\u0011)TIRjw+_'[k5DgO[5B!FSeNZ4>O%b\u0003eJ1cG\u0012,gm\u001a5jU.dWN\\8qcI\u001aD'\u000e\u001c8q\u0005\u00135\tR#G\u000f\";C\u0006I\u0014D\u0005\u000e;C\u0006I\u0014E\u000b\u001a\u000bU\u000b\u0014+(SmR\u0001\u0005\t\u0011!A\u0001\u00023\u000b]1sW*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CSO\u001c2bg\u00164D\u0007K\u0014B\u0003\u0006\u000b\u0015)Q!B\u0003\u0006\u000b\u0015)Q!B\u0003FK\u0017,[\u0016t)2kwg\u0013#:+\u000eT&G\u001c7SIf#Um\f)Yi\u001dJC\u0006I\u0014bE\u000e$WMZ4iS*\\G.\u001c8paF\u00124\u0007N\u001b7oa\n%i\u0011#F\r\u001eCu\u0005\f\u0011(\u000f\u000eku\u0005\f\u0011(\t\u00163\u0015)\u0016'UO1\u0002s\u0005\u00165jg\u0002J7\u000fI1oA\u0005\u000bE\tI7jq\u0016$\u0007%\u001b8u_\u0002\"\b.\u001a\u0011j]B,HoJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AM\u0003\u0018M]6\u000bA\u0001\nQa]5oG\u0016\f#!a1\u0002\u000bMr3G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005%\u0017AC7jg\u000e|f-\u001e8dg\u0006Q\u0011)Z:EK\u000e\u0014\u0018\u0010\u001d;\u0011\u0005a\u00123#\u0002\u0012\u0002R\u0006u\u0007CCAj\u00033<tgN\u001c8A6\u0011\u0011Q\u001b\u0006\u0004\u0003/\u001c\u0015a\u0002:v]RLW.Z\u0005\u0005\u00037\f)NA\tBEN$(/Y2u\rVt7\r^5p]V\u0002B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\fy&\u0001\u0002j_&\u0019\u0011+!9\u0015\u0005\u00055\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0013!B1qa2LHc\u00031\u0002r\u0006M\u0018Q_A|\u0003sDQaU\u0013A\u0002]BQAV\u0013A\u0002]BQ\u0001W\u0013A\u0002]BQAW\u0013A\u0002]BQ\u0001X\u0013A\u0002]\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\n-\u0001#\u0002\"\u0003\u0002\t\u0015\u0011b\u0001B\u0002\u0007\n1q\n\u001d;j_:\u0004\u0002B\u0011B\u0004o]:tgN\u0005\u0004\u0005\u0013\u0019%A\u0002+va2,W\u0007\u0003\u0005\u0003\u000e\u0019\n\t\u00111\u0001a\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005'\u0001B!!\u0017\u0003\u0016%!!qCA.\u0005\u0019y%M[3di\u0002")
public class AesDecrypt
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression input;
    private final Expression key;
    private final Expression mode;
    private final Expression padding;
    private final Expression aad;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Expression, Expression>> unapply(AesDecrypt x$0) {
        return AesDecrypt$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Expression, Expression>, AesDecrypt> tupled() {
        return AesDecrypt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, AesDecrypt>>>>> curried() {
        return AesDecrypt$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        AesDecrypt aesDecrypt = this;
        synchronized (aesDecrypt) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression input() {
        return this.input;
    }

    public Expression key() {
        return this.key;
    }

    public Expression mode() {
        return this.mode;
    }

    public Expression padding() {
        return this.padding;
    }

    public Expression aad() {
        return this.aad;
    }

    private Expression replacement$lzycompute() {
        AesDecrypt aesDecrypt = this;
        synchronized (aesDecrypt) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new StaticInvoke(ExpressionImplUtils.class, (DataType)BinaryType$.MODULE$, "aesDecrypt", (Seq<Expression>)new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.key(), (List)new .colon.colon((Object)this.mode(), (List)new .colon.colon((Object)this.padding(), (List)new .colon.colon((Object)this.aad(), (List)Nil$.MODULE$))))), this.inputTypes(), StaticInvoke$.MODULE$.apply$default$6(), StaticInvoke$.MODULE$.apply$default$7(), StaticInvoke$.MODULE$.apply$default$8(), StaticInvoke$.MODULE$.apply$default$9());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$)))));
    }

    @Override
    public String prettyName() {
        return "aes_decrypt";
    }

    @Override
    public Seq<Expression> children() {
        return new .colon.colon((Object)this.input(), (List)new .colon.colon((Object)this.key(), (List)new .colon.colon((Object)this.mode(), (List)new .colon.colon((Object)this.padding(), (List)new .colon.colon((Object)this.aad(), (List)Nil$.MODULE$)))));
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4));
    }

    public AesDecrypt copy(Expression input, Expression key, Expression mode, Expression padding, Expression aad) {
        return new AesDecrypt(input, key, mode, padding, aad);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.key();
    }

    public Expression copy$default$3() {
        return this.mode();
    }

    public Expression copy$default$4() {
        return this.padding();
    }

    public Expression copy$default$5() {
        return this.aad();
    }

    @Override
    public String productPrefix() {
        return "AesDecrypt";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.key();
            }
            case 2: {
                return this.mode();
            }
            case 3: {
                return this.padding();
            }
            case 4: {
                return this.aad();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AesDecrypt;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "input";
            }
            case 1: {
                return "key";
            }
            case 2: {
                return "mode";
            }
            case 3: {
                return "padding";
            }
            case 4: {
                return "aad";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AesDecrypt)) return false;
        boolean bl = true;
        if (!bl) return false;
        AesDecrypt aesDecrypt = (AesDecrypt)x$1;
        Expression expression = this.input();
        Expression expression2 = aesDecrypt.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.key();
        Expression expression4 = aesDecrypt.key();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.mode();
        Expression expression6 = aesDecrypt.mode();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.padding();
        Expression expression8 = aesDecrypt.padding();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.aad();
        Expression expression10 = aesDecrypt.aad();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        if (!aesDecrypt.canEqual(this)) return false;
        return true;
    }

    public AesDecrypt(Expression input, Expression key, Expression mode, Expression padding, Expression aad) {
        this.input = input;
        this.key = key;
        this.mode = mode;
        this.padding = padding;
        this.aad = aad;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public AesDecrypt(Expression input, Expression key, Expression mode, Expression padding) {
        this(input, key, mode, padding, Literal$.MODULE$.apply(""));
    }

    public AesDecrypt(Expression input, Expression key, Expression mode) {
        this(input, key, mode, Literal$.MODULE$.apply("DEFAULT"));
    }

    public AesDecrypt(Expression input, Expression key) {
        this(input, key, Literal$.MODULE$.apply("GCM"));
    }
}

