/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayCompact$;
import org.apache.spark.sql.catalyst.expressions.ArrayFilter;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Removes null values from the array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3, null));\n       [1,2,3]\n      > SELECT _FUNC_(array(\"a\", \"b\", \"c\"));\n       [\"a\",\"b\",\"c\"]\n  ", group="array_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0014\u0001\u0003\u0016\u0004%\tA\u0014\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005W!)\u0001\u000b\u0001C\u0001#\"AA\u000b\u0001EC\u0002\u0013\u0005Q\u000b\u0003\u0005Z\u0001!\u0015\r\u0011\"\u0001[\u0011!q\u0006\u0001#b\u0001\n\u0003y\u0006\u0002C2\u0001\u0011\u000b\u0007I\u0011\t(\t\u000b\u0011\u0004A\u0011I3\t\u000b=\u0004A\u0011\t9\t\u000be\u0004A\u0011\t>\t\u000by\u0004A\u0011K@\t\u0013\u0005\u0015\u0001!!A\u0005\u0002\u0005\u001d\u0001\"CA\u0006\u0001E\u0005I\u0011AA\u0007\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)\u0003C\u0005\u00026\u0001\t\t\u0011\"\u0001\u00028!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u001b\u0002\u0011\u0011!C!\u0003\u001fB\u0011\"!\u0018\u0001\u0003\u0003%\t!a\u0018\t\u0013\u0005%\u0004!!A\u0005B\u0005-\u0004\"CA8\u0001\u0005\u0005I\u0011IA9\u000f%\t)*HA\u0001\u0012\u0003\t9J\u0002\u0005\u001d;\u0005\u0005\t\u0012AAM\u0011\u0019\u0001f\u0003\"\u0001\u00022\"I\u00111\u0017\f\u0002\u0002\u0013\u0015\u0013Q\u0017\u0005\n\u0003o3\u0012\u0011!CA\u0003sC\u0011\"!0\u0017\u0003\u0003%\t)a0\t\u0013\u0005-g#!A\u0005\n\u00055'\u0001D!se\u0006L8i\\7qC\u000e$(B\u0001\u0010 \u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\n\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001YsF\r\u001d<\u0003B\u0011A&L\u0007\u0002;%\u0011a&\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00171\u0013\t\tTD\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007cA\u001a7W5\tAG\u0003\u00026?\u0005)AO]3fg&\u0011q\u0007\u000e\u0002\n+:\f'/\u001f'jW\u0016\u0004\"\u0001L\u001d\n\u0005ij\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011!I\u0013\b\u0003\u0007\"s!\u0001R$\u000e\u0003\u0015S!AR\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014BA%>\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0013'\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005%k\u0014!B2iS2$W#A\u0016\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011!k\u0015\t\u0003Y\u0001AQ!T\u0002A\u0002-\n\u0011\"[:O_RtU\u000f\u001c7\u0016\u0003Y\u0003B\u0001P,,W%\u0011\u0001,\u0010\u0002\n\rVt7\r^5p]F\n!\u0001\u001c<\u0016\u0003m\u0003\"\u0001\f/\n\u0005uk\"a\u0005(b[\u0016$G*Y7cI\u00064\u0016M]5bE2,\u0017A\u00027b[\n$\u0017-F\u0001a!\ta\u0013-\u0003\u0002c;\tqA*Y7cI\u00064UO\\2uS>t\u0017a\u0003:fa2\f7-Z7f]R\f!\"\u001b8qkR$\u0016\u0010]3t+\u00051\u0007c\u0001\"hS&\u0011\u0001\u000e\u0014\u0002\u0004'\u0016\f\bC\u00016n\u001b\u0005Y'B\u00017\"\u0003\u0015!\u0018\u0010]3t\u0013\tq7N\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003E\u0004\"A\u001d<\u000f\u0005M$\bC\u0001#>\u0013\t)X(\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;>\u0003!!\u0017\r^1UsB,W#A>\u0011\u0005)d\u0018BA?l\u0005%\t%O]1z)f\u0004X-\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004%\u0006\u0005\u0001BBA\u0002\u0017\u0001\u00071&\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007I\u000bI\u0001C\u0004N\u0019A\u0005\t\u0019A\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0002\u0016\u0004W\u0005E1FAA\n!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uQ(\u0001\u0006b]:|G/\u0019;j_:LA!!\t\u0002\u0018\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0003\u0005\u0003\u0002*\u0005MRBAA\u0016\u0015\u0011\ti#a\f\u0002\t1\fgn\u001a\u0006\u0003\u0003c\tAA[1wC&\u0019q/a\u000b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005e\u0002c\u0001\u001f\u0002<%\u0019\u0011QH\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0013\u0011\n\t\u0004y\u0005\u0015\u0013bAA${\t\u0019\u0011I\\=\t\u0013\u0005-\u0003#!AA\u0002\u0005e\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002RA1\u00111KA-\u0003\u0007j!!!\u0016\u000b\u0007\u0005]S(\u0001\u0006d_2dWm\u0019;j_:LA!a\u0017\u0002V\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t'a\u001a\u0011\u0007q\n\u0019'C\u0002\u0002fu\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002LI\t\t\u00111\u0001\u0002D\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9#!\u001c\t\u0013\u0005-3#!AA\u0002\u0005e\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002b\u0005M\u0004\"CA&)\u0005\u0005\t\u0019AA\"QM\u0001\u0011qOA?\u0003\u007f\n\u0019)!\"\u0002\n\u0006-\u0015qRAI!\ra\u0013\u0011P\u0005\u0004\u0003wj\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0003\u000b1g\u0018$V\u001d\u000e{\u0006&\u0019:sCfL\u0003%\f\u0011SK6|g/Z:!]VdG\u000e\t<bYV,7\u000f\t4s_6\u0004C\u000f[3!CJ\u0014\u0018-\u001f\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\"\u0002\u0003?Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001aD\u0006\t8vY2L\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1\u0012DfM/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)E\u0005\u0014C\u0006\t\u0012cE1\u0002#e\u0019\u0012*SmR\u0001\u0005\t\u0011!A\u0001\u00023LI1#Y\t\u0012'\u0005\f\u0012dEuS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001b\u000b1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u00111S\u0001\u0006g9\"d\u0006M\u0001\r\u0003J\u0014\u0018-_\"p[B\f7\r\u001e\t\u0003YY\u0019RAFAN\u0003O\u0003b!!(\u0002$.\u0012VBAAP\u0015\r\t\t+P\u0001\beVtG/[7f\u0013\u0011\t)+a(\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002*\u0006=VBAAV\u0015\u0011\ti+a\f\u0002\u0005%|\u0017bA&\u0002,R\u0011\u0011qS\u0001\ti>\u001cFO]5oOR\u0011\u0011qE\u0001\u0006CB\u0004H.\u001f\u000b\u0004%\u0006m\u0006\"B'\u001a\u0001\u0004Y\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0003\f9\r\u0005\u0003=\u0003\u0007\\\u0013bAAc{\t1q\n\u001d;j_:D\u0001\"!3\u001b\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAh!\u0011\tI#!5\n\t\u0005M\u00171\u0006\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayCompact
extends Expression
implements RuntimeReplaceable,
UnaryLike<Expression>,
ImplicitCastInputTypes,
Serializable {
    private Function1<Expression, Expression> isNotNull;
    private NamedLambdaVariable lv;
    private LambdaFunction lambda;
    private Expression replacement;
    private final Expression child;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(ArrayCompact x$0) {
        return ArrayCompact$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArrayCompact, A> g) {
        return ArrayCompact$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ArrayCompact> compose(Function1<A$, Expression> g) {
        return ArrayCompact$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    private Function1<Expression, Expression> isNotNull$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.isNotNull = (Function1 & Serializable)x -> new IsNotNull((Expression)x);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.isNotNull;
    }

    public Function1<Expression, Expression> isNotNull() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.isNotNull$lzycompute();
        }
        return this.isNotNull;
    }

    private NamedLambdaVariable lv$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.lv = new NamedLambdaVariable("arg", ((ArrayType)this.child().dataType()).elementType(), true, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.lv;
    }

    public NamedLambdaVariable lv() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.lv$lzycompute();
        }
        return this.lv;
    }

    private LambdaFunction lambda$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lambda = new LambdaFunction((Expression)this.isNotNull().apply((Object)this.lv()), (Seq<NamedExpression>)new .colon.colon((Object)this.lv(), (List)Nil$.MODULE$), LambdaFunction$.MODULE$.apply$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lambda;
    }

    public LambdaFunction lambda() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.lambda$lzycompute();
        }
        return this.lambda;
    }

    private Expression replacement$lzycompute() {
        ArrayCompact arrayCompact = this;
        synchronized (arrayCompact) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.replacement = new ArrayFilter(this.child(), this.lambda());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public String prettyName() {
        return "array_compact";
    }

    public ArrayType dataType() {
        ArrayType qual$1 = (ArrayType)this.child().dataType();
        boolean x$1 = false;
        DataType x$2 = qual$1.copy$default$1();
        return qual$1.copy(x$2, false);
    }

    @Override
    public ArrayCompact withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public ArrayCompact copy(Expression child) {
        return new ArrayCompact(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArrayCompact";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayCompact;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayCompact)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayCompact arrayCompact = (ArrayCompact)x$1;
        Expression expression = this.child();
        Expression expression2 = arrayCompact.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arrayCompact.canEqual(this)) return false;
        return true;
    }

    public ArrayCompact(Expression child) {
        this.child = child;
        RuntimeReplaceable.$init$(this);
        UnaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

