/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.SQLOrderingUtil;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;

public class ArrayExpressionUtils {
    private static final Comparator<Object> booleanComp = (o1, o2) -> {
        boolean c2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        boolean c1 = (Boolean)o1;
        return c1 == (c2 = ((Boolean)o2).booleanValue()) ? 0 : (c1 ? 1 : -1);
    };
    private static final Comparator<Object> byteComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        byte c1 = (Byte)o1;
        byte c2 = (Byte)o2;
        return Byte.compare(c1, c2);
    };
    private static final Comparator<Object> shortComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        short c1 = (Short)o1;
        short c2 = (Short)o2;
        return Short.compare(c1, c2);
    };
    private static final Comparator<Object> integerComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int c1 = (Integer)o1;
        int c2 = (Integer)o2;
        return Integer.compare(c1, c2);
    };
    private static final Comparator<Object> longComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        long c1 = (Long)o1;
        long c2 = (Long)o2;
        return Long.compare(c1, c2);
    };
    private static final Comparator<Object> floatComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        float c1 = ((Float)o1).floatValue();
        float c2 = ((Float)o2).floatValue();
        return SQLOrderingUtil.compareFloats(c1, c2);
    };
    private static final Comparator<Object> doubleComp = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        double c1 = (Double)o1;
        double c2 = (Double)o2;
        return SQLOrderingUtil.compareDoubles(c1, c2);
    };

    public static int binarySearchNullSafe(ArrayData data, Boolean value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)BooleanType$.MODULE$), value, booleanComp);
    }

    public static int binarySearch(ArrayData data, byte value) {
        return Arrays.binarySearch(data.toByteArray(), value);
    }

    public static int binarySearchNullSafe(ArrayData data, Byte value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)ByteType$.MODULE$), value, byteComp);
    }

    public static int binarySearch(ArrayData data, short value) {
        return Arrays.binarySearch(data.toShortArray(), value);
    }

    public static int binarySearchNullSafe(ArrayData data, Short value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)ShortType$.MODULE$), value, shortComp);
    }

    public static int binarySearch(ArrayData data, int value) {
        return Arrays.binarySearch(data.toIntArray(), value);
    }

    public static int binarySearchNullSafe(ArrayData data, Integer value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)IntegerType$.MODULE$), value, integerComp);
    }

    public static int binarySearch(ArrayData data, long value) {
        return Arrays.binarySearch(data.toLongArray(), value);
    }

    public static int binarySearchNullSafe(ArrayData data, Long value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)LongType$.MODULE$), value, longComp);
    }

    public static int binarySearch(ArrayData data, float value) {
        return Arrays.binarySearch(data.toFloatArray(), value);
    }

    public static int binarySearchNullSafe(ArrayData data, Float value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)FloatType$.MODULE$), value, floatComp);
    }

    public static int binarySearch(ArrayData data, double value) {
        return Arrays.binarySearch(data.toDoubleArray(), value);
    }

    public static int binarySearchNullSafe(ArrayData data, Double value) {
        return Arrays.binarySearch(data.toObjectArray((DataType)DoubleType$.MODULE$), value, doubleComp);
    }

    public static int binarySearch(DataType elementType, Comparator<Object> comp, ArrayData data, Object value) {
        Object[] array = data.toObjectArray(elementType);
        return Arrays.binarySearch(array, value, comp);
    }
}

