/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first matching element of\n      the array as long, or 0 if no match is found.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(312, 773, 708, 708), 708);\n       3\n      > SELECT _FUNC_(array(312, 773, 708, 708), 414);\n       0\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001B\u0010!\u00016B\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0001]\u0011!\u0001\u0007\u0001#b\u0001\n\u0013\t\u0007\"\u00027\u0001\t\u0003j\u0007\"\u0002;\u0001\t\u0003*\b\"\u0002?\u0001\t\u0003j\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\tI\u0003\u0001C!\u0003WAq!a\u0012\u0001\t#\nI\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u00111\f\u0001\u0012\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003g\u0002\u0011\u0013!C\u0001\u0003;B\u0011\"!\u001e\u0001\u0003\u0003%\t%a\u001e\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAI\u0001\u0005\u0005I\u0011AAJ\u0011%\tI\nAA\u0001\n\u0003\nY\nC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0013q\u0017\u0005\n\u0003w\u0003\u0011\u0011!C!\u0003{;\u0011\"!9!\u0003\u0003E\t!a9\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0003KDaaW\r\u0005\u0002\u0005u\b\"CA\u00003\u0005\u0005IQ\tB\u0001\u0011%\u0011\u0019!GA\u0001\n\u0003\u0013)\u0001C\u0005\u0003\fe\t\t\u0011\"!\u0003\u000e!I!qD\r\u0002\u0002\u0013%!\u0011\u0005\u0002\u000e\u0003J\u0014\u0018-\u001f)pg&$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013aC3yaJ,7o]5p]NT!a\t\u0013\u0002\u0011\r\fG/\u00197zgRT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0007\u0001\u0019r\u0001\u0001\u00183kq\u0012\u0005\n\u0005\u00020a5\t\u0001%\u0003\u00022A\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003_MJ!\u0001\u000e\u0011\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AN\u001d\u000f\u0005=:\u0014B\u0001\u001d!\u0003\u001d\u0001\u0018mY6bO\u0016L!AO\u001e\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011\u0001\b\t\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0011\na!\u001a:s_J\u001c\u0018BA!?\u0005=\tV/\u001a:z\u000bJ\u0014xN]:CCN,\u0007CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013Bs!AS(\u000f\u0005-sU\"\u0001'\u000b\u00055c\u0013A\u0002\u001fs_>$h(C\u0001F\u0013\tAD)\u0003\u0002R%\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001\bR\u0001\u0005Y\u00164G/F\u0001V!\tyc+\u0003\u0002XA\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019QLX0\u0011\u0005=\u0002\u0001\"B*\u0006\u0001\u0004)\u0006\"B-\u0006\u0001\u0004)\u0016\u0001C8sI\u0016\u0014\u0018N\\4\u0016\u0003\t\u00042!S2f\u0013\t!'K\u0001\u0005Pe\u0012,'/\u001b8h!\t\u0019e-\u0003\u0002h\t\n\u0019\u0011I\\=)\u0005\u0019I\u0007CA\"k\u0013\tYGIA\u0005ue\u0006t7/[3oi\u0006AA-\u0019;b)f\u0004X-F\u0001o!\ty'/D\u0001q\u0015\t\tH%A\u0003usB,7/\u0003\u0002ta\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001e\t\u0004\u0013^L\u0018B\u0001=S\u0005\r\u0019V-\u001d\t\u0003_jL!a\u001f9\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#\u0001@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0012\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u0002\u0002\u0002\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0003f\u0003\u001b\t\t\u0002\u0003\u0004\u0002\u0010)\u0001\r!Z\u0001\u0004CJ\u0014\bBBA\n\u0015\u0001\u0007Q-A\u0003wC2,X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0007\u0011\t\u0005m\u00111\u0005\b\u0005\u0003;\ty\u0002\u0005\u0002L\t&\u0019\u0011\u0011\u0005#\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#a\n\u0003\rM#(/\u001b8h\u0015\r\t\t\u0003R\u0001\nI><UM\\\"pI\u0016$b!!\f\u0002:\u0005\r\u0003\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005M\u0002%A\u0004d_\u0012,w-\u001a8\n\t\u0005]\u0012\u0011\u0007\u0002\t\u000bb\u0004(oQ8eK\"9\u00111\b\u0007A\u0002\u0005u\u0012aA2uqB!\u0011qFA \u0013\u0011\t\t%!\r\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011Q\t\u0007A\u0002\u00055\u0012AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003^\u0003\u0017\ny\u0005\u0003\u0004\u0002N5\u0001\r!V\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\t&\u0004a\u0001+\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#B/\u0002X\u0005e\u0003bB*\u000f!\u0003\u0005\r!\u0016\u0005\b3:\u0001\n\u00111\u0001V\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0018+\u0007U\u000b\tg\u000b\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!C;oG\",7m[3e\u0015\r\ti\u0007R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA9\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA=!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000bA\u0001\\1oO*\u0011\u00111Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005u\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAAF!\r\u0019\u0015QR\u0005\u0004\u0003\u001f#%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA3\u0002\u0016\"I\u0011qS\n\u0002\u0002\u0003\u0007\u00111R\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005u\u0005#BAP\u0003K+WBAAQ\u0015\r\t\u0019\u000bR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAT\u0003C\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011QVAZ!\r\u0019\u0015qV\u0005\u0004\u0003c#%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003/+\u0012\u0011!a\u0001K\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tI(!/\t\u0013\u0005]e#!AA\u0002\u0005-\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002.\u0006}\u0006\u0002CAL/\u0005\u0005\t\u0019A3)'\u0001\t\u0019-!3\u0002L\u0006=\u0017\u0011[Ak\u0003/\fY.!8\u0011\u0007=\n)-C\u0002\u0002H\u0002\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002N\u0006\t\u0019C\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1zY\u0001*G.Z7f]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005K\u0019.E\u0006\u001cX\rZ\u0015!S:$W\r\u001f\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI7bi\u000eD\u0017N\\4!K2,W.\u001a8uA=4'\u0002\t\u0011!A\u0001\u0002C\u000f[3!CJ\u0014\u0018-\u001f\u0011bg\u0002bwN\\4-A=\u0014\b\u0005\r\u0011jM\u0002rw\u000eI7bi\u000eD\u0007%[:!M>,h\u000e\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003'\f\u00111\u0005\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00154cIb\u0003eN\u001c4Y\u0001:\u0004\u0007\u000f\u0017!oAB\u0014\u0006\f\u00118aaJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)gE\u0012D\u0006I\u001c8g1\u0002s\u0007\r\u001d-A]\u0002\u0004(\u000b\u0017!iE\"\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAm\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005}\u0017!\u0002\u001a/i9\u0002\u0014!D!se\u0006L\bk\\:ji&|g\u000e\u0005\u000203M)\u0011$a:\u0002tB9\u0011\u0011^Ax+VkVBAAv\u0015\r\ti\u000fR\u0001\beVtG/[7f\u0013\u0011\t\t0a;\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002v\u0006mXBAA|\u0015\u0011\tI0!!\u0002\u0005%|\u0017bA)\u0002xR\u0011\u00111]\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011P\u0001\u0006CB\u0004H.\u001f\u000b\u0006;\n\u001d!\u0011\u0002\u0005\u0006'r\u0001\r!\u0016\u0005\u00063r\u0001\r!V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yAa\u0007\u0011\u000b\r\u0013\tB!\u0006\n\u0007\tMAI\u0001\u0004PaRLwN\u001c\t\u0006\u0007\n]Q+V\u0005\u0004\u00053!%A\u0002+va2,'\u0007\u0003\u0005\u0003\u001eu\t\t\u00111\u0001^\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005G\u0001B!a\u001f\u0003&%!!qEA?\u0005\u0019y%M[3di\u0002")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
QueryErrorsBase,
Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition x$0) {
        return ArrayPosition$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if (!this.bitmap$trans$0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType e1 = arrayType.elementType();
                boolean hasNull = arrayType.containsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return new .colon.colon((Object)new ArrayType(dt, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType t;
        DataType dataType;
        DataType dataType2;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null && NullType$.MODULE$.equals(dataType2 = (DataType)tuple2._1()) ? true : tuple2 != null && NullType$.MODULE$.equals(dataType = (DataType)tuple2._2())) {
            return new TypeCheckResult.DataTypeMismatch("NULL_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName()))}))));
        }
        if (tuple2 != null && !ArrayType$.MODULE$.acceptsType(t = (DataType)tuple2._1())) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
        }
        if (tuple2 != null) {
            ArrayType arrayType;
            DataType e1;
            DataType dataType3 = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType3 instanceof ArrayType && DataTypeUtils$.MODULE$.sameType(e1 = (arrayType = (ArrayType)dataType3).elementType(), e2)) {
                return TypeUtils$.MODULE$.checkForOrderingExpr(e2, this.prettyName());
            }
        }
        return new TypeCheckResult.DataTypeMismatch("ARRAY_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object object;
        Object object2 = new Object();
        try {
            ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(i, v) -> {
                ArrayPosition.$anonfun$nullSafeEval$8(this, value, object2, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            object = BoxesRunTime.boxToLong((long)0L);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(arr, value) -> {
            String pos = ctx.freshName("arrayPosition");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.right().dataType(), i);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |int " + pos + " = 0;\n         |for (int " + i + " = 0; " + i + " < " + arr + ".numElements(); " + i + " ++) {\n         |  if (!" + arr + ".isNullAt(" + i + ") && " + ctx.genEqual(this.right().dataType(), (String)value, getValue) + ") {\n         |    " + pos + " = " + i + " + 1;\n         |    break;\n         |  }\n         |}\n         |" + ev.value() + " = (long) " + pos + ";\n       "));
        });
    }

    @Override
    public ArrayPosition withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$8(ArrayPosition $this, Object value$2, Object nonLocalReturnKey4$1, int i, Object v) {
        if (v != null && $this.ordering().equiv(v, value$2)) {
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey4$1, (long)(i + 1));
        }
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

