/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.CallMethodViaReflection$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.ArrayImplicits$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(class, method[, arg1[, arg2 ..]]) - Calls a method with reflection.", examples="\n    Examples:\n      > SELECT _FUNC_('java.util.UUID', 'randomUUID');\n       c33fb387-8500-4bfa-81d2-6e0e3e930df2\n      > SELECT _FUNC_('java.util.UUID', 'fromString', 'a5cf6c42-0c85-418f-af6c-3e4e5b1328f2');\n       a5cf6c42-0c85-418f-af6c-3e4e5b1328f2\n  ", since="2.0.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001B\u0016-\u0001fB\u0001b\u0018\u0001\u0003\u0016\u0004%\t\u0001\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005C\"AQ\r\u0001BK\u0002\u0013\u0005a\r\u0003\u0005k\u0001\tE\t\u0015!\u0003h\u0011\u0015Y\u0007\u0001\"\u0001m\u0011\u0015Y\u0007\u0001\"\u0001q\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015a\b\u0001\"\u0011~\u0011\u0019\tI\u0001\u0001C!M\"I\u00111\u0002\u0001C\u0002\u0013\u0005\u0013Q\u0002\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0010!9\u0011Q\u0004\u0001\u0005R\u0005}\u0001bBA\u0019\u0001\u0011E\u00131\u0007\u0005\u000b\u0003\u000f\u0002\u0001R1A\u0005\n\u0005%\u0003BCA-\u0001!\u0015\r\u0011\"\u0003\u0002\\!I\u0011Q\u000e\u0001\t\u0006\u0004%IA\u001a\u0005\u000b\u0003c\u0002\u0001R1A\u0005\n\u0005m\u0003BCA;\u0001!\u0015\r\u0011\"\u0001\u0002x!Q\u0011q\u0011\u0001\t\u0006\u0004%I!!#\t\u000f\u0005U\u0005\u0001\"\u0015\u0002\u0018\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003W\u0003\u0011\u0013!C\u0001\u0003[C\u0011\"a1\u0001#\u0003%\t!!2\t\u0013\u0005%\u0007!!A\u0005B\u0005m\u0003\"CAf\u0001\u0005\u0005I\u0011AAg\u0011%\ty\rAA\u0001\n\u0003\t\t\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\"I\u0011q\u001d\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003[\u0004\u0011\u0011!C!\u0003_D\u0011\"a=\u0001\u0003\u0003%\t%!>\b\u000f\teA\u0006#\u0001\u0003\u001c\u001911\u0006\fE\u0001\u0005;Aaa\u001b\u0011\u0005\u0002\t=\u0002\"\u0003B\u0019A\t\u0007I\u0011\u0001B\u001a\u0011!\u0011)\u0006\tQ\u0001\n\tU\u0002bBA7A\u0011%!q\f\u0005\b\u0005G\u0002C\u0011\u0001B3\u0011%\u00119\bIA\u0001\n\u0003\u0013I\bC\u0005\u0003\u0000\u0001\n\n\u0011\"\u0001\u0002F\"I!\u0011\u0011\u0011\u0002\u0002\u0013\u0005%1\u0011\u0005\n\u0005#\u0003\u0013\u0013!C\u0001\u0003\u000bD\u0011Ba%!\u0003\u0003%IA!&\u0003/\r\u000bG\u000e\\'fi\"|GMV5b%\u00164G.Z2uS>t'BA\u0017/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005=\u0002\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001Qd(Q$N'B\u00111\bP\u0007\u0002Y%\u0011Q\b\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u001e@\u0013\t\u0001EF\u0001\tO_:$W\r^3s[&t\u0017n\u001d;jGB\u0011!)R\u0007\u0002\u0007*\u0011A\tL\u0001\bG>$WmZ3o\u0013\t15IA\bD_\u0012,w-\u001a8GC2d'-Y2l!\tA5*D\u0001J\u0015\tQ\u0005'\u0001\u0004feJ|'o]\u0005\u0003\u0019&\u0013q\"U;fef,%O]8sg\n\u000b7/\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0002!\u0006)1oY1mC&\u0011!k\u0014\u0002\b!J|G-^2u!\t!FL\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001\fO\u0001\u0007yI|w\u000e\u001e \n\u0003AK!aW(\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u00037>\u000b\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002CB\u0019AK\u0019\u001e\n\u0005\rt&aA*fc\u0006I1\r[5mIJ,g\u000eI\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001h!\tq\u0005.\u0003\u0002j\u001f\n9!i\\8mK\u0006t\u0017\u0001\u00044bS2|e.\u0012:s_J\u0004\u0013A\u0002\u001fj]&$h\bF\u0002n]>\u0004\"a\u000f\u0001\t\u000b}+\u0001\u0019A1\t\u000f\u0015,\u0001\u0013!a\u0001OR\u0011Q.\u001d\u0005\u0006?\u001a\u0001\r!Y\u0001\u000baJ,G\u000f^=OC6,W#\u0001;\u0011\u0005ULhB\u0001<x!\t1v*\u0003\u0002y\u001f\u00061\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tAx*A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001/\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA\u0004\u0003\u0003\u0011q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\t]VdG.\u00192mK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016A\nQ\u0001^=qKNLA!!\u0007\u0002\u0014\tAA)\u0019;b)f\u0004X-A\u0005eCR\fG+\u001f9fA\u0005\u0011\u0012N\\5uS\u0006d\u0017N_3J]R,'O\\1m)\u0011\t\t#a\n\u0011\u00079\u000b\u0019#C\u0002\u0002&=\u0013A!\u00168ji\"9\u0011\u0011\u0006\u0007A\u0002\u0005-\u0012A\u00049beRLG/[8o\u0013:$W\r\u001f\t\u0004\u001d\u00065\u0012bAA\u0018\u001f\n\u0019\u0011J\u001c;\u0002\u0019\u00154\u0018\r\\%oi\u0016\u0014h.\u00197\u0015\t\u0005U\u00121\b\t\u0004\u001d\u0006]\u0012bAA\u001d\u001f\n\u0019\u0011I\\=\t\u000f\u0005uR\u00021\u0001\u0002@\u0005)\u0011N\u001c9viB!\u0011\u0011IA\"\u001b\u0005q\u0013bAA#]\tY\u0011J\u001c;fe:\fGNU8x\u0003!\t'oZ#yaJ\u001cXCAA&!\u0011q\u0015Q\n\u001e\n\u0007\u0005=sJA\u0003BeJ\f\u0017\u0010K\u0002\u000f\u0003'\u00022ATA+\u0013\r\t9f\u0014\u0002\niJ\fgn]5f]R\f\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\u0005u\u0003\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\u0005Y\u0006twM\u0003\u0002\u0002h\u0005!!.\u0019<b\u0013\rQ\u0018\u0011\r\u0015\u0004\u001f\u0005M\u0013aC2mCN\u001cX\t_5tiND3\u0001EA*\u0003)iW\r\u001e5pI:\u000bW.\u001a\u0015\u0004#\u0005M\u0013AB7fi\"|G-\u0006\u0002\u0002zA!\u00111PAA\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0014a\u0002:fM2,7\r^\u0005\u0005\u0003\u0007\u000biH\u0001\u0004NKRDw\u000e\u001a\u0015\u0004%\u0005M\u0013A\u00022vM\u001a,'/\u0006\u0002\u0002\fB)a*!\u0014\u0002\u000eB!\u0011qLAH\u0013\u0011\t\t*!\u0019\u0003\r=\u0013'.Z2uQ\r\u0019\u00121K\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$2!\\AM\u0011\u001d\tY\n\u0006a\u0001\u0003;\u000b1B\\3x\u0007\"LG\u000e\u001a:f]B!A+a(;\u0013\r\t\tK\u0018\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018\u0001B2paf$R!\\AT\u0003SCqaX\u000b\u0011\u0002\u0003\u0007\u0011\rC\u0004f+A\u0005\t\u0019A4\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0016\u0016\u0004C\u0006E6FAAZ!\u0011\t),a0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005uv*\u0001\u0006b]:|G/\u0019;j_:LA!!1\u00028\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0019\u0016\u0004O\u0006E\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001b\u0003'D\u0011\"!6\u001b\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u000e\u0005\u0004\u0002^\u0006\r\u0018QG\u0007\u0003\u0003?T1!!9P\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\fyN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA4\u0002l\"I\u0011Q\u001b\u000f\u0002\u0002\u0003\u0007\u0011QG\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002^\u0005E\b\"CAk;\u0005\u0005\t\u0019AA\u0016\u0003\u0019)\u0017/^1mgR\u0019q-a>\t\u0013\u0005Ug$!AA\u0002\u0005U\u0002f\u0005\u0001\u0002|\n\u0005!1\u0001B\u0004\u0005\u0013\u0011iAa\u0004\u0003\u0014\tU\u0001cA\u001e\u0002~&\u0019\u0011q \u0017\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QA\u0001K?\u001a+fjQ0)G2\f7o\u001d\u0017![\u0016$\bn\u001c3\\Y\u0001\n'oZ\u0019\\Y\u0001\n'o\u001a\u001a!]9jV,\u000b\u0011.A\r\u000bG\u000e\\:!C\u0002jW\r\u001e5pI\u0002:\u0018\u000e\u001e5!e\u00164G.Z2uS>tg&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011Y!AA\u0000\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":#.\u0019<b]U$\u0018\u000e\u001c\u0018V+&#u\u0005\f\u0011(e\u0006tGm\\7V+&#u%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!GN\u001adMY\u001a9o5BT\u0007\r\u0019.i\t4\u0017-\f\u001d2IJjc'\u001a\u0019fg\u0015L4\u0007\r3ge)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CsE[1wC:*H/\u001b7/+VKEi\n\u0017!O\u0019\u0014x.\\*ue&twm\n\u0017!O\u0005,4M\u001a\u001cdiIj\u0003g\u0019\u001d6[Q\n\u0004HZ\u0017bMZ\u001aWfM35KV\u0012\u0017g\r\u001a9MJ:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011bk\r4gg\u0019\u001b3[A\u001a\u0007(N\u00175ca2W&\u001947G6\u001aT\rN36EF\u001a$\u0007\u000f43\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\t\u0003\u0015\u0011d\u0006\r\u00181\u0003\u00159'o\\;qC\t\u00119\"\u0001\u0006nSN\u001cwLZ;oGN\fqcQ1mY6+G\u000f[8e-&\f'+\u001a4mK\u000e$\u0018n\u001c8\u0011\u0005m\u00023#\u0002\u0011\u0003 \t\u0015\u0002c\u0001(\u0003\"%\u0019!1E(\u0003\r\u0005s\u0017PU3g!\u0011\u00119C!\f\u000e\u0005\t%\"\u0002\u0002B\u0016\u0003K\n!![8\n\u0007u\u0013I\u0003\u0006\u0002\u0003\u001c\u0005YA/\u001f9f\u001b\u0006\u0004\b/\u001b8h+\t\u0011)\u0004\u0005\u0005\u00038\tu\u0012q\u0002B!\u001b\t\u0011ID\u0003\u0003\u0003<\u0005}\u0017!C5n[V$\u0018M\u00197f\u0013\u0011\u0011yD!\u000f\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u00038\t\r#QI\u0005\u0004G\ne\u0002\u0007\u0002B$\u0005#\u0002b!a\u0018\u0003J\t5\u0013\u0002\u0002B&\u0003C\u0012Qa\u00117bgN\u0004BAa\u0014\u0003R1\u0001Aa\u0003B*G\u0005\u0005\t\u0011!B\u0001\u0005/\u00121a\u0018\u00132\u00031!\u0018\u0010]3NCB\u0004\u0018N\\4!#\u0011\u0011I&!\u000e\u0011\u00079\u0013Y&C\u0002\u0003^=\u0013qAT8uQ&tw\rF\u0002h\u0005CBa!!\u0017%\u0001\u0004!\u0018A\u00034j]\u0012lU\r\u001e5pIRA!q\rB7\u0005_\u0012\t\bE\u0003O\u0005S\nI(C\u0002\u0003l=\u0013aa\u00149uS>t\u0007BBA-K\u0001\u0007A\u000f\u0003\u0004\u0002r\u0015\u0002\r\u0001\u001e\u0005\b\u0005g*\u0003\u0019\u0001B;\u0003!\t'o\u001a+za\u0016\u001c\b\u0003\u0002+c\u0003\u001f\tQ!\u00199qYf$R!\u001cB>\u0005{BQa\u0018\u0014A\u0002\u0005Dq!\u001a\u0014\u0011\u0002\u0003\u0007q-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BA!\"\u0003\u000eB)aJ!\u001b\u0003\bB)aJ!#bO&\u0019!1R(\u0003\rQ+\b\u000f\\33\u0011!\u0011y\tKA\u0001\u0002\u0004i\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!$")
public class CallMethodViaReflection
extends Expression
implements Nondeterministic,
CodegenFallback,
QueryErrorsBase,
Serializable {
    private transient Expression[] argExprs;
    private transient String className;
    private transient boolean classExists;
    private transient String methodName;
    private transient Method method;
    private transient Object[] buffer;
    private final Seq<Expression> children;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return CallMethodViaReflection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CallMethodViaReflection x$0) {
        return CallMethodViaReflection$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return CallMethodViaReflection$.MODULE$.apply$default$2();
    }

    public static Option<Method> findMethod(String className, String methodName, Seq<DataType> argTypes) {
        return CallMethodViaReflection$.MODULE$.findMethod(className, methodName, argTypes);
    }

    public static Map<DataType, Seq<Class<?>>> typeMapping() {
        return CallMethodViaReflection$.MODULE$.typeMapping();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    private boolean deterministic$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "reflect");
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(this.toSQLId(this.prettyName()), (Seq<Object>)new .colon.colon((Object)"> 1", (List)Nil$.MODULE$), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        Option unexpectedParameter = ((IterableOnceOps)this.children().zipWithIndex()).collectFirst((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CallMethodViaReflection $outer;

            public final <A1 extends Tuple2<Expression, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (!(0 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.$outer.toSQLId("class")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringTypeAnyCollation$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().head()))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("class"))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (!(1 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.$outer.toSQLId("method")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)StringTypeAnyCollation$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.$outer.toSQLExpr((Expression)this.$outer.children().apply(1)))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int n = A1._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_NULL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)this.$outer.toSQLId("method"))}))));
                    }
                }
                if (A1 != null) {
                    Expression e = (Expression)A1._1();
                    int idx = A1._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType()) && !(e.dataType() instanceof StringType)) {
                        return (B1)new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.$outer.ordinalNumber(idx)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.$outer.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, StringTypeAnyCollation$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.$outer.toSQLExpr(e)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.$outer.toSQLType((AbstractDataType)e.dataType()))}))));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Expression, Object> x1) {
                Tuple2<Expression, Object> tuple2 = x1;
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (!(0 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (0 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (!(1 != n || e.dataType() instanceof StringType && e.foldable())) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int n = tuple2._2$mcI$sp();
                    if (1 == n && e.eval(e.eval$default$1()) == null) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    Expression e = (Expression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (idx > 1 && !CallMethodViaReflection$.MODULE$.typeMapping().contains((Object)e.dataType()) && !(e.dataType() instanceof StringType)) {
                        return true;
                    }
                }
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option option = unexpectedParameter;
        if (option instanceof Some) {
            Some some = (Some)option;
            TypeCheckResult.DataTypeMismatch mismatch = (TypeCheckResult.DataTypeMismatch)some.value();
            return mismatch;
        }
        if (!this.classExists()) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_CLASS_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())}))));
        }
        if (this.method() == null) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_STATIC_METHOD", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"methodName"), (Object)this.methodName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)this.className())}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
    }

    @Override
    public Object evalInternal(InternalRow input) {
        UTF8String uTF8String;
        for (int i = 0; i < this.argExprs().length; ++i) {
            this.buffer()[i] = this.argExprs()[i].eval(input);
            if (!(this.buffer()[i] instanceof UTF8String)) continue;
            this.buffer()[i] = this.buffer()[i].toString();
        }
        try {
            Object ret = this.method().invoke(null, this.buffer());
            uTF8String = UTF8String.fromString((String)String.valueOf(ret));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty() && !this.failOnError()) {
                uTF8String = null;
            }
            throw throwable;
        }
        return uTF8String;
    }

    private Expression[] argExprs$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.argExprs = (Expression[])((IterableOnceOps)this.children().drop(2)).toArray(ClassTag$.MODULE$.apply(Expression.class));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.argExprs;
    }

    private Expression[] argExprs() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.argExprs$lzycompute();
        }
        return this.argExprs;
    }

    private String className$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Expression qual$1 = (Expression)this.children().apply(0);
                InternalRow x$1 = qual$1.eval$default$1();
                this.className = ((UTF8String)qual$1.eval(x$1)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.className;
    }

    private String className() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.className$lzycompute();
        }
        return this.className;
    }

    private boolean classExists$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.classExists = CallMethodViaReflection$.MODULE$.org$apache$spark$sql$catalyst$expressions$CallMethodViaReflection$$classExists(this.className());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.classExists;
    }

    private boolean classExists() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.classExists$lzycompute();
        }
        return this.classExists;
    }

    private String methodName$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.methodName = ((UTF8String)((Expression)this.children().apply(1)).eval(null)).toString();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.methodName;
    }

    private String methodName() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.methodName$lzycompute();
        }
        return this.methodName;
    }

    private Method method$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.method = (Method)CallMethodViaReflection$.MODULE$.findMethod(this.className(), this.methodName(), (Seq<DataType>)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.argExprs()), (Function1 & Serializable)x$1 -> x$1.dataType(), ClassTag$.MODULE$.apply(DataType.class))).toImmutableArraySeq()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.method;
    }

    public Method method() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.method$lzycompute();
        }
        return this.method;
    }

    private Object[] buffer$lzycompute() {
        CallMethodViaReflection callMethodViaReflection = this;
        synchronized (callMethodViaReflection) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                this.buffer = new Object[this.argExprs().length];
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.buffer;
    }

    private Object[] buffer() {
        if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
            return this.buffer$lzycompute();
        }
        return this.buffer;
    }

    @Override
    public CallMethodViaReflection withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public CallMethodViaReflection copy(Seq<Expression> children2, boolean failOnError) {
        return new CallMethodViaReflection(children2, failOnError);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "CallMethodViaReflection";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CallMethodViaReflection;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CallMethodViaReflection)) return false;
        boolean bl = true;
        if (!bl) return false;
        CallMethodViaReflection callMethodViaReflection = (CallMethodViaReflection)x$1;
        if (this.failOnError() != callMethodViaReflection.failOnError()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = callMethodViaReflection.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!callMethodViaReflection.canEqual(this)) return false;
        return true;
    }

    public CallMethodViaReflection(Seq<Expression> children2, boolean failOnError) {
        this.children = children2;
        this.failOnError = failOnError;
        Nondeterministic.$init$(this);
        CodegenFallback.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.dataType = SQLConf$.MODULE$.get().defaultStringType();
    }

    public CallMethodViaReflection(Seq<Expression> children2) {
        this(children2, true);
    }
}

