/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Collation$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the collation name of a given expression.", arguments="\n    Arguments:\n      * expr - String expression to perform collation on.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n      UTF8_BINARY\n  ", since="4.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001B\f\u0019\u0001\u0016B\u0001B\u0011\u0001\u0003\u0016\u0004%\ta\u0011\u0005\t\u000f\u0002\u0011\t\u0012)A\u0005\t\")\u0001\n\u0001C\u0001\u0013\")A\n\u0001C)\u001b\"A\u0001\u000b\u0001EC\u0002\u0013\u00053\tC\u0003R\u0001\u0011\u0005#\u000bC\u0004]\u0001\u0005\u0005I\u0011A/\t\u000f}\u0003\u0011\u0013!C\u0001A\"91\u000eAA\u0001\n\u0003b\u0007bB;\u0001\u0003\u0003%\tA\u001e\u0005\bu\u0002\t\t\u0011\"\u0001|\u0011%\t\u0019\u0001AA\u0001\n\u0003\n)\u0001C\u0005\u0002\u0014\u0001\t\t\u0011\"\u0001\u0002\u0016!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0005\u0005\n\u0003K\u0001\u0011\u0011!C!\u0003O9\u0011\"!\u0015\u0019\u0003\u0003E\t!a\u0015\u0007\u0011]A\u0012\u0011!E\u0001\u0003+Ba\u0001S\t\u0005\u0002\u00055\u0004\"CA8#\u0005\u0005IQIA9\u0011%\t\u0019(EA\u0001\n\u0003\u000b)\bC\u0005\u0002zE\t\t\u0011\"!\u0002|!I\u0011qQ\t\u0002\u0002\u0013%\u0011\u0011\u0012\u0002\n\u0007>dG.\u0019;j_:T!!\u0007\u000e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00037q\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0019RS\u0006\r\u001c\u0011\u0005\u001dBS\"\u0001\r\n\u0005%B\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u001dZ\u0013B\u0001\u0017\u0019\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005\u001dr\u0013BA\u0018\u0019\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\b!J|G-^2u!\t9tH\u0004\u00029{9\u0011\u0011\bP\u0007\u0002u)\u00111\bJ\u0001\u0007yI|w\u000e\u001e \n\u0003MJ!A\u0010\u001a\u0002\u000fA\f7m[1hK&\u0011\u0001)\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003}I\nQa\u00195jY\u0012,\u0012\u0001\u0012\t\u0003O\u0015K!A\u0012\r\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)[\u0005CA\u0014\u0001\u0011\u0015\u00115\u00011\u0001E\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0011!J\u0014\u0005\u0006\u001f\u0012\u0001\r\u0001R\u0001\t]\u0016<8\t[5mI\u0006Y!/\u001a9mC\u000e,W.\u001a8u\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002'B\u0019q\u0007\u0016,\n\u0005U\u000b%aA*fcB\u0011qKW\u0007\u00021*\u0011\u0011\fH\u0001\u0006if\u0004Xm]\u0005\u00037b\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\t\r|\u0007/\u001f\u000b\u0003\u0015zCqAQ\u0004\u0011\u0002\u0003\u0007A)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003\u0005T#\u0001\u00122,\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\u0013Ut7\r[3dW\u0016$'B\u000153\u0003)\tgN\\8uCRLwN\\\u0005\u0003U\u0016\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\tQ\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u0006!A.\u00198h\u0015\u0005\u0011\u0018\u0001\u00026bm\u0006L!\u0001^8\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u00059\bCA\u0019y\u0013\tI(GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002}\u007fB\u0011\u0011'`\u0005\u0003}J\u00121!\u00118z\u0011!\t\taCA\u0001\u0002\u00049\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\bA)\u0011\u0011BA\by6\u0011\u00111\u0002\u0006\u0004\u0003\u001b\u0011\u0014AC2pY2,7\r^5p]&!\u0011\u0011CA\u0006\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0011Q\u0004\t\u0004c\u0005e\u0011bAA\u000ee\t9!i\\8mK\u0006t\u0007\u0002CA\u0001\u001b\u0005\u0005\t\u0019\u0001?\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0004[\u0006\r\u0002\u0002CA\u0001\u001d\u0005\u0005\t\u0019A<\u0002\r\u0015\fX/\u00197t)\u0011\t9\"!\u000b\t\u0011\u0005\u0005q\"!AA\u0002qDs\u0003AA\u0017\u0003g\t)$!\u000f\u0002<\u0005}\u0012\u0011IA#\u0003\u000f\nY%!\u0014\u0011\u0007\u001d\ny#C\u0002\u00022a\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00028\u0005\u0001uLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aw\u000e\u001c7bi&|g\u000e\t8b[\u0016\u0004sN\u001a\u0011bA\u001dLg/\u001a8!Kb\u0004(/Z:tS>tg&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QH\u0001M\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002S\r\u001f9sA5\u00023\u000b\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!i>\u0004\u0003/\u001a:g_Jl\u0007eY8mY\u0006$\u0018n\u001c8!_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u0011\u0002\u000f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.\u00043+\u0015'(SmR\u0001\u0005\t\u0011!A\u0001*FK\u0012\u001d`\u0005&s\u0015IU-\u000bA\u0001\nQa]5oG\u0016\f#!!\u0013\u0002\u000bQr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005=\u0013\u0001D:ue&twm\u00184v]\u000e\u001c\u0018!C\"pY2\fG/[8o!\t9\u0013cE\u0003\u0012\u0003/\n\u0019\u0007\u0005\u0004\u0002Z\u0005}CIS\u0007\u0003\u00037R1!!\u00183\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u0019\u0002\\\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001br\u0003\tIw.C\u0002A\u0003O\"\"!a\u0015\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\\\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0015\u0006]\u0004\"\u0002\"\u0015\u0001\u0004!\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003{\n\u0019\t\u0005\u00032\u0003\u007f\"\u0015bAAAe\t1q\n\u001d;j_:D\u0001\"!\"\u0016\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAF!\rq\u0017QR\u0005\u0004\u0003\u001f{'AB(cU\u0016\u001cG\u000f")
public class Collation
extends UnaryExpression
implements RuntimeReplaceable,
ExpectsInputTypes,
Serializable {
    private Expression replacement;
    private final Expression child;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Expression> unapply(Collation x$0) {
        return Collation$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Collation, A> g) {
        return Collation$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Collation> compose(Function1<A$, Expression> g) {
        return Collation$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        Collation collation = this;
        synchronized (collation) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Collation withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    private Expression replacement$lzycompute() {
        Collation collation = this;
        synchronized (collation) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                int collationId = ((StringType)this.child().dataType()).collationId();
                String collationName = CollationFactory.fetchCollation((int)collationId).collationName;
                this.replacement = Literal$.MODULE$.create(collationName, (DataType)SQLConf$.MODULE$.get().defaultStringType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$);
    }

    public Collation copy(Expression child) {
        return new Collation(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Collation";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Collation;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Collation)) return false;
        boolean bl = true;
        if (!bl) return false;
        Collation collation = (Collation)x$1;
        Expression expression = this.child();
        Expression expression2 = collation.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!collation.canEqual(this)) return false;
        return true;
    }

    public Collation(Expression child) {
        this.child = child;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }
}

