/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ConvertTimezone$;
import org.apache.spark.sql.catalyst.expressions.CurrentTimeZone;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_([sourceTz, ]targetTz, sourceTs) - Converts the timestamp without time zone `sourceTs` from the `sourceTz` time zone to `targetTz`. ", arguments="\n    Arguments:\n      * sourceTz - the time zone for the input timestamp.\n                   If it is missed, the current session time zone is used as the source time zone.\n      * targetTz - the time zone to which the input timestamp should be converted\n      * sourceTs - a timestamp without time zone\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Europe/Brussels', 'America/Los_Angeles', timestamp_ntz'2021-12-06 00:00:00');\n       2021-12-05 15:00:00\n      > SELECT _FUNC_('Europe/Brussels', timestamp_ntz'2021-12-05 15:00:00');\n       2021-12-06 00:00:00\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\t-b\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003\u0019\u0006\u0002C.\u0001\u0005#\u0005\u000b\u0011\u0002+\t\u000bq\u0003A\u0011A/\t\u000bq\u0003A\u0011\u00012\t\u000b\u0015\u0004A\u0011I*\t\u000b\u0019\u0004A\u0011I*\t\u000b\u001d\u0004A\u0011I*\t\u000b!\u0004A\u0011I5\t\u000bM\u0004A\u0011\t;\t\u000ba\u0004A\u0011I=\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0002bBA\u001d\u0001\u0011E\u00131\b\u0005\n\u0003\u0013\u0002\u0011\u0011!C\u0001\u0003\u0017B\u0011\"a\u0015\u0001#\u0003%\t!!\u0016\t\u0013\u0005-\u0004!%A\u0005\u0002\u0005U\u0003\"CA7\u0001E\u0005I\u0011AA+\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0001\u0002\u0004\"I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003'\u0003\u0011\u0011!C!\u0003+C\u0011\"a)\u0001\u0003\u0003%\t!!*\t\u0013\u0005=\u0006!!A\u0005B\u0005E\u0006\"CA[\u0001\u0005\u0005I\u0011IA\\\u000f%\t\t/JA\u0001\u0012\u0003\t\u0019O\u0002\u0005%K\u0005\u0005\t\u0012AAs\u0011\u0019af\u0004\"\u0001\u0002~\"I\u0011q \u0010\u0002\u0002\u0013\u0015#\u0011\u0001\u0005\n\u0005\u0007q\u0012\u0011!CA\u0005\u000bA\u0011B!\u0004\u001f\u0003\u0003%\tIa\u0004\t\u0013\t\u0005b$!A\u0005\n\t\r\"aD\"p]Z,'\u000f\u001e+j[\u0016TxN\\3\u000b\u0005\u0019:\u0013aC3yaJ,7o]5p]NT!\u0001K\u0015\u0002\u0011\r\fG/\u00197zgRT!AK\u0016\u0002\u0007M\fHN\u0003\u0002-[\u0005)1\u000f]1sW*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u001a8u\u0005;\u0005C\u0001\u001b6\u001b\u0005)\u0013B\u0001\u001c&\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003iaJ!!O\u0013\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u000f \u000f\u0005Qb\u0014BA\u001f&\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0010!\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011Q(\n\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b!J|G-^2u!\tAuJ\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011A*M\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!!P\"\n\u0005A\u000b&\u0001D*fe&\fG.\u001b>bE2,'BA\u001fD\u0003!\u0019x.\u001e:dKRSX#\u0001+\u0011\u0005Q*\u0016B\u0001,&\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\ng>,(oY3Uu\u0002\n\u0001\u0002^1sO\u0016$HK_\u0001\ni\u0006\u0014x-\u001a;Uu\u0002\n\u0001b]8ve\u000e,Gk]\u0001\ng>,(oY3Ug\u0002\na\u0001P5oSRtD\u0003\u00020`A\u0006\u0004\"\u0001\u000e\u0001\t\u000bI;\u0001\u0019\u0001+\t\u000ba;\u0001\u0019\u0001+\t\u000bi;\u0001\u0019\u0001+\u0015\u0007y\u001bG\rC\u0003Y\u0011\u0001\u0007A\u000bC\u0003[\u0011\u0001\u0007A+A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u00016\u0011\u0007![W.\u0003\u0002m#\n\u00191+Z9\u0011\u00059\fX\"A8\u000b\u0005AL\u0013!\u0002;za\u0016\u001c\u0018B\u0001:p\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005)\bC\u00018w\u0013\t9xN\u0001\u0005ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0015QXp`A\u0002!\t\u001150\u0003\u0002}\u0007\n\u0019\u0011I\\=\t\u000byt\u0001\u0019\u0001>\u0002\u000bM\u00148\r\u0016>\t\r\u0005\u0005a\u00021\u0001{\u0003\u0015!x\r\u001e+{\u0011\u0019\t)A\u0004a\u0001u\u00061Q.[2s_N\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005-\u0011qCA\u0011!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\tK\u000591m\u001c3fO\u0016t\u0017\u0002BA\u000b\u0003\u001f\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u00033y\u0001\u0019AA\u000e\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u001b\ti\"\u0003\u0003\u0002 \u0005=!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003Gy\u0001\u0019AA\u0006\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u000b\u0011\t\u0005-\u00121\u0007\b\u0005\u0003[\ty\u0003\u0005\u0002K\u0007&\u0019\u0011\u0011G\"\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\rM#(/\u001b8h\u0015\r\t\tdQ\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$rAXA\u001f\u0003\u0003\n)\u0005\u0003\u0004\u0002@E\u0001\r\u0001V\u0001\t]\u0016<h)\u001b:ti\"1\u00111I\tA\u0002Q\u000b\u0011B\\3x'\u0016\u001cwN\u001c3\t\r\u0005\u001d\u0013\u00031\u0001U\u0003!qWm\u001e+iSJ$\u0017\u0001B2paf$rAXA'\u0003\u001f\n\t\u0006C\u0004S%A\u0005\t\u0019\u0001+\t\u000fa\u0013\u0002\u0013!a\u0001)\"9!L\u0005I\u0001\u0002\u0004!\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003/R3\u0001VA-W\t\tY\u0006\u0005\u0003\u0002^\u0005\u001dTBAA0\u0015\u0011\t\t'a\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA3\u0007\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0014q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u000f\t\u0005\u0003k\ny(\u0004\u0002\u0002x)!\u0011\u0011PA>\u0003\u0011a\u0017M\\4\u000b\u0005\u0005u\u0014\u0001\u00026bm\u0006LA!!\u000e\u0002x\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0011\t\u0004\u0005\u0006\u001d\u0015bAAE\u0007\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!0a$\t\u0013\u0005E\u0005$!AA\u0002\u0005\u0015\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0018B)\u0011\u0011TAPu6\u0011\u00111\u0014\u0006\u0004\u0003;\u001b\u0015AC2pY2,7\r^5p]&!\u0011\u0011UAN\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0016Q\u0016\t\u0004\u0005\u0006%\u0016bAAV\u0007\n9!i\\8mK\u0006t\u0007\u0002CAI5\u0005\u0005\t\u0019\u0001>\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003g\n\u0019\fC\u0005\u0002\u0012n\t\t\u00111\u0001\u0002\u0006\u00061Q-];bYN$B!a*\u0002:\"A\u0011\u0011\u0013\u000f\u0002\u0002\u0003\u0007!\u0010K\f\u0001\u0003{\u000b\u0019-!2\u0002J\u0006-\u0017qZAi\u0003+\f9.a7\u0002^B\u0019A'a0\n\u0007\u0005\u0005WEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u001d\u0017!!\u0006`\rVs5i\u0018\u0015\\g>,(oY3Uu2\u0002S\f^1sO\u0016$HK\u001f\u0017!g>,(oY3Ug&\u0002S\u0006I\"p]Z,'\u000f^:!i\",\u0007\u0005^5nKN$\u0018-\u001c9!o&$\bn\\;uAQLW.\u001a\u0011{_:,\u0007\u0005Y:pkJ\u001cW\rV:aA\u0019\u0014x.\u001c\u0011uQ\u0016\u0004\u0003m]8ve\u000e,GK\u001f1!i&lW\r\t>p]\u0016\u0004Co\u001c\u0011ai\u0006\u0014x-\u001a;Uu\u0002t\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QZ\u0001\u0003f)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e]8ve\u000e,GK\u001f\u0011.AQDW\r\t;j[\u0016\u0004#p\u001c8fA\u0019|'\u000f\t;iK\u0002Jg\u000e];uAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013J\u001a\u0011ji\u0002J7\u000fI7jgN,G\r\f\u0011uQ\u0016\u00043-\u001e:sK:$\be]3tg&|g\u000e\t;j[\u0016\u0004#p\u001c8fA%\u001c\b%^:fI\u0002\n7\u000f\t;iK\u0002\u001ax.\u001e:dK\u0002\"\u0018.\\3!u>tWM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i\u0006\u0014x-\u001a;Uu\u0002j\u0003\u0005\u001e5fAQLW.\u001a\u0011{_:,\u0007\u0005^8!o\"L7\r\u001b\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\"\u0018.\\3ti\u0006l\u0007\u000fI:i_VdG\r\t2fA\r|gN^3si\u0016$'\u0002\t\u0011!A\u0001\u0002#\u0006I:pkJ\u001cW\rV:![\u0001\n\u0007\u0005^5nKN$\u0018-\u001c9!o&$\bn\\;uAQLW.\u001a\u0011{_:,'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a5\u0002\u0003kT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ#ve>\u0004Xm\f\"skN\u001cX\r\\:(Y\u0001:\u0013)\\3sS\u000e\fw\u0006T8t?\u0006sw-\u001a7fg\u001eb\u0003\u0005^5nKN$\u0018-\u001c9`]RTxE\r\u00193c5\n$'\f\u00197AA\u0002$\b\r\u0019;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aI\nT&\r\u001a.aU\u0002\u0013'\u000e\u001e1ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(\u000bV\u0014x\u000e]30\u0005J,8o]3mg\u001eb\u0003\u0005^5nKN$\u0018-\u001c9`]RTxE\r\u00193c5\n$'\f\u00196AE*$\b\r\u0019;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aI\nT&\r\u001a.aY\u0002\u0003\u0007\r\u001e1ai\u0002\u0004G\u0003\u0011!\u0003\u00159'o\\;qC\t\tI.\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005}\u0017!B\u001a/i9\u0002\u0014aD\"p]Z,'\u000f\u001e+j[\u0016TxN\\3\u0011\u0005Qr2#\u0002\u0010\u0002h\u0006M\b\u0003CAu\u0003_$F\u000b\u00160\u000e\u0005\u0005-(bAAw\u0007\u00069!/\u001e8uS6,\u0017\u0002BAy\u0003W\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t)0a?\u000e\u0005\u0005](\u0002BA}\u0003w\n!![8\n\u0007A\u000b9\u0010\u0006\u0002\u0002d\u0006AAo\\*ue&tw\r\u0006\u0002\u0002t\u0005)\u0011\r\u001d9msR9aLa\u0002\u0003\n\t-\u0001\"\u0002*\"\u0001\u0004!\u0006\"\u0002-\"\u0001\u0004!\u0006\"\u0002.\"\u0001\u0004!\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005#\u0011i\u0002E\u0003C\u0005'\u00119\"C\u0002\u0003\u0016\r\u0013aa\u00149uS>t\u0007C\u0002\"\u0003\u001aQ#F+C\u0002\u0003\u001c\r\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B\u0010E\u0005\u0005\t\u0019\u00010\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003&A!\u0011Q\u000fB\u0014\u0013\u0011\u0011I#a\u001e\u0003\r=\u0013'.Z2u\u0001")
public class ConvertTimezone
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression sourceTz;
    private final Expression targetTz;
    private final Expression sourceTs;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(ConvertTimezone x$0) {
        return ConvertTimezone$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, ConvertTimezone> tupled() {
        return ConvertTimezone$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, ConvertTimezone>>> curried() {
        return ConvertTimezone$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression sourceTz() {
        return this.sourceTz;
    }

    public Expression targetTz() {
        return this.targetTz;
    }

    public Expression sourceTs() {
        return this.sourceTs;
    }

    @Override
    public Expression first() {
        return this.sourceTz();
    }

    @Override
    public Expression second() {
        return this.targetTz();
    }

    @Override
    public Expression third() {
        return this.sourceTs();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)TimestampNTZType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object srcTz, Object tgtTz, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.convertTimestampNtzToAnotherTz(((UTF8String)srcTz).toString(), ((UTF8String)tgtTz).toString(), BoxesRunTime.unboxToLong((Object)micros)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(srcTz, tgtTz, micros) -> dtu + ".convertTimestampNtzToAnotherTz(" + srcTz + ".toString(), " + tgtTz + ".toString(), " + micros + ")");
    }

    @Override
    public String prettyName() {
        return "convert_timezone";
    }

    @Override
    public ConvertTimezone withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public ConvertTimezone copy(Expression sourceTz, Expression targetTz, Expression sourceTs) {
        return new ConvertTimezone(sourceTz, targetTz, sourceTs);
    }

    public Expression copy$default$1() {
        return this.sourceTz();
    }

    public Expression copy$default$2() {
        return this.targetTz();
    }

    public Expression copy$default$3() {
        return this.sourceTs();
    }

    @Override
    public String productPrefix() {
        return "ConvertTimezone";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourceTz();
            }
            case 1: {
                return this.targetTz();
            }
            case 2: {
                return this.sourceTs();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConvertTimezone;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sourceTz";
            }
            case 1: {
                return "targetTz";
            }
            case 2: {
                return "sourceTs";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConvertTimezone)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConvertTimezone convertTimezone = (ConvertTimezone)x$1;
        Expression expression = this.sourceTz();
        Expression expression2 = convertTimezone.sourceTz();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.targetTz();
        Expression expression4 = convertTimezone.targetTz();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.sourceTs();
        Expression expression6 = convertTimezone.sourceTs();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!convertTimezone.canEqual(this)) return false;
        return true;
    }

    public ConvertTimezone(Expression sourceTz, Expression targetTz, Expression sourceTs) {
        this.sourceTz = sourceTz;
        this.targetTz = targetTz;
        this.sourceTs = sourceTs;
        ExpectsInputTypes.$init$(this);
    }

    public ConvertTimezone(Expression targetTz, Expression sourceTs) {
        this(new CurrentTimeZone(), targetTz, sourceTs);
    }
}

