/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.NoThrow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.0.0", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\rc\u0001B\u0014)\u0001VB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005#\"AQ\u000b\u0001BK\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003X\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015Y\u0006\u0001\"\u0001a\u0011!\u0011\u0007\u0001#b\u0001\n\u0003\u0019\u0007\u0002\u00037\u0001\u0011\u000b\u0007I\u0011A2\t\u000f5\u0004!\u0019!C\u0005]\"1Q\u000f\u0001Q\u0001\n=DQA\u001e\u0001\u0005BYCQa\u001e\u0001\u0005BaDaa \u0001\u0005B\u0005\u0005\u0001BCA\b\u0001!\u0015\r\u0011\"\u0011\u0002\u0012!1\u0011\u0011\u0004\u0001\u0005BYC!\"a\u0007\u0001\u0011\u000b\u0007I\u0011BA\u000f\u0011\u0019\tY\u0003\u0001C!-\"9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA\u001f\u0001\u0011\u0005\u0013q\b\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\ty\u0007\u0001C)\u0003cB\u0011\"a\u001f\u0001\u0003\u0003%\t!! \t\u0013\u0005\r\u0005!%A\u0005\u0002\u0005\u0015\u0005\"CAN\u0001E\u0005I\u0011AAO\u0011%\t\t\u000bAA\u0001\n\u0003\n\u0019\u000bC\u0005\u00024\u0002\t\t\u0011\"\u0001\u00026\"I\u0011Q\u0018\u0001\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u000b\u0004\u0011\u0011!C!\u0003\u000fD\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005U\u0007!!A\u0005B\u0005]\u0007\"CAn\u0001\u0005\u0005I\u0011IAo\u000f\u001d\u0011\t\u0001\u000bE\u0001\u0005\u00071aa\n\u0015\t\u0002\t\u0015\u0001BB.\"\t\u0003\u00119\u0002C\u0004\u0003\u001a\u0005\"\tAa\u0007\t\u0013\te\u0011%!A\u0005\u0002\n}\u0001\"\u0003B\u0013C\u0005\u0005I\u0011\u0011B\u0014\u0011%\u0011I$IA\u0001\n\u0013\u0011YDA\u0005De\u0016\fG/Z'ba*\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002,Y\u0005A1-\u0019;bYf\u001cHO\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001mij4\t\u0005\u00028q5\t\u0001&\u0003\u0002:Q\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005]Z\u0014B\u0001\u001f)\u0005\u001dqu\u000e\u00165s_^\u0004\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002E\u0019:\u0011QI\u0013\b\u0003\r&k\u0011a\u0012\u0006\u0003\u0011R\na\u0001\u0010:p_Rt\u0014\"\u0001!\n\u0005-{\u0014a\u00029bG.\fw-Z\u0005\u0003\u001b:\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aS \u0002\u0011\rD\u0017\u000e\u001c3sK:,\u0012!\u0015\t\u0004\tJ3\u0014BA*O\u0005\r\u0019V-]\u0001\nG\"LG\u000e\u001a:f]\u0002\na#^:f'R\u0014\u0018N\\4UsB,w\u000b[3o\u000b6\u0004H/_\u000b\u0002/B\u0011a\bW\u0005\u00033~\u0012qAQ8pY\u0016\fg.A\fvg\u0016\u001cFO]5oORK\b/Z,iK:,U\u000e\u001d;zA\u00051A(\u001b8jiz\"2!\u00180`!\t9\u0004\u0001C\u0003P\u000b\u0001\u0007\u0011\u000bC\u0003V\u000b\u0001\u0007q\u000b\u0006\u0002^C\")qJ\u0002a\u0001#\u0006!1.Z=t+\u0005!\u0007cA3km5\taM\u0003\u0002hQ\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003S~\n!bY8mY\u0016\u001cG/[8o\u0013\tYgM\u0001\u0006J]\u0012,\u00070\u001a3TKF\faA^1mk\u0016\u001c\u0018A\u00053fM\u0006,H\u000e^#mK6,g\u000e\u001e+za\u0016,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003e2\nQ\u0001^=qKNL!\u0001^9\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f1\u0003Z3gCVdG/\u00127f[\u0016tG\u000fV=qK\u0002\n\u0001BZ8mI\u0006\u0014G.Z\u0001\u000bgR\u0014\u0018N\\4Be\u001e\u001cX#A=\u0011\u0007\u0011SH0\u0003\u0002|\u001d\nA\u0011\n^3sCR|'\u000f\u0005\u0002?{&\u0011ap\u0010\u0002\u0004\u0003:L\u0018aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005U\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u000e\u0005\u001d!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0005\u0011\u0007A\f)\"C\u0002\u0002\u0018E\u0014q!T1q)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f\u0003)i\u0017\r\u001d\"vS2$WM]\u000b\u0003\u0003?\u0001B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003KQ\u0013\u0001B;uS2LA!!\u000b\u0002$\t!\u0012I\u001d:bs\n\u000b7/\u001a3NCB\u0014U/\u001b7eKJ\f\u0001b\u001d;bi\u00164W\u000f\\\u0001\u0005KZ\fG\u000eF\u0002}\u0003cA\u0011\"a\r\u0013!\u0003\u0005\r!!\u000e\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005]\u0012\u0011H\u0007\u0002U%\u0019\u00111\b\u0016\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$b!!\u0011\u0002N\u0005]\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d\u0003&A\u0004d_\u0012,w-\u001a8\n\t\u0005-\u0013Q\t\u0002\t\u000bb\u0004(oQ8eK\"9\u0011qJ\nA\u0002\u0005E\u0013aA2uqB!\u00111IA*\u0013\u0011\t)&!\u0012\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011L\nA\u0002\u0005\u0005\u0013AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003?\u0002B!!\u0019\u0002j9!\u00111MA3!\t1u(C\u0002\u0002h}\na\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003[\u0012aa\u0015;sS:<'bAA4\u007f\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004;\u0006M\u0004bBA;+\u0001\u0007\u0011qO\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003E\u0003s2\u0014BA6O\u0003\u0011\u0019w\u000e]=\u0015\u000bu\u000by(!!\t\u000f=3\u0002\u0013!a\u0001#\"9QK\u0006I\u0001\u0002\u00049\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000fS3!UAEW\t\tY\t\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\u0013Ut7\r[3dW\u0016$'bAAK\u007f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0015q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003?S3aVAE\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0016\u0001\u00026bm\u0006LA!a\u001b\u0002*\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0017\t\u0004}\u0005e\u0016bAA^\u007f\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019A0!1\t\u0013\u0005\r7$!AA\u0002\u0005]\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JB)\u00111ZAgy6\t\u0001.\u0003\u0002|Q\u0006A1-\u00198FcV\fG\u000eF\u0002X\u0003'D\u0001\"a1\u001e\u0003\u0003\u0005\r\u0001`\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002&\u0006e\u0007\"CAb=\u0005\u0005\t\u0019AA\\\u0003\u0019)\u0017/^1mgR\u0019q+a8\t\u0011\u0005\rw$!AA\u0002qD3\u0003AAr\u0003S\fY/a<\u0002r\u0006U\u0018q_A~\u0003{\u00042aNAs\u0013\r\t9\u000f\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ti/A,`\rVs5i\u0018\u0015lKf\u0004D\u0006\t<bYV,\u0007\u0007\f\u0011lKf\fD\u0006\t<bYV,\u0017\u0007\f\u0011/]9J\u0003%\f\u0011De\u0016\fG/Z:!C\u0002j\u0017\r\u001d\u0011xSRD\u0007\u0005\u001e5fA\u001dLg/\u001a8!W\u0016LxF^1mk\u0016\u0004\u0003/Y5sg:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003g\fQK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152]Ab\u0003e\n\u001a(Y\u0001\u001ad\u0006\r\u0017!OQ:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|c9\u0002$H\t\u001a#YMr\u0003G\u000f\u00125EuT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003s\fQA\r\u00181]A\nQa\u001a:pkB\f#!a@\u0002\u00135\f\u0007o\u00184v]\u000e\u001c\u0018!C\"sK\u0006$X-T1q!\t9\u0014eE\u0003\"\u0005\u000f\u0011i\u0001E\u0002?\u0005\u0013I1Aa\u0003@\u0005\u0019\te.\u001f*fMB!!q\u0002B\u000b\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\u00055\u0016AA5p\u0013\ri%\u0011\u0003\u000b\u0003\u0005\u0007\tQ!\u00199qYf$2!\u0018B\u000f\u0011\u0015y5\u00051\u0001R)\u0015i&\u0011\u0005B\u0012\u0011\u0015yE\u00051\u0001R\u0011\u0015)F\u00051\u0001X\u0003\u001d)h.\u00199qYf$BA!\u000b\u00036A)aHa\u000b\u00030%\u0019!QF \u0003\r=\u0003H/[8o!\u0015q$\u0011G)X\u0013\r\u0011\u0019d\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\t]R%!AA\u0002u\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011i\u0004\u0005\u0003\u0002(\n}\u0012\u0002\u0002B!\u0003S\u0013aa\u00142kK\u000e$\b")
public class CreateMap
extends Expression
implements NoThrow,
Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private MapType dataType;
    private ArrayBasedMapBuilder mapBuilder;
    private final Seq<Expression> children;
    private final boolean useStringTypeWhenEmpty;
    private final DataType defaultElementType;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CreateMap x$0) {
        return CreateMap$.MODULE$.unapply(x$0);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean useStringTypeWhenEmpty() {
        return this.useStringTypeWhenEmpty;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((IndexedSeqOps)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 % 2 == 0)).map(this.children());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.keys$lzycompute();
        }
        return this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((IndexedSeqOps)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 % 2 != 0)).map(this.children());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.values$lzycompute();
        }
        return this.values;
    }

    private DataType defaultElementType() {
        return this.defaultElementType;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.foldable()));
    }

    @Override
    public Iterator<Object> stringArgs() {
        return super.stringArgs().take(1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().size() % 2 != 0) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)new .colon.colon((Object)"2n (n > 0)", (List)Nil$.MODULE$), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        if (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable)x$10 -> x$10.dataType())))) {
            return new TypeCheckResult.DataTypeMismatch("CREATE_MAP_KEY_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((IterableOnceOps)this.keys().map((Function1 & Serializable)key -> Cast$.MODULE$.toSQLType((AbstractDataType)key.dataType()))).mkString("[", ", ", "]"))}))));
        }
        if (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable)x$11 -> x$11.dataType())))) {
            return new TypeCheckResult.DataTypeMismatch("CREATE_MAP_VALUE_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)Cast$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((IterableOnceOps)this.values().map((Function1 & Serializable)value -> Cast$.MODULE$.toSQLType((AbstractDataType)value.dataType()))).mkString("[", ", ", "]"))}))));
        }
        return TypeUtils$.MODULE$.checkForMapKeyType(this.dataType().keyType());
    }

    private MapType dataType$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataType = new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable)x$12 -> x$12.dataType()))).getOrElse((Function0 & Serializable)() -> this.defaultElementType()), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable)x$13 -> x$13.dataType()))).getOrElse((Function0 & Serializable)() -> this.defaultElementType()), this.values().exists((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.nullable())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataType;
    }

    public MapType dataType() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Object eval(InternalRow input) {
        for (int i = 0; i < this.keys().length(); ++i) {
            this.mapBuilder().put(((Expression)this.keys().apply(i)).eval(input), ((Expression)this.values().apply(i)).eval(input));
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        MapType mapType = this.dataType();
        if (mapType == null) {
            throw new MatchError((Object)mapType);
        }
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        DataType keyDt2 = (DataType)tuple2._1();
        DataType valueDt2 = (DataType)tuple2._2();
        Tuple3<String, String, String> tuple3 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<Expression>)this.keys(), "createMap");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String allocationKeyData = (String)tuple3._1();
        String assignKeys = (String)tuple3._2();
        String keyArrayData = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)allocationKeyData, (Object)assignKeys, (Object)keyArrayData);
        String allocationKeyData2 = (String)tuple32._1();
        String assignKeys2 = (String)tuple32._2();
        String keyArrayData2 = (String)tuple32._3();
        Tuple3<String, String, String> tuple33 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<Expression>)this.values(), "createMap");
        if (tuple33 == null) {
            throw new MatchError(tuple33);
        }
        String allocationValueData = (String)tuple33._1();
        String assignValues = (String)tuple33._2();
        String valueArrayData = (String)tuple33._3();
        Tuple3 tuple34 = new Tuple3((Object)allocationValueData, (Object)assignValues, (Object)valueArrayData);
        String allocationValueData2 = (String)tuple34._1();
        String assignValues2 = (String)tuple34._2();
        String valueArrayData2 = (String)tuple34._3();
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = ", ".from(", ", ", ");\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{allocationKeyData2, assignKeys2, allocationValueData2, assignValues2, ev.value(), builderTerm, keyArrayData2, valueArrayData2}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    @Override
    public CreateMap withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Seq<Expression>)newChildren, this.copy$default$2());
    }

    public CreateMap copy(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        return new CreateMap(children2, useStringTypeWhenEmpty);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.useStringTypeWhenEmpty();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.useStringTypeWhenEmpty());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
            case 1: {
                return "useStringTypeWhenEmpty";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        if (this.useStringTypeWhenEmpty() != createMap.useStringTypeWhenEmpty()) return false;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        this.children = children2;
        this.useStringTypeWhenEmpty = useStringTypeWhenEmpty;
        this.defaultElementType = useStringTypeWhenEmpty ? SQLConf$.MODULE$.get().defaultStringType() : NullType$.MODULE$;
    }

    public CreateMap(Seq<Expression> children2) {
        this(children2, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_CREATE_EMPTY_COLLECTION_USING_STRING_TYPE())));
    }
}

