/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If Index is 0,\n      Spark will throw an error. If index < 0, accesses elements from the last to the first.\n      The function returns NULL if the index exceeds the length of the array and\n      `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL if the key is not\n       contained in the map.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0", group="collection_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%g\u0001B\u00193\u0001~B\u0001b\u001b\u0001\u0003\u0016\u0004%\t\u0001\u001c\u0005\ta\u0002\u0011\t\u0012)A\u0005[\"A\u0011\u000f\u0001BK\u0002\u0013\u0005A\u000e\u0003\u0005s\u0001\tE\t\u0015!\u0003n\u0011!\u0019\bA!f\u0001\n\u0003!\b\u0002C>\u0001\u0005#\u0005\u000b\u0011B;\t\u0011q\u0004!Q3A\u0005\u0002uD\u0011\"a\u0001\u0001\u0005#\u0005\u000b\u0011\u0002@\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011Q\u0001\u0001\u0005\u0002\u0005M\u0001BCA\r\u0001!\u0015\r\u0011\"\u0003\u0002\u001c!I\u0011\u0011\u0007\u0001\t\u0006\u0004%I! \u0005\n\u0003k\u0001\u0001R1A\u0005\nuD!\"!\u000f\u0001\u0011\u000b\u0007I\u0011BA\u001e\u0011)\tY\u0005\u0001EC\u0002\u0013\u0005\u00131\u0004\u0005\b\u0003\u001f\u0002A\u0011IA)\u0011\u001d\ty\u0006\u0001C!\u0003CBq!a\u001c\u0001\t\u0013\t\t\b\u0003\u0004\u0002\u0004\u0002!\t% \u0005\b\u0003\u000b\u0003A\u0011IAD\u0011)\ty\t\u0001EC\u0002\u0013%\u0011\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\tI\f\u0001C!\u0003wCq!!4\u0001\t#\ny\rC\u0004\u0002Z\u0002!\t%a7\t\u0013\u0005\u001d\b!!A\u0005\u0002\u0005%\b\"CAz\u0001E\u0005I\u0011AA{\u0011%\u0011Y\u0001AI\u0001\n\u0003\t)\u0010C\u0005\u0003\u000e\u0001\t\n\u0011\"\u0001\u0003\u0010!I!1\u0003\u0001\u0012\u0002\u0013\u0005!Q\u0003\u0005\n\u00053\u0001\u0011\u0011!C!\u00057A\u0011Ba\u000b\u0001\u0003\u0003%\tA!\f\t\u0013\t=\u0002!!A\u0005\u0002\tE\u0002\"\u0003B\u001c\u0001\u0005\u0005I\u0011\tB\u001d\u0011%\u00119\u0005AA\u0001\n\u0003\u0011I\u0005C\u0005\u0003N\u0001\t\t\u0011\"\u0011\u0003P!I!1\u000b\u0001\u0002\u0002\u0013\u0005#QK\u0004\n\u0005s\u0012\u0014\u0011!E\u0001\u0005w2\u0001\"\r\u001a\u0002\u0002#\u0005!Q\u0010\u0005\b\u0003\u000b9C\u0011\u0001BK\u0011%\u00119jJA\u0001\n\u000b\u0012I\nC\u0005\u0003\u001c\u001e\n\t\u0011\"!\u0003\u001e\"I!qU\u0014\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005S;\u0013\u0013!C\u0001\u0005+A\u0011Ba+(\u0003\u0003%\tI!,\t\u0013\tmv%%A\u0005\u0002\t=\u0001\"\u0003B_OE\u0005I\u0011\u0001B\u000b\u0011%\u0011ylJA\u0001\n\u0013\u0011\tMA\u0005FY\u0016lWM\u001c;Bi*\u00111\u0007N\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00026m\u0005A1-\u0019;bYf\u001cHO\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005eR\u0014!B:qCJ\\'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001aE\u0005\u0001\u0001\u0012;%*\u0015+[AB\u0011\u0011IQ\u0007\u0002e%\u00111I\r\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!Q#\n\u0005\u0019\u0013$aD$fi6\u000b\u0007OV1mk\u0016,F/\u001b7\u0011\u0005\u0005C\u0015BA%3\u0005A9U\r^!se\u0006L\u0018\n^3n+RLG\u000e\u0005\u0002L\u001d:\u0011\u0011\tT\u0005\u0003\u001bJ\nq\u0001]1dW\u0006<W-\u0003\u0002P!\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(BA'3!\t\t%+\u0003\u0002Te\t\u00192+\u001e9q_J$\u0018+^3ss\u000e{g\u000e^3yiB\u0011Q\u000bW\u0007\u0002-*\u0011qKN\u0001\u0007KJ\u0014xN]:\n\u0005e3&aD)vKJLXI\u001d:peN\u0014\u0015m]3\u0011\u0005msV\"\u0001/\u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011\r\u001b\b\u0003E\u001et!a\u00194\u000e\u0003\u0011T!!\u001a \u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0016BA']\u0013\tI'N\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002N9\u0006!A.\u001a4u+\u0005i\u0007CA!o\u0013\ty'G\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u00063fM\u0006,H\u000e\u001e,bYV,w*\u001e;PM\n{WO\u001c3\u0016\u0003U\u00042a\u0017<y\u0013\t9HL\u0001\u0004PaRLwN\u001c\t\u0003\u0003fL!A\u001f\u001a\u0003\u000f1KG/\u001a:bY\u00069B-\u001a4bk2$h+\u00197vK>+Ho\u00144C_VtG\rI\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001\u007f!\tYv0C\u0002\u0002\u0002q\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u0001CA!\u0001\u0011\u0015Y\u0017\u00021\u0001n\u0011\u0015\t\u0018\u00021\u0001n\u0011\u001d\u0019\u0018\u0002%AA\u0002UDq\u0001`\u0005\u0011\u0002\u0003\u0007a\u0010\u0006\u0004\u0002\n\u0005U\u0011q\u0003\u0005\u0006W*\u0001\r!\u001c\u0005\u0006c*\u0001\r!\\\u0001\u000b[\u0006\u00048*Z=UsB,WCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012m\u0005)A/\u001f9fg&!\u0011qEA\u0011\u0005!!\u0015\r^1UsB,\u0007fA\u0006\u0002,A\u00191,!\f\n\u0007\u0005=BLA\u0005ue\u0006t7/[3oi\u0006!R.\u00199WC2,XmQ8oi\u0006Lgn\u001d(vY2D3\u0001DA\u0016\u0003Q\t'O]1z\u000b2,W.\u001a8u\u001dVdG.\u00192mK\"\u001aQ\"a\u000b\u0002\u0011=\u0014H-\u001a:j]\u001e,\"!!\u0010\u0011\u000b\u0005\fy$a\u0011\n\u0007\u0005\u0005#N\u0001\u0005Pe\u0012,'/\u001b8h!\rY\u0016QI\u0005\u0004\u0003\u000fb&aA!os\"\u001aa\"a\u000b\u0002\u0011\u0011\fG/\u0019+za\u0016D3aDA\u0016\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003'\u0002R!YA+\u00033J1!a\u0016k\u0005\r\u0019V-\u001d\t\u0005\u0003?\tY&\u0003\u0003\u0002^\u0005\u0005\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\t\t\u0019\u0007\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI\u0007N\u0001\tC:\fG._:jg&!\u0011QNA4\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018a\u00038vY2\f'-\u001b7jif$RA`A:\u0003sBq!!\u001e\u0013\u0001\u0004\t9(\u0001\u0005fY\u0016lWM\u001c;t!\u0011\t\u0017QK7\t\u000f\u0005m$\u00031\u0001\u0002~\u00059qN\u001d3j]\u0006d\u0007cA.\u0002\u0000%\u0019\u0011\u0011\u0011/\u0003\u0007%sG/\u0001\u0005ok2d\u0017M\u00197f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t\u0019%!#\u0002\u000e\"9\u00111\u0012\u000bA\u0002\u0005\r\u0013!\u0002<bYV,\u0007bBA>)\u0001\u0007\u00111I\u0001\fI>,E.Z7f]R\fE/\u0006\u0002\u0002\u0014BI1,!&\u0002D\u0005\r\u00131I\u0005\u0004\u0003/c&!\u0003$v]\u000e$\u0018n\u001c83Q\r)\u00121F\u0001\nI><UM\\\"pI\u0016$b!a(\u0002,\u0006U\u0006\u0003BAQ\u0003Ok!!a)\u000b\u0007\u0005\u0015&'A\u0004d_\u0012,w-\u001a8\n\t\u0005%\u00161\u0015\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0016\fA\u0002\u0005=\u0016aA2uqB!\u0011\u0011UAY\u0013\u0011\t\u0019,a)\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\u0017\fA\u0002\u0005}\u0015AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003{\u0003B!a0\u0002H:!\u0011\u0011YAb!\t\u0019G,C\u0002\u0002Fr\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAe\u0003\u0017\u0014aa\u0015;sS:<'bAAc9\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0007\u0003\u0013\t\t.!6\t\r\u0005M\u0007\u00041\u0001n\u0003\u001dqWm\u001e'fMRDa!a6\u0019\u0001\u0004i\u0017\u0001\u00038foJKw\r\u001b;\u0002!%t\u0017\u000e^)vKJL8i\u001c8uKb$HCAAo!\u0011Yf/a8\u0011\t\u0005\u0005\u00181]\u0007\u0002q%\u0019\u0011Q\u001d\u001d\u0003\u0019E+XM]=D_:$X\r\u001f;\u0002\t\r|\u0007/\u001f\u000b\u000b\u0003\u0013\tY/!<\u0002p\u0006E\bbB6\u001b!\u0003\u0005\r!\u001c\u0005\bcj\u0001\n\u00111\u0001n\u0011\u001d\u0019(\u0004%AA\u0002UDq\u0001 \u000e\u0011\u0002\u0003\u0007a0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005](fA7\u0002z.\u0012\u00111 \t\u0005\u0003{\u00149!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0006q\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011I!a@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u0003\u0016\u0004k\u0006e\u0018AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005/Q3A`A}\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0004\t\u0005\u0005?\u0011I#\u0004\u0002\u0003\")!!1\u0005B\u0013\u0003\u0011a\u0017M\\4\u000b\u0005\t\u001d\u0012\u0001\u00026bm\u0006LA!!3\u0003\"\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011QP\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019Ea\r\t\u0013\tU\u0012%!AA\u0002\u0005u\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003<A1!Q\bB\"\u0003\u0007j!Aa\u0010\u000b\u0007\t\u0005C,\u0001\u0006d_2dWm\u0019;j_:LAA!\u0012\u0003@\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rq(1\n\u0005\n\u0005k\u0019\u0013\u0011!a\u0001\u0003\u0007\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!Q\u0004B)\u0011%\u0011)\u0004JA\u0001\u0002\u0004\ti(\u0001\u0004fcV\fGn\u001d\u000b\u0004}\n]\u0003\"\u0003B\u001bK\u0005\u0005\t\u0019AA\"QM\u0001!1\fB1\u0005G\u00129G!\u001b\u0003n\t=$1\u000fB;!\r\t%QL\u0005\u0004\u0005?\u0012$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005K\nAQ\r\u0006!A\u0001\u0002sLR+O\u0007~C\u0013M\u001d:bs2\u0002\u0013N\u001c3fq&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011fY\u0016lWM\u001c;!_\u001a\u0004\u0013M\u001d:bs\u0002\nG\u000fI4jm\u0016t\u0007\u0005K\u0019.E\u0006\u001cX\rZ\u0015!S:$W\r\u001f\u0018!\u0013\u001a\u0004\u0013J\u001c3fq\u0002J7\u000f\t\u0019-\u0015\u0001\u0002\u0003\u0005\t\u0011!'B\f'o\u001b\u0011xS2d\u0007\u0005\u001e5s_^\u0004\u0013M\u001c\u0011feJ|'O\f\u0011JM\u0002Jg\u000eZ3yAq\u0002\u0003\u0007\f\u0011bG\u000e,7o]3tA\u0015dW-\\3oiN\u0004cM]8nAQDW\r\t7bgR\u0004Co\u001c\u0011uQ\u0016\u0004c-\u001b:ti:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rU\u000b\u0014'!S\u001a\u0004C\u000f[3!S:$W\r\u001f\u0011fq\u000e,W\rZ:!i\",\u0007\u0005\\3oORD\u0007e\u001c4!i\",\u0007%\u0019:sCf\u0004\u0013M\u001c3\u000bA\u0001\u0002\u0003\u0005\t\u0011agB\f'o\u001b\u0018tc2t\u0013M\\:j]\u0015t\u0017M\u00197fI\u0002\u0004\u0013n\u001d\u0011tKR\u0004Co\u001c\u0011gC2\u001cXM\f\u0006!A\u0001\u0002\u0003\u0005I%gA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tAM,G\u000f\t;pAQ\u0014X/\u001a\u0017!SR\u0004C\u000f\u001b:poN\u0004\u0013I\u001d:bs&sG-\u001a=PkR|eMQ8v]\u0012\u001cX\t_2faRLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t4pe\u0002JgN^1mS\u0012\u0004\u0013N\u001c3jG\u0016\u001chF\u0003\u0006!A\u0001\u0002sLR+O\u0007~CS.\u00199-A-,\u00170\u000b\u0011.AI+G/\u001e:og\u00022\u0018\r\\;fA\u0019|'\u000fI4jm\u0016t\u0007e[3z]\u0001\"\u0006.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rU\u000b\u0014'!S\u001a\u0004C\u000f[3!W\u0016L\b%[:!]>$(\u0002\t\u0011!A\u0001\u0002\u0003eY8oi\u0006Lg.\u001a3!S:\u0004C\u000f[3![\u0006\u0004hF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B6\u0003qT\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfD\u0013\u0007\f\u00113Y\u0001\u001a\u0014\u0006\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBD\u0013\u0007\f\u0011(C\u001eb\u0003E\r\u0017!O\t<\u0013\u0006\f\u00113SmR\u0001\u0005\t\u0011!A\u0001\u0002#M\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t(A\u00033]Qr\u0003'A\u0003he>,\b/\t\u0002\u0003x\u0005\u00012m\u001c7mK\u000e$\u0018n\u001c8`MVt7m]\u0001\n\u000b2,W.\u001a8u\u0003R\u0004\"!Q\u0014\u0014\u000b\u001d\u0012yHa#\u0011\u0015\t\u0005%qQ7nkz\fI!\u0004\u0002\u0003\u0004*\u0019!Q\u0011/\u0002\u000fI,h\u000e^5nK&!!\u0011\u0012BB\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005\u001b\u0013\u0019*\u0004\u0002\u0003\u0010*!!\u0011\u0013B\u0013\u0003\tIw.C\u0002j\u0005\u001f#\"Aa\u001f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\u0005%!q\u0014BQ\u0005G\u0013)\u000bC\u0003lU\u0001\u0007Q\u000eC\u0003rU\u0001\u0007Q\u000eC\u0004tUA\u0005\t\u0019A;\t\u000fqT\u0003\u0013!a\u0001}\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BAa,\u00038B!1L\u001eBY!\u001dY&1W7nkzL1A!.]\u0005\u0019!V\u000f\u001d7fi!I!\u0011X\u0017\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u0007\u0004BAa\b\u0003F&!!q\u0019B\u0011\u0005\u0019y%M[3di\u0002")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant,
SupportQueryContext,
QueryErrorsBase {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayElementNullable;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final Option<Literal> defaultValueOutOfBound;
    private final boolean failOnError;
    private Option<QueryContext> queryContext;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ElementAt$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Literal> $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Option<Literal>, Object>> unapply(ElementAt x$0) {
        return ElementAt$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ElementAt$.MODULE$.apply$default$4();
    }

    public static Option<Literal> apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Option<Literal>, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Literal>, Function1<Object, ElementAt>>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public Option<Literal> defaultValueOutOfBound() {
        return this.defaultValueOutOfBound;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.mapKeyType$lzycompute();
        }
        return this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.mapValueContainsNull$lzycompute();
        }
        return this.mapValueContainsNull;
    }

    private boolean arrayElementNullable$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayElementNullable = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayElementNullable;
    }

    private boolean arrayElementNullable() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.arrayElementNullable$lzycompute();
        }
        return this.arrayElementNullable;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return new .colon.colon((Object)arrayType, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    return new .colon.colon((Object)new MapType(dt, valueType, hasNull), (List)new .colon.colon((Object)dt, (List)Nil$.MODULE$));
                }
                return (Seq)package$.MODULE$.Seq().empty();
            }
        }
        if (tuple2 != null) {
            return (Seq)package$.MODULE$.Seq().empty();
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.right())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !DataTypeUtils$.MODULE$.sameType(e2, e12 = (mapType = (MapType)dataType).keyType())) {
                return new TypeCheckResult.DataTypeMismatch("MAP_FUNCTION_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)MapType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"leftType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rightType"), (Object)this.toSQLType((AbstractDataType)this.right().dataType()))}))));
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.left())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.left().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        if (ordinal == 0) {
            return false;
        }
        if (elements.length() < scala.math.package$.MODULE$.abs(ordinal)) {
            return !this.failOnError();
        }
        if (ordinal < 0) {
            return ((Expression)elements.apply(elements.length() + ordinal)).nullable();
        }
        return ((Expression)elements.apply(ordinal - 1)).nullable();
    }

    @Override
    public boolean nullable() {
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            return this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        }
        if (dataType instanceof MapType) {
            return true;
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> {
                        int idx;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < scala.math.package$.MODULE$.abs(index)) {
                            if (this.failOnError()) {
                                throw QueryExecutionErrors$.MODULE$.invalidElementAtIndexError(index, array.numElements(), this.getContextOrNull());
                            }
                            Option<Literal> option = this.defaultValueOutOfBound();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Literal value2 = (Literal)some.value();
                                return value2.eval(value2.eval$default$1());
                            }
                            if (None$.MODULE$.equals(option)) {
                                return null;
                            }
                            throw new MatchError(option);
                        }
                        if (index == 0) {
                            throw QueryExecutionErrors$.MODULE$.invalidIndexOfZeroError(this.getContextOrNull());
                        }
                        int n = idx = index > 0 ? index - 1 : array.numElements() + index;
                        if (this.arrayElementNullable() && array.isNullAt(idx)) {
                            return null;
                        }
                        return array.get(idx, this.dataType());
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
            return this.doElementAt$lzycompute();
        }
        return this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> {
                Object object;
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayElementNullable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n               |if (" + eval1 + ".isNullAt(" + index + ")) {\n               |  " + ev.isNull() + " = true;\n               |} else\n             ")) : "";
                String errorContext = this.getContextOrNullCode(ctx, this.getContextOrNullCode$default$2());
                if (this.failOnError()) {
                    object = "throw QueryExecutionErrors.invalidElementAtIndexError(" + index + ", " + eval1 + ".numElements(), " + errorContext + ");";
                } else {
                    Option<Literal> option = this.defaultValueOutOfBound();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Literal value = (Literal)some.value();
                        ExprCode defaultValueEval = value.genCode(ctx);
                        object = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                  " + defaultValueEval.code() + "\n                  " + ev.isNull() + " = " + defaultValueEval.isNull() + ";\n                  " + ev.value() + " = " + defaultValueEval.value() + ";\n                "));
                    } else if (None$.MODULE$.equals(option)) {
                        object = ev.isNull() + " = true;";
                    } else {
                        throw new MatchError(option);
                    }
                }
                String indexOutOfBoundBranch = object;
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |int " + index + " = (int) " + eval2 + ";\n             |if (" + eval1 + ".numElements() < Math.abs(" + index + ")) {\n             |  " + indexOutOfBoundBranch + "\n             |} else {\n             |  if (" + index + " == 0) {\n             |    throw QueryExecutionErrors.invalidIndexOfZeroError(" + errorContext + ");\n             |  } else if (" + index + " > 0) {\n             |    " + index + "--;\n             |  } else {\n             |    " + index + " += " + eval1 + ".numElements();\n             |  }\n             |  " + nullCheck + "\n             |  {\n             |    " + ev.value() + " = " + CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index) + ";\n             |  }\n             |}\n           "));
            });
        }
        if (dataType instanceof MapType) {
            return this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    @Override
    public ElementAt withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        if (this.failOnError() && this.left().resolved() && this.left().dataType() instanceof ArrayType) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    public ElementAt copy(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        return new ElementAt(left, right, defaultValueOutOfBound, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Literal> copy$default$3() {
        return this.defaultValueOutOfBound();
    }

    public boolean copy$default$4() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.defaultValueOutOfBound();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "defaultValueOutOfBound";
            }
            case 3: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        if (this.failOnError() != elementAt.failOnError()) return false;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Literal> option = this.defaultValueOutOfBound();
        Option<Literal> option2 = elementAt.defaultValueOutOfBound();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, Option<Literal> defaultValueOutOfBound, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.defaultValueOutOfBound = defaultValueOutOfBound;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
        SupportQueryContext.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, (Option<Literal>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

