/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unix_time[, fmt]) - Returns `unix_time` in the specified `fmt`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>\n              for valid date and time format patterns. The 'yyyy-MM-dd HH:mm:ss' pattern is used if omitted.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1969-12-31 16:00:00\n\n      > SELECT _FUNC_(0);\n       1969-12-31 16:00:00\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t]c\u0001\u0002\u0016,\u0001bB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tA\u0002\u0011\t\u0012)A\u0005;\"A\u0011\r\u0001BK\u0002\u0013\u0005A\f\u0003\u0005c\u0001\tE\t\u0015!\u0003^\u0011!\u0019\u0007A!f\u0001\n\u0003!\u0007\u0002\u00039\u0001\u0005#\u0005\u000b\u0011B3\t\u000bE\u0004A\u0011\u0001:\t\u000bE\u0004A\u0011A<\t\u000bi\u0004A\u0011\t/\t\u000bm\u0004A\u0011\t/\t\u000bq\u0004A\u0011I?\t\u000bE\u0004A\u0011\u0001@\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006!9\u00111\u0003\u0001\u0005B\u0005U\u0001bBA\u000f\u0001\u0011\u0005\u0013q\u0004\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\tI\u0004\u0001C!\u0003wAq!!\u0013\u0001\t\u0003\nY\u0005\u0003\u0004\u0002h\u0001!\t\u0006\u0018\u0005\b\u0003S\u0002A\u0011KA\u000b\u0011\u001d\tY\u0007\u0001C)\u0003[B\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005\r\u0005\"CAM\u0001E\u0005I\u0011AAB\u0011%\tY\nAI\u0001\n\u0003\ti\nC\u0005\u0002\"\u0002\t\t\u0011\"\u0011\u0002$\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0011Q\u0017\u0005\n\u0003{\u0003\u0011\u0011!C\u0001\u0003\u007fC\u0011\"!2\u0001\u0003\u0003%\t%a2\t\u0013\u0005U\u0007!!A\u0005\u0002\u0005]\u0007\"CAn\u0001\u0005\u0005I\u0011IAo\u0011%\t\t\u000fAA\u0001\n\u0003\n\u0019oB\u0005\u0003\u000e-\n\t\u0011#\u0001\u0003\u0010\u0019A!fKA\u0001\u0012\u0003\u0011\t\u0002\u0003\u0004rE\u0011\u0005!\u0011\u0006\u0005\n\u0005W\u0011\u0013\u0011!C#\u0005[A\u0011Ba\f#\u0003\u0003%\tI!\r\t\u0013\te\"%%A\u0005\u0002\u0005u\u0005\"\u0003B\u001eE\u0005\u0005I\u0011\u0011B\u001f\u0011%\u0011YEII\u0001\n\u0003\ti\nC\u0005\u0003N\t\n\t\u0011\"\u0003\u0003P\taaI]8n+:L\u0007\u0010V5nK*\u0011A&L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002/_\u0005A1-\u0019;bYf\u001cHO\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005I\u001a\u0014!B:qCJ\\'B\u0001\u001b6\u0003\u0019\t\u0007/Y2iK*\ta'A\u0002pe\u001e\u001c\u0001aE\u0004\u0001su\u00025I\u0013)\u0011\u0005iZT\"A\u0016\n\u0005qZ#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tQd(\u0003\u0002@W\tAB+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s\u0011\u0016d\u0007/\u001a:\u0011\u0005i\n\u0015B\u0001\",\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001#H\u001d\tQT)\u0003\u0002GW\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!AR\u0016\u0011\u0005-sU\"\u0001'\u000b\u00035\u000bQa]2bY\u0006L!a\u0014'\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011\u000b\u0017\b\u0003%^s!a\u0015,\u000e\u0003QS!!V\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0015B\u0001$M\u0013\tI&L\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002G\u0019\u0006\u00191/Z2\u0016\u0003u\u0003\"A\u000f0\n\u0005}[#AC#yaJ,7o]5p]\u0006!1/Z2!\u0003\u00191wN]7bi\u00069am\u001c:nCR\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\tQ\rE\u0002LM\"L!a\u001a'\u0003\r=\u0003H/[8o!\tIWN\u0004\u0002kWB\u00111\u000bT\u0005\u0003Y2\u000ba\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011A\u000eT\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005gR,h\u000f\u0005\u0002;\u0001!)1l\u0002a\u0001;\")\u0011m\u0002a\u0001;\"91m\u0002I\u0001\u0002\u0004)GcA:ys\")1\f\u0003a\u0001;\")\u0011\r\u0003a\u0001;\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002QR\u00111o \u0005\u0007\u0003\u0003a\u0001\u0019A/\u0002\tUt\u0017\u000e_\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u0018\u0002\u000bQL\b/Z:\n\t\u0005E\u00111\u0002\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002\u0018A\u00191*!\u0007\n\u0007\u0005mAJA\u0004C_>dW-\u00198\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\"A)\u0011+a\t\u0002(%\u0019\u0011Q\u0005.\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\n\u0005%\u0012\u0002BA\u0016\u0003\u0017\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\t\u0005E\u0012q\u0007\t\u0004u\u0005M\u0012bAA\u001bW\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\u0006GB\u0001\r\u0001[\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003{\t\u0019%a\u0012\u0011\u0007-\u000by$C\u0002\u0002B1\u00131!\u00118z\u0011\u001d\t)%\u0005a\u0001\u0003{\tqa]3d_:$7\u000f\u0003\u0004b#\u0001\u0007\u0011QH\u0001\nI><UM\\\"pI\u0016$b!!\u0014\u0002Z\u0005\r\u0004\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M3&A\u0004d_\u0012,w-\u001a8\n\t\u0005]\u0013\u0011\u000b\u0002\t\u000bb\u0004(oQ8eK\"9\u00111\f\nA\u0002\u0005u\u0013aA2uqB!\u0011qJA0\u0013\u0011\t\t'!\u0015\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011Q\r\nA\u0002\u00055\u0013AA3w\u000311wN]7biN#(/\u001b8h\u0003%I7\u000fU1sg&tw-A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)1/a\u001c\u0002t!1\u0011\u0011O\u000bA\u0002u\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002vU\u0001\r!X\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u001d\u0019\u00181PA?\u0003\u007fBqa\u0017\f\u0011\u0002\u0003\u0007Q\fC\u0004b-A\u0005\t\u0019A/\t\u000f\r4\u0002\u0013!a\u0001K\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAACU\ri\u0016qQ\u0016\u0003\u0003\u0013\u0003B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0013'\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00065%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003?S3!ZAD\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0016\u0001\u00026bm\u0006L1A\\AU\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\fE\u0002L\u0003sK1!a/M\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti$!1\t\u0013\u0005\rG$!AA\u0002\u0005]\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JB1\u00111ZAi\u0003{i!!!4\u000b\u0007\u0005=G*\u0001\u0006d_2dWm\u0019;j_:LA!a5\u0002N\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t9\"!7\t\u0013\u0005\rg$!AA\u0002\u0005u\u0012A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!*\u0002`\"I\u00111Y\u0010\u0002\u0002\u0003\u0007\u0011qW\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\u0011Q\u001d\u0005\n\u0003\u0007\u0004\u0013\u0011!a\u0001\u0003{As\u0003AAu\u0003_\f\t0!>\u0002x\u0006m\u0018Q B\u0001\u0005\u0007\u00119A!\u0003\u0011\u0007i\nY/C\u0002\u0002n.\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002t\u00061uLR+O\u0007~CSO\\5y?RLW.Z.-A\u0019lG/X\u0015![\u0001\u0012V\r^;s]N\u0004\u0003-\u001e8jq~#\u0018.\\3aA%t\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007\u0005\u00194ni\u0002t\u0013!C1sOVlWM\u001c;tC\t\tI0\u0001Bd\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002SO\\5y?RLW.\u001a\u0011.AUs\u0015\n\u0017\u0011US6,7\u000f^1na\u0002\"x\u000e\t2fA\r|gN^3si\u0016$\u0007\u0005^8!i\",\u0007\u0005\u001d:pm&$W\r\u001a\u0011g_Jl\u0017\r\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0019lG\u000fI\u0017!\t\u0006$Xm\f;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC-\u0019;fi&lW-\f9biR,'O\u001c\u0018ii6d'E\u0010#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011g_J\u0004c/\u00197jI\u0002\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001ch\u0006\t+iK\u0002:\u00130_=z[5kU\u0006\u001a3!\u0011\"ST.\u001c\u001etg\u001e\u0002\u0003/\u0019;uKJt\u0007%[:!kN,G\rI5gA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q`\u0001\u0002()\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003\u0007\f\u0011(sfL\u00180L'N[\u0011$\u0007\u0005\u0013%;[6T4o]\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0014HN\u001d.cIj3'\r\u00112mi\u0002\u0004G\u000f\u00191\u0015)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0003'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!ce2\u0014(L\u00193[M\n\u0004%\r\u001c;aAR\u0004\u0007\r\u0006!A\u0005)qM]8va\u0006\u0012!QA\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011Y!A\u00032]Ur\u0003'\u0001\u0007Ge>lWK\\5y)&lW\r\u0005\u0002;EM)!Ea\u0005\u0003 AA!Q\u0003B\u000e;v+7/\u0004\u0002\u0003\u0018)\u0019!\u0011\u0004'\u0002\u000fI,h\u000e^5nK&!!Q\u0004B\f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!QEAW\u0003\tIw.C\u0002Z\u0005G!\"Aa\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!*\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fM\u0014\u0019D!\u000e\u00038!)1,\na\u0001;\")\u0011-\na\u0001;\"91-\nI\u0001\u0002\u0004)\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0002\u000fUt\u0017\r\u001d9msR!!q\bB$!\u0011YeM!\u0011\u0011\r-\u0013\u0019%X/f\u0013\r\u0011)\u0005\u0014\u0002\u0007)V\u0004H.Z\u001a\t\u0011\t%s%!AA\u0002M\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u000b\t\u0005\u0003O\u0013\u0019&\u0003\u0003\u0003V\u0005%&AB(cU\u0016\u001cG\u000f")
public class FromUnixTime
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime x$0) {
        return FromUnixTime$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatterOption$lzycompute();
        }
        return this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object seconds, Object format) {
        TimestampFormatter fmt = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)fmt.format(BoxesRunTime.unboxToLong((Object)seconds) * 1000000L));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable)f -> {
            String formatterName = ctx.addReferenceObj("formatter", f, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(seconds, x$4) -> "UTF8String.fromString(" + formatterName + ".format(" + seconds + " * 1000000L))");
        }).getOrElse((Function0 & Serializable)() -> {
            String tf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName()), "$");
            String ldf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName()), "$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(seconds, format) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |UTF8String.fromString(\n           |  " + tf + "$.MODULE$.apply(" + format + ".toString(),\n           |  " + zid + ",\n           |  " + ldf + "$.MODULE$.SIMPLE_DATE_FORMAT(),\n           |  false).format(" + seconds + " * 1000000L))\n           |")));
        });
    }

    @Override
    public Expression formatString() {
        return this.format();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public FromUnixTime withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public FromUnixTime copy(Expression sec, Expression format, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sec();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sec";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    public FromUnixTime(Expression sec, Expression format, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public FromUnixTime(Expression sec, Expression format) {
        this(sec, format, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply(TimestampFormatter$.MODULE$.defaultPattern()));
    }
}

