/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.GetJsonObjectEvaluator;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n  ", group="json_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u0011#\u0001>B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011K\u0011\u00159\u0006\u0001\"\u0011K\u0011\u0015A\u0006\u0001\"\u0011Z\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015i\u0007\u0001\"\u0011o\u0011!9\b\u0001#b\u0001\n\u0013A\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003/\u0001A\u0011CA\r\u0011\u001d\t)\u0004\u0001C)\u0003oA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0003\"CA1\u0001E\u0005I\u0011AA&\u0011%\t\u0019\u0007AA\u0001\n\u0003\n)\u0007C\u0005\u0002v\u0001\t\t\u0011\"\u0001\u0002x!I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0011\u0005\n\u0003\u000f\u0003\u0011\u0011!C!\u0003\u0013C\u0011\"a&\u0001\u0003\u0003%\t!!'\t\u0013\u0005u\u0005!!A\u0005B\u0005}\u0005\"CAR\u0001\u0005\u0005I\u0011IAS\u000f%\tIMIA\u0001\u0012\u0003\tYM\u0002\u0005\"E\u0005\u0005\t\u0012AAg\u0011\u0019\t6\u0004\"\u0001\u0002f\"I\u0011q]\u000e\u0002\u0002\u0013\u0015\u0013\u0011\u001e\u0005\n\u0003W\\\u0012\u0011!CA\u0003[D\u0011\"a=\u001c\u0003\u0003%\t)!>\t\u0013\t\u001d1$!A\u0005\n\t%!!D$fi*\u001bxN\\(cU\u0016\u001cGO\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0007N\u001c>!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0011'N\u0005\u0003m\t\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"/\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(\u0001\u0003kg>tW#A&\u0011\u0005Eb\u0015BA'#\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006UN|g\u000eI\u0001\u0005a\u0006$\b.A\u0003qCRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004'R+\u0006CA\u0019\u0001\u0011\u0015IU\u00011\u0001L\u0011\u0015yU\u00011\u0001L\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001[!\rq4,X\u0005\u00039\"\u00131aU3r!\tq\u0016-D\u0001`\u0015\t\u0001g%A\u0003usB,7/\u0003\u0002c?\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\tQ\r\u0005\u0002_M&\u0011qm\u0018\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001k!\tA4.\u0003\u0002ms\t9!i\\8mK\u0006t\u0017A\u00039sKR$\u0018PT1nKV\tq\u000e\u0005\u0002qi:\u0011\u0011O\u001d\t\u0003\u0001fJ!a]\u001d\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gf\n\u0011\"\u001a<bYV\fGo\u001c:\u0016\u0003e\u0004\"!\r>\n\u0005m\u0014#AF$fi*\u001bxN\\(cU\u0016\u001cG/\u0012<bYV\fGo\u001c:)\u00051i\bC\u0001\u001d\u007f\u0013\ty\u0018HA\u0005ue\u0006t7/[3oi\u0006!QM^1m)\u0011\t)!a\u0003\u0011\u0007a\n9!C\u0002\u0002\ne\u00121!\u00118z\u0011%\ti!\u0004I\u0001\u0002\u0004\ty!A\u0003j]B,H\u000f\u0005\u0003\u0002\u0012\u0005MQ\"\u0001\u0013\n\u0007\u0005UAEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tY\"a\n\u00022A!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"\t\nqaY8eK\u001e,g.\u0003\u0003\u0002&\u0005}!\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005%b\u00021\u0001\u0002,\u0005\u00191\r\u001e=\u0011\t\u0005u\u0011QF\u0005\u0005\u0003_\tyB\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005Mb\u00021\u0001\u0002\u001c\u0005\u0011QM^\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$RaUA\u001d\u0003{Aa!a\u000f\u0010\u0001\u0004Y\u0015a\u00028fo2+g\r\u001e\u0005\u0007\u0003\u007fy\u0001\u0019A&\u0002\u00119,wOU5hQR\fAaY8qsR)1+!\u0012\u0002H!9\u0011\n\u0005I\u0001\u0002\u0004Y\u0005bB(\u0011!\u0003\u0005\raS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiEK\u0002L\u0003\u001fZ#!!\u0015\u0011\t\u0005M\u0013QL\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037J\u0014AC1o]>$\u0018\r^5p]&!\u0011qLA+\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0014\u0001\u00026bm\u0006L1!^A6\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\bE\u00029\u0003wJ1!! :\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t)!a!\t\u0013\u0005\u0015U#!AA\u0002\u0005e\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fB1\u0011QRAJ\u0003\u000bi!!a$\u000b\u0007\u0005E\u0015(\u0001\u0006d_2dWm\u0019;j_:LA!!&\u0002\u0010\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ\u00171\u0014\u0005\n\u0003\u000b;\u0012\u0011!a\u0001\u0003\u000b\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qMAQ\u0011%\t)\tGA\u0001\u0002\u0004\tI(\u0001\u0004fcV\fGn\u001d\u000b\u0004U\u0006\u001d\u0006\"CAC3\u0005\u0005\t\u0019AA\u0003QM\u0001\u00111VAY\u0003g\u000b9,!/\u0002>\u0006}\u00161YAc!\r\t\u0014QV\u0005\u0004\u0003_\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003k\u000bAh\u0018$V\u001d\u000e{\u0006F[:p]~#\b\u0010\u001e\u0017!a\u0006$\b.\u000b\u0011.A\u0015CHO]1diN\u0004\u0013\r\t6t_:\u0004sN\u00196fGR\u0004cM]8nA\u0001\u0004\u0018\r\u001e5a]\u0005AQ\r_1na2,7/\t\u0002\u0002<\u0006)%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014|E\u0005\u0014#H\t2#{\u001eb\u0003e\n\u0013/C\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t2\u000bA\u0001\nQa\u001a:pkB\f#!!1\u0002\u0015)\u001cxN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002H\u0006)\u0011GL\u001b/a\u0005iq)\u001a;Kg>twJ\u00196fGR\u0004\"!M\u000e\u0014\u000bm\ty-a7\u0011\u000f\u0005E\u0017q[&L'6\u0011\u00111\u001b\u0006\u0004\u0003+L\u0014a\u0002:v]RLW.Z\u0005\u0005\u00033\f\u0019NA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!!8\u0002d6\u0011\u0011q\u001c\u0006\u0005\u0003C\fy'\u0001\u0002j_&\u0019q)a8\u0015\u0005\u0005-\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0014!B1qa2LH#B*\u0002p\u0006E\b\"B%\u001f\u0001\u0004Y\u0005\"B(\u001f\u0001\u0004Y\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u0014\u0019\u0001E\u00039\u0003s\fi0C\u0002\u0002|f\u0012aa\u00149uS>t\u0007#\u0002\u001d\u0002\u0000.[\u0015b\u0001B\u0001s\t1A+\u001e9mKJB\u0001B!\u0002 \u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0006!\u0011\tIG!\u0004\n\t\t=\u00111\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
Serializable {
    private transient GetJsonObjectEvaluator evaluator;
    private final Expression json;
    private final Expression path;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject x$0) {
        return GetJsonObject$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private GetJsonObjectEvaluator evaluator$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.evaluator = this.path().foldable() ? new GetJsonObjectEvaluator((UTF8String)this.path().eval(this.path().eval$default$1())) : new GetJsonObjectEvaluator();
                this.bitmap$trans$0 = true;
            }
        }
        return this.evaluator;
    }

    private GetJsonObjectEvaluator evaluator() {
        if (!this.bitmap$trans$0) {
            return this.evaluator$lzycompute();
        }
        return this.evaluator;
    }

    @Override
    public Object eval(InternalRow input) {
        block0: {
            this.evaluator().setJson((UTF8String)this.json().eval(input));
            if (this.path().foldable()) break block0;
            this.evaluator().setPath((UTF8String)this.path().eval(input));
        }
        return this.evaluator().evaluate();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        String evaluatorClass = GetJsonObjectEvaluator.class.getName();
        boolean bl = this.path().foldable();
        if (bl && this.path().eval(this.path().eval$default$1()) != null) {
            UTF8String cachedPath = (UTF8String)this.path().eval(this.path().eval$default$1());
            String refCachedPath = ctx.addReferenceObj("cachedPath", cachedPath, ctx.addReferenceObj$default$3());
            string = "new " + evaluatorClass + "(" + refCachedPath + ")";
        } else {
            string = "new " + evaluatorClass + "()";
        }
        String initEvaluator = string;
        String evaluator = ctx.addMutableState(evaluatorClass, "evaluator", (Function1<String, String>)(Function1 & Serializable)v -> v + " = " + initEvaluator + ";", true, ctx.addMutableState$default$5());
        ExprCode jsonEval = this.json().genCode(ctx);
        ExprCode pathEval = this.path().genCode(ctx);
        String setJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + jsonEval.isNull() + ") {\n         |  " + evaluator + ".setJson(null);\n         |} else {\n         |  " + evaluator + ".setJson(" + jsonEval.value() + ");\n         |}\n         |"));
        String setPath = !this.path().foldable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + pathEval.isNull() + ") {\n         |  " + evaluator + ".setPath(null);\n         |} else {\n         |  " + evaluator + ".setPath(" + pathEval.value() + ");\n         |}\n         |")) : "";
        String resultType = CodeGenerator$.MODULE$.boxedType(this.dataType());
        String resultTerm = ctx.freshName("result");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", "\n         |", "\n         |", " ", " = (", ") ", ".evaluate();\n         |boolean ", " = ", " == null;\n         |", " ", " = ", ";\n         |if (!", ") {\n         |  ", " = ", ";\n         |}\n         |"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{jsonEval.code(), pathEval.code(), setJson, setPath, resultType, resultTerm, resultType, evaluator, ev.isNull(), resultTerm, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), resultTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public GetJsonObject withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.json();
            }
            case 1: {
                return this.path();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "json";
            }
            case 1: {
                return "path";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes.$init$(this);
    }
}

