/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GreaterThan$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is greater than `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       true\n      > SELECT 2 _FUNC_ 1.1;\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       false\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       false\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u0015a\u0006\u0001\"\u0015^\u0011\u0015)\u0007\u0001\"\u0015g\u0011\u001dY\u0007!!A\u0005\u00021Dqa\u001c\u0001\u0012\u0002\u0013\u0005\u0001\u000fC\u0004|\u0001E\u0005I\u0011\u00019\t\u000fq\u0004\u0011\u0011!C!{\"I\u00111\u0002\u0001\u0002\u0002\u0013\u0005\u0011Q\u0002\u0005\n\u0003+\u0001\u0011\u0011!C\u0001\u0003/A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\ty\u0004AA\u0001\n\u0003\n\teB\u0005\u0002lm\t\t\u0011#\u0001\u0002n\u0019A!dGA\u0001\u0012\u0003\ty\u0007\u0003\u0004N)\u0011\u0005\u0011q\u0011\u0005\n\u0003\u0013#\u0012\u0011!C#\u0003\u0017C\u0011\"!$\u0015\u0003\u0003%\t)a$\t\u0013\u0005UE#!A\u0005\u0002\u0006]\u0005\"CAU)\u0005\u0005I\u0011BAV\u0005-9%/Z1uKJ$\u0006.\u00198\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0015.ii\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003!\tKg.\u0019:z\u0007>l\u0007/\u0019:jg>t\u0007C\u0001\u00182\u001d\tQs&\u0003\u000217\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001M\u000e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\u000fA\u0013x\u000eZ;diB\u00111H\u0011\b\u0003y\u0005s!!\u0010!\u000e\u0003yR!aP\u0014\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0014B\u0001\u00197\u0013\t\u0019EI\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u00021m\u0005!A.\u001a4u+\u00059\u0005C\u0001\u0016I\u0013\tI5D\u0001\u0006FqB\u0014Xm]:j_:\fQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002P!F\u0003\"A\u000b\u0001\t\u000b\u0015+\u0001\u0019A$\t\u000b-+\u0001\u0019A$\u0002\rMLXNY8m+\u0005!\u0006CA+Z\u001d\t1v\u000b\u0005\u0002>m%\u0011\u0001LN\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Ym\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u0019a,Y2\u0011\u0005Uz\u0016B\u000117\u0005\r\te.\u001f\u0005\u0006E\u001e\u0001\rAX\u0001\u0007S:\u0004X\u000f^\u0019\t\u000b\u0011<\u0001\u0019\u00010\u0002\r%t\u0007/\u001e;3\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002HO&DQ\u0001\u001b\u0005A\u0002\u001d\u000bqA\\3x\u0019\u00164G\u000fC\u0003k\u0011\u0001\u0007q)\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0007=kg\u000eC\u0004F\u0013A\u0005\t\u0019A$\t\u000f-K\u0001\u0013!a\u0001\u000f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A9+\u0005\u001d\u00138&A:\u0011\u0005QLX\"A;\u000b\u0005Y<\u0018!C;oG\",7m[3e\u0015\tAh'\u0001\u0006b]:|G/\u0019;j_:L!A_;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005q\bcA@\u0002\n5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003mC:<'BAA\u0004\u0003\u0011Q\u0017M^1\n\u0007i\u000b\t!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0010A\u0019Q'!\u0005\n\u0007\u0005MaGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002_\u00033A\u0011\"a\u0007\u000f\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0003E\u0003\u0002$\u0005%b,\u0004\u0002\u0002&)\u0019\u0011q\u0005\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0015\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\r\u00028A\u0019Q'a\r\n\u0007\u0005UbGA\u0004C_>dW-\u00198\t\u0011\u0005m\u0001#!AA\u0002y\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u0019a0!\u0010\t\u0013\u0005m\u0011#!AA\u0002\u0005=\u0011AB3rk\u0006d7\u000f\u0006\u0003\u00022\u0005\r\u0003\u0002CA\u000e%\u0005\u0005\t\u0019\u00010)/\u0001\t9%!\u0014\u0002P\u0005M\u0013QKA-\u00037\ny&!\u0019\u0002f\u0005\u001d\u0004c\u0001\u0016\u0002J%\u0019\u00111J\u000e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011K\u0001FKb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u0002W\r\u001f9sc\u0001\u0004\u0013n\u001d\u0011he\u0016\fG/\u001a:!i\"\fg\u000e\t1fqB\u0014(\u0007\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA,\u0003\tM%\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002z'\u000fZ3sK\u0012t\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002S.\u00199!if\u0004X\rI5tA9|G\u000fI8sI\u0016\u0014\u0018M\u00197fY\u0001\u001ax\u000eI5u\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%[:!]>$\be];qa>\u0014H/\u001a3/A\u0019{'\u000fI2p[BdW\r\u001f\u0011usB,7\u000fI:vG\"\u0004\u0013M\u001d:bs>\u001aHO];di2\u0002C\u000f[3!I\u0006$\u0018\r\t;za\u0016\u001c\be\u001c4!M&,G\u000eZ:![V\u001cHO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\t,\u0007e\u001c:eKJ\f'\r\\3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0013Aa(\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UAI\u0002sLR+O\u0007~\u0003\u0013g\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t\u001a!?\u001a+fjQ0!c9\n4H\u0003\u0011!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006\u0005^8`I\u0006$X\rK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015!?\u001a+fjQ0!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.aaj\u0003'\r\u00111ii\ntGO\u001b3O%Z$\u0002\t\u0011!A\u0001\u0002\u0003EZ1mg\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\r\u0011`\rVs5i\u0018\u0011O+2c5H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003G\nQ!\r\u00181]A\nQa\u001a:pkB\f#!!\u001b\u0002\u001fA\u0014X\rZ5dCR,wLZ;oGN\f1b\u0012:fCR,'\u000f\u00165b]B\u0011!\u0006F\n\u0006)\u0005E\u0014Q\u0010\t\b\u0003g\nIhR$P\u001b\t\t)HC\u0002\u0002xY\nqA];oi&lW-\u0003\u0003\u0002|\u0005U$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qPAC\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0011AA5p\u0013\r\u0019\u0015\u0011\u0011\u000b\u0003\u0003[\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002}\u0006)\u0011\r\u001d9msR)q*!%\u0002\u0014\")Qi\u0006a\u0001\u000f\")1j\u0006a\u0001\u000f\u00069QO\\1qa2LH\u0003BAM\u0003K\u0003R!NAN\u0003?K1!!(7\u0005\u0019y\u0005\u000f^5p]B)Q'!)H\u000f&\u0019\u00111\u0015\u001c\u0003\rQ+\b\u000f\\33\u0011!\t9\u000bGA\u0001\u0002\u0004y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011Q\u0016\t\u0004\u007f\u0006=\u0016\u0002BAY\u0003\u0003\u0011aa\u00142kK\u000e$\b")
public class GreaterThan
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(GreaterThan x$0) {
        return GreaterThan$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, GreaterThan> tupled() {
        return GreaterThan$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GreaterThan>> curried() {
        return GreaterThan$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return ">";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().gt(input1, input2));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GreaterThan copy(Expression left, Expression right) {
        return new GreaterThan(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "GreaterThan";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GreaterThan;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GreaterThan)) return false;
        boolean bl = true;
        if (!bl) return false;
        GreaterThan greaterThan = (GreaterThan)x$1;
        Expression expression = this.left();
        Expression expression2 = greaterThan.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = greaterThan.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!greaterThan.canEqual(this)) return false;
        return true;
    }

    public GreaterThan(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

