/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t]q!\u0002\u0011\"\u0011\u0003qc!\u0002\u0019\"\u0011\u0003\t\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%ia\u0011\u0005\u0007\u0015\u0006\u0001\u000bQ\u0002#\t\u000f-\u000b!\u0019!C\u0001\u0007\"1A*\u0001Q\u0001\n\u0011CQ!T\u0001\u0005\u00029CQ!T\u0001\u0005\u0002eCQaX\u0001\u0005\u0002\u0001DQaX\u0001\u0005\u0002\tDq\u0001]\u0001\u0002\u0002\u0013\u0005\u0015\u000fC\u0005\u0002\u0000\u0006\t\t\u0011\"!\u0003\u0002!I!QB\u0001\u0002\u0002\u0013%!q\u0002\u0004\u0005a\u0005\u00025\u000f\u0003\u0006\u0002\u00189\u0011)\u001a!C\u0001\u00033A!\"!\t\u000f\u0005#\u0005\u000b\u0011BA\u000e\u0011\u0019\u0001e\u0002\"\u0001\u0002$!9\u0011q\u0005\b\u0005B\u0005%\u0002bBA\u001e\u001d\u0011\u0005\u0013Q\b\u0005\b\u0003\u000brA\u0011KA$\u0011\u001d\t\tF\u0004C)\u0003'Bq!a\u001c\u000f\t#\n\t\bC\u0005\u0002x9\t\t\u0011\"\u0001\u0002z!I\u0011Q\u0010\b\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003+s\u0011\u0011!C!\u0003/C\u0011\"a)\u000f\u0003\u0003%\t!!*\t\u0013\u00055f\"!A\u0005\u0002\u0005=\u0006\"CA[\u001d\u0005\u0005I\u0011IA\\\u0011%\t)MDA\u0001\n\u0003\t9\rC\u0005\u0002R:\t\t\u0011\"\u0011\u0002T\"I\u0011q\u001b\b\u0002\u0002\u0013\u0005\u0013\u0011\\\u0001\u0004\u0011\u0016D(B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005=\nQ\"A\u0011\u0003\u0007!+\u0007pE\u0002\u0002ea\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0007CA\u001d?\u001b\u0005Q$BA\u001e=\u0003\tIwNC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001/\u0003%AW\r\u001f#jO&$8/F\u0001E!\r\u0019TiR\u0005\u0003\rR\u0012Q!\u0011:sCf\u0004\"a\r%\n\u0005%#$\u0001\u0002\"zi\u0016\f!\u0002[3y\t&<\u0017\u000e^:!\u0003-)h\u000e[3y\t&<\u0017\u000e^:\u0002\u0019Ut\u0007.\u001a=ES\u001eLGo\u001d\u0011\u0002\u0007!,\u0007\u0010\u0006\u0002P/B\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0006if\u0004Xm\u001d\u0006\u0003)\u001e\na!\u001e8tC\u001a,\u0017B\u0001,R\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u00061\u001e\u0001\r\u0001R\u0001\u0006Ef$Xm\u001d\u000b\u0003\u001fjCQa\u0017\u0005A\u0002q\u000b1A\\;n!\t\u0019T,\u0003\u0002_i\t!Aj\u001c8h\u0003\u0015)h\u000e[3y)\t!\u0015\rC\u0003Y\u0013\u0001\u0007A\t\u0006\u0002EG\")AM\u0003a\u0001K\u0006\u00191\u000f\u001e:\u0011\u0005\u0019lgBA4l!\tAG'D\u0001j\u0015\tQW&\u0001\u0004=e>|GOP\u0005\u0003YR\na\u0001\u0015:fI\u00164\u0017B\u00018p\u0005\u0019\u0019FO]5oO*\u0011A\u000eN\u0001\u0006CB\u0004H.\u001f\u000b\u0004e\u0006u\bCA\u0018\u000f'!qAo\u001e>\u0002\u0004\u0005%\u0001CA\u0018v\u0013\t1\u0018EA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ty\u00030\u0003\u0002zC\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002|}:\u0011q\u0006`\u0005\u0003{\u0006\nq\u0001]1dW\u0006<W-C\u0002\u0000\u0003\u0003\u0011aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002~CA\u00191'!\u0002\n\u0007\u0005\u001dAGA\u0004Qe>$Wo\u0019;\u0011\t\u0005-\u00111\u0003\b\u0005\u0003\u001b\t\tBD\u0002i\u0003\u001fI\u0011!N\u0005\u0003{RJ1aPA\u000b\u0015\tiH'A\u0003dQ&dG-\u0006\u0002\u0002\u001cA\u0019q&!\b\n\u0007\u0005}\u0011E\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004Cc\u0001:\u0002&!9\u0011qC\tA\u0002\u0005m\u0011AC5oaV$H+\u001f9fgV\u0011\u00111\u0006\t\u0007\u0003\u0017\ti#!\r\n\t\u0005=\u0012Q\u0003\u0002\u0004'\u0016\f\b\u0003BA\u001a\u0003oi!!!\u000e\u000b\u0005I+\u0013\u0002BA\u001d\u0003k\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a\u0010\u0011\t\u0005M\u0012\u0011I\u0005\u0005\u0003\u0007\n)D\u0001\u0005ECR\fG+\u001f9f\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0011\tI%a\u0014\u0011\u0007M\nY%C\u0002\u0002NQ\u00121!\u00118z\u0011\u0019YF\u00031\u0001\u0002J\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003+\n\t'a\u001b\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017\"\u0003\u001d\u0019w\u000eZ3hK:LA!a\u0018\u0002Z\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0002dU\u0001\r!!\u001a\u0002\u0007\r$\b\u0010\u0005\u0003\u0002X\u0005\u001d\u0014\u0002BA5\u00033\u0012abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002nU\u0001\r!!\u0016\u0002\u0005\u00154\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002s\u0003gBq!!\u001e\u0017\u0001\u0004\tY\"\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007I\fY\bC\u0005\u0002\u0018]\u0001\n\u00111\u0001\u0002\u001c\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAAU\u0011\tY\"a!,\u0005\u0005\u0015\u0005\u0003BAD\u0003#k!!!#\u000b\t\u0005-\u0015QR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a$5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\u000bIIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAPy\u0005!A.\u00198h\u0013\rq\u0017QT\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003O\u00032aMAU\u0013\r\tY\u000b\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\n\t\fC\u0005\u00024n\t\t\u00111\u0001\u0002(\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!/\u0011\r\u0005m\u0016\u0011YA%\u001b\t\tiLC\u0002\u0002@R\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019-!0\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\fy\rE\u00024\u0003\u0017L1!!45\u0005\u001d\u0011un\u001c7fC:D\u0011\"a-\u001e\u0003\u0003\u0005\r!!\u0013\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u00033\u000b)\u000eC\u0005\u00024z\t\t\u00111\u0001\u0002(\u00061Q-];bYN$B!!3\u0002\\\"I\u00111W\u0010\u0002\u0002\u0003\u0007\u0011\u0011\n\u0015\u0014\u001d\u0005}\u0017Q]At\u0003W\fi/!=\u0002t\u0006]\u0018\u0011 \t\u0004_\u0005\u0005\u0018bAArC\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAu\u00039zf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u00023i\u001c8wKJ$8\u000f\t1fqB\u0014\b\r\t;pA!,\u00070\u00193fG&l\u0017\r\u001c\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a<\u0002i*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013gN\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\n$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001b4oA2\u0014g\u000e\u001a7\u0005J\u0002TgM\u001b2i\rS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003k\fQ!\r\u00186]A\nQa\u001a:pkB\f#!a?\u0002\u00155\fG\u000f[0gk:\u001c7\u000fC\u0004\u0002\u0018-\u0001\r!a\u0007\u0002\u000fUt\u0017\r\u001d9msR!!1\u0001B\u0005!\u0015\u0019$QAA\u000e\u0013\r\u00119\u0001\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\t-A\"!AA\u0002I\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\t\u0002\u0005\u0003\u0002\u001c\nM\u0011\u0002\u0002B\u000b\u0003;\u0013aa\u00142kK\u000e$\b")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex x$0) {
        return Hex$.MODULE$.unapply(x$0);
    }

    public static byte[] unhex(String str) {
        return Hex$.MODULE$.unhex(str);
    }

    public static byte[] unhex(byte[] bytes) {
        return Hex$.MODULE$.unhex(bytes);
    }

    public static UTF8String hex(long num) {
        return Hex$.MODULE$.hex(num);
    }

    public static UTF8String hex(byte[] bytes) {
        return Hex$.MODULE$.hex(bytes);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringTypeAnyCollation$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        DataType dataType = this.child().dataType();
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return stringType;
        }
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public Object nullSafeEval(Object num) {
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return Hex$.MODULE$.hex((byte[])num);
        }
        if (dataType instanceof StringType) {
            return Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> {
            DataType dataType;
            String hex = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName()), "$");
            return ev.value() + " = " + ((dataType = this.child().dataType()) instanceof StringType ? hex + ".hex(" + c + ".getBytes());" : hex + ".hex(" + c + ");");
        });
    }

    @Override
    public Hex withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

