/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ILike$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="str _FUNC_ pattern[ ESCAPE escape] - Returns true if str matches `pattern` with `escape` case-insensitively, null if any arguments are null, false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * pattern - a string expression. The pattern is a string which is matched literally and\n          case-insensitively, with exception to the following special symbols:<br><br>\n          _ matches any one character in the input (similar to . in posix regular expressions)<br><br>\n          % matches zero or more characters in the input (similar to .* in posix regular\n          expressions)<br><br>\n          Since Spark 2.0, string literals are unescaped in our SQL parser, see the unescaping\n          rules at <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#string-literal\">String Literal</a>.\n          For example, in order to match \"\\abc\", the pattern should be \"\\\\abc\".<br><br>\n          When SQL config 'spark.sql.parser.escapedStringLiterals' is enabled, it falls back\n          to Spark 1.6 behavior regarding string literal parsing. For example, if the config is\n          enabled, the pattern to match \"\\abc\" should be \"\\abc\".<br><br>\n          It's recommended to use a raw string literal (with the `r` prefix) to avoid escaping\n          special characters in the pattern string if exists.\n      * escape - an character added since Spark 3.0. The default escape character is the '\\'.\n          If an escape character precedes a special symbol or another escape character, the\n          following character is matched literally. It is invalid to escape any other character.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', '_Park');\n      true\n      > SELECT '\\\\abc' AS S, S _FUNC_ r'\\\\abc', S _FUNC_ '\\\\\\\\abc';\n      \\abc\ttrue\ttrue\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT '%SystemDrive%\\Users\\John' _FUNC_ '\\%SystemDrive\\%\\\\users%';\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT '%SystemDrive%\\\\USERS\\\\John' _FUNC_ r'%SystemDrive%\\\\Users%';\n      true\n      > SELECT '%SystemDrive%/Users/John' _FUNC_ '/%SYSTEMDrive/%//Users%' ESCAPE '/';\n      true\n  ", note="\n    Use RLIKE to match with standard regular expressions.\n  ", since="3.3.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\u0010!\u00016B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t%\u0002\u0011\t\u0012)A\u0005]!A1\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003/\u0011!)\u0006A!f\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B,\t\u000bm\u0003A\u0011\u0001/\t\u000bm\u0003A\u0011A1\t\u0011\u0015\u0004\u0001R1A\u0005BECQa\u0017\u0001\u0005\u0002\u0019DQ!\u001b\u0001\u0005B)DQ\u0001\u001e\u0001\u0005RUDqA\u001f\u0001\u0002\u0002\u0013\u00051\u0010\u0003\u0005\u0000\u0001E\u0005I\u0011AA\u0001\u0011%\t9\u0002AI\u0001\n\u0003\t\t\u0001C\u0005\u0002\u001a\u0001\t\n\u0011\"\u0001\u0002\u001c!I\u0011q\u0004\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0005\u0005\n\u0003g\u0001\u0011\u0011!C\u0001\u0003kA\u0011\"!\u0010\u0001\u0003\u0003%\t!a\u0010\t\u0013\u0005-\u0003!!A\u0005B\u00055\u0003\"CA.\u0001\u0005\u0005I\u0011AA/\u0011%\t9\u0007AA\u0001\n\u0003\nI\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0011\u0002p\u001dI\u0011q\u0014\u0011\u0002\u0002#\u0005\u0011\u0011\u0015\u0004\t?\u0001\n\t\u0011#\u0001\u0002$\"11,\u0007C\u0001\u0003wC\u0011\"!0\u001a\u0003\u0003%)%a0\t\u0013\u0005\u0005\u0017$!A\u0005\u0002\u0006\r\u0007\"CAf3\u0005\u0005I\u0011QAg\u0011%\ty.GA\u0001\n\u0013\t\tOA\u0003J\u0019&\\WM\u0003\u0002\"E\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0019C%\u0001\u0005dCR\fG._:u\u0015\t)c%A\u0002tc2T!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\u0002\u0001'\u001d\u0001aFM\u001b9}\u0011\u0003\"a\f\u0019\u000e\u0003\u0001J!!\r\u0011\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00020g%\u0011A\u0007\t\u0002\u0013%VtG/[7f%\u0016\u0004H.Y2fC\ndW\r\u0005\u00020m%\u0011q\u0007\t\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019\u0011\b\u0010\u0018\u000e\u0003iR!a\u000f\u0012\u0002\u000bQ\u0014X-Z:\n\u0005uR$A\u0003\"j]\u0006\u0014\u0018\u0010T5lKB\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n9\u0001K]8ek\u000e$\bCA#N\u001d\t15J\u0004\u0002H\u00156\t\u0001J\u0003\u0002JY\u00051AH]8pizJ\u0011!Q\u0005\u0003\u0019\u0002\u000bq\u0001]1dW\u0006<W-\u0003\u0002O\u001f\na1+\u001a:jC2L'0\u00192mK*\u0011A\nQ\u0001\u0005Y\u00164G/F\u0001/\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u0005QQm]2ba\u0016\u001c\u0005.\u0019:\u0016\u0003]\u0003\"a\u0010-\n\u0005e\u0003%\u0001B\"iCJ\f1\"Z:dCB,7\t[1sA\u00051A(\u001b8jiz\"B!\u00180`AB\u0011q\u0006\u0001\u0005\u0006!\u001e\u0001\rA\f\u0005\u0006'\u001e\u0001\rA\f\u0005\u0006+\u001e\u0001\ra\u0016\u000b\u0005;\n\u001cG\rC\u0003Q\u0011\u0001\u0007a\u0006C\u0003T\u0011\u0001\u0007a\u0006C\u0003V\u0011\u0001\u0007a&A\u0006sKBd\u0017mY3nK:$HcA/hQ\")\u0001K\u0003a\u0001]!)1K\u0003a\u0001]\u0005Q\u0011N\u001c9viRK\b/Z:\u0016\u0003-\u00042!\u00127o\u0013\tiwJA\u0002TKF\u0004\"a\u001c:\u000e\u0003AT!!\u001d\u0013\u0002\u000bQL\b/Z:\n\u0005M\u0004(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002/mbDQa\u001e\u0007A\u00029\nqA\\3x\u0019\u00164G\u000fC\u0003z\u0019\u0001\u0007a&\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\tucXP \u0005\b!6\u0001\n\u00111\u0001/\u0011\u001d\u0019V\u0002%AA\u00029Bq!V\u0007\u0011\u0002\u0003\u0007q+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\r!f\u0001\u0018\u0002\u0006-\u0012\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0012\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0004\u0016\u0004/\u0006\u0015\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002$A!\u0011QEA\u0018\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001\u00027b]\u001eT!!!\f\u0002\t)\fg/Y\u0005\u0005\u0003c\t9C\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003o\u00012aPA\u001d\u0013\r\tY\u0004\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0003\n9\u0005E\u0002@\u0003\u0007J1!!\u0012A\u0005\r\te.\u001f\u0005\n\u0003\u0013\u001a\u0012\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA(!\u0019\t\t&a\u0016\u0002B5\u0011\u00111\u000b\u0006\u0004\u0003+\u0002\u0015AC2pY2,7\r^5p]&!\u0011\u0011LA*\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005}\u0013Q\r\t\u0004\u007f\u0005\u0005\u0014bAA2\u0001\n9!i\\8mK\u0006t\u0007\"CA%+\u0005\u0005\t\u0019AA!\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\r\u00121\u000e\u0005\n\u0003\u00132\u0012\u0011!a\u0001\u0003o\ta!Z9vC2\u001cH\u0003BA0\u0003cB\u0011\"!\u0013\u0018\u0003\u0003\u0005\r!!\u0011)7\u0001\t)(a\u001f\u0002~\u0005\u0005\u00151QAD\u0003\u0013\u000bi)a$\u0002\u0014\u0006U\u0015\u0011TAN!\ry\u0013qO\u0005\u0004\u0003s\u0002#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u007f\n\u00111H:ue\u0002zf)\u0016(D?\u0002\u0002\u0018\r\u001e;fe:\\\u0006%R*D\u0003B+\u0005%Z:dCB,W\fI\u0017!%\u0016$XO\u001d8tAQ\u0014X/\u001a\u0011jM\u0002\u001aHO\u001d\u0011nCR\u001c\u0007.Z:!AB\fG\u000f^3s]\u0002\u0004s/\u001b;iA\u0001,7oY1qK\u0002\u00043-Y:f[%t7/\u001a8tSRLg/\u001a7zY\u0001rW\u000f\u001c7!S\u001a\u0004\u0013M\\=!CJ<W/\\3oiN\u0004\u0013M]3!]VdG\u000e\f\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u000b\u000b1\u0012\u000f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!a\u0006$H/\u001a:oA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:\u0002C\u000b[3!a\u0006$H/\u001a:oA%\u001c\b%\u0019\u0011tiJLgn\u001a\u0011xQ&\u001c\u0007\u000eI5tA5\fGo\u00195fI\u0002b\u0017\u000e^3sC2d\u0017\u0010I1oI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I2bg\u0016l\u0013N\\:f]NLG/\u001b<fYfd\u0003e^5uQ\u0002*\u0007pY3qi&|g\u000e\t;pAQDW\r\t4pY2|w/\u001b8hAM\u0004XmY5bY\u0002\u001a\u00180\u001c2pYNTDH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A}\u0003S.\u0019;dQ\u0016\u001c\b%\u00198zA=tW\rI2iCJ\f7\r^3sA%t\u0007\u0005\u001e5fA%t\u0007/\u001e;!QMLW.\u001b7be\u0002\"x\u000e\t\u0018!S:\u0004\u0003o\\:jq\u0002\u0012XmZ;mCJ\u0004S\r\u001f9sKN\u001c\u0018n\u001c8tSq\u0012'O\u0010\u001fcezR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011&A5\fGo\u00195fg\u0002RXM]8!_J\u0004Sn\u001c:fA\rD\u0017M]1di\u0016\u00148\u000fI5oAQDW\rI5oaV$\b\u0005K:j[&d\u0017M\u001d\u0011u_\u0002r#\u0006I5oAA|7/\u001b=!e\u0016<W\u000f\\1s\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u001a=qe\u0016\u001c8/[8og&b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000fI1sK\u0002*h.Z:dCB,G\rI5oA=,(\u000fI*R\u0019\u0002\u0002\u0018M]:fe2\u00023/Z3!i\",\u0007%\u001e8fg\u000e\f\u0007/\u001b8h\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003E];mKN\u0004\u0013\r\u001e\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006\\5uKJ\fGn\u001d\u0018ii6d7e\u001d;sS:<W\u0006\\5uKJ\fGN\t TiJLgn\u001a\u0011MSR,'/\u00197=_\u0005tdF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!S:\u0004sN\u001d3fe\u0002\"x\u000eI7bi\u000eD\u0007E\t/bE\u000e\u0014C\u0006\t;iK\u0002\u0002\u0018\r\u001e;fe:\u00043\u000f[8vY\u0012\u0004#-\u001a\u0011#9r\u000b'm\u0019\u0012/y\t\u0014h\b\u00102s})\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I,iK:\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011jg\u0002*g.\u00192mK\u0012d\u0003%\u001b;!M\u0006dGn\u001d\u0011cC\u000e\\'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i>\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0011jM\u0002\"\b.\u001a\u0011d_:4\u0017n\u001a\u0011jg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I3oC\ndW\r\u001a\u0017!i\",\u0007\u0005]1ui\u0016\u0014h\u000e\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012!g\"|W\u000f\u001c3!E\u0016\u0004#\u0005X1cG\nrCH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A%#xe\u001d\u0011sK\u000e|W.\\3oI\u0016$\u0007\u0005^8!kN,\u0007%\u0019\u0011sC^\u00043\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d\u0007\u0005K<ji\"\u0004C\u000f[3!AJ\u0004\u0007\u0005\u001d:fM&D\u0018\u0006\t;pA\u00054x.\u001b3!KN\u001c\u0017\r]5oO*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I:qK\u000eL\u0017\r\u001c\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004\u0013N\u001c\u0011uQ\u0016\u0004\u0003/\u0019;uKJt\u0007e\u001d;sS:<\u0007%\u001b4!KbL7\u000f^:/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001*7oY1qK\u0002j\u0003%\u00198!G\"\f'/Y2uKJ\u0004\u0013\r\u001a3fI\u0002\u001a\u0018N\\2fAM\u0003\u0018M]6!g9\u0002d\u0006\t+iK\u0002\"WMZ1vYR\u0004Sm]2ba\u0016\u00043\r[1sC\u000e$XM\u001d\u0011jg\u0002\"\b.\u001a\u0011(9\u001er#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0013M\u001c\u0011fg\u000e\f\u0007/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;fe\u0002\u0002(/Z2fI\u0016\u001c\b%\u0019\u0011ta\u0016\u001c\u0017.\u00197!gfl'm\u001c7!_J\u0004\u0013M\\8uQ\u0016\u0014\b%Z:dCB,\u0007e\u00195be\u0006\u001cG/\u001a:-AQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019|G\u000e\\8xS:<\u0007e\u00195be\u0006\u001cG/\u001a:!SN\u0004S.\u0019;dQ\u0016$\u0007\u0005\\5uKJ\fG\u000e\\=/A%#\b%[:!S:4\u0018\r\\5eAQ|\u0007%Z:dCB,\u0007%\u00198zA=$\b.\u001a:!G\"\f'/Y2uKJt#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a#\u0002\u000b\u001fQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\w\u0005\f\u0011(?B\u000b'o[\u0014*w)\u0001\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!Oqc\u0016MY2(A\u0005\u001b\u0006e\u0015\u0017!'\u0002zf)\u0016(D?\u0002\u0012x\u0005\u0018/bE\u000e<C\u0006I*!?\u001a+fjQ0!OqcF\fX1cG\u001eZ$\u0002\t\u0011!A\u0001\u0002C,\u00192d\u0013Q\u0014X/Z\u0005ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F)\u0002\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u001fueV,7H\u0003\u0011!A\u0001\u0002\u0003e\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197t\u0013Q\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9V\u001bXM]:]\u0015>Dgn\n\u0011`\rVs5i\u0018\u0011(9\u0016\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3]KqcVo]3sg\u0016:3H\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e:vK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012+!gB\f'o\u001b\u0018tc2t\u0003/\u0019:tKJtSm]2ba\u0016$7\u000b\u001e:j]\u001ed\u0015\u000e^3sC2\u001cXHZ1mg\u0016\\$\u0002\t\u0011!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:\nM\u0006d7/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!O\u0015\u001a\u0016p\u001d;f[\u0012\u0013\u0018N^3&9r+6+\u0012*T9rSu\u000e\u001b8(A}3UKT\"`AI<SeU=ti\u0016lGI]5wK\u0016bF,V:feN,se\u000f\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eJ\u0013TsN$X-\u001c#sSZ,WeL+tKJ\u001cxFS8i]\u001e\u0002sLR+O\u0007~\u0003seL\u0013T3N#V)\u0014#sSZ,w&J\u00180+N,'o]\u0013(A\u0015\u001b6)\u0011)FA\u001dzse\u000f\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002\u0012\u0006i$\u0002\t\u0011!AU\u001bX\r\t*M\u0013.+\u0005\u0005^8![\u0006$8\r\u001b\u0011xSRD\u0007e\u001d;b]\u0012\f'\u000f\u001a\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7O\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qS\u0001\u0006g9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003;\u000bq\u0002\u001d:fI&\u001c\u0017\r^3`MVt7m]\u0001\u0006\u00132K7.\u001a\t\u0003_e\u0019R!GAS\u0003c\u0003\u0002\"a*\u0002.:rs+X\u0007\u0003\u0003SS1!a+A\u0003\u001d\u0011XO\u001c;j[\u0016LA!a,\u0002*\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kSA!a.\u0002,\u0005\u0011\u0011n\\\u0005\u0004\u001d\u0006UFCAAQ\u0003!!xn\u0015;sS:<GCAA\u0012\u0003\u0015\t\u0007\u000f\u001d7z)\u001di\u0016QYAd\u0003\u0013DQ\u0001\u0015\u000fA\u00029BQa\u0015\u000fA\u00029BQ!\u0016\u000fA\u0002]\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002P\u0006m\u0007#B \u0002R\u0006U\u0017bAAj\u0001\n1q\n\u001d;j_:\u0004baPAl]9:\u0016bAAm\u0001\n1A+\u001e9mKNB\u0001\"!8\u001e\u0003\u0003\u0005\r!X\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAr!\u0011\t)#!:\n\t\u0005\u001d\u0018q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class ILike
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
BinaryLike<Expression>,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private final char escapeChar;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ILike x$0) {
        return ILike$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Object>, ILike> tupled() {
        return ILike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, ILike>>> curried() {
        return ILike$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ILike iLike = this;
        synchronized (iLike) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ILike iLike = this;
        synchronized (iLike) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public char escapeChar() {
        return this.escapeChar;
    }

    private Expression replacement$lzycompute() {
        ILike iLike = this;
        synchronized (iLike) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new Like((Expression)new Lower(this.left()), (Expression)new Lower(this.right()), this.escapeChar());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public ILike copy(Expression left, Expression right, char escapeChar) {
        return new ILike(left, right, escapeChar);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public char copy$default$3() {
        return this.escapeChar();
    }

    @Override
    public String productPrefix() {
        return "ILike";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToCharacter((char)this.escapeChar());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ILike;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "escapeChar";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ILike)) return false;
        boolean bl = true;
        if (!bl) return false;
        ILike iLike = (ILike)x$1;
        if (this.escapeChar() != iLike.escapeChar()) return false;
        Expression expression = this.left();
        Expression expression2 = iLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = iLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!iLike.canEqual(this)) return false;
        return true;
    }

    public ILike(Expression left, Expression right, char escapeChar) {
        this.left = left;
        this.right = right;
        this.escapeChar = escapeChar;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
        Statics.releaseFence();
    }

    public ILike(Expression left, Expression right, Expression escapeChar) {
        this(left, right, StringRegexExpression$.MODULE$.expressionToEscapeChar(escapeChar));
    }

    public ILike(Expression left, Expression right) {
        this(left, right, '\\');
    }
}

