/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonObjectKeys$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(json_object) - Returns all the keys of the outermost JSON object as an array.", arguments="\n    Arguments:\n      * json_object - A JSON object. If a valid JSON object is given, all the keys of the outermost\n          object will be returned as an array. If it is any other valid JSON string, an invalid JSON\n          string or an empty string, the function returns null.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('{}');\n        []\n      > SELECT _FUNC_('{\"key\": \"value\"}');\n        [\"key\"]\n      > SELECT _FUNC_('{\"f1\":\"abc\",\"f2\":{\"f3\":\"a\", \"f4\":\"b\"}}');\n        [\"f1\",\"f2\"]\n  ", group="json_funcs", since="3.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001B\u000e\u001d\u0001&B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\")q\n\u0001C\u0001!\")1\u000b\u0001C!)\")a\f\u0001C!?\")1\r\u0001C!I\")\u0001\u000e\u0001C!S\")!\u000f\u0001C!g\")Q\u0010\u0001C\u0005}\"9\u0011\u0011\u0006\u0001\u0005R\u0005-\u0002\"CA\u0019\u0001\u0005\u0005I\u0011AA\u001a\u0011%\t9\u0004AI\u0001\n\u0003\tI\u0004C\u0005\u0002P\u0001\t\t\u0011\"\u0011\u0002R!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00111\r\u0005\n\u0003W\u0002\u0011\u0011!C\u0001\u0003[B\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\t\u0013\u0005\r\u0005!!A\u0005\u0002\u0005\u0015\u0005\"CAE\u0001\u0005\u0005I\u0011IAF\u0011%\ty\tAA\u0001\n\u0003\n\tjB\u0005\u0002<r\t\t\u0011#\u0001\u0002>\u001aA1\u0004HA\u0001\u0012\u0003\ty\f\u0003\u0004P+\u0011\u0005\u0011q\u001b\u0005\n\u00033,\u0012\u0011!C#\u00037D\u0011\"!8\u0016\u0003\u0003%\t)a8\t\u0013\u0005\rX#!A\u0005\u0002\u0006\u0015\b\"CAy+\u0005\u0005I\u0011BAz\u00059Q5o\u001c8PE*,7\r^&fsNT!!\b\u0010\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003?\u0001\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003C\t\n1a]9m\u0015\t\u0019C%A\u0003ta\u0006\u00148N\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<7\u0001A\n\u0007\u0001)rCgN\u001f\u0011\u0005-bS\"\u0001\u000f\n\u00055b\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005Eb\u0012aB2pI\u0016<WM\\\u0005\u0003gA\u0012qbQ8eK\u001e,gNR1mY\n\f7m\u001b\t\u0003WUJ!A\u000e\u000f\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005y2eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0005&\u0001\u0004=e>|GOP\u0005\u0002u%\u0011Q)O\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002Fs\u0005)1\r[5mIV\t1\n\u0005\u0002,\u0019&\u0011Q\n\b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003#J\u0003\"a\u000b\u0001\t\u000b%\u001b\u0001\u0019A&\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001V!\rqd\u000bW\u0005\u0003/\"\u00131aU3r!\tIF,D\u0001[\u0015\tY\u0006%A\u0003usB,7/\u0003\u0002^5\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0001\r\u0005\u0002ZC&\u0011!M\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006Aa.\u001e7mC\ndW-F\u0001f!\tAd-\u0003\u0002hs\t9!i\\8mK\u0006t\u0017A\u00039sKR$\u0018PT1nKV\t!\u000e\u0005\u0002l_:\u0011A.\u001c\t\u0003\u0001fJ!A\\\u001d\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0018O\u0001\u0004TiJLgn\u001a\u0006\u0003]f\nA!\u001a<bYR\u0011Ao\u001e\t\u0003qUL!A^\u001d\u0003\u0007\u0005s\u0017\u0010C\u0004y\u0011A\u0005\t\u0019A=\u0002\u000b%t\u0007/\u001e;\u0011\u0005i\\X\"\u0001\u0010\n\u0005qt\"aC%oi\u0016\u0014h.\u00197S_^\f1bZ3u\u0015N|gnS3zgR)q0a\u0003\u0002(A!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006y\tA!\u001e;jY&!\u0011\u0011BA\u0002\u0005A9UM\\3sS\u000e\f%O]1z\t\u0006$\u0018\rC\u0004\u0002\u000e%\u0001\r!a\u0004\u0002\rA\f'o]3s!\u0011\t\t\"a\t\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tAaY8sK*!\u0011\u0011DA\u000e\u0003\u001dQ\u0017mY6t_:TA!!\b\u0002 \u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0003\u0003C\t1aY8n\u0013\u0011\t)#a\u0005\u0003\u0015)\u001bxN\u001c)beN,'\u000fC\u0003y\u0013\u0001\u0007\u00110\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0004#\u00065\u0002BBA\u0018\u0015\u0001\u00071*\u0001\u0005oK^\u001c\u0005.\u001b7e\u0003\u0011\u0019w\u000e]=\u0015\u0007E\u000b)\u0004C\u0004J\u0017A\u0005\t\u0019A&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\b\u0016\u0004\u0017\u0006u2FAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%\u0013(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0014\u0002D\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&\u0019\u0001/a\u0016\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0015\u0004c\u0001\u001d\u0002h%\u0019\u0011\u0011N\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007Q\fy\u0007C\u0005\u0002r=\t\t\u00111\u0001\u0002f\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001e\u0011\u000b\u0005e\u0014q\u0010;\u000e\u0005\u0005m$bAA?s\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00151\u0010\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002f\u0003\u000fC\u0001\"!\u001d\u0012\u0003\u0003\u0005\r\u0001^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002T\u00055\u0005\"CA9%\u0005\u0005\t\u0019AA3\u0003\u0019)\u0017/^1mgR\u0019Q-a%\t\u0011\u0005E4#!AA\u0002QDs\u0003AAL\u0003;\u000by*a)\u0002&\u0006%\u00161VAX\u0003c\u000b),a.\u0011\u0007-\nI*C\u0002\u0002\u001cr\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\"\u0006!vLR+O\u0007~C#n]8o?>\u0014'.Z2uS\u0001j\u0003EU3ukJt7\u000fI1mY\u0002\"\b.\u001a\u0011lKf\u001c\be\u001c4!i\",\u0007e\\;uKJlwn\u001d;!\u0015N{e\nI8cU\u0016\u001cG\u000fI1tA\u0005t\u0007%\u0019:sCft\u0013!C1sOVlWM\u001c;tC\t\t9+\u0001B\u001c\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002#n]8o?>\u0014'.Z2uA5\u0002\u0013\t\t&T\u001f:\u0003sN\u00196fGRt\u0003%\u00134!C\u00022\u0018\r\\5eA)\u001bvJ\u0014\u0011pE*,7\r\u001e\u0011jg\u0002:\u0017N^3oY\u0001\nG\u000e\u001c\u0011uQ\u0016\u00043.Z=tA=4\u0007\u0005\u001e5fA=,H/\u001a:n_N$(\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!_\nTWm\u0019;!o&dG\u000e\t2fAI,G/\u001e:oK\u0012\u0004\u0013m\u001d\u0011b]\u0002\n'O]1z]\u0001Je\rI5uA%\u001c\b%\u00198zA=$\b.\u001a:!m\u0006d\u0017\u000e\u001a\u0011K'>s\u0005e\u001d;sS:<G\u0006I1oA%tg/\u00197jI\u0002R5k\u0014(\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\u000f\u001e:j]\u001e\u0004sN\u001d\u0011b]\u0002*W\u000e\u001d;zAM$(/\u001b8hY\u0001\"\b.\u001a\u0011gk:\u001cG/[8oAI,G/\u001e:og\u0002rW\u000f\u001c7/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u00055\u0016!a%\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZXpJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001ZVL\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(w\nZW-\u001f\u0012;A\t2\u0018\r\\;fEu<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!7\nZW-\u001f\u0012^\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3P\t42Ei\u0012\u0013MY2#Y\t2'G\t\u001e|E\u0019\u001c$E\u000f\u0012bE1\u0002#E\u001a\u001b#u\t\u0012'%`?(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003e\u0017\u0012gc\tb#E\u001a\u001a#;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u00024\u0006Q!n]8o?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005e\u0016!B\u001a/c9\u0002\u0014A\u0004&t_:|%M[3di.+\u0017p\u001d\t\u0003WU\u0019R!FAa\u0003\u001b\u0004b!a1\u0002J.\u000bVBAAc\u0015\r\t9-O\u0001\beVtG/[7f\u0013\u0011\tY-!2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002P\u0006UWBAAi\u0015\u0011\t\u0019.a\u0017\u0002\u0005%|\u0017bA$\u0002RR\u0011\u0011QX\u0001\ti>\u001cFO]5oOR\u0011\u00111K\u0001\u0006CB\u0004H.\u001f\u000b\u0004#\u0006\u0005\b\"B%\u0019\u0001\u0004Y\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\fi\u000f\u0005\u00039\u0003S\\\u0015bAAvs\t1q\n\u001d;j_:D\u0001\"a<\u001a\u0003\u0003\u0005\r!U\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA{!\u0011\t)&a>\n\t\u0005e\u0018q\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class JsonObjectKeys
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(JsonObjectKeys x$0) {
        return JsonObjectKeys$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<JsonObjectKeys, A> g) {
        return JsonObjectKeys$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, JsonObjectKeys> compose(Function1<A$, Expression> g) {
        return JsonObjectKeys$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply((DataType)SQLConf$.MODULE$.get().defaultStringType());
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "json_object_keys";
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        block7: {
            Object object2 = new Object();
            try {
                UTF8String json = (UTF8String)this.child().eval(input);
                if (json == null) {
                    return null;
                }
                try {
                    object = Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable)parser -> {
                        block3: {
                            block2: {
                                if (parser.nextToken() == null) break block2;
                                JsonToken jsonToken = parser.currentToken();
                                JsonToken jsonToken2 = JsonToken.START_OBJECT;
                                if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break block3;
                            }
                            throw new NonLocalReturnControl(object2, null);
                        }
                        return this.getJsonKeys((JsonParser)parser, input);
                    });
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof IOException) {
                        object = null;
                        break block7;
                    }
                    throw throwable;
                }
            }
            catch (NonLocalReturnControl ex) {
                if (ex.key() == object2) {
                    object = ex.value();
                }
                throw ex;
            }
        }
        return object;
    }

    private GenericArrayData getJsonKeys(JsonParser parser, InternalRow input) {
        ArrayBuffer arrayBufferOfKeys = ArrayBuffer$.MODULE$.empty();
        while (parser.nextValue() != null && parser.currentName() != null) {
            arrayBufferOfKeys.$plus$eq((Object)UTF8String.fromString((String)parser.currentName()));
            parser.skipChildren();
        }
        return new GenericArrayData((Object[])arrayBufferOfKeys.toArray(ClassTag$.MODULE$.Any()));
    }

    @Override
    public JsonObjectKeys withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public JsonObjectKeys copy(Expression child) {
        return new JsonObjectKeys(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "JsonObjectKeys";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonObjectKeys;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonObjectKeys)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonObjectKeys jsonObjectKeys = (JsonObjectKeys)x$1;
        Expression expression = this.child();
        Expression expression2 = jsonObjectKeys.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!jsonObjectKeys.canEqual(this)) return false;
        return true;
    }

    public JsonObjectKeys(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

