/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonFactory;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.JsonToStructs$;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.expressions.variant.VariantExpressionEvalUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.json.JacksonParser$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(jsonStr, schema[, options]) - Returns a struct value with the given `jsonStr` and `schema`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":0.8}', 'a INT, b DOUBLE');\n       {\"a\":1,\"b\":0.8}\n      > SELECT _FUNC_('{\"time\":\"26/08/2015\"}', 'time Timestamp', map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":2015-08-26 00:00:00}\n      > SELECT _FUNC_('{\"teacher\": \"Alice\", \"student\": [{\"name\": \"Bob\", \"rank\": 1}, {\"name\": \"Charlie\", \"rank\": 2}]}', 'STRUCT<teacher: STRING, student: ARRAY<STRUCT<name: STRING, rank: INT>>>');\n       {\"teacher\":\"Alice\",\"student\":[{\"name\":\"Bob\",\"rank\":1},{\"name\":\"Charlie\",\"rank\":2}]}\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\teh\u0001\u0002\u001a4\u0001\u0002C\u0001b\u001c\u0001\u0003\u0016\u0004%\t\u0001\u001d\u0005\to\u0002\u0011\t\u0012)A\u0005c\"A\u0001\u0010\u0001BK\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\f\u0001\u0011\t\u0012)A\u0005u\"Q\u0011Q\u0002\u0001\u0003\u0016\u0004%\t!a\u0004\t\u0015\u0005]\u0001A!E!\u0002\u0013\t\t\u0002\u0003\u0006\u0002\u001a\u0001\u0011)\u001a!C\u0001\u00037A!\"a\t\u0001\u0005#\u0005\u000b\u0011BA\u000f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OA\u0001\"a\r\u0001\u0005\u0004%\t\u0001\u001d\u0005\b\u0003k\u0001\u0001\u0015!\u0003r\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0011\u0001\t\u000b\n\u0019\u0005C\u0004\u0002&\u0001!\t!!\u001e\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002~!9\u0011Q\u0005\u0001\u0005\u0002\u0005\r\u0005bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\u000b\u00037\u0003\u0001R1A\u0005\u0002\u0005u\u0005\"CAn\u0001\t\u0007I\u0011AAo\u0011!\ty\u000e\u0001Q\u0001\n\u0005\u0015\u0001BCAq\u0001!\u0015\r\u0011\"\u0001\u0002d\"1!\u0011\u0001\u0001\u0005BADqAa\u0001\u0001\t\u0003\u0012)\u0001C\u0004\u0003\n\u0001!\tEa\u0003\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!1\u0001\b\u0001C!\u0003;DqAa\t\u0001\t\u0003\ni\u000eC\u0004\u0003&\u0001!\tFa\n\t\u0013\t5\u0002!!A\u0005\u0002\t=\u0002\"\u0003B\u001d\u0001E\u0005I\u0011\u0001B\u001e\u0011%\u0011\t\u0006AI\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003X\u0001\t\n\u0011\"\u0001\u0003Z!I!Q\f\u0001\u0012\u0002\u0013\u0005!q\f\u0005\n\u0005G\u0002\u0011\u0011!C!\u0005KB\u0011Ba\u001b\u0001\u0003\u0003%\tA!\u001c\t\u0013\tU\u0004!!A\u0005\u0002\t]\u0004\"\u0003B?\u0001\u0005\u0005I\u0011\tB@\u0011%\u0011Y\tAA\u0001\n\u0003\u0011i\tC\u0005\u0003\u0012\u0002\t\t\u0011\"\u0011\u0003\u0014\"I!q\u0013\u0001\u0002\u0002\u0013\u0005#\u0011T\u0004\n\u0005{\u001b\u0014\u0011!E\u0001\u0005\u007f3\u0001BM\u001a\u0002\u0002#\u0005!\u0011\u0019\u0005\b\u0003KQC\u0011\u0001Bh\u0011%\u0011\tNKA\u0001\n\u000b\u0012\u0019\u000eC\u0005\u0003V*\n\t\u0011\"!\u0003X\"I!\u0011\u001d\u0016\u0012\u0002\u0013\u0005!q\f\u0005\n\u0005GT\u0013\u0011!CA\u0005KD\u0011Ba=+#\u0003%\tAa\u0018\t\u0013\tU(&!A\u0005\n\t](!\u0004&t_:$vn\u0015;sk\u000e$8O\u0003\u00025k\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1t'\u0001\u0005dCR\fG._:u\u0015\tA\u0014(A\u0002tc2T!AO\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001'%\u0001\u0011)\u0012%O#bsF\r\u0005\u0002C\u00076\t1'\u0003\u0002Eg\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002C\r&\u0011qi\r\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"!\u0013'\u000e\u0003)S!aS\u001a\u0002\u000f\r|G-Z4f]&\u0011QJ\u0013\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011!iT\u0005\u0003!N\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t\u0011VK\u0004\u0002C'&\u0011AkM\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005Q\u001b\u0004CA-]\u001b\u0005Q&BA.8\u0003\u0019)'O]8sg&\u0011QL\u0017\u0002\u0010#V,'/_#se>\u00148OQ1tKB\u0011qLY\u0007\u0002A*\t\u0011-A\u0003tG\u0006d\u0017-\u0003\u0002dA\n9\u0001K]8ek\u000e$\bCA3m\u001d\t17N\u0004\u0002hU6\t\u0001N\u0003\u0002j\u007f\u00051AH]8pizJ\u0011!Y\u0005\u0003)\u0002L!!\u001c8\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005Q\u0003\u0017AB:dQ\u0016l\u0017-F\u0001r!\t\u0011X/D\u0001t\u0015\t!x'A\u0003usB,7/\u0003\u0002wg\nAA)\u0019;b)f\u0004X-A\u0004tG\",W.\u0019\u0011\u0002\u000f=\u0004H/[8ogV\t!\u0010\u0005\u0004|\u007f\u0006\u0015\u0011Q\u0001\b\u0003yv\u0004\"a\u001a1\n\u0005y\u0004\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0005\r!aA'ba*\u0011a\u0010\u0019\t\u0004w\u0006\u001d\u0011\u0002BA\u0005\u0003\u0007\u0011aa\u0015;sS:<\u0017\u0001C8qi&|gn\u001d\u0011\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0005\u0005E\u0001c\u0001\"\u0002\u0014%\u0019\u0011QC\u001a\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#WCAA\u000f!\u0015y\u0016qDA\u0003\u0013\r\t\t\u0003\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005%\u00121FA\u0017\u0003_\t\t\u0004\u0005\u0002C\u0001!)q.\u0003a\u0001c\")\u00010\u0003a\u0001u\"9\u0011QB\u0005A\u0002\u0005E\u0001\"CA\r\u0013A\u0005\t\u0019AA\u000f\u00039qW\u000f\u001c7bE2,7k\u00195f[\u0006\fqB\\;mY\u0006\u0014G.Z*dQ\u0016l\u0017\rI\u0001\t]VdG.\u00192mKV\u0011\u00111\b\t\u0004?\u0006u\u0012bAA A\n9!i\\8mK\u0006t\u0017\u0001\u00068pI\u0016\u0004\u0016\r\u001e;fe:\u001c\u0018J\u001c;fe:\fG\u000e\u0006\u0002\u0002FA)Q-a\u0012\u0002L%\u0019\u0011\u0011\n8\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002N\u0005=d\u0002BA(\u0003SrA!!\u0015\u0002f9!\u00111KA2\u001d\u0011\t)&!\u0019\u000f\t\u0005]\u0013q\f\b\u0005\u00033\niFD\u0002h\u00037J\u0011AP\u0005\u0003yuJ!AO\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\r\t9'N\u0001\u0006iJ,Wm]\u0005\u0005\u0003W\ni'A\u0006Ue\u0016,\u0007+\u0019;uKJt'bAA4k%!\u0011\u0011OA:\u0005-!&/Z3QCR$XM\u001d8\u000b\t\u0005-\u0014Q\u000e\u000b\t\u0003S\t9(!\u001f\u0002|!9\u0011Q\u0002\bA\u0002\u0005E\u0001BB8\u000f\u0001\u0004\t\t\u0002C\u0003y\u001d\u0001\u0007!\u0010\u0006\u0004\u0002*\u0005}\u0014\u0011\u0011\u0005\b\u0003\u001by\u0001\u0019AA\t\u0011\u0019yw\u00021\u0001\u0002\u0012QA\u0011\u0011FAC\u0003\u000f\u000bI\tC\u0004\u0002\u000eA\u0001\r!!\u0005\t\r=\u0004\u0002\u0019AA\t\u0011\u0019A\b\u00031\u0001\u0002\u0012\u0005\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011q\u0012\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*\u0019\u0011QS\u001b\u0002\u0011\u0005t\u0017\r\\=tSNLA!!'\u0002\u0014\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0005d_:4XM\u001d;feV\u0011\u0011q\u0014\t\b?\u0006\u0005\u0016QUAZ\u0013\r\t\u0019\u000b\u0019\u0002\n\rVt7\r^5p]F\u0002R!ZAT\u0003WK1!!+o\u0005!IE/\u001a:bi>\u0014\b\u0003BAW\u0003_k\u0011!N\u0005\u0004\u0003c+$aC%oi\u0016\u0014h.\u00197S_^\u0014b!!.\u0002:\u0006%gABA\\\u0001\u0001\t\u0019L\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0003\u0002<\u0006\u0015WBAA_\u0015\u0011\ty,!1\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\fAA[1wC&!\u0011qYA_\u0005\u0019y%M[3diB!\u00111ZAi\u001b\t\tiM\u0003\u0003\u0002P\u0006\u0005\u0017AA5p\u0013\ri\u0017Q\u001a\u0015\u0004%\u0005U\u0007cA0\u0002X&\u0019\u0011\u0011\u001c1\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00058b[\u0016|emQ8seV\u0004HOU3d_J$WCAA\u0003\u0003Qq\u0017-\\3PM\u000e{'O];qiJ+7m\u001c:eA\u00051\u0001/\u0019:tKJ,\"!!:\u0011\r\u0005\u001d\u0018Q^Ay\u001b\t\tIOC\u0002\u0002lV\nA!\u001e;jY&!\u0011q^Au\u0005E1\u0015-\u001b7ve\u0016\u001c\u0016MZ3QCJ\u001cXM\u001d\t\u0005\u0003g\fY0\u0004\u0002\u0002v*\u0019A/a>\u000b\u0007\u0005e\u0018(\u0001\u0004v]N\fg-Z\u0005\u0005\u0003{\f)P\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001eD3!FAk\u0003!!\u0017\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,GcA#\u0003\b!9\u0011\u0011D\fA\u0002\u0005\u0015\u0011\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003\u0002B\u0007\u0005'\u00012a\u0018B\b\u0013\r\u0011\t\u0002\u0019\u0002\u0004\u0003:L\bb\u0002B\u000b1\u0001\u0007!QB\u0001\u0005UN|g.\u0001\u0006j]B,H\u000fV=qKN,\"Aa\u0007\u0011\u000b\u0015\f9E!\b\u0011\u0007I\u0014y\"C\u0002\u0003\"M\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003S\u0011I\u0003C\u0004\u0003,q\u0001\r!!\u0005\u0002\u00119,wo\u00115jY\u0012\fAaY8qsRQ\u0011\u0011\u0006B\u0019\u0005g\u0011)Da\u000e\t\u000f=l\u0002\u0013!a\u0001c\"9\u00010\bI\u0001\u0002\u0004Q\b\"CA\u0007;A\u0005\t\u0019AA\t\u0011%\tI\"\bI\u0001\u0002\u0004\ti\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu\"fA9\u0003@-\u0012!\u0011\t\t\u0005\u0005\u0007\u0012i%\u0004\u0002\u0003F)!!q\tB%\u0003%)hn\u00195fG.,GMC\u0002\u0003L\u0001\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yE!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tU#f\u0001>\u0003@\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B.U\u0011\t\tBa\u0010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\r\u0016\u0005\u0003;\u0011y$A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005O\u0002B!a/\u0003j%!\u0011\u0011BA_\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011y\u0007E\u0002`\u0005cJ1Aa\u001da\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iA!\u001f\t\u0013\tmD%!AA\u0002\t=\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0002B1!1\u0011BE\u0005\u001bi!A!\"\u000b\u0007\t\u001d\u0005-\u0001\u0006d_2dWm\u0019;j_:LA!!+\u0003\u0006\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002<\t=\u0005\"\u0003B>M\u0005\u0005\t\u0019\u0001B\u0007\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t\u001d$Q\u0013\u0005\n\u0005w:\u0013\u0011!a\u0001\u0005_\na!Z9vC2\u001cH\u0003BA\u001e\u00057C\u0011Ba\u001f)\u0003\u0003\u0005\rA!\u0004)'\u0001\u0011yJ!*\u0003(\n-&Q\u0016BY\u0005g\u00139L!/\u0011\u0007\t\u0013\t+C\u0002\u0003$N\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003*\u0006\u0011wLR+O\u0007~C#n]8o'R\u0014H\u0006I:dQ\u0016l\u0017m\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAM$(/^2uAY\fG.^3!o&$\b\u000e\t;iK\u0002:\u0017N^3oA\u0001T7o\u001c8TiJ\u0004\u0007%\u00198eA\u0001\u001c8\r[3nC\u0002t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t=\u0016\u0001b\t\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ(%\u0019\u0012;c1\u0002#E\u0019\u0012;a9BTp\n\u0017!O\u0005\u0004\u0013J\u0014+-A\t\u0004CiT+C\u0019\u0016;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#(\r\u0017#E\nR\u0004G\f\u001d~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3P\t;j[\u0016\u0014#H\t\u001a7_ABtF\r\u00192k\tjx\u0005\f\u0011(i&lW\r\t+j[\u0016\u001cH/Y7qO1\u0002S.\u00199)OQLW.Z:uC6\u0004hi\u001c:nCR<C\u0006I\u0014eI>jUjL=zsf<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!w\n\"\u0018.\\3#uI\u0002\u0014'N\u00171q5\u0012d\u0007\t\u00191uA\u0002$\b\r\u0019~\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3P\t;fC\u000eDWM\u001d\u0012;A\t\nE.[2fE1\u0002#e\u001d;vI\u0016tGO\t\u001e!7n\u0014c.Y7fEi\u0002#EQ8cE1\u0002#E]1oW\nR\u0004%M?-Am\u0014c.Y7fEi\u0002#e\u00115be2LWM\t\u0017!EI\fgn\u001b\u0012;AIjX,`\u0014-A\u001d\u001aFKU+D)r\"X-Y2iKJT\u0004e\u0015+S\u0013:;E\u0006I:uk\u0012,g\u000e\u001e\u001e!\u0003J\u0013\u0016)\u0017\u001fT)J+6\t\u0016\u001foC6,'\bI*U%&su\t\f\u0011sC:\\'\bI%O)zrdhJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014C/Z1dQ\u0016\u0014(E\u000f\u0012BY&\u001cWM\t\u0017#gR,H-\u001a8uEiZ6P\t8b[\u0016\u0014#H\t\"pE\nb#E]1oW\nR\u0014' \u0017|E9\fW.\u001a\u0012;E\rC\u0017M\u001d7jK\nb#E]1oW\nR$'`/~\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B[\u0003)Q7o\u001c8`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005w\u000bQA\r\u00183]A\nQBS:p]R{7\u000b\u001e:vGR\u001c\bC\u0001\"+'\u0015Q#1YAe!1\u0011)Ma3ru\u0006E\u0011QDA\u0015\u001b\t\u00119MC\u0002\u0003J\u0002\fqA];oi&lW-\u0003\u0003\u0003N\n\u001d'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u0011!qX\u0001\ti>\u001cFO]5oOR\u0011!qM\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003S\u0011INa7\u0003^\n}\u0007\"B8.\u0001\u0004\t\b\"\u0002=.\u0001\u0004Q\bbBA\u0007[\u0001\u0007\u0011\u0011\u0003\u0005\n\u00033i\u0003\u0013!a\u0001\u0003;\tq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u00119Oa<\u0011\u000b}\u000byB!;\u0011\u0013}\u0013Y/\u001d>\u0002\u0012\u0005u\u0011b\u0001BwA\n1A+\u001e9mKRB\u0011B!=0\u0003\u0003\u0005\r!!\u000b\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003s\u0003")
public class JsonToStructs
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
QueryErrorsBase,
Serializable {
    private transient Function1<Iterator<InternalRow>, Object> converter;
    private transient FailureSafeParser<UTF8String> parser;
    private final DataType schema;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private final DataType nullableSchema;
    private final String nameOfCorruptRecord;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return JsonToStructs$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<DataType, Map<String, String>, Expression, Option<String>>> unapply(JsonToStructs x$0) {
        return JsonToStructs$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return JsonToStructs$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<DataType, Map<String, String>, Expression, Option<String>>, JsonToStructs> tupled() {
        return JsonToStructs$.MODULE$.tupled();
    }

    public static Function1<DataType, Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, JsonToStructs>>>> curried() {
        return JsonToStructs$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DataType schema() {
        return this.schema;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public DataType nullableSchema() {
        return this.nullableSchema;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.JSON_TO_STRUCT(), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.nullableSchema();
        if (dataType instanceof StructType ? true : (dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof VariantType))) {
            TypeCheckResult checkResult = ExprUtils$.MODULE$.checkJsonSchema(this.nullableSchema());
            if (checkResult.isFailure()) {
                return checkResult;
            }
            return ExpectsInputTypes.checkInputDataTypes$(this);
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_SCHEMA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)this.nullableSchema()))}))));
    }

    private Function1<Iterator<InternalRow>, Object> converter$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.nullableSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable)rows -> {
                        if (rows.hasNext()) {
                            return (InternalRow)rows.next();
                        }
                        return null;
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable)rows -> {
                        if (rows.hasNext()) {
                            return ((SpecializedGetters)rows.next()).getArray(0);
                        }
                        return null;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable)rows -> {
                        if (rows.hasNext()) {
                            return ((SpecializedGetters)rows.next()).getMap(0);
                        }
                        return null;
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.converter;
    }

    public Function1<Iterator<InternalRow>, Object> converter() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    public String nameOfCorruptRecord() {
        return this.nameOfCorruptRecord;
    }

    private FailureSafeParser<UTF8String> parser$lzycompute() {
        JsonToStructs jsonToStructs = this;
        synchronized (jsonToStructs) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                Tuple2 tuple2;
                DataType dataType;
                ParseMode mode;
                JSONOptions parsedOptions = new JSONOptions(this.options(), (String)this.timeZoneId().get(), this.nameOfCorruptRecord());
                ParseMode parseMode = mode = parsedOptions.parseMode();
                PermissiveMode$ permissiveMode$ = PermissiveMode$.MODULE$;
                if (parseMode == null ? permissiveMode$ != null : !parseMode.equals(permissiveMode$)) {
                    ParseMode parseMode2 = mode;
                    FailFastMode$ failFastMode$ = FailFastMode$.MODULE$;
                    if (parseMode2 == null ? failFastMode$ != null : !parseMode2.equals(failFastMode$)) {
                        throw QueryCompilationErrors$.MODULE$.parseModeUnsupportedError("from_json", mode);
                    }
                }
                if ((dataType = this.nullableSchema()) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(structType, parsedOptions.columnNameOfCorruptRecord());
                    v2 = new Tuple2((Object)structType, (Object)StructType$.MODULE$.apply((Seq)structType.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JsonToStructs.$anonfun$parser$1(parsedOptions, x$6)))));
                } else {
                    v2 = tuple2 = new Tuple2((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField("value", dataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})), (Object)dataType);
                }
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructType parserSchema = (StructType)tuple2._1();
                DataType actualSchema = (DataType)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)parserSchema, (Object)actualSchema);
                StructType parserSchema2 = (StructType)tuple22._1();
                DataType actualSchema2 = (DataType)tuple22._2();
                JacksonParser rawParser = new JacksonParser(actualSchema2, parsedOptions, false, JacksonParser$.MODULE$.$lessinit$greater$default$4());
                Function2 & Serializable createParser = (Function2 & Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.utf8String((JsonFactory)jsonFactory, (UTF8String)record);
                this.parser = new FailureSafeParser((Function1 & Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable)x -> (UTF8String)Predef$.MODULE$.identity(x)), mode, parserSchema2, parsedOptions.columnNameOfCorruptRecord());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.parser;
    }

    public FailureSafeParser<UTF8String> parser() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.parser$lzycompute();
        }
        return this.parser;
    }

    @Override
    public DataType dataType() {
        return this.nullableSchema();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object json) {
        DataType dataType = this.nullableSchema();
        if (dataType instanceof VariantType) {
            return VariantExpressionEvalUtils$.MODULE$.parseJson((UTF8String)json, VariantExpressionEvalUtils$.MODULE$.parseJson$default$2(), VariantExpressionEvalUtils$.MODULE$.parseJson$default$3());
        }
        return this.converter().apply(this.parser().parse((UTF8String)json));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeAnyCollation$ stringTypeAnyCollation$ = StringTypeAnyCollation$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)stringTypeAnyCollation$);
    }

    @Override
    public String sql() {
        DataType dataType = this.schema();
        if (dataType instanceof MapType) {
            return "entries";
        }
        return super.sql();
    }

    @Override
    public String prettyName() {
        return "from_json";
    }

    @Override
    public JsonToStructs withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        DataType x$2 = this.copy$default$1();
        Map<String, String> x$3 = this.copy$default$2();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    public JsonToStructs copy(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new JsonToStructs(schema, options, child, timeZoneId);
    }

    public DataType copy$default$1() {
        return this.schema();
    }

    public Map<String, String> copy$default$2() {
        return this.options();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "JsonToStructs";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.schema();
            }
            case 1: {
                return this.options();
            }
            case 2: {
                return this.child();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonToStructs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "schema";
            }
            case 1: {
                return "options";
            }
            case 2: {
                return "child";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonToStructs)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonToStructs jsonToStructs = (JsonToStructs)x$1;
        DataType dataType = this.schema();
        DataType dataType2 = jsonToStructs.schema();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = jsonToStructs.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = jsonToStructs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = jsonToStructs.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!jsonToStructs.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$parser$1(JSONOptions parsedOptions$1, StructField x$6) {
        String string = x$6.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonToStructs(DataType schema, Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.schema = schema;
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.nullableSchema = schema.asNullable();
        this.nameOfCorruptRecord = SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.COLUMN_NAME_OF_CORRUPT_RECORD());
        Statics.releaseFence();
    }

    public JsonToStructs(Expression child, Expression schema, Map<String, String> options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), options, child, (Option<String>)None$.MODULE$);
    }

    public JsonToStructs(Expression child, Expression schema) {
        this(child, schema, (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public JsonToStructs(Expression child, Expression schema, Expression options) {
        this(ExprUtils$.MODULE$.evalTypeExpr(schema), ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

