/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Levenshtein$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str1, str2[, threshold]) - Returns the Levenshtein distance between the two given strings. If threshold is set and distance more than it, return -1.", examples="\n    Examples:\n      > SELECT _FUNC_('kitten', 'sitting');\n       3\n      > SELECT _FUNC_('kitten', 'sitting', 2);\n       -1\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tMc\u0001B\u0015+\u0001^B\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t3\u0002\u0011\t\u0012)A\u0005q!A!\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005\\\u0001\tE\t\u0015!\u00039\u0011!a\u0006A!f\u0001\n\u0003i\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011\u00020\t\u000b\t\u0004A\u0011A2\t\u000b\t\u0004A\u0011\u00015\t\u000b\t\u0004A\u0011\u00017\t\u000b=\u0004A\u0011\t9\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b!9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u000b\u0001\u0011E\u0013q\u0003\u0005\b\u0003G\u0001A\u0011IA\u0013\u0011\u001d\ti\u0003\u0001C!\u0003KAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005\r\u0004\u0001\"\u0003\u0002f!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004\"CA<\u0001\u0005\u0005I\u0011AA=\u0011%\t\t\tAI\u0001\n\u0003\t\u0019\tC\u0005\u0002\u001a\u0002\t\n\u0011\"\u0001\u0002\u0004\"I\u00111\u0014\u0001\u0012\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0003C\u0003\u0011\u0011!C!\u0003GC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005}\u0006!!A\u0005\u0002\u0005\u0005\u0007\"CAd\u0001\u0005\u0005I\u0011IAe\u0011%\t9\u000eAA\u0001\n\u0003\tI\u000eC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\"I\u00111\u001d\u0001\u0002\u0002\u0013\u0005\u0013Q]\u0004\n\u0005\u0013Q\u0013\u0011!E\u0001\u0005\u00171\u0001\"\u000b\u0016\u0002\u0002#\u0005!Q\u0002\u0005\u0007E\u0006\"\tA!\n\t\u0013\t\u001d\u0012%!A\u0005F\t%\u0002\"\u0003B\u0016C\u0005\u0005I\u0011\u0011B\u0017\u0011%\u0011)$II\u0001\n\u0003\ti\nC\u0005\u00038\u0005\n\t\u0011\"!\u0003:!I!qI\u0011\u0012\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0005\u0013\n\u0013\u0011!C\u0005\u0005\u0017\u00121\u0002T3wK:\u001c\b\u000e^3j]*\u00111\u0006L\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002.]\u0005A1-\u0019;bYf\u001cHO\u0003\u00020a\u0005\u00191/\u001d7\u000b\u0005E\u0012\u0014!B:qCJ\\'BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001qqzd\t\u0014\t\u0003sij\u0011AK\u0005\u0003w)\u0012!\"\u0012=qe\u0016\u001c8/[8o!\tIT(\u0003\u0002?U\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002A\u0007:\u0011\u0011(Q\u0005\u0003\u0005*\nq\u0001]1dW\u0006<W-\u0003\u0002E\u000b\nqa*\u001e7m\u0013:$x\u000e\\3sC:$(B\u0001\"+!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0014+\u000f\u00059\u001bfBA(S\u001b\u0005\u0001&BA)7\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002C\u0011&\u0011QK\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0005\"\u000bA\u0001\\3giV\t\u0001(A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012A\u0018\t\u0004\u000f~C\u0014B\u00011I\u0005\u0019y\u0005\u000f^5p]\u0006QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\u0011!WMZ4\u0011\u0005e\u0002\u0001\"B,\b\u0001\u0004A\u0004\"\u0002.\b\u0001\u0004A\u0004b\u0002/\b!\u0003\u0005\rA\u0018\u000b\u0005I&T7\u000eC\u0003X\u0011\u0001\u0007\u0001\bC\u0003[\u0011\u0001\u0007\u0001\bC\u0003]\u0011\u0001\u0007\u0001\bF\u0002e[:DQaV\u0005A\u0002aBQAW\u0005A\u0002a\n1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u001d\t\u0003eVl\u0011a\u001d\u0006\u0003i2\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003mN\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A=\u0011\u00075SH0\u0003\u0002|-\n\u00191+Z9\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyh&A\u0003usB,7/C\u0002\u0002\u0004y\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011\rD\u0017\u000e\u001c3sK:,\"!!\u0003\u0011\u00075S\b(\u0001\u0005eCR\fG+\u001f9f+\t\ty\u0001E\u0002~\u0003#I1!a\u0005\u007f\u0005!!\u0015\r^1UsB,\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\rA\u0014\u0011\u0004\u0005\b\u00037q\u0001\u0019AA\u000f\u0003-qWm^\"iS2$'/\u001a8\u0011\t5\u000by\u0002O\u0005\u0004\u0003C1&AC%oI\u0016DX\rZ*fc\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002(A\u0019q)!\u000b\n\u0007\u0005-\u0002JA\u0004C_>dW-\u00198\u0002\u0011\u0019|G\u000eZ1cY\u0016\fA!\u001a<bYR!\u00111GA\u001d!\r9\u0015QG\u0005\u0004\u0003oA%aA!os\"I\u00111H\t\u0011\u0002\u0003\u0007\u0011QH\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003\u007f\t\t%D\u0001-\u0013\r\t\u0019\u0005\f\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR1\u0011\u0011JA+\u0003?\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001fR\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003'\niE\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t9F\u0005a\u0001\u00033\n1a\u0019;y!\u0011\tY%a\u0017\n\t\u0005u\u0013Q\n\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\tG\u0005a\u0001\u0003\u0013\n!!\u001a<\u0002)\u001d,gnQ8eK^KG\u000f\u001b+ie\u0016\u001c\bn\u001c7e)!\tI%a\u001a\u0002j\u0005-\u0004bBA,'\u0001\u0007\u0011\u0011\f\u0005\b\u0003C\u001a\u0002\u0019AA%\u0011\u0019\tig\u0005a\u0001q\u0005iA\u000f\u001b:fg\"|G\u000eZ#yaJ\fqcZ3o\u0007>$WmV5uQ>,H\u000f\u00165sKNDw\u000e\u001c3\u0015\r\u0005%\u00131OA;\u0011\u001d\t9\u0006\u0006a\u0001\u00033Bq!!\u0019\u0015\u0001\u0004\tI%\u0001\u0003d_BLHc\u00023\u0002|\u0005u\u0014q\u0010\u0005\b/V\u0001\n\u00111\u00019\u0011\u001dQV\u0003%AA\u0002aBq\u0001X\u000b\u0011\u0002\u0003\u0007a,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0015%f\u0001\u001d\u0002\b.\u0012\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0014\"\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9*!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\u0014\u0016\u0004=\u0006\u001d\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016\u0001\u00027b]\u001eT!!a,\u0002\t)\fg/Y\u0005\u0005\u0003g\u000bIK\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003s\u00032aRA^\u0013\r\ti\f\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003g\t\u0019\rC\u0005\u0002Fn\t\t\u00111\u0001\u0002:\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a3\u0011\r\u00055\u00171[A\u001a\u001b\t\tyMC\u0002\u0002R\"\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t).a4\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\tY\u000eC\u0005\u0002Fv\t\t\u00111\u0001\u00024\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)+!9\t\u0013\u0005\u0015g$!AA\u0002\u0005e\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002(\u0005\u001d\b\"CAc?\u0005\u0005\t\u0019AA\u001aQM\u0001\u00111^Ay\u0003g\f90!?\u0002~\u0006}(1\u0001B\u0003!\rI\u0014Q^\u0005\u0004\u0003_T#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003k\f\u0011\u0011\t\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:2Y\u0001\u001aHO\u001d\u001a\\Y\u0001\"\bN]3tQ>dG-X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!\u0019\u00164XM\\:ii\u0016Lg\u000e\t3jgR\fgnY3!E\u0016$x/Z3oAQDW\r\t;x_\u0002:\u0017N^3oAM$(/\u001b8hg:\u0002\u0013J\u001a\u0011uQJ,7\u000f[8mI\u0002J7\u000fI:fi\u0002\ng\u000e\u001a\u0011eSN$\u0018M\\2fA5|'/\u001a\u0011uQ\u0006t\u0007%\u001b;-AI,G/\u001e:oA5\nd&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY0A@\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001dZ\u0017\u000e\u001e;f]\u001eb\u0003eJ:jiRLgnZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014lSR$XM\\\u0014-A\u001d\u001a\u0018\u000e\u001e;j]\u001e<C\u0006\t\u001a*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t!A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0003\b\u0005a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006YA*\u001a<f]NDG/Z5o!\tI\u0014eE\u0003\"\u0005\u001f\u0011Y\u0002\u0005\u0005\u0003\u0012\t]\u0001\b\u000f0e\u001b\t\u0011\u0019BC\u0002\u0003\u0016!\u000bqA];oi&lW-\u0003\u0003\u0003\u001a\tM!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!!Q\u0004B\u0012\u001b\t\u0011yB\u0003\u0003\u0003\"\u00055\u0016AA5p\u0013\r)&q\u0004\u000b\u0003\u0005\u0017\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003K\u000bQ!\u00199qYf$r\u0001\u001aB\u0018\u0005c\u0011\u0019\u0004C\u0003XI\u0001\u0007\u0001\bC\u0003[I\u0001\u0007\u0001\bC\u0004]IA\u0005\t\u0019\u00010\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003<\t\r\u0003\u0003B$`\u0005{\u0001ba\u0012B qar\u0016b\u0001B!\u0011\n1A+\u001e9mKNB\u0001B!\u0012'\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003NA!\u0011q\u0015B(\u0013\u0011\u0011\t&!+\u0003\r=\u0013'.Z2u\u0001")
public class Levenshtein
extends Expression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<Expression> threshold;

    public static Option<Expression> $lessinit$greater$default$3() {
        return Levenshtein$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(Levenshtein x$0) {
        return Levenshtein$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$3() {
        return Levenshtein$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, Levenshtein> tupled() {
        return Levenshtein$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, Levenshtein>>> curried() {
        return Levenshtein$.MODULE$.curried();
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    public Option<Expression> threshold() {
        return this.threshold;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().length() > 3 || this.children().length() < 2) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Seq<Expression> children() {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            Some some = (Some)option;
            Expression value = (Expression)some.value();
            return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)new .colon.colon((Object)value, (List)Nil$.MODULE$)));
        }
        return new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Option<Expression>)new Some(newChildren.apply(2)));
        }
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), this.copy$default$3());
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.nullable()));
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.foldable()));
    }

    @Override
    public Object eval(InternalRow input) {
        Object leftEval = this.left().eval(input);
        if (leftEval == null) {
            return null;
        }
        Object rightEval = this.right().eval(input);
        if (rightEval == null) {
            return null;
        }
        Option thresholdEval = this.threshold().map((Function1 & Serializable)x$25 -> x$25.eval(input));
        Option option = thresholdEval;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval, BoxesRunTime.unboxToInt((Object)v)));
        }
        return BoxesRunTime.boxToInteger((int)((UTF8String)leftEval).levenshteinDistance((UTF8String)rightEval));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Option<Expression> option = this.threshold();
        if (option instanceof Some) {
            return this.genCodeWithThreshold(ctx, ev, (Expression)this.children().apply(2));
        }
        return this.genCodeWithoutThreshold(ctx, ev);
    }

    private ExprCode genCodeWithThreshold(CodegenContext ctx, ExprCode ev, Expression thresholdExpr) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        ExprCode thresholdGen = thresholdExpr.genCode(ctx);
        String resultCode = ev.value() + " = " + leftGen.value() + ".levenshteinDistance(" + rightGen.value() + ", " + thresholdGen.value() + ");";
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), rightGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), thresholdGen.code().toString() + ctx.nullSafeExec(thresholdExpr.nullable(), ExprValue$.MODULE$.exprValueToString(thresholdGen.isNull()), "\n                  " + ev.isNull() + " = false;\n                  " + resultCode + "\n                 ")));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code()).$plus(thresholdGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    private ExprCode genCodeWithoutThreshold(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = ((Expression)this.children().head()).genCode(ctx);
        ExprCode rightGen = ((Expression)this.children().apply(1)).genCode(ctx);
        String resultCode = ev.value() + " = " + leftGen.value() + ".levenshteinDistance(" + rightGen.value() + ");";
        if (this.nullable()) {
            String nullSafeEval = leftGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().head()).nullable(), ExprValue$.MODULE$.exprValueToString(leftGen.isNull()), rightGen.code().toString() + ctx.nullSafeExec(((Expression)this.children().apply(1)).nullable(), ExprValue$.MODULE$.exprValueToString(rightGen.isNull()), "\n              " + ev.isNull() + " = false;\n              " + resultCode + "\n             "));
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = true;\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), nullSafeEval})), ev.copy$default$2(), ev.copy$default$3());
        }
        Block eval = leftGen.code().$plus(rightGen.code());
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        ", "\n        ", " ", " = ", ";\n        ", ""}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), resultCode})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Levenshtein copy(Expression left, Expression right, Option<Expression> threshold) {
        return new Levenshtein(left, right, threshold);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<Expression> copy$default$3() {
        return this.threshold();
    }

    @Override
    public String productPrefix() {
        return "Levenshtein";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return this.threshold();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Levenshtein;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "threshold";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Levenshtein)) return false;
        boolean bl = true;
        if (!bl) return false;
        Levenshtein levenshtein = (Levenshtein)x$1;
        Expression expression = this.left();
        Expression expression2 = levenshtein.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = levenshtein.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.threshold();
        Option<Expression> option2 = levenshtein.threshold();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!levenshtein.canEqual(this)) return false;
        return true;
    }

    public Levenshtein(Expression left, Expression right, Option<Expression> threshold) {
        this.left = left;
        this.right = right;
        this.threshold = threshold;
        ExpectsInputTypes.$init$(this);
    }

    public Levenshtein(Expression left, Expression right, Expression threshold) {
        this(left, right, (Option<Expression>)Option$.MODULE$.apply((Object)threshold));
    }

    public Levenshtein(Expression left, Expression right) {
        this(left, right, (Option<Expression>)None$.MODULE$);
    }
}

