/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FoldableUnevaluable;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.LocalTimestamp$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_() - Returns the current timestamp without time zone at the start of query evaluation. All calls of localtimestamp within the same query return the same value.\n\n    _FUNC_ - Returns the current local date-time at the session time zone at the start of query evaluation.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_();\n       2020-04-25 15:49:11.914\n  ", group="datetime_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\u000f\u001e\u0001*B\u0001b\u0012\u0001\u0003\u0016\u0004%\t\u0001\u0013\u0005\t)\u0002\u0011\t\u0012)A\u0005\u0013\")Q\u000b\u0001C\u0001-\")Q\u000b\u0001C\u00013\")!\f\u0001C!7\")q\f\u0001C!A\")q\r\u0001C#Q\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001fA\u0011\"a\u0005\u0001#\u0003%\t!!\u0006\t\u0013\u0005-\u0002!!A\u0005B\u00055\u0002\"CA\u001f\u0001\u0005\u0005I\u0011AA \u0011%\t9\u0005AA\u0001\n\u0003\tI\u0005C\u0005\u0002V\u0001\t\t\u0011\"\u0011\u0002X!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0011q\r\u0005\n\u0003W\u0002\u0011\u0011!C!\u0003[B\u0011\"!\u001d\u0001\u0003\u0003%\t%a\u001d\b\u0013\u0005]U$!A\t\u0002\u0005ee\u0001\u0003\u000f\u001e\u0003\u0003E\t!a'\t\rU#B\u0011AAZ\u0011%\t)\fFA\u0001\n\u000b\n9\fC\u0005\u0002:R\t\t\u0011\"!\u0002<\"I\u0011q\u0018\u000b\u0012\u0002\u0013\u0005\u0011Q\u0003\u0005\n\u0003\u0003$\u0012\u0011!CA\u0003\u0007D\u0011\"a3\u0015#\u0003%\t!!\u0006\t\u0013\u00055G#!A\u0005\n\u0005='A\u0004'pG\u0006dG+[7fgR\fW\u000e\u001d\u0006\u0003=}\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001%I\u0001\tG\u0006$\u0018\r\\=ti*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M1\u0001aK\u00183km\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003\u001d1+\u0017MZ#yaJ,7o]5p]B\u0011A\u0006M\u0005\u0003cu\u0011q\u0003V5nKj{g.Z!xCJ,W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00051\u001a\u0014B\u0001\u001b\u001e\u0005M1u\u000e\u001c3bE2,WK\\3wC2,\u0018M\u00197f!\t1\u0014(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0010#\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!*\u0003\u0019a$o\\8u}%\t\u0001(\u0003\u0002Do\u00059\u0001/Y2lC\u001e,\u0017BA#G\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0019u'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012!\u0013\t\u0004m)c\u0015BA&8\u0005\u0019y\u0005\u000f^5p]B\u0011Q*\u0015\b\u0003\u001d>\u0003\"AP\u001c\n\u0005A;\u0014A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U\u001c\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005]C\u0006C\u0001\u0017\u0001\u0011\u001d95\u0001%AA\u0002%#\u0012aV\u0001\t]VdG.\u00192mKV\tA\f\u0005\u00027;&\u0011al\u000e\u0002\b\u0005>|G.Z1o\u0003!!\u0017\r^1UsB,W#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011\f\u0013!\u0002;za\u0016\u001c\u0018B\u00014d\u0005!!\u0015\r^1UsB,\u0017\u0001\u00068pI\u0016\u0004\u0016\r\u001e;fe:\u001c\u0018J\u001c;fe:\fG\u000eF\u0001j!\ra$\u000e\\\u0005\u0003W\u001a\u00131aU3r!\tigP\u0004\u0002ow:\u0011q.\u001f\b\u0003abt!!]<\u000f\u0005I4hBA:v\u001d\tqD/C\u0001)\u0013\t1s%\u0003\u0002%K%\u0011!eI\u0005\u0003A\u0005J!A_\u0010\u0002\u000bQ\u0014X-Z:\n\u0005ql\u0018a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:T!A_\u0010\n\u0007}\f\tAA\u0006Ue\u0016,\u0007+\u0019;uKJt'B\u0001?~\u000319\u0018\u000e\u001e5US6,'l\u001c8f)\ry\u0013q\u0001\u0005\u0006\u000f\"\u0001\r\u0001T\u0001\u000baJ,G\u000f^=OC6,W#\u0001'\u0002\t\r|\u0007/\u001f\u000b\u0004/\u0006E\u0001bB$\u000b!\u0003\u0005\r!S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t9BK\u0002J\u00033Y#!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K9\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011FA\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005Y\u0006twM\u0003\u0002\u0002:\u0005!!.\u0019<b\u0013\r\u0011\u00161G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0003\u00022ANA\"\u0013\r\t)e\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\n\t\u0006E\u00027\u0003\u001bJ1!a\u00148\u0005\r\te.\u001f\u0005\n\u0003'r\u0011\u0011!a\u0001\u0003\u0003\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA-!\u0019\tY&!\u0019\u0002L5\u0011\u0011Q\f\u0006\u0004\u0003?:\u0014AC2pY2,7\r^5p]&!\u00111MA/\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007q\u000bI\u0007C\u0005\u0002TA\t\t\u00111\u0001\u0002L\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty#a\u001c\t\u0013\u0005M\u0013#!AA\u0002\u0005\u0005\u0013AB3rk\u0006d7\u000fF\u0002]\u0003kB\u0011\"a\u0015\u0013\u0003\u0003\u0005\r!a\u0013)'\u0001\tI(a \u0002\u0002\u0006\u0015\u0015qQAF\u0003\u001b\u000b\t*a%\u0011\u00071\nY(C\u0002\u0002~u\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0004\u0006\u0011)D\u0003\u0011!A\u0001zf)\u0016(D?\"J\u0003%\f\u0011SKR,(O\\:!i\",\u0007eY;se\u0016tG\u000f\t;j[\u0016\u001cH/Y7qA]LG\u000f[8vi\u0002\"\u0018.\\3!u>tW\rI1uAQDW\rI:uCJ$\be\u001c4!cV,'/\u001f\u0011fm\u0006dW/\u0019;j_:t\u0003%\u00117mA\r\fG\u000e\\:!_\u001a\u0004Cn\\2bYRLW.Z:uC6\u0004\be^5uQ&t\u0007\u0005\u001e5fAM\fW.\u001a\u0011rk\u0016\u0014\u0018\u0010\t:fiV\u0014h\u000e\t;iK\u0002\u001a\u0018-\\3!m\u0006dW/\u001a\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fI\u0017!%\u0016$XO\u001d8tAQDW\rI2veJ,g\u000e\u001e\u0011m_\u000e\fG\u000e\t3bi\u0016lC/[7fA\u0005$\b\u0005\u001e5fAM,7o]5p]\u0002\"\u0018.\\3!u>tW\rI1uAQDW\rI:uCJ$\be\u001c4!cV,'/\u001f\u0011fm\u0006dW/\u0019;j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!#\u0002\u0013*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aI\u0002T\u0006\r\u001b.eU\u0002\u0013'\u000e\u001e5si\n\u0014GL\u001d2i)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002\u0010\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAK\u0003\u0015\u0019d\u0006\u000e\u00181\u00039aunY1m)&lWm\u001d;b[B\u0004\"\u0001\f\u000b\u0014\u000bQ\ti*!+\u0011\r\u0005}\u0015QU%X\u001b\t\t\tKC\u0002\u0002$^\nqA];oi&lW-\u0003\u0003\u0002(\u0006\u0005&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u00111VAY\u001b\t\tiK\u0003\u0003\u00020\u0006]\u0012AA5p\u0013\r)\u0015Q\u0016\u000b\u0003\u00033\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003_\tQ!\u00199qYf$2aVA_\u0011\u001d9u\u0003%AA\u0002%\u000bq\"\u00199qYf$C-\u001a4bk2$H%M\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)-a2\u0011\u0007YR\u0015\n\u0003\u0005\u0002Jf\t\t\u00111\u0001X\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005E\u0007\u0003BA\u0019\u0003'LA!!6\u00024\t1qJ\u00196fGR\u0004")
public class LocalTimestamp
extends LeafExpression
implements TimeZoneAwareExpression,
FoldableUnevaluable,
Serializable {
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$1() {
        return LocalTimestamp$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<String>> unapply(LocalTimestamp x$0) {
        return LocalTimestamp$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$1() {
        return LocalTimestamp$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<String>, A> andThen(Function1<LocalTimestamp, A> g) {
        return LocalTimestamp$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, LocalTimestamp> compose(Function1<A$, Option<String>> g) {
        return LocalTimestamp$.MODULE$.compose(g);
    }

    @Override
    public boolean foldable() {
        return FoldableUnevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return FoldableUnevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return FoldableUnevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return FoldableUnevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        LocalTimestamp localTimestamp = this;
        synchronized (localTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        LocalTimestamp localTimestamp = this;
        synchronized (localTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return TimestampNTZType$.MODULE$;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.CURRENT_LIKE(), (List)Nil$.MODULE$);
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        return this.copy((Option<String>)Option$.MODULE$.apply((Object)timeZoneId));
    }

    @Override
    public String prettyName() {
        return "localtimestamp";
    }

    public LocalTimestamp copy(Option<String> timeZoneId) {
        return new LocalTimestamp(timeZoneId);
    }

    public Option<String> copy$default$1() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "LocalTimestamp";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LocalTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LocalTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        LocalTimestamp localTimestamp = (LocalTimestamp)x$1;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = localTimestamp.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!localTimestamp.canEqual(this)) return false;
        return true;
    }

    public LocalTimestamp(Option<String> timeZoneId) {
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        FoldableUnevaluable.$init$(this);
        Statics.releaseFence();
    }

    public LocalTimestamp() {
        this((Option<String>)None$.MODULE$);
    }
}

