/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.SparkDateTimeException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.SeptenaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function7;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple10;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create timestamp from year, month, day, hour, min, sec and timezone fields. The result data type is consistent with the value of configuration `spark.sql.timestampType`. If the configuration `spark.sql.ansi.enabled` is false, the function returns NULL on invalid inputs. Otherwise, it will throw an error instead.", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from 0 to 60.\n              The value can be either an integer like 13 , or a fraction like 13.123.\n              If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 1);\n       2019-06-30 23:59:01\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0005\rMb\u0001\u0002\"D\u0001BC\u0001b\u001d\u0001\u0003\u0016\u0004%\t\u0001\u001e\u0005\tq\u0002\u0011\t\u0012)A\u0005k\"A\u0011\u0010\u0001BK\u0002\u0013\u0005A\u000f\u0003\u0005{\u0001\tE\t\u0015!\u0003v\u0011!Y\bA!f\u0001\n\u0003!\b\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011B;\t\u0011u\u0004!Q3A\u0005\u0002QD\u0001B \u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\t\u007f\u0002\u0011)\u001a!C\u0001i\"I\u0011\u0011\u0001\u0001\u0003\u0012\u0003\u0006I!\u001e\u0005\n\u0003\u0007\u0001!Q3A\u0005\u0002QD\u0011\"!\u0002\u0001\u0005#\u0005\u000b\u0011B;\t\u0015\u0005\u001d\u0001A!f\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0012)A\u0005\u0003\u0017A!\"a\u0005\u0001\u0005+\u0007I\u0011AA\u000b\u0011)\tI\u0003\u0001B\tB\u0003%\u0011q\u0003\u0005\u000b\u0003W\u0001!Q3A\u0005\u0002\u00055\u0002BCA\u001b\u0001\tE\t\u0015!\u0003\u00020!Q\u0011q\u0007\u0001\u0003\u0016\u0004%\t%!\u000f\t\u0015\u0005\u001d\u0003A!E!\u0002\u0013\tY\u0004C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u0005%\u0003\u0001\"\u0001\u0002d!9\u0011\u0011\n\u0001\u0005\u0002\u0005E\u0004bBAA\u0001\u0011\u0005\u00131\u0011\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\t9\n\u0001C!\u0003[Aq!!'\u0001\t\u0003\nY\nC\u0004\u0002 \u0002!I!!)\t\u000f\u0005]\u0007\u0001\"\u0011\u0002Z\"9\u00111\u001e\u0001\u0005B\u00055\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u0005\u001b\u0001A\u0011\u000bB\b\u0011%\u0011Y\u0002AA\u0001\n\u0003\u0011i\u0002C\u0005\u00034\u0001\t\n\u0011\"\u0001\u00036!I!1\n\u0001\u0012\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u001b\u0002\u0011\u0013!C\u0001\u0005kA\u0011Ba\u0014\u0001#\u0003%\tA!\u000e\t\u0013\tE\u0003!%A\u0005\u0002\tU\u0002\"\u0003B*\u0001E\u0005I\u0011\u0001B\u001b\u0011%\u0011)\u0006AI\u0001\n\u0003\u00119\u0006C\u0005\u0003\\\u0001\t\n\u0011\"\u0001\u0003^!I!\u0011\r\u0001\u0012\u0002\u0013\u0005!1\r\u0005\n\u0005O\u0002\u0011\u0013!C\u0001\u0005SB\u0011B!\u001c\u0001\u0003\u0003%\tEa\u001c\t\u0013\tm\u0004!!A\u0005\u0002\tu\u0004\"\u0003B@\u0001\u0005\u0005I\u0011\u0001BA\u0011%\u00119\tAA\u0001\n\u0003\u0012I\tC\u0005\u0003\u0018\u0002\t\t\u0011\"\u0001\u0003\u001a\"I!Q\u0014\u0001\u0002\u0002\u0013\u0005#q\u0014\u0005\n\u0005G\u0003\u0011\u0011!C!\u0005K;\u0011Ba4D\u0003\u0003E\tA!5\u0007\u0011\t\u001b\u0015\u0011!E\u0001\u0005'Dq!!\u00135\t\u0003\u0011Y\u000fC\u0005\u0003nR\n\t\u0011\"\u0012\u0003p\"I!\u0011\u001f\u001b\u0002\u0002\u0013\u0005%1\u001f\u0005\n\u0007\u0013!\u0014\u0013!C\u0001\u0005/B\u0011ba\u00035#\u0003%\tA!\u0018\t\u0013\r5A'%A\u0005\u0002\t\r\u0004\"CB\biE\u0005I\u0011\u0001B5\u0011%\u0019\t\u0002NA\u0001\n\u0003\u001b\u0019\u0002C\u0005\u0004\"Q\n\n\u0011\"\u0001\u0003X!I11\u0005\u001b\u0012\u0002\u0013\u0005!Q\f\u0005\n\u0007K!\u0014\u0013!C\u0001\u0005GB\u0011ba\n5#\u0003%\tA!\u001b\t\u0013\r%B'!A\u0005\n\r-\"!D'bW\u0016$\u0016.\\3ti\u0006l\u0007O\u0003\u0002E\u000b\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t1u)\u0001\u0005dCR\fG._:u\u0015\tA\u0015*A\u0002tc2T!AS&\u0002\u000bM\u0004\u0018M]6\u000b\u00051k\u0015AB1qC\u000eDWMC\u0001O\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011+\u0016-\\E\"\u0004\"AU*\u000e\u0003\rK!\u0001V\"\u0003'M+\u0007\u000f^3oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I3\u0016BA,D\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002S3&\u0011!l\u0011\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Al\u0018\b\u0003%vK!AX\"\u0002\u000fA\f7m[1hK&\u0011\u0001-\u0019\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tq6\t\u0005\u0002dM6\tAMC\u0001f\u0003\u0015\u00198-\u00197b\u0013\t9GMA\u0004Qe>$Wo\u0019;\u0011\u0005%\u0004hB\u00016p\u001d\tYg.D\u0001m\u0015\tiw*\u0001\u0004=e>|GOP\u0005\u0002K&\u0011a\fZ\u0005\u0003cJ\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!A\u00183\u0002\te,\u0017M]\u000b\u0002kB\u0011!K^\u0005\u0003o\u000e\u0013!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015IX-\u0019:!\u0003\u0015iwN\u001c;i\u0003\u0019iwN\u001c;iA\u0005\u0019A-Y=\u0002\t\u0011\f\u0017\u0010I\u0001\u0005Q>,(/A\u0003i_V\u0014\b%A\u0002nS:\fA!\\5oA\u0005\u00191/Z2\u0002\tM,7\rI\u0001\ti&lWM_8oKV\u0011\u00111\u0002\t\u0005G\u00065Q/C\u0002\u0002\u0010\u0011\u0014aa\u00149uS>t\u0017!\u0003;j[\u0016TxN\\3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0003\u0003/\u0001RaYA\u0007\u00033\u0001B!a\u0007\u0002$9!\u0011QDA\u0010!\tYG-C\u0002\u0002\"\u0011\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011I\u0006YA/[7f5>tW-\u00133!\u0003-1\u0017-\u001b7P]\u0016\u0013(o\u001c:\u0016\u0005\u0005=\u0002cA2\u00022%\u0019\u00111\u00073\u0003\u000f\t{w\u000e\\3b]\u0006aa-Y5m\u001f:,%O]8sA\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\u001d\u000bQ\u0001^=qKNLA!!\u0012\u0002@\tAA)\u0019;b)f\u0004X-A\u0005eCR\fG+\u001f9fA\u00051A(\u001b8jiz\"b#!\u0014\u0002P\u0005E\u00131KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011\r\t\u0003%\u0002AQa]\u000bA\u0002UDQ!_\u000bA\u0002UDQa_\u000bA\u0002UDQ!`\u000bA\u0002UDQa`\u000bA\u0002UDa!a\u0001\u0016\u0001\u0004)\b\"CA\u0004+A\u0005\t\u0019AA\u0006\u0011%\t\u0019\"\u0006I\u0001\u0002\u0004\t9\u0002C\u0005\u0002,U\u0001\n\u00111\u0001\u00020!I\u0011qG\u000b\u0011\u0002\u0003\u0007\u00111\b\u000b\u000f\u0003\u001b\n)'a\u001a\u0002j\u0005-\u0014QNA8\u0011\u0015\u0019h\u00031\u0001v\u0011\u0015Ih\u00031\u0001v\u0011\u0015Yh\u00031\u0001v\u0011\u0015ih\u00031\u0001v\u0011\u0015yh\u00031\u0001v\u0011\u0019\t\u0019A\u0006a\u0001kR\u0001\u0012QJA:\u0003k\n9(!\u001f\u0002|\u0005u\u0014q\u0010\u0005\u0006g^\u0001\r!\u001e\u0005\u0006s^\u0001\r!\u001e\u0005\u0006w^\u0001\r!\u001e\u0005\u0006{^\u0001\r!\u001e\u0005\u0006\u007f^\u0001\r!\u001e\u0005\u0007\u0003\u00079\u0002\u0019A;\t\r\u0005\u001dq\u00031\u0001v\u0003!\u0019\u0007.\u001b7ee\u0016tWCAAC!\u0011I\u0017qQ;\n\u0007\u0005%%OA\u0002TKF\f!\"\u001b8qkR$\u0016\u0010]3t+\t\ty\tE\u0003j\u0003\u000f\u000b\t\n\u0005\u0003\u0002>\u0005M\u0015\u0002BAK\u0003\u007f\u0011\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u00119,H\u000e\\1cY\u0016\fAb^5uQRKW.\u001a.p]\u0016$2!VAO\u0011\u001d\t\u0019b\u0007a\u0001\u00033\t\u0001\u0002^8NS\u000e\u0014xn\u001d\u000b\u0011\u0003G\u000bI+!-\u00024\u0006U\u0016qWA]\u0003\u0007\u00042aYAS\u0013\r\t9\u000b\u001a\u0002\u0004\u0003:L\bBB:\u001d\u0001\u0004\tY\u000bE\u0002d\u0003[K1!a,e\u0005\rIe\u000e\u001e\u0005\u0007sr\u0001\r!a+\t\rmd\u0002\u0019AAV\u0011\u0019iH\u00041\u0001\u0002,\"1q\u0010\ba\u0001\u0003WCq!a/\u001d\u0001\u0004\ti,\u0001\u0007tK\u000e\fe\u000eZ'jGJ|7\u000f\u0005\u0003\u0002>\u0005}\u0016\u0002BAa\u0003\u007f\u0011q\u0001R3dS6\fG\u000eC\u0004\u0002Fr\u0001\r!a2\u0002\ri|g.Z%e!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fA\u0001^5nK*\u0011\u0011\u0011[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002V\u0006-'A\u0002.p]\u0016LE-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\t\u0002$\u0006m\u0017Q\\Ap\u0003C\f\u0019/!:\u0002h\"11/\ba\u0001\u0003GCa!_\u000fA\u0002\u0005\r\u0006BB>\u001e\u0001\u0004\t\u0019\u000b\u0003\u0004~;\u0001\u0007\u00111\u0015\u0005\u0007\u007fv\u0001\r!a)\t\u000f\u0005\rQ\u00041\u0001\u0002$\"9\u0011qA\u000fA\u0002\u0005%\b#B2\u0002\u000e\u0005\r\u0016!\u00033p\u000f\u0016t7i\u001c3f)\u0019\ty/a?\u0003\u0006A!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002v\u000e\u000bqaY8eK\u001e,g.\u0003\u0003\u0002z\u0006M(\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005uh\u00041\u0001\u0002\u0000\u0006\u00191\r\u001e=\u0011\t\u0005E(\u0011A\u0005\u0005\u0005\u0007\t\u0019P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\t\u001da\u00041\u0001\u0002p\u0006\u0011QM^\u0001\t]>$WMT1nKV\u0011\u0011\u0011D\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$B!!\u0014\u0003\u0012!9!1\u0003\u0011A\u0002\tU\u0011a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004B!\u001bB\fk&\u0019!\u0011\u0004:\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLHCFA'\u0005?\u0011\tCa\t\u0003&\t\u001d\"\u0011\u0006B\u0016\u0005[\u0011yC!\r\t\u000fM\f\u0003\u0013!a\u0001k\"9\u00110\tI\u0001\u0002\u0004)\bbB>\"!\u0003\u0005\r!\u001e\u0005\b{\u0006\u0002\n\u00111\u0001v\u0011\u001dy\u0018\u0005%AA\u0002UD\u0001\"a\u0001\"!\u0003\u0005\r!\u001e\u0005\n\u0003\u000f\t\u0003\u0013!a\u0001\u0003\u0017A\u0011\"a\u0005\"!\u0003\u0005\r!a\u0006\t\u0013\u0005-\u0012\u0005%AA\u0002\u0005=\u0002\"CA\u001cCA\u0005\t\u0019AA\u001e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u000e+\u0007U\u0014Id\u000b\u0002\u0003<A!!Q\bB$\u001b\t\u0011yD\u0003\u0003\u0003B\t\r\u0013!C;oG\",7m[3e\u0015\r\u0011)\u0005Z\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B%\u0005\u007f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122\u0014AD2paf$C-\u001a4bk2$HeN\u000b\u0003\u00053RC!a\u0003\u0003:\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012BTC\u0001B0U\u0011\t9B!\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\r\u0016\u0005\u0003_\u0011I$A\bd_BLH\u0005Z3gCVdG\u000fJ\u00191+\t\u0011YG\u000b\u0003\u0002<\te\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003rA!!1\u000fB=\u001b\t\u0011)H\u0003\u0003\u0003x\u0005=\u0017\u0001\u00027b]\u001eLA!!\n\u0003v\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111V\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019Ka!\t\u0013\t\u0015e&!AA\u0002\u0005-\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\fB1!Q\u0012BJ\u0003Gk!Aa$\u000b\u0007\tEE-\u0001\u0006d_2dWm\u0019;j_:LAA!&\u0003\u0010\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tyCa'\t\u0013\t\u0015\u0005'!AA\u0002\u0005\r\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u001d\u0003\"\"I!QQ\u0019\u0002\u0002\u0003\u0007\u00111V\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\"q\u0015\u0005\n\u0005\u000b\u0013\u0014\u0011!a\u0001\u0003GCs\u0003\u0001BV\u0005c\u0013\u0019La.\u0003:\nu&q\u0018Bb\u0005\u000b\u0014IMa3\u0011\u0007I\u0013i+C\u0002\u00030\u000e\u0013Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00036\u0006\u0011\to\u0018$V\u001d\u000e{\u0006&_3be2\u0002Sn\u001c8uQ2\u0002C-Y=-A!|WO\u001d\u0017![&tG\u0006I:fGnc\u0003\u0005^5nKj|g.Z/*A5\u00023I]3bi\u0016\u0004C/[7fgR\fW\u000e\u001d\u0011ge>l\u0007%_3be2\u0002Sn\u001c8uQ2\u0002C-Y=-A!|WO\u001d\u0017![&tG\u0006I:fG\u0002\ng\u000e\u001a\u0011uS6,'p\u001c8fA\u0019LW\r\u001c3t]\u0001\"\u0006.\u001a\u0011sKN,H\u000e\u001e\u0011eCR\f\u0007\u0005^=qK\u0002J7\u000fI2p]NL7\u000f^3oi\u0002:\u0018\u000e\u001e5!i\",\u0007E^1mk\u0016\u0004sN\u001a\u0011d_:4\u0017nZ;sCRLwN\u001c\u0011agB\f'o\u001b\u0018tc2tC/[7fgR\fW\u000e\u001d+za\u0016\u0004g\u0006I%gAQDW\rI2p]\u001aLw-\u001e:bi&|g\u000e\t1ta\u0006\u00148NL:rY:\ngn]5/K:\f'\r\\3eA\u0002J7\u000f\t4bYN,G\u0006\t;iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000f\t(V\u00192\u0003sN\u001c\u0011j]Z\fG.\u001b3!S:\u0004X\u000f^:/A=#\b.\u001a:xSN,G\u0006I5uA]LG\u000e\u001c\u0011uQJ|w\u000fI1oA\u0015\u0014(o\u001c:!S:\u001cH/Z1e]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0005w\u000bQq\u0013\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+Ae,\u0017M\u001d\u0011.AQDW\rI=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002Co\u001c\u0011:seJ$\u0002\t\u0011!A\u0001\u0002#\u0006I7p]RD\u0007%\f\u0011uQ\u0016\u0004Sn\u001c8uQ6zg-L=fCJ\u0004Co\u001c\u0011sKB\u0014Xm]3oi2\u0002cM]8nAE\u0002\u0003FS1ok\u0006\u0014\u00180\u000b\u0011u_\u0002\n$\u0007\t\u0015EK\u000e,WNY3sS)\u0001\u0003\u0005\t\u0011!A)\u0002C-Y=![\u0001\"\b.\u001a\u0011eCflsNZ\u0017n_:$\b\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0013\u0007\t;pAM\n$\u0002\t\u0011!A\u0001\u0002#\u0006\t5pkJ\u0004S\u0006\t;iK\u0002Bw.\u001e:._\u001alC-Y=!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000e\t\u0019!i>\u0004#g\r\u0006!A\u0001\u0002\u0003\u0005\t\u0016![&t\u0007%\f\u0011uQ\u0016\u0004S.\u001b8vi\u0016lsNZ\u0017i_V\u0014\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0005^8!keR\u0001\u0005\t\u0011!A\u0001R\u0003e]3dA5\u0002C\u000f[3!g\u0016\u001cwN\u001c3._\u001alS.\u001b8vi\u0016\u0004\u0013M\u001c3!SR\u001c\b%\\5de>lcM]1di&|g\u000e\t;pAI,\u0007O]3tK:$H\u0006\t4s_6\u0004\u0003\u0007\t;pAY\u0002dF\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t+iK\u00022\u0018\r\\;fA\r\fg\u000e\t2fA\u0015LG\u000f[3sA\u0005t\u0007%\u001b8uK\u001e,'\u000f\t7jW\u0016\u0004\u0013g\r\u0011-A=\u0014\b%\u0019\u0011ge\u0006\u001cG/[8oA1L7.\u001a\u00112g9\n$g\r\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004C\u000f[3!g\u0016\u001c\u0007%\u0019:hk6,g\u000e\u001e\u0011fcV\fGn\u001d\u0011u_\u00022\u0004\u0007\f\u0011uQ\u0016\u00043/Z2p]\u0012\u001c\bEZ5fY\u0012\u0004\u0013n\u001d\u0011tKRT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002Co\u001c\u00111A\u0005tG\rI\u0019![&tW\u000f^3!SN\u0004\u0013\r\u001a3fI\u0002\"x\u000e\t;iK\u00022\u0017N\\1mAQLW.Z:uC6\u0004hF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011uS6,'p\u001c8fA5\u0002C\u000f[3!i&lW\r\t>p]\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017!\u0007\u0016#F\u0006I+U\u0007\u0002\ng\u000e\u001a\u0011fi\u000et#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#A!1\u0002\u0007;Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192i1\u0002\u0013G\r\u0017!eab\u0003E\u000e\u0017!gAb\u0003\u0005N\u001b/qa:\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\"T&\r\u001a.ea\u0002\u0003G\u000e\u001e4ai\"TG\f\u001d9o)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C#\u0007M\u00195Y\u0001\n$\u0007\f\u00113q1\u0002c\u0007\f\u00114a1\u0002C'\u000e\u00189q]b\u0003eJ\"F)\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1cQj\u0013GM\u00173o\u0001\u0012\u0014GO\u001a1uQ*d\u0006\u000f\u001d8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AYb\u0003e\r\u0019-AI\u001aD\u0006I\u001b:Y\u00012\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\n\u0014(\f\u00198[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)eA\n\u0014\b\f\u00117Y\u0001\u001a\u0004\u0007\f\u00113g1\u0002S'\u000f\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192s5\u0002d'L\u001a1AI\u001a$(N\u001d;aER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\;mY2\u0002s\u0007\f\u00113e1\u0002\u0013'\u000e\u0017!gAb\u0003\u0005M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9+F\n\u0014\u0006!A\u0005)qM]8va\u0006\u0012!qY\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011i-A\u00034]Ar\u0003'A\u0007NC.,G+[7fgR\fW\u000e\u001d\t\u0003%R\u001aR\u0001\u000eBk\u0005C\u0004BCa6\u0003^V,X/^;v\u0003\u0017\t9\"a\f\u0002<\u00055SB\u0001Bm\u0015\r\u0011Y\u000eZ\u0001\beVtG/[7f\u0013\u0011\u0011yN!7\u0003%\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\r\t\u0005\u0005G\u0014I/\u0004\u0002\u0003f*!!q]Ah\u0003\tIw.C\u0002r\u0005K$\"A!5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u001d\u0002\u000b\u0005\u0004\b\u000f\\=\u0015-\u00055#Q\u001fB|\u0005s\u0014YP!@\u0003\u0000\u000e\u000511AB\u0003\u0007\u000fAQa]\u001cA\u0002UDQ!_\u001cA\u0002UDQa_\u001cA\u0002UDQ!`\u001cA\u0002UDQa`\u001cA\u0002UDa!a\u00018\u0001\u0004)\b\"CA\u0004oA\u0005\t\u0019AA\u0006\u0011%\t\u0019b\u000eI\u0001\u0002\u0004\t9\u0002C\u0005\u0002,]\u0002\n\u00111\u0001\u00020!I\u0011qG\u001c\u0011\u0002\u0003\u0007\u00111H\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u0003A\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0004'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\rU1Q\u0004\t\u0006G\u000651q\u0003\t\u0012G\u000eeQ/^;vkV\fY!a\u0006\u00020\u0005m\u0012bAB\u000eI\n9A+\u001e9mKF\u0002\u0004\"CB\u0010y\u0005\u0005\t\u0019AA'\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%s\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB\u0017!\u0011\u0011\u0019ha\f\n\t\rE\"Q\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class MakeTimestamp
extends SeptenaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final Option<String> timeZoneId;
    private final boolean failOnError;
    private final DataType dataType;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static DataType $lessinit$greater$default$10() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$10();
    }

    public static boolean $lessinit$greater$default$9() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<String> $lessinit$greater$default$8() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return MakeTimestamp$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>> unapply(MakeTimestamp x$0) {
        return MakeTimestamp$.MODULE$.unapply(x$0);
    }

    public static DataType apply$default$10() {
        return MakeTimestamp$.MODULE$.apply$default$10();
    }

    public static boolean apply$default$9() {
        return MakeTimestamp$.MODULE$.apply$default$9();
    }

    public static Option<String> apply$default$8() {
        return MakeTimestamp$.MODULE$.apply$default$8();
    }

    public static Option<Expression> apply$default$7() {
        return MakeTimestamp$.MODULE$.apply$default$7();
    }

    public static Function1<Tuple10<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Option<String>, Object, DataType>, MakeTimestamp> tupled() {
        return MakeTimestamp$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, Function1<DataType, MakeTimestamp>>>>>>>>>> curried() {
        return MakeTimestamp$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        MakeTimestamp makeTimestamp = this;
        synchronized (makeTimestamp) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.year(), (List)new .colon.colon((Object)this.month(), (List)new .colon.colon((Object)this.day(), (List)new .colon.colon((Object)this.hour(), (List)new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.sec(), (List)Nil$.MODULE$)))))).$plus$plus(this.timezone());
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)new DecimalType(16, 6), (List)Nil$.MODULE$)))))).$plus$plus((IterableOnce)this.timezone().map((Function1 & Serializable)x$10 -> StringTypeAnyCollation$.MODULE$));
    }

    @Override
    public boolean nullable() {
        if (this.failOnError()) {
            return this.children().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.nullable()));
        }
        return true;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$9();
        DataType x$10 = this.copy$default$10();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, (Option<String>)x$1, x$9, x$10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toMicros(int year, int month, int day, int hour, int min, Decimal secAndMicros, ZoneId zoneId) {
        try {
            LocalDateTime localDateTime;
            Predef$.MODULE$.assert(secAndMicros.scale() == 6, (Function0 & Serializable)() -> "Seconds fraction must have 6 digits for microseconds but got " + secAndMicros.scale());
            long unscaledSecFrac = secAndMicros.toUnscaledLong();
            int totalMicros = (int)unscaledSecFrac;
            int seconds = Math.floorDiv(totalMicros, 1000000);
            int nanos = Math.floorMod(totalMicros, 1000000) * 1000;
            if (seconds == 60) {
                if (nanos != 0) throw QueryExecutionErrors$.MODULE$.invalidFractionOfSecondError();
                localDateTime = LocalDateTime.of(year, month, day, hour, min, 0, 0).plusMinutes(1L);
            } else {
                localDateTime = LocalDateTime.of(year, month, day, hour, min, seconds, nanos);
            }
            LocalDateTime ldt = localDateTime;
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            Long l = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(ldt.atZone(zoneId).toInstant())) : BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt));
            return l;
        }
        catch (Throwable throwable) {
            boolean bl = false;
            DateTimeException dateTimeException = null;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkDateTimeException) {
                SparkDateTimeException sparkDateTimeException = (SparkDateTimeException)throwable2;
                if (this.failOnError()) {
                    throw sparkDateTimeException;
                }
            }
            if (throwable2 instanceof DateTimeException) {
                bl = true;
                dateTimeException = (DateTimeException)throwable2;
                if (this.failOnError()) {
                    throw QueryExecutionErrors$.MODULE$.ansiDateTimeError(dateTimeException);
                }
            }
            if (!bl) throw throwable;
            return null;
        }
    }

    @Override
    public Object nullSafeEval(Object year, Object month, Object day, Object hour, Object min, Object sec, Option<Object> timezone) {
        ZoneId zid = (ZoneId)timezone.map((Function1 & Serializable)tz -> DateTimeUtils$.MODULE$.getZoneId(((UTF8String)tz).toString())).getOrElse((Function0 & Serializable)() -> this.zoneId());
        return this.toMicros(BoxesRunTime.unboxToInt((Object)year), BoxesRunTime.unboxToInt((Object)month), BoxesRunTime.unboxToInt((Object)day), BoxesRunTime.unboxToInt((Object)hour), BoxesRunTime.unboxToInt((Object)min), (Decimal)sec, zid);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String d = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(Decimal$.MODULE$.getClass().getName()), "$");
        String failOnErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiDateTimeError(e);" : ev.isNull() + " = true;";
        String failOnSparkErrorBranch = this.failOnError() ? "throw e;" : ev.isNull() + " = true;";
        return this.nullSafeCodeGen(ctx, ev, (Function7<String, String, String, String, String, String, Option<String>, String>)(Function7 & Serializable)(year, month, day, hour, min, secAndNanos, timezone) -> {
            String zoneId = (String)timezone.map((Function1 & Serializable)tz -> dtu + ".getZoneId(" + tz + ".toString())").getOrElse((Function0 & Serializable)() -> zid);
            DataType dataType = this.dataType();
            TimestampType$ timestampType$ = TimestampType$.MODULE$;
            String toMicrosCode = !(dataType != null ? !dataType.equals(timestampType$) : timestampType$ != null) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |java.time.Instant instant = ldt.atZone(" + zoneId + ").toInstant();\n           |" + ev.value() + " = " + dtu + ".instantToMicros(instant);\n           |")) : ev.value() + " = " + dtu + ".localDateTimeToMicros(ldt);";
            return "\n      try {\n        org.apache.spark.sql.types.Decimal secFloor = " + secAndNanos + ".floor();\n        org.apache.spark.sql.types.Decimal nanosPerSec = " + d + "$.MODULE$.apply(1000000000L, 10, 0);\n        int nanos = ((" + secAndNanos + ".$minus(secFloor)).$times(nanosPerSec)).toInt();\n        int seconds = secFloor.toInt();\n        java.time.LocalDateTime ldt;\n        if (seconds == 60) {\n          if (nanos == 0) {\n            ldt = java.time.LocalDateTime.of(\n              " + year + ", " + month + ", " + day + ", " + hour + ", " + min + ", 0, 0).plusMinutes(1);\n          } else {\n            throw QueryExecutionErrors.invalidFractionOfSecondError();\n          }\n        } else {\n          ldt = java.time.LocalDateTime.of(" + year + ", " + month + ", " + day + ", " + hour + ", " + min + ", seconds, nanos);\n        }\n        " + toMicrosCode + "\n      } catch (org.apache.spark.SparkDateTimeException e) {\n        " + failOnSparkErrorBranch + "\n      } catch (java.time.DateTimeException e) {\n        " + failOnErrorBranch + "\n      }";
        });
    }

    @Override
    public String nodeName() {
        return "make_timestamp";
    }

    @Override
    public MakeTimestamp withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        None$ timezoneOpt = this.timezone().isDefined() ? new Some(newChildren.apply(6)) : None$.MODULE$;
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1), (Expression)newChildren.apply(2), (Expression)newChildren.apply(3), (Expression)newChildren.apply(4), (Expression)newChildren.apply(5), (Option<Expression>)timezoneOpt, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
    }

    public MakeTimestamp copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        return new MakeTimestamp(year, month, day, hour, min, sec, timezone, timeZoneId, failOnError, dataType);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public DataType copy$default$10() {
        return this.dataType();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public Option<String> copy$default$8() {
        return this.timeZoneId();
    }

    public boolean copy$default$9() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestamp";
    }

    public int productArity() {
        return 10;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.year();
            }
            case 1: {
                return this.month();
            }
            case 2: {
                return this.day();
            }
            case 3: {
                return this.hour();
            }
            case 4: {
                return this.min();
            }
            case 5: {
                return this.sec();
            }
            case 6: {
                return this.timezone();
            }
            case 7: {
                return this.timeZoneId();
            }
            case 8: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
            case 9: {
                return this.dataType();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestamp;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "year";
            }
            case 1: {
                return "month";
            }
            case 2: {
                return "day";
            }
            case 3: {
                return "hour";
            }
            case 4: {
                return "min";
            }
            case 5: {
                return "sec";
            }
            case 6: {
                return "timezone";
            }
            case 7: {
                return "timeZoneId";
            }
            case 8: {
                return "failOnError";
            }
            case 9: {
                return "dataType";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestamp)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestamp makeTimestamp = (MakeTimestamp)x$1;
        if (this.failOnError() != makeTimestamp.failOnError()) return false;
        Expression expression = this.year();
        Expression expression2 = makeTimestamp.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestamp.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestamp.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestamp.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestamp.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestamp.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestamp.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = makeTimestamp.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        DataType dataType = this.dataType();
        DataType dataType2 = makeTimestamp.dataType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!makeTimestamp.canEqual(this)) return false;
        return true;
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, Option<String> timeZoneId, boolean failOnError, DataType dataType) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.timeZoneId = timeZoneId;
        this.failOnError = failOnError;
        this.dataType = dataType;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), (DataType)SQLConf$.MODULE$.get().timestampType());
    }

    public MakeTimestamp(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), (Option<String>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), (DataType)SQLConf$.MODULE$.get().timestampType());
    }
}

