/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Shuffle$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.RandomIndicesGenerator;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(array) - Returns a random permutation of the given array.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, 3, 5));\n       [3,1,5,20]\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       [20,null,3,1]\n  ", note="\n    The function is non-deterministic.\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\tMd\u0001B\u0015+\u0001^B\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005a\f\u0003\u0005f\u0001\tE\t\u0015!\u0003`\u0011\u00151\u0007\u0001\"\u0001h\u0011\u00151\u0007\u0001\"\u0001l\u0011\u00151\u0007\u0001\"\u0001n\u0011\u0015\t\b\u0001\"\u0011s\u0011\u00151\b\u0001\"\u0011Y\u0011\u00159\b\u0001\"\u0011y\u0011!Q\b\u0001#b\u0001\n\u0003\u0012\b\"B>\u0001\t\u0003b\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\u0007\u0003/\u0001A\u0011\u0002:\t\u0015\u0005e\u0001\u0001#b\u0001\n\u0003\ty\u0001C\u0006\u0002$\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0002bBA\u001a\u0001\u0011E\u0013Q\u0007\u0005\b\u0003\u000f\u0002A\u0011KA%\u0011\u001d\ti\u0006\u0001C)\u0003?Bq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u0018\u0002!\t%!'\t\u0013\u0005}\u0005!!A\u0005\u0002\u0005\u0005\u0006\"CAT\u0001E\u0005I\u0011AAU\u0011%\ty\fAI\u0001\n\u0003\t\t\rC\u0005\u0002F\u0002\t\t\u0011\"\u0011\u0002H\"I\u0011q\u001b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u00037\u0004\u0011\u0011!C\u0001\u0003;D\u0011\"a9\u0001\u0003\u0003%\t%!:\t\u0013\u0005M\b!!A\u0005\u0002\u0005U\b\"CA}\u0001\u0005\u0005I\u0011IA~\u0011%\ty\u0010AA\u0001\n\u0003\u0012\taB\u0005\u0003,)\n\t\u0011#\u0001\u0003.\u0019A\u0011FKA\u0001\u0012\u0003\u0011y\u0003\u0003\u0004gC\u0011\u0005!q\t\u0005\n\u0005\u0013\n\u0013\u0011!C#\u0005\u0017B\u0011B!\u0014\"\u0003\u0003%\tIa\u0014\t\u0013\tU\u0013%%A\u0005\u0002\u0005\u0005\u0007\"\u0003B,C\u0005\u0005I\u0011\u0011B-\u0011%\u00119'II\u0001\n\u0003\t\t\rC\u0005\u0003j\u0005\n\t\u0011\"\u0003\u0003l\t91\u000b[;gM2,'BA\u0016-\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00055r\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001ADh\u0010\"F\u0017B\u0011\u0011HO\u0007\u0002U%\u00111H\u000b\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011\u0011(P\u0005\u0003})\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tI\u0004)\u0003\u0002BU\t\u0001bj\u001c8eKR,'/\\5oSN$\u0018n\u0019\t\u0003s\rK!\u0001\u0012\u0016\u00031\u0015C\bO]3tg&|gnV5uQJ\u000bg\u000eZ8n'\u0016,G\r\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuIA\u0004Qe>$Wo\u0019;\u0011\u00051#fBA'S\u001d\tq\u0015+D\u0001P\u0015\t\u0001f'\u0001\u0004=e>|GOP\u0005\u0002\u0011&\u00111kR\u0001\ba\u0006\u001c7.Y4f\u0013\t)fK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002T\u000f\u0006)1\r[5mIV\t\u0011\f\u0005\u0002:5&\u00111L\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AB2iS2$\u0007%\u0001\u0006sC:$w.\\*fK\u0012,\u0012a\u0018\t\u0004\r\u0002\u0014\u0017BA1H\u0005\u0019y\u0005\u000f^5p]B\u0011aiY\u0005\u0003I\u001e\u0013A\u0001T8oO\u0006Y!/\u00198e_6\u001cV-\u001a3!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001.\u001b6\u0011\u0005e\u0002\u0001\"B,\u0006\u0001\u0004I\u0006bB/\u0006!\u0003\u0005\ra\u0018\u000b\u0003Q2DQa\u0016\u0004A\u0002e#2\u0001\u001b8p\u0011\u00159v\u00011\u0001Z\u0011\u0015\u0001x\u00011\u0001Z\u0003\u0011\u0019X-\u001a3\u0002\u0011M$\u0018\r^3gk2,\u0012a\u001d\t\u0003\rRL!!^$\u0003\u000f\t{w\u000e\\3b]\u0006q1/Z3e\u000bb\u0004(/Z:tS>t\u0017aC<ji\"tUm^*fK\u0012$\"\u0001[=\t\u000bAT\u0001\u0019\u00012\u0002\u0011I,7o\u001c7wK\u0012\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005i\b\u0003\u0002'\u007f\u0003\u0003I!a ,\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9AL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003\u0017\t)A\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0012A!\u00111AA\n\u0013\u0011\t)\"!\u0002\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!D]3tk2$\u0018I\u001d:bs\u0016cW-\\3oi:+H\u000e\\1cY\u0016\f1\"\u001a7f[\u0016tG\u000fV=qK\"\u001aq\"!\b\u0011\u0007\u0019\u000by\"C\u0002\u0002\"\u001d\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\rI\fg\u000eZ8n!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016Y\u0005!Q\u000f^5m\u0013\u0011\ty#!\u000b\u0003-I\u000bg\u000eZ8n\u0013:$\u0017nY3t\u000f\u0016tWM]1u_JD3\u0001EA\u000f\u0003IIg.\u001b;jC2L'0Z%oi\u0016\u0014h.\u00197\u0015\t\u0005]\u0012Q\b\t\u0004\r\u0006e\u0012bAA\u001e\u000f\n!QK\\5u\u0011\u001d\ty$\u0005a\u0001\u0003\u0003\na\u0002]1si&$\u0018n\u001c8J]\u0012,\u0007\u0010E\u0002G\u0003\u0007J1!!\u0012H\u0005\rIe\u000e^\u0001\rKZ\fG.\u00138uKJt\u0017\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006E\u0002G\u0003\u001bJ1!a\u0014H\u0005\r\te.\u001f\u0005\b\u0003'\u0012\u0002\u0019AA+\u0003\u0015Ig\u000e];u!\u0011\t9&!\u0017\u000e\u00031J1!a\u0017-\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA1\u0003[\n9\b\u0005\u0003\u0002d\u0005%TBAA3\u0015\r\t9GK\u0001\bG>$WmZ3o\u0013\u0011\tY'!\u001a\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u001c\u0014\u0001\u0004\t\t(A\u0002dib\u0004B!a\u0019\u0002t%!\u0011QOA3\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u001f\u0014\u0001\u0004\t\t'\u0001\u0002fm\u0006\u00192\u000f[;gM2,\u0017I\u001d:bs\u000e{G-Z$f]RA\u0011qPAH\u0003#\u000b\u0019\n\u0005\u0003\u0002\u0002\u0006%e\u0002BAB\u0003\u000b\u0003\"AT$\n\u0007\u0005\u001du)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0017\u000biI\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000f;\u0005bBA8)\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003s\"\u0002\u0019AA1\u0011\u001d\t)\n\u0006a\u0001\u0003\u007f\n\u0011b\u00195jY\u0012t\u0015-\\3\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\rA\u00171\u0014\u0005\u0007\u0003;+\u0002\u0019A-\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR)\u0001.a)\u0002&\"9qK\u0006I\u0001\u0002\u0004I\u0006bB/\u0017!\u0003\u0005\raX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYKK\u0002Z\u0003[[#!a,\u0011\t\u0005E\u00161X\u0007\u0003\u0003gSA!!.\u00028\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003s;\u0015AC1o]>$\u0018\r^5p]&!\u0011QXAZ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019MK\u0002`\u0003[\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAe!\u0011\tY-!6\u000e\u0005\u00055'\u0002BAh\u0003#\fA\u0001\\1oO*\u0011\u00111[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u00065\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA!\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0013\u0002`\"I\u0011\u0011]\u000e\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u001d\bCBAu\u0003_\fY%\u0004\u0002\u0002l*\u0019\u0011Q^$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002r\u0006-(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a]A|\u0011%\t\t/HA\u0001\u0002\u0004\tY%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAe\u0003{D\u0011\"!9\u001f\u0003\u0003\u0005\r!!\u0011\u0002\r\u0015\fX/\u00197t)\r\u0019(1\u0001\u0005\n\u0003C|\u0012\u0011!a\u0001\u0003\u0017Bs\u0003\u0001B\u0004\u0005\u001b\u0011yAa\u0005\u0003\u0016\te!1\u0004B\u0010\u0005C\u0011)Ca\n\u0011\u0007e\u0012I!C\u0002\u0003\f)\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0012\u0005\u0001uLR+O\u0007~C\u0013M\u001d:bs&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bAI\fg\u000eZ8nAA,'/\\;uCRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011hSZ,g\u000eI1se\u0006Lh&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u00119\"AA\u0012\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0019-AMb\u0003%N\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007L\u0019-k1\u0012\u0004'\u0018\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)CJ\u0014\u0018-\u001f\u00152Y\u0001\u0012\u0004\u0007\f\u0011ok2dG\u0006I\u001a*SmR\u0001\u0005\t\u0011!A\u0001\u00023L\r\u0019-]VdG\u000eL\u001a-cuS\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0003\u001e\u0005Q#\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2/\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0012\u0003-\t'O]1z?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t%\u0012!\u0002\u001a/i9\u0002\u0014aB*ik\u001a4G.\u001a\t\u0003s\u0005\u001aR!\tB\u0019\u0005{\u0001rAa\r\u0003:e{\u0006.\u0004\u0002\u00036)\u0019!qG$\u0002\u000fI,h\u000e^5nK&!!1\bB\u001b\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0005\u007f\u0011)%\u0004\u0002\u0003B)!!1IAi\u0003\tIw.C\u0002V\u0005\u0003\"\"A!\f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b!\u0014\tFa\u0015\t\u000b]#\u0003\u0019A-\t\u000fu#\u0003\u0013!a\u0001?\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tm#1\r\t\u0005\r\u0002\u0014i\u0006E\u0003G\u0005?Jv,C\u0002\u0003b\u001d\u0013a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B3M\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005[\u0002B!a3\u0003p%!!\u0011OAg\u0005\u0019y%M[3di\u0002")
public class Shuffle
extends UnaryExpression
implements ExpectsInputTypes,
Nondeterministic,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private transient DataType elementType;
    private final Expression child;
    private final Option<Object> randomSeed;
    private transient RandomIndicesGenerator random;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return Shuffle$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Object>>> unapply(Shuffle x$0) {
        return Shuffle$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$2() {
        return Shuffle$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Option<Object>>, Shuffle> tupled() {
        return Shuffle$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Object>, Shuffle>> curried() {
        return Shuffle$.MODULE$.curried();
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Shuffle withNewSeed(long seed) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)seed));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, (Option<Object>)x$1);
    }

    private boolean resolved$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.childrenResolved() && this.checkInputDataTypes().isSuccess() && this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.dataType()).containsNull();
    }

    private DataType elementType$lzycompute() {
        Shuffle shuffle = this;
        synchronized (shuffle) {
            if (!this.bitmap$trans$0) {
                this.elementType = ((ArrayType)this.dataType()).elementType();
                this.bitmap$trans$0 = true;
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if (!this.bitmap$trans$0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.random = new RandomIndicesGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        Object value = this.child().eval(input);
        if (value == null) {
            return null;
        }
        ArrayData source = (ArrayData)value;
        int numElements = source.numElements();
        int[] indices = this.random.getNextIndices(numElements);
        return new GenericArrayData((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(indices), (Function1 & Serializable)x$21 -> source.get(BoxesRunTime.unboxToInt((Object)x$21), this.elementType()), ClassTag$.MODULE$.apply(Object.class)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> this.shuffleArrayCodeGen(ctx, ev, (String)c));
    }

    private String shuffleArrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String randomClass;
        String x$1 = randomClass = RandomIndicesGenerator.class.getName();
        String x$2 = "rand";
        boolean x$3 = true;
        Function1<String, String> x$4 = ctx.addMutableState$default$3();
        boolean x$5 = ctx.addMutableState$default$5();
        String rand = ctx.addMutableState(x$1, "rand", x$4, true, x$5);
        ctx.addPartitionInitializationStatement(rand + " = new " + randomClass + "(" + this.randomSeed().get() + "L + partitionIndex);");
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String indices = ctx.freshName("indices");
        String i = ctx.freshName("i");
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, this.elementType(), numElements, " " + this.prettyName() + " failed.");
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, this.elementType(), childName, i, indices + "[" + i + "]", this.resultArrayElementNullable());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |int " + numElements + " = " + childName + ".numElements();\n       |int[] " + indices + " = " + rand + ".getNextIndices(" + numElements + ");\n       |" + initialization + "\n       |for (int " + i + " = 0; " + i + " < " + numElements + "; " + i + "++) {\n       |  " + assignment + "\n       |}\n       |" + ev.value() + " = " + arrayData + ";\n     "));
    }

    @Override
    public Shuffle withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Shuffle copy(Expression child, Option<Object> randomSeed) {
        return new Shuffle(child, randomSeed);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Option<Object> copy$default$2() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Shuffle";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.randomSeed();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Shuffle;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "randomSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Shuffle)) return false;
        boolean bl = true;
        if (!bl) return false;
        Shuffle shuffle = (Shuffle)x$1;
        Expression expression = this.child();
        Expression expression2 = shuffle.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = shuffle.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!shuffle.canEqual(this)) return false;
        return true;
    }

    public Shuffle(Expression child, Option<Object> randomSeed) {
        this.child = child;
        this.randomSeed = randomSeed;
        ExpectsInputTypes.$init$(this);
        Nondeterministic.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Shuffle(Expression child) {
        this(child, (Option<Object>)None$.MODULE$);
    }

    public Shuffle(Expression child, Expression seed) {
        this(child, ExpressionWithRandomSeed$.MODULE$.expressionToSeed(seed, "shuffle"));
    }
}

