/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RowOrdering$;
import org.apache.spark.sql.catalyst.expressions.SortArray$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.types.PhysicalDataType$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array[, ascendingOrder]) - Sorts the input array in ascending or descending order\n      according to the natural ordering of the array elements. NaN is greater than any non-NaN\n      elements for double/float type. Null elements will be placed at the beginning of the returned\n      array in ascending order or at the end of the returned array in descending order.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'), true);\n       [null,\"a\",\"b\",\"c\",\"d\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'), false);\n       [\"d\",\"c\",\"b\",\"a\",null]\n  ", group="array_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t-d\u0001B\u0014)\u0001VB\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tA\u0002\u0011\t\u0012)A\u0005;\"A\u0011\r\u0001BK\u0002\u0013\u0005A\f\u0003\u0005c\u0001\tE\t\u0015!\u0003^\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015\u0019\u0007\u0001\"\u0001i\u0011\u0015Y\u0007\u0001\"\u0011]\u0011\u0015a\u0007\u0001\"\u0011]\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015)\b\u0001\"\u0011w\u0011\u0015i\b\u0001\"\u0011\u007f\u0011)\tY\u0001\u0001EC\u0002\u0013%\u0011Q\u0002\u0005\u000b\u0003[\u0001\u0001R1A\u0005\n\u00055\u0001\"CA\u0019\u0001!\u0015\r\u0011\"\u0001o\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\"9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003'\u0003A\u0011KAK\u0011%\ty\nAA\u0001\n\u0003\t\t\u000bC\u0005\u0002(\u0002\t\n\u0011\"\u0001\u0002*\"I\u0011q\u0018\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007D\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005e\u0007!!A\u0005\u0002\u0005m\u0007\"CAq\u0001\u0005\u0005I\u0011IAr\u0011%\t\t\u0010AA\u0001\n\u0003\t\u0019\u0010C\u0005\u0002x\u0002\t\t\u0011\"\u0011\u0002z\"I\u0011Q \u0001\u0002\u0002\u0013\u0005\u0013q`\u0004\n\u0005GA\u0013\u0011!E\u0001\u0005K1\u0001b\n\u0015\u0002\u0002#\u0005!q\u0005\u0005\u0007G\u0006\"\tAa\u0010\t\u0013\t\u0005\u0013%!A\u0005F\t\r\u0003\"\u0003B#C\u0005\u0005I\u0011\u0011B$\u0011%\u0011i%IA\u0001\n\u0003\u0013y\u0005C\u0005\u0003b\u0005\n\t\u0011\"\u0003\u0003d\tI1k\u001c:u\u0003J\u0014\u0018-\u001f\u0006\u0003S)\n1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0006L\u0001\tG\u0006$\u0018\r\\=ti*\u0011QFL\u0001\u0004gFd'BA\u00181\u0003\u0015\u0019\b/\u0019:l\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0004\u0001M9\u0001A\u000e\u001e>\t*\u0003\u0006CA\u001c9\u001b\u0005A\u0013BA\u001d)\u0005A\u0011\u0015N\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00028w%\u0011A\b\u000b\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001 B\u001d\t9t(\u0003\u0002AQ\u00059\u0001/Y2lC\u001e,\u0017B\u0001\"D\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!\u0001\u0011\u0015\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dc\u0013AB3se>\u00148/\u0003\u0002J\r\ny\u0011+^3ss\u0016\u0013(o\u001c:t\u0005\u0006\u001cX\r\u0005\u0002L\u001d6\tAJC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyEJA\u0004Qe>$Wo\u0019;\u0011\u0005ECfB\u0001*X\u001d\t\u0019f+D\u0001U\u0015\t)F'\u0001\u0004=e>|GOP\u0005\u0002\u001b&\u0011\u0001\tT\u0005\u00033j\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0011'\u0002\t\t\f7/Z\u000b\u0002;B\u0011qGX\u0005\u0003?\"\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015\u0011\u0017m]3!\u00039\t7oY3oI&twm\u0014:eKJ\fq\"Y:dK:$\u0017N\\4Pe\u0012,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00154w\r\u0005\u00028\u0001!)1,\u0002a\u0001;\")\u0011-\u0002a\u0001;R\u0011Q-\u001b\u0005\u0006U\u001a\u0001\r!X\u0001\u0002K\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003!!\u0017\r^1UsB,W#A8\u0011\u0005A\u001cX\"A9\u000b\u0005Id\u0013!\u0002;za\u0016\u001c\u0018B\u0001;r\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\tq\u000fE\u0002RqjL!!\u001f.\u0003\u0007M+\u0017\u000f\u0005\u0002qw&\u0011A0\u001d\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012a \t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0016\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u0003\u0002\u0004\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0002miV\u0011\u0011q\u0002\t\u0007\u0003#\tY\"a\b\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA!\u001e;jY*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!AC\"p[B\f'/\u0019;peB\u00191*!\t\n\u0007\u0005\rBJA\u0002B]fD3\u0001DA\u0014!\rY\u0015\u0011F\u0005\u0004\u0003Wa%!\u0003;sC:\u001c\u0018.\u001a8u\u0003\t9G\u000fK\u0002\u000e\u0003O\t1\"\u001a7f[\u0016tG\u000fV=qK\"\u001aa\"a\n\u00025I,7/\u001e7u\u0003J\u0014\u0018-_#mK6,g\u000e\u001e(vY2\f'\r\\3\u0016\u0005\u0005e\u0002cA&\u0002<%\u0019\u0011Q\b'\u0003\u000f\t{w\u000e\\3b]\u0006A1o\u001c:u\u000bZ\fG\u000e\u0006\u0004\u0002 \u0005\r\u0013q\t\u0005\b\u0003\u000b\u0002\u0002\u0019AA\u0010\u0003\u0015\t'O]1z\u0011\u001d\tI\u0005\u0005a\u0001\u0003s\t\u0011\"Y:dK:$\u0017N\\4\u0002\u0017M|'\u000f^\"pI\u0016<WM\u001c\u000b\u000b\u0003\u001f\ny&a\u001c\u0002z\u0005m\u0004\u0003BA)\u00033rA!a\u0015\u0002VA\u00111\u000bT\u0005\u0004\u0003/b\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#AB*ue&twMC\u0002\u0002X1Cq!!\u0019\u0012\u0001\u0004\t\u0019'A\u0002dib\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003SB\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003[\n9G\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005E\u0014\u00031\u0001\u0002t\u0005\u0011QM\u001e\t\u0005\u0003K\n)(\u0003\u0003\u0002x\u0005\u001d$\u0001C#yaJ\u001cu\u000eZ3\t\rm\u000b\u0002\u0019AA(\u0011\u001d\ti(\u0005a\u0001\u0003\u001f\nQa\u001c:eKJ\fAB\\;mYN\u000bg-Z#wC2$b!a\b\u0002\u0004\u0006\u0015\u0005bBA#%\u0001\u0007\u0011q\u0004\u0005\b\u0003\u0013\u0012\u0002\u0019AA\u0010\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002t\u0005-\u0015Q\u0012\u0005\b\u0003C\u001a\u0002\u0019AA2\u0011\u001d\t\th\u0005a\u0001\u0003g\n!\u0002\u001d:fiRLh*Y7f+\t\ty%A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)Q-a&\u0002\u001c\"1\u0011\u0011T\u000bA\u0002u\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\u001eV\u0001\r!X\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015)\u00171UAS\u0011\u001dYf\u0003%AA\u0002uCq!\u0019\f\u0011\u0002\u0003\u0007Q,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005-&fA/\u0002..\u0012\u0011q\u0016\t\u0005\u0003c\u000bY,\u0004\u0002\u00024*!\u0011QWA\\\u0003%)hn\u00195fG.,GMC\u0002\u0002:2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ti,a-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\r\u0005\u0003\u0002H\u00065WBAAe\u0015\u0011\tY-a\u0006\u0002\t1\fgnZ\u0005\u0005\u00037\nI-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002TB\u00191*!6\n\u0007\u0005]GJA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002 \u0005u\u0007\"CAp7\u0005\u0005\t\u0019AAj\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001d\t\u0007\u0003O\fi/a\b\u000e\u0005\u0005%(bAAv\u0019\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0018\u0011\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002:\u0005U\b\"CAp;\u0005\u0005\t\u0019AA\u0010\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u0015\u00171 \u0005\n\u0003?t\u0012\u0011!a\u0001\u0003'\fa!Z9vC2\u001cH\u0003BA\u001d\u0005\u0003A\u0011\"a8 \u0003\u0003\u0005\r!a\b)'\u0001\u0011)Aa\u0003\u0003\u000e\tE!1\u0003B\f\u00053\u0011iBa\b\u0011\u0007]\u00129!C\u0002\u0003\n!\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\u0010\u0005\u00119P\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1z72\u0002\u0013m]2f]\u0012LgnZ(sI\u0016\u0014X,\u000b\u0011.AM{'\u000f^:!i\",\u0007%\u001b8qkR\u0004\u0013M\u001d:bs\u0002Jg\u000eI1tG\u0016tG-\u001b8hA=\u0014\b\u0005Z3tG\u0016tG-\u001b8hA=\u0014H-\u001a:\u000bA\u0001\u0002\u0003\u0005\t\u0011bG\u000e|'\u000fZ5oO\u0002\"x\u000e\t;iK\u0002r\u0017\r^;sC2\u0004sN\u001d3fe&tw\rI8gAQDW\rI1se\u0006L\b%\u001a7f[\u0016tGo\u001d\u0018!\u001d\u0006t\u0005%[:!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011b]f\u0004cn\u001c8.\u001d\u0006t%\u0002\t\u0011!A\u0001\u0002S\r\\3nK:$8\u000f\t4pe\u0002\"w.\u001e2mK>2Gn\\1uAQL\b/\u001a\u0018!\u001dVdG\u000eI3mK6,g\u000e^:!o&dG\u000e\t2fAAd\u0017mY3eA\u0005$\b\u0005\u001e5fA\t,w-\u001b8oS:<\u0007e\u001c4!i\",\u0007E]3ukJtW\r\u001a\u0006!A\u0001\u0002\u0003\u0005I1se\u0006L\b%\u001b8!CN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe\u0002z'\u000fI1uAQDW\rI3oI\u0002zg\r\t;iK\u0002\u0012X\r^;s]\u0016$\u0007%\u0019:sCf\u0004\u0013N\u001c\u0011eKN\u001cWM\u001c3j]\u001e\u0004sN\u001d3fe:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QC\u0001\u0002\u0016*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":#m\n\u0017!O\u0011<C\u0006\t8vY2d\u0003eJ2(Y\u0001:\u0013mJ\u0015-AQ\u0014X/Z\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AmsW\u000f\u001c7-E\u0005\u0014CF\t2#Y\t\u001a'\u0005\f\u0012eEuS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDsEY\u0014-A\u001d\"w\u0005\f\u0011ok2dG\u0006I\u0014dO1\u0002s%Y\u0014*Y\u00012\u0017\r\\:fSmR\u0001\u0005\t\u0011!A\u0001\u00023L\t3#Y\t\u001a'\u0005\f\u0012cE1\u0012\u0013M\t\u0017ok2dWL\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011Y\"A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017E\u0001B\u0011\u0003\u0015\td&\u000e\u00181\u0003%\u0019vN\u001d;BeJ\f\u0017\u0010\u0005\u00028CM)\u0011E!\u000b\u00036A9!1\u0006B\u0019;v+WB\u0001B\u0017\u0015\r\u0011y\u0003T\u0001\beVtG/[7f\u0013\u0011\u0011\u0019D!\f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u00038\tuRB\u0001B\u001d\u0015\u0011\u0011Y$a\u0006\u0002\u0005%|\u0017bA-\u0003:Q\u0011!QE\u0001\ti>\u001cFO]5oOR\u0011\u0011QY\u0001\u0006CB\u0004H.\u001f\u000b\u0006K\n%#1\n\u0005\u00067\u0012\u0002\r!\u0018\u0005\u0006C\u0012\u0002\r!X\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tF!\u0018\u0011\u000b-\u0013\u0019Fa\u0016\n\u0007\tUCJ\u0001\u0004PaRLwN\u001c\t\u0006\u0017\neS,X\u0005\u0004\u00057b%A\u0002+va2,'\u0007\u0003\u0005\u0003`\u0015\n\t\u00111\u0001f\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005K\u0002B!a2\u0003h%!!\u0011NAe\u0005\u0019y%M[3di\u0002")
public class SortArray
extends BinaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
QueryErrorsBase,
Serializable {
    private transient Comparator<Object> lt;
    private transient Comparator<Object> gt;
    private transient DataType elementType;
    private final Expression base;
    private final Expression ascendingOrder;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SortArray x$0) {
        return SortArray$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, SortArray> tupled() {
        return SortArray$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, SortArray>> curried() {
        return SortArray$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    public Expression base() {
        return this.base;
    }

    public Expression ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public Expression left() {
        return this.base();
    }

    @Override
    public Expression right() {
        return this.ascendingOrder();
    }

    @Override
    public DataType dataType() {
        return this.base().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = this.base().dataType();
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType dt = arrayType.elementType();
            if (RowOrdering$.MODULE$.isOrderable(dt)) {
                if (!this.ascendingOrder().foldable()) {
                    return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)this.toSQLId("ascendingOrder")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.ascendingOrder().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.ascendingOrder()))}))));
                }
                DataType dataType2 = this.ascendingOrder().dataType();
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                if (dataType2 == null ? booleanType$ != null : !dataType2.equals(booleanType$)) {
                    return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.ascendingOrder())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.ascendingOrder().dataType()))}))));
                }
                return TypeCheckResult$TypeCheckSuccess$.MODULE$;
            }
        }
        if (bl) {
            return new TypeCheckResult.DataTypeMismatch("INVALID_ORDERING_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)this.base().dataType()))}))));
        }
        return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)this.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)ArrayType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.base())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.base().dataType()))}))));
    }

    private Comparator<Object> lt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                DataType dataType = this.base().dataType();
                if (!(dataType instanceof ArrayType)) {
                    throw new MatchError((Object)dataType);
                }
                ArrayType arrayType = (ArrayType)dataType;
                DataType n = arrayType.elementType();
                Ordering<Object> ordering = PhysicalDataType$.MODULE$.ordering(n);
                this.lt = (o1, o2) -> {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    return ordering.compare(o1, o2);
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.lt;
    }

    private Comparator<Object> lt() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.lt$lzycompute();
        }
        return this.lt;
    }

    private Comparator<Object> gt$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                DataType dataType = this.base().dataType();
                if (!(dataType instanceof ArrayType)) {
                    throw new MatchError((Object)dataType);
                }
                ArrayType arrayType = (ArrayType)dataType;
                DataType n = arrayType.elementType();
                Ordering<Object> ordering = PhysicalDataType$.MODULE$.ordering(n);
                this.gt = (o1, o2) -> {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    return ordering.compare(o2, o1);
                };
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gt;
    }

    private Comparator<Object> gt() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.gt$lzycompute();
        }
        return this.gt;
    }

    private DataType elementType$lzycompute() {
        SortArray sortArray = this;
        synchronized (sortArray) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.elementType = ((ArrayType)this.base().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.elementType$lzycompute();
        }
        return this.elementType;
    }

    private boolean resultArrayElementNullable() {
        return ((ArrayType)this.base().dataType()).containsNull();
    }

    private Object sortEval(Object array, boolean ascending) {
        Object[] data = (Object[])((ArrayData)array).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(data, ascending ? this.lt() : this.gt());
        }
        return new GenericArrayData(data);
    }

    /*
     * Unable to fully structure code
     */
    private String sortCodegen(CodegenContext ctx, ExprCode ev, String base, String order) {
        genericArrayData = GenericArrayData.class.getName();
        unsafeArrayData = UnsafeArrayData.class.getName();
        array = ctx.freshName("array");
        c = ctx.freshName("c");
        v0 = this.elementType();
        var9_9 = NullType$.MODULE$;
        if (!(v0 != null ? v0.equals(var9_9) == false : var9_9 != null)) {
            return ev.value() + " = " + base + ".copy();";
        }
        elementTypeTerm = ctx.addReferenceObj("elementTypeTerm", this.elementType(), ctx.addReferenceObj$default$3());
        sortOrder = ctx.freshName("sortOrder");
        o1 = ctx.freshName("o1");
        o2 = ctx.freshName("o2");
        jt = CodeGenerator$.MODULE$.javaType(this.elementType());
        if (CodeGenerator$.MODULE$.isPrimitiveType(this.elementType())) {
            bt = CodeGenerator$.MODULE$.boxedType(this.elementType());
            v1 = ctx.freshName("v1");
            v2 = ctx.freshName("v2");
            v1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |" + jt + " " + v1 + " = ((" + bt + ") " + o1 + ")." + jt + "Value();\n           |" + jt + " " + v2 + " = ((" + bt + ") " + o2 + ")." + jt + "Value();\n           |int " + c + " = " + ctx.genComp(this.elementType(), v1, v2) + ";\n         "));
        } else {
            v1 = comp = "int " + c + " = " + ctx.genComp(this.elementType(), "((" + jt + ") " + o1 + ")", "((" + jt + ") " + o2 + ")") + ";";
        }
        if (!CodeGenerator$.MODULE$.isPrimitiveType(this.elementType())) ** GOTO lbl-1000
        v2 = this.elementType();
        var20_19 = BooleanType$.MODULE$;
        if ((v2 == null ? var20_19 != null : v2.equals(var20_19) == false) && !this.resultArrayElementNullable()) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = canPerformFastSort = false;
        }
        if (canPerformFastSort) {
            javaType = CodeGenerator$.MODULE$.javaType(this.elementType());
            primitiveTypeName = CodeGenerator$.MODULE$.primitiveTypeName(this.elementType());
            v4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |if (" + order + ") {\n           |  " + javaType + "[] " + array + " = " + base + ".to" + primitiveTypeName + "Array();\n           |  java.util.Arrays.sort(" + array + ");\n           |  " + ev.value() + " = " + unsafeArrayData + ".fromPrimitiveArray(" + array + ");\n           |} else\n           "));
        } else {
            v4 = "";
        }
        nonNullPrimitiveAscendingSort = v4;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |" + nonNullPrimitiveAscendingSort + "\n         |{\n         |  Object[] " + array + " = " + base + ".toObjectArray(" + elementTypeTerm + ");\n         |  final int " + sortOrder + " = " + order + " ? 1 : -1;\n         |  java.util.Arrays.sort(" + array + ", new java.util.Comparator() {\n         |    @Override public int compare(Object " + o1 + ", Object " + o2 + ") {\n         |      if (" + o1 + " == null && " + o2 + " == null) {\n         |        return 0;\n         |      } else if (" + o1 + " == null) {\n         |        return -" + sortOrder + ";\n         |      } else if (" + o2 + " == null) {\n         |        return " + sortOrder + ";\n         |      }\n         |      " + comp + "\n         |      return " + sortOrder + " * " + c + ";\n         |    }\n         |  });\n         |  " + ev.value() + " = new " + genericArrayData + "(" + array + ");\n         |}\n       "));
    }

    @Override
    public Object nullSafeEval(Object array, Object ascending) {
        return this.sortEval(array, BoxesRunTime.unboxToBoolean((Object)ascending));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(b, order) -> this.sortCodegen(ctx, ev, (String)b, (String)order));
    }

    @Override
    public String prettyName() {
        return "sort_array";
    }

    @Override
    public SortArray withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public SortArray copy(Expression base, Expression ascendingOrder) {
        return new SortArray(base, ascendingOrder);
    }

    public Expression copy$default$1() {
        return this.base();
    }

    public Expression copy$default$2() {
        return this.ascendingOrder();
    }

    @Override
    public String productPrefix() {
        return "SortArray";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.base();
            }
            case 1: {
                return this.ascendingOrder();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SortArray;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "base";
            }
            case 1: {
                return "ascendingOrder";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SortArray)) return false;
        boolean bl = true;
        if (!bl) return false;
        SortArray sortArray = (SortArray)x$1;
        Expression expression = this.base();
        Expression expression2 = sortArray.base();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.ascendingOrder();
        Expression expression4 = sortArray.ascendingOrder();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sortArray.canEqual(this)) return false;
        return true;
    }

    public SortArray(Expression base, Expression ascendingOrder) {
        this.base = base;
        this.ascendingOrder = ascendingOrder;
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }

    public SortArray(Expression e) {
        this(e, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)true)));
    }
}

