/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression$;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ua!B\b\u0011\u0003\u0003i\u0002\"B\u0018\u0001\t\u0003\u0001\u0004\"\u0002\u001a\u0001\r\u0003\u0019\u0004\"B\"\u0001\r\u0003!\u0005\"\u0002,\u0001\t\u0003:\u0006\u0002\u00034\u0001\u0011\u000b\u0007IQA4\t\u0011-\u0004\u0001R1A\u0005\u0006\u001dD\u0001\u0002\u001c\u0001\t\u0006\u0004%I!\u001c\u0005\u0006]\u0002!\tb\u001c\u0005\u0006c\u0002!\tB\u001d\u0005\u0006i\u0002!\t&^\u0004\u0007{BA\tA\u0005@\u0007\r=\u0001\u0002\u0012\u0001\n\u0000\u0011\u0019yC\u0002\"\u0001\u0002\b!9\u0011\u0011\u0002\u0007\u0005\u0002\u0005-!!F*ue&twMU3hKb,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0003#I\t1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0003F\u0001\tG\u0006$\u0018\r\\=ti*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M)\u0001A\b\u0012&YA\u0011q\u0004I\u0007\u0002!%\u0011\u0011\u0005\u0005\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"aH\u0012\n\u0005\u0011\u0002\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005\u0019JcBA\u0010(\u0013\tA\u0003#A\u0004qC\u000e\\\u0017mZ3\n\u0005)Z#A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003QA\u0001\"aH\u0017\n\u00059\u0002\"!\u0003)sK\u0012L7-\u0019;f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0007\u0005\u0002 \u0001\u00051Qm]2ba\u0016$\"\u0001N!\u0011\u0005UrdB\u0001\u001c=!\t9$(D\u00019\u0015\tID$\u0001\u0004=e>|GO\u0010\u0006\u0002w\u0005)1oY1mC&\u0011QHO\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>u!)!I\u0001a\u0001i\u0005\ta/A\u0004nCR\u001c\u0007.Z:\u0015\u0007\u0015KE\u000b\u0005\u0002G\u000f6\t!(\u0003\u0002Iu\t9!i\\8mK\u0006t\u0007\"\u0002&\u0004\u0001\u0004Y\u0015!\u0002:fO\u0016D\bC\u0001'S\u001b\u0005i%B\u0001&O\u0015\ty\u0005+\u0001\u0003vi&d'\"A)\u0002\t)\fg/Y\u0005\u0003'6\u0013q\u0001U1ui\u0016\u0014h\u000eC\u0003V\u0007\u0001\u0007A'A\u0002tiJ\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\u0006cA-^A:\u0011!\f\u0018\b\u0003omK\u0011aO\u0005\u0003QiJ!AX0\u0003\u0007M+\u0017O\u0003\u0002)uA\u0011\u0011\rZ\u0007\u0002E*\u00111\rF\u0001\u0006if\u0004Xm]\u0005\u0003K\n\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0017\r|G\u000e\\1uS>t\u0017\nZ\u000b\u0002QB\u0011a)[\u0005\u0003Uj\u00121!\u00138u\u0003M\u0019w\u000e\u001c7bi&|gNU3hKb4E.Y4t\u0003\u0015\u0019\u0017m\u00195f+\u0005Y\u0015aB2p[BLG.\u001a\u000b\u0003\u0017BDQ!\u0016\u0005A\u0002Q\nq\u0001]1ui\u0016\u0014h\u000e\u0006\u0002Lg\")Q+\u0003a\u0001i\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u0019a/_>\u0011\u0005\u0019;\u0018B\u0001=;\u0005\r\te.\u001f\u0005\u0006u*\u0001\rA^\u0001\u0007S:\u0004X\u000f^\u0019\t\u000bqT\u0001\u0019\u0001<\u0002\r%t\u0007/\u001e;3\u0003U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"a\b\u0007\u0014\u00071\t\t\u0001E\u0002G\u0003\u0007I1!!\u0002;\u0005\u0019\te.\u001f*fMR\ta0\u0001\ffqB\u0014Xm]:j_:$v.R:dCB,7\t[1s)\u0011\ti!a\u0005\u0011\u0007\u0019\u000by!C\u0002\u0002\u0012i\u0012Aa\u00115be\"9\u0011Q\u0003\bA\u0002\u0005]\u0011!A3\u0011\u0007}\tI\"C\u0002\u0002\u001cA\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0001")
public abstract class StringRegexExpression
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Predicate {
    private int collationId;
    private int collationRegexFlags;
    private Pattern cache;
    private volatile byte bitmap$0;

    public static char expressionToEscapeChar(Expression e) {
        return StringRegexExpression$.MODULE$.expressionToEscapeChar(e);
    }

    @Override
    public DataType dataType() {
        return Predicate.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public abstract String escape(String var1);

    public abstract boolean matches(Pattern var1, String var2);

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$));
    }

    private int collationId$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.collationId = ((StringType)((Expression)this.left()).dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    private int collationRegexFlags$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.collationRegexFlags = CollationSupport.collationAwareRegexFlags((int)this.collationId());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.collationRegexFlags;
    }

    public final int collationRegexFlags() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.collationRegexFlags$lzycompute();
        }
        return this.collationRegexFlags;
    }

    private Pattern cache$lzycompute() {
        StringRegexExpression stringRegexExpression = this;
        synchronized (stringRegexExpression) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Expression expression;
                Expression expression2 = (Expression)this.right();
                this.cache = expression2 != null && (expression = expression2).foldable() ? this.compile(((UTF8String)expression.eval(expression.eval$default$1())).toString()) : null;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.cache;
    }

    private Pattern cache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.cache$lzycompute();
        }
        return this.cache;
    }

    public Pattern compile(String str) {
        Pattern pattern;
        if (str == null) {
            return null;
        }
        try {
            pattern = Pattern.compile(this.escape(str), this.collationRegexFlags());
        }
        catch (PatternSyntaxException e) {
            throw QueryExecutionErrors$.MODULE$.invalidPatternError(this.prettyName(), e.getPattern(), e);
        }
        return pattern;
    }

    public Pattern pattern(String str) {
        if (this.cache() == null) {
            return this.compile(str);
        }
        return this.cache();
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        Pattern regex = this.pattern(((UTF8String)input2).toString());
        if (regex == null) {
            return null;
        }
        return BoxesRunTime.boxToBoolean((boolean)this.matches(regex, ((UTF8String)input1).toString()));
    }

    public StringRegexExpression() {
        ExpectsInputTypes.$init$(this);
        Predicate.$init$(this);
    }
}

