/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringReplace$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(str, search[, replace]) - Replaces all occurrences of `search` with `replace`.", arguments="\n    Arguments:\n      * str - a string expression\n      * search - a string expression. If `search` is not found in `str`, `str` is returned unchanged.\n      * replace - a string expression. If `replace` is not specified or is an empty string, nothing replaces\n          the string that is removed from `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('ABCabc', 'abc', 'DEF');\n       ABCDEF\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t=b\u0001B\u0013'\u0001NB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005+\"A\u0011\f\u0001BK\u0002\u0013\u0005A\u000b\u0003\u0005[\u0001\tE\t\u0015!\u0003V\u0011!Y\u0006A!f\u0001\n\u0003!\u0006\u0002\u0003/\u0001\u0005#\u0005\u000b\u0011B+\t\u000bu\u0003A\u0011\u00010\t\u0011\r\u0004\u0001R1A\u0005\u0006\u0011DQ!\u0018\u0001\u0005\u0002!DQa\u001b\u0001\u0005B1DQA\u001e\u0001\u0005B]Dq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u001c\u0001!\t%!\b\t\r\u0005-\u0002\u0001\"\u0011U\u0011\u0019\ti\u0003\u0001C!)\"1\u0011q\u0006\u0001\u0005BQCq!!\r\u0001\t\u0003\n\u0019\u0004C\u0004\u0002F\u0001!\t&a\u0012\t\u0013\u0005U\u0003!!A\u0005\u0002\u0005]\u0003\"CA0\u0001E\u0005I\u0011AA1\u0011%\t9\bAI\u0001\n\u0003\t\t\u0007C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002b!I\u00111\u0010\u0001\u0002\u0002\u0013\u0005\u0013Q\u0010\u0005\t\u0003\u001b\u0003\u0011\u0011!C\u0001I\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u0003/\u0003\u0011\u0011!C!\u00033C\u0011\"a*\u0001\u0003\u0003%\t!!+\t\u0013\u0005M\u0006!!A\u0005B\u0005U\u0006\"CA]\u0001\u0005\u0005I\u0011IA^\u000f%\t)OJA\u0001\u0012\u0003\t9O\u0002\u0005&M\u0005\u0005\t\u0012AAu\u0011\u0019iv\u0004\"\u0001\u0003\u0002!I!1A\u0010\u0002\u0002\u0013\u0015#Q\u0001\u0005\n\u0005\u000fy\u0012\u0011!CA\u0005\u0013A\u0011B!\u0005 \u0003\u0003%\tIa\u0005\t\u0013\t\u0015r$!A\u0005\n\t\u001d\"!D*ue&twMU3qY\u0006\u001cWM\u0003\u0002(Q\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tI#&\u0001\u0005dCR\fG._:u\u0015\tYC&A\u0002tc2T!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014AB1qC\u000eDWMC\u00012\u0003\ry'oZ\u0002\u0001'\u0019\u0001A\u0007O\u001eC\u0011B\u0011QGN\u0007\u0002M%\u0011qG\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001b:\u0013\tQdE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tatH\u0004\u00026{%\u0011aHJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015I\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005y2\u0003CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0013Bs!AS(\u000f\u0005-sU\"\u0001'\u000b\u00055\u0013\u0014A\u0002\u001fs_>$h(C\u0001F\u0013\tqD)\u0003\u0002R%\na1+\u001a:jC2L'0\u00192mK*\u0011a\bR\u0001\bgJ\u001cW\t\u001f9s+\u0005)\u0006CA\u001bW\u0013\t9fE\u0001\u0006FqB\u0014Xm]:j_:\f\u0001b\u001d:d\u000bb\u0004(\u000fI\u0001\u000bg\u0016\f'o\u00195FqB\u0014\u0018aC:fCJ\u001c\u0007.\u0012=qe\u0002\n1B]3qY\u0006\u001cW-\u0012=qe\u0006a!/\u001a9mC\u000e,W\t\u001f9sA\u00051A(\u001b8jiz\"Ba\u00181bEB\u0011Q\u0007\u0001\u0005\u0006'\u001e\u0001\r!\u0016\u0005\u00063\u001e\u0001\r!\u0016\u0005\u00067\u001e\u0001\r!V\u0001\fG>dG.\u0019;j_:LE-F\u0001f!\t\u0019e-\u0003\u0002h\t\n\u0019\u0011J\u001c;\u0015\u0007}K'\u000eC\u0003T\u0013\u0001\u0007Q\u000bC\u0003Z\u0013\u0001\u0007Q+\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003naJ$\bCA\"o\u0013\tyGIA\u0002B]fDQ!\u001d\u0006A\u00025\fqa\u001d:d\u000bZ\fG\u000eC\u0003t\u0015\u0001\u0007Q.\u0001\u0006tK\u0006\u00148\r[#wC2DQ!\u001e\u0006A\u00025\f1B]3qY\u0006\u001cW-\u0012<bY\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0005qz\f9\u0001\u0005\u0002zy6\t!P\u0003\u0002|M\u000591m\u001c3fO\u0016t\u0017BA?{\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007BB@\f\u0001\u0004\t\t!A\u0002dib\u00042!_A\u0002\u0013\r\t)A\u001f\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0019\tIa\u0003a\u0001q\u0006\u0011QM^\u0001\tI\u0006$\u0018\rV=qKV\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u0016\u0002\u000bQL\b/Z:\n\t\u0005e\u00111\u0003\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005}\u0001#B%\u0002\"\u0005\u0015\u0012bAA\u0012%\n\u00191+Z9\u0011\t\u0005E\u0011qE\u0005\u0005\u0003S\t\u0019B\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\f!\u0002\u001d:fiRLh*Y7f+\t\t)\u0004\u0005\u0003\u00028\u0005}b\u0002BA\u001d\u0003w\u0001\"a\u0013#\n\u0007\u0005uB)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{!\u0015aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u001dy\u0016\u0011JA'\u0003#Ba!a\u0013\u0013\u0001\u0004)\u0016\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005=#\u00031\u0001V\u0003%qWm^*fG>tG\r\u0003\u0004\u0002TI\u0001\r!V\u0001\t]\u0016<H\u000b[5sI\u0006!1m\u001c9z)\u001dy\u0016\u0011LA.\u0003;BqaU\n\u0011\u0002\u0003\u0007Q\u000bC\u0004Z'A\u0005\t\u0019A+\t\u000fm\u001b\u0002\u0013!a\u0001+\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA2U\r)\u0016QM\u0016\u0003\u0003O\u0002B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000f#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002v\u0005-$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0004\u0003BAA\u0003\u0017k!!a!\u000b\t\u0005\u0015\u0015qQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002\n\u0006!!.\u0019<b\u0013\u0011\t\t%a!\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q.a%\t\u0011\u0005U\u0015$!AA\u0002\u0015\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAN!\u0015\ti*a)n\u001b\t\tyJC\u0002\u0002\"\u0012\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)+a(\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\u000b\t\fE\u0002D\u0003[K1!a,E\u0005\u001d\u0011un\u001c7fC:D\u0001\"!&\u001c\u0003\u0003\u0005\r!\\\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0000\u0005]\u0006\u0002CAK9\u0005\u0005\t\u0019A3\u0002\r\u0015\fX/\u00197t)\u0011\tY+!0\t\u0011\u0005UU$!AA\u00025Ds\u0003AAa\u0003\u000f\fI-!4\u0002P\u0006M\u0017Q[Am\u00037\fy.!9\u0011\u0007U\n\u0019-C\u0002\u0002F\u001a\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002L\u0006)vLR+O\u0007~C3\u000f\u001e:-AM,\u0017M]2i72\u0002#/\u001a9mC\u000e,W,\u000b\u0011.AI+\u0007\u000f\\1dKN\u0004\u0013\r\u001c7!_\u000e\u001cWO\u001d:f]\u000e,7\u000fI8gA\u0001\u001cX-\u0019:dQ\u0002\u0004s/\u001b;iA\u0001\u0014X\r\u001d7bG\u0016\u0004g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011[\u0001\u0003r)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003e\u001d;sA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]*\u0001\u0003\u0005\t\u0011!A)\u00023/Z1sG\"\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tg\u0006I%gA\u0001\u001cX-\u0019:dQ\u0002\u0004\u0013n\u001d\u0011o_R\u0004cm\\;oI\u0002Jg\u000e\t1tiJ\u0004G\u0006\t1tiJ\u0004\u0007%[:!e\u0016$XO\u001d8fI\u0002*hn\u00195b]\u001e,GM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016\u0004H.Y2fA5\u0002\u0013\rI:ue&tw\rI3yaJ,7o]5p]:\u0002\u0013J\u001a\u0011ae\u0016\u0004H.Y2fA\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\rI8sA%\u001c\b%\u00198!K6\u0004H/\u001f\u0011tiJLgn\u001a\u0017!]>$\b.\u001b8hAI,\u0007\u000f\\1dKNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e\u0004C\u000f[1uA%\u001c\bE]3n_Z,G\r\t4s_6\u0004\u0003m\u001d;sA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011q[\u0001O\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013IQ\"bE\u000e<C\u0006I\u0014bE\u000e<C\u0006I\u0014E\u000b\u001a;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011B\u0005\u000e#UI\u0012\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011Q\\\u0001\u0006e9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003G\fAb\u001d;sS:<wLZ;oGN\fQb\u0015;sS:<'+\u001a9mC\u000e,\u0007CA\u001b '\u0015y\u00121^A|!!\ti/a=V+V{VBAAx\u0015\r\t\t\u0010R\u0001\beVtG/[7f\u0013\u0011\t)0a<\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0a\"\u0002\u0005%|\u0017bA)\u0002|R\u0011\u0011q]\u0001\ti>\u001cFO]5oOR\u0011\u0011qP\u0001\u0006CB\u0004H.\u001f\u000b\b?\n-!Q\u0002B\b\u0011\u0015\u0019&\u00051\u0001V\u0011\u0015I&\u00051\u0001V\u0011\u0015Y&\u00051\u0001V\u0003\u001d)h.\u00199qYf$BA!\u0006\u0003\"A)1Ia\u0006\u0003\u001c%\u0019!\u0011\u0004#\u0003\r=\u0003H/[8o!\u0019\u0019%QD+V+&\u0019!q\u0004#\u0003\rQ+\b\u000f\\34\u0011!\u0011\u0019cIA\u0001\u0002\u0004y\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0006\t\u0005\u0003\u0003\u0013Y#\u0003\u0003\u0003.\u0005\r%AB(cU\u0016\u001cG\u000f")
public class StringReplace
extends TernaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
Serializable {
    private int collationId;
    private final Expression srcExpr;
    private final Expression searchExpr;
    private final Expression replaceExpr;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringReplace x$0) {
        return StringReplace$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringReplace> tupled() {
        return StringReplace$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringReplace>>> curried() {
        return StringReplace$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression srcExpr() {
        return this.srcExpr;
    }

    public Expression searchExpr() {
        return this.searchExpr;
    }

    public Expression replaceExpr() {
        return this.replaceExpr;
    }

    private int collationId$lzycompute() {
        StringReplace stringReplace = this;
        synchronized (stringReplace) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object srcEval, Object searchEval, Object replaceEval) {
        return CollationSupport.StringReplace.exec((UTF8String)((UTF8String)srcEval), (UTF8String)((UTF8String)searchEval), (UTF8String)((UTF8String)replaceEval), (int)this.collationId());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(src, search, replace) -> CollationSupport.StringReplace.genCode((String)src, (String)search, (String)replace, (int)this.collationId()));
    }

    @Override
    public DataType dataType() {
        return this.srcExpr().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.srcExpr();
    }

    @Override
    public Expression second() {
        return this.searchExpr();
    }

    @Override
    public Expression third() {
        return this.replaceExpr();
    }

    @Override
    public String prettyName() {
        return "replace";
    }

    @Override
    public StringReplace withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringReplace copy(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        return new StringReplace(srcExpr, searchExpr, replaceExpr);
    }

    public Expression copy$default$1() {
        return this.srcExpr();
    }

    public Expression copy$default$2() {
        return this.searchExpr();
    }

    public Expression copy$default$3() {
        return this.replaceExpr();
    }

    @Override
    public String productPrefix() {
        return "StringReplace";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.srcExpr();
            }
            case 1: {
                return this.searchExpr();
            }
            case 2: {
                return this.replaceExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringReplace;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "srcExpr";
            }
            case 1: {
                return "searchExpr";
            }
            case 2: {
                return "replaceExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringReplace stringReplace = (StringReplace)x$1;
        Expression expression = this.srcExpr();
        Expression expression2 = stringReplace.srcExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.searchExpr();
        Expression expression4 = stringReplace.searchExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.replaceExpr();
        Expression expression6 = stringReplace.replaceExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringReplace.canEqual(this)) return false;
        return true;
    }

    public StringReplace(Expression srcExpr, Expression searchExpr, Expression replaceExpr) {
        this.srcExpr = srcExpr;
        this.searchExpr = searchExpr;
        this.replaceExpr = replaceExpr;
        ExpectsInputTypes.$init$(this);
    }

    public StringReplace(Expression srcExpr, Expression searchExpr) {
        this(srcExpr, searchExpr, Literal$.MODULE$.apply(""));
    }
}

