/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.StringToMap$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.sql.internal.types.StringTypeAnyCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(text[, pairDelim[, keyValueDelim]]) - Creates a map after splitting the text into key/value pairs using delimiters. Default delimiters are ',' for `pairDelim` and ':' for `keyValueDelim`. Both `pairDelim` and `keyValueDelim` are treated as regular expressions.", examples="\n    Examples:\n      > SELECT _FUNC_('a:1,b:2,c:3', ',', ':');\n       {\"a\":\"1\",\"b\":\"2\",\"c\":\"3\"}\n      > SELECT _FUNC_('a');\n       {\"a\":null}\n  ", since="2.0.1", group="map_funcs")
@ScalaSignature(bytes="\u0006\u0005\t%c\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t7\u0002\u0011\t\u0012)A\u00051\"AA\f\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005^\u0001\tE\t\u0015!\u0003Y\u0011!q\u0006A!f\u0001\n\u00039\u0006\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u000b\u0001\u0004A\u0011A1\t\u000b\u0001\u0004A\u0011\u00014\t\u000b\u0001\u0004A\u0011\u00016\t\u000b1\u0004A\u0011I7\t\u000bE\u0004A\u0011I,\t\u000bI\u0004A\u0011I,\t\u000bM\u0004A\u0011I,\t\u000bQ\u0004A\u0011I;\t\r}\u0004A\u0011IA\u0001\u0011)\tI\u0001\u0001EC\u0002\u0013%\u00111\u0002\u0005\u000b\u00033\u0001\u0001R1A\u0005\u000e\u0005m\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0005\b\u0003s\u0001A\u0011KA\u001e\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a\u001b\u0001\t#\ni\u0007C\u0005\u0002|\u0001\t\t\u0011\"\u0001\u0002~!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\n\u0003;\u0003\u0011\u0013!C\u0001\u0003\u000fC\u0011\"a(\u0001#\u0003%\t!a\"\t\u0013\u0005\u0005\u0006!!A\u0005B\u0005\r\u0006\"CAZ\u0001\u0005\u0005I\u0011AA\u000e\u0011%\t)\fAA\u0001\n\u0003\t9\fC\u0005\u0002>\u0002\t\t\u0011\"\u0011\u0002@\"I\u0011Q\u001a\u0001\u0002\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003'\u0004\u0011\u0011!C!\u0003+D\u0011\"!7\u0001\u0003\u0003%\t%a7\b\u0013\u0005}\u0018&!A\t\u0002\t\u0005a\u0001\u0003\u0015*\u0003\u0003E\tAa\u0001\t\r\u0001\u0014C\u0011\u0001B\u000e\u0011%\u0011iBIA\u0001\n\u000b\u0012y\u0002C\u0005\u0003\"\t\n\t\u0011\"!\u0003$!I!1\u0006\u0012\u0002\u0002\u0013\u0005%Q\u0006\u0005\n\u0005\u007f\u0011\u0013\u0011!C\u0005\u0005\u0003\u00121b\u0015;sS:<Gk\\'ba*\u0011!fK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002-[\u0005A1-\u0019;bYf\u001cHO\u0003\u0002/_\u0005\u00191/\u001d7\u000b\u0005A\n\u0014!B:qCJ\\'B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001omrTi\u0013\t\u0003qej\u0011!K\u0005\u0003u%\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tAD(\u0003\u0002>S\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005}\u0012eB\u0001\u001dA\u0013\t\t\u0015&A\u0004qC\u000e\\\u0017mZ3\n\u0005\r#%A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003\u0003&\u0002\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002M':\u0011QJ\u0015\b\u0003\u001dFk\u0011a\u0014\u0006\u0003!V\na\u0001\u0010:p_Rt\u0014\"\u0001%\n\u0005\u0005;\u0015B\u0001+V\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tu)\u0001\u0003uKb$X#\u0001-\u0011\u0005aJ\u0016B\u0001.*\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006i\u0016DH\u000fI\u0001\na\u0006L'\u000fR3mS6\f!\u0002]1je\u0012+G.[7!\u00035YW-\u001f,bYV,G)\u001a7j[\u0006q1.Z=WC2,X\rR3mS6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003cG\u0012,\u0007C\u0001\u001d\u0001\u0011\u00151v\u00011\u0001Y\u0011\u0015av\u00011\u0001Y\u0011\u0015qv\u00011\u0001Y)\r\u0011w-\u001b\u0005\u0006Q\"\u0001\r\u0001W\u0001\u0006G\"LG\u000e\u001a\u0005\u00069\"\u0001\r\u0001\u0017\u000b\u0003E.DQ\u0001[\u0005A\u0002a\u000b\u0001b\u001d;bi\u00164W\u000f\\\u000b\u0002]B\u0011ai\\\u0005\u0003a\u001e\u0013qAQ8pY\u0016\fg.A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001<\u0011\u00071;\u00180\u0003\u0002y+\n\u00191+Z9\u0011\u0005ilX\"A>\u000b\u0005ql\u0013!\u0002;za\u0016\u001c\u0018B\u0001@|\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t\u0019\u0001E\u0002{\u0003\u000bI1!a\u0002|\u0005!!\u0015\r^1UsB,\u0017AC7ba\n+\u0018\u000e\u001c3feV\u0011\u0011Q\u0002\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111C\u0016\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003/\t\tB\u0001\u000bBeJ\f\u0017PQ1tK\u0012l\u0015\r\u001d\"vS2$WM]\u0001\fG>dG.\u0019;j_:LE-\u0006\u0002\u0002\u001eA\u0019a)a\b\n\u0007\u0005\u0005rIA\u0002J]R\fAB\\;mYN\u000bg-Z#wC2$\u0002\"a\n\u0002.\u0005E\u0012Q\u0007\t\u0004\r\u0006%\u0012bAA\u0016\u000f\n\u0019\u0011I\\=\t\u000f\u0005=\"\u00031\u0001\u0002(\u0005Y\u0011N\u001c9viN#(/\u001b8h\u0011\u001d\t\u0019D\u0005a\u0001\u0003O\tqb\u001d;sS:<G)\u001a7j[&$XM\u001d\u0005\b\u0003o\u0011\u0002\u0019AA\u0014\u0003EYW-\u001f,bYV,G)\u001a7j[&$XM]\u0001\nI><UM\\\"pI\u0016$b!!\u0010\u0002J\u0005M\u0003\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\r\u0013&A\u0004d_\u0012,w-\u001a8\n\t\u0005\u001d\u0013\u0011\t\u0002\t\u000bb\u0004(oQ8eK\"9\u00111J\nA\u0002\u00055\u0013aA2uqB!\u0011qHA(\u0013\u0011\t\t&!\u0011\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011QK\nA\u0002\u0005u\u0012AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u00037\u0002B!!\u0018\u0002f9!\u0011qLA1!\tqu)C\u0002\u0002d\u001d\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA4\u0003S\u0012aa\u0015;sS:<'bAA2\u000f\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\b1\u0006=\u00141OA<\u0011\u0019\t\t(\u0006a\u00011\u0006Aa.Z<GSJ\u001cH\u000f\u0003\u0004\u0002vU\u0001\r\u0001W\u0001\n]\u0016<8+Z2p]\u0012Da!!\u001f\u0016\u0001\u0004A\u0016\u0001\u00038foRC\u0017N\u001d3\u0002\t\r|\u0007/\u001f\u000b\bE\u0006}\u0014\u0011QAB\u0011\u001d1f\u0003%AA\u0002aCq\u0001\u0018\f\u0011\u0002\u0003\u0007\u0001\fC\u0004_-A\u0005\t\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0012\u0016\u00041\u0006-5FAAG!\u0011\ty)!'\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005]u)\u0001\u0006b]:|G/\u0019;j_:LA!a'\u0002\u0012\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016\u0001\u00027b]\u001eT!!a,\u0002\t)\fg/Y\u0005\u0005\u0003O\nI+\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0012\u0011\u0018\u0005\n\u0003wc\u0012\u0011!a\u0001\u0003;\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAa!\u0019\t\u0019-!3\u0002(5\u0011\u0011Q\u0019\u0006\u0004\u0003\u000f<\u0015AC2pY2,7\r^5p]&!\u00111ZAc\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00079\f\t\u000eC\u0005\u0002<z\t\t\u00111\u0001\u0002(\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)+a6\t\u0013\u0005mv$!AA\u0002\u0005u\u0011AB3rk\u0006d7\u000fF\u0002o\u0003;D\u0011\"a/!\u0003\u0003\u0005\r!a\n)'\u0001\t\t/a:\u0002j\u00065\u0018q^Az\u0003k\fI0a?\u0011\u0007a\n\u0019/C\u0002\u0002f&\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002l\u0006\u00119b\u0018$V\u001d\u000e{\u0006\u0006^3yinc\u0003\u0005]1je\u0012+G.[7\\Y\u0001ZW-\u001f,bYV,G)\u001a7j[vk\u0016\u0006I\u0017!\u0007J,\u0017\r^3tA\u0005\u0004S.\u00199!C\u001a$XM\u001d\u0011ta2LG\u000f^5oO\u0002\"\b.\u001a\u0011uKb$\b%\u001b8u_\u0002ZW-_\u0018wC2,X\r\t9bSJ\u001c\b%^:j]\u001e\u0004C-\u001a7j[&$XM]:/A\u0011+g-Y;mi\u0002\"W\r\\5nSR,'o\u001d\u0011be\u0016\u0004s\u0005L\u0014!M>\u0014\b\u0005\u00199bSJ$U\r\\5nA\u0002\ng\u000e\u001a\u0011(u\u001d\u0002cm\u001c:!A.,\u0017PV1mk\u0016$U\r\\5nA:\u0002#i\u001c;iA\u0001\u0004\u0018-\u001b:EK2LW\u000e\u0019\u0011b]\u0012\u0004\u0003m[3z-\u0006dW/\u001a#fY&l\u0007\rI1sK\u0002\"(/Z1uK\u0012\u0004\u0013m\u001d\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011_\u0001\u0002\")\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\u0019\u001e2Y\tT$\u0007L2;g\u001db\u0003e\n\u0017(Y\u0001:#hJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am\u0014\u0013M\t\u001e#c\tb#E\u0019\u0012;EI\u0012CFI2#u\t\u001a$% \u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O\u0005<\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#H\\;mYvT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003o\fQA\r\u00181]E\nQa\u001a:pkB\f#!!@\u0002\u00135\f\u0007o\u00184v]\u000e\u001c\u0018aC*ue&tw\rV8NCB\u0004\"\u0001\u000f\u0012\u0014\u000b\t\u0012)A!\u0005\u0011\u0011\t\u001d!Q\u0002-Y1\nl!A!\u0003\u000b\u0007\t-q)A\u0004sk:$\u0018.\\3\n\t\t=!\u0011\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B\n\u00053i!A!\u0006\u000b\t\t]\u0011QV\u0001\u0003S>L1\u0001\u0016B\u000b)\t\u0011\t!\u0001\u0005u_N#(/\u001b8h)\t\t)+A\u0003baBd\u0017\u0010F\u0004c\u0005K\u00119C!\u000b\t\u000bY+\u0003\u0019\u0001-\t\u000bq+\u0003\u0019\u0001-\t\u000by+\u0003\u0019\u0001-\u0002\u000fUt\u0017\r\u001d9msR!!q\u0006B\u001e!\u00151%\u0011\u0007B\u001b\u0013\r\u0011\u0019d\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0019\u00139\u0004\u0017-Y\u0013\r\u0011Id\u0012\u0002\u0007)V\u0004H.Z\u001a\t\u0011\tub%!AA\u0002\t\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011\u0019\u0005\u0005\u0003\u0002(\n\u0015\u0013\u0002\u0002B$\u0003S\u0013aa\u00142kK\u000e$\b")
public class StringToMap
extends TernaryExpression
implements ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private ArrayBasedMapBuilder mapBuilder;
    private int collationId;
    private final Expression text;
    private final Expression pairDelim;
    private final Expression keyValueDelim;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(StringToMap x$0) {
        return StringToMap$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, StringToMap> tupled() {
        return StringToMap$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, StringToMap>>> curried() {
        return StringToMap$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression text() {
        return this.text;
    }

    public Expression pairDelim() {
        return this.pairDelim;
    }

    public Expression keyValueDelim() {
        return this.keyValueDelim;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression first() {
        return this.text();
    }

    @Override
    public Expression second() {
        return this.pairDelim();
    }

    @Override
    public Expression third() {
        return this.keyValueDelim();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeAnyCollation$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return MapType$.MODULE$.apply(this.first().dataType(), this.first().dataType());
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.first().dataType(), this.first().dataType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.mapBuilder$lzycompute();
        }
        return this.mapBuilder;
    }

    private int collationId$lzycompute() {
        StringToMap stringToMap = this;
        synchronized (stringToMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.collationId = ((StringType)this.text().dataType()).collationId();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.collationId;
    }

    private final int collationId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public Object nullSafeEval(Object inputString, Object stringDelimiter, Object keyValueDelimiter) {
        UTF8String[] keyValues = CollationAwareUTF8String.splitSQL((UTF8String)((UTF8String)inputString), (UTF8String)((UTF8String)stringDelimiter), (int)-1, (int)this.collationId());
        UTF8String keyValueDelimiterUTF8String = (UTF8String)keyValueDelimiter;
        for (int i = 0; i < keyValues.length; ++i) {
            UTF8String[] keyValueArray = CollationAwareUTF8String.splitSQL((UTF8String)keyValues[i], (UTF8String)keyValueDelimiterUTF8String, (int)2, (int)this.collationId());
            UTF8String key = keyValueArray[0];
            UTF8String value = keyValueArray.length < 2 ? null : keyValueArray[1];
            this.mapBuilder().put(key, value);
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        String keyValues = ctx.freshName("kvs");
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(text, pd, kvd) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |UTF8String[] " + keyValues + " = CollationAwareUTF8String.splitSQL(" + text + ", " + pd + ", -1, " + this.collationId() + ");\n         |for(UTF8String kvEntry: " + keyValues + ") {\n         |  UTF8String[] kv = CollationAwareUTF8String.splitSQL(kvEntry, " + kvd + ", 2, " + this.collationId() + ");\n         |  " + builderTerm + ".put(kv[0], kv.length == 2 ? kv[1] : null);\n         |}\n         |" + ev.value() + " = " + builderTerm + ".build();\n         |")));
    }

    @Override
    public String prettyName() {
        return "str_to_map";
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public StringToMap copy(Expression text, Expression pairDelim, Expression keyValueDelim) {
        return new StringToMap(text, pairDelim, keyValueDelim);
    }

    public Expression copy$default$1() {
        return this.text();
    }

    public Expression copy$default$2() {
        return this.pairDelim();
    }

    public Expression copy$default$3() {
        return this.keyValueDelim();
    }

    @Override
    public String productPrefix() {
        return "StringToMap";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.text();
            }
            case 1: {
                return this.pairDelim();
            }
            case 2: {
                return this.keyValueDelim();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringToMap;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "text";
            }
            case 1: {
                return "pairDelim";
            }
            case 2: {
                return "keyValueDelim";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringToMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringToMap stringToMap = (StringToMap)x$1;
        Expression expression = this.text();
        Expression expression2 = stringToMap.text();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pairDelim();
        Expression expression4 = stringToMap.pairDelim();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.keyValueDelim();
        Expression expression6 = stringToMap.keyValueDelim();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!stringToMap.canEqual(this)) return false;
        return true;
    }

    public StringToMap(Expression text, Expression pairDelim, Expression keyValueDelim) {
        this.text = text;
        this.pairDelim = pairDelim;
        this.keyValueDelim = keyValueDelim;
        ExpectsInputTypes.$init$(this);
    }

    public StringToMap(Expression child, Expression pairDelim) {
        this(child, pairDelim, Literal$.MODULE$.apply(":"));
    }

    public StringToMap(Expression child) {
        this(child, Literal$.MODULE$.apply(","), Literal$.MODULE$.apply(":"));
    }
}

