/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\tMf\u0001B\u0017/\u0001nB\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\tW\u0002\u0011\t\u0012)A\u0005A\"AA\u000e\u0001BK\u0002\u0013\u0005Q\u000e\u0003\u0005r\u0001\tE\t\u0015!\u0003o\u0011!\u0011\bA!f\u0001\n\u0003\u0019\b\u0002C<\u0001\u0005#\u0005\u000b\u0011\u0002;\t\u000ba\u0004A\u0011A=\t\u000by\u0004A\u0011I@\t\ra\u0004A\u0011AA\u0004\u0011\u0019A\b\u0001\"\u0001\u0002\u000e!1\u0001\u0010\u0001C\u0001\u0003#Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0004\u0002(\u0001!I!!\u000b\t\u0015\u0005m\u0002\u0001#b\u0001\n\u0003\ti\u0004\u0003\u0006\u0002X\u0001A)\u0019!C\u0001\u00033B!\"a\u0019\u0001\u0011\u000b\u0007I\u0011AA3\u0011)\t)\b\u0001EC\u0002\u0013\u0005\u0011q\u000f\u0005\b\u0003[\u0001A\u0011IAK\u0011\u001d\t9\n\u0001C!\u00033Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002&\u0002!\t%a*\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u0011\u0011\u0018\u0001\u0005R\u0005m\u0006bBAa\u0001\u0011E\u00131\u0019\u0005\n\u0003?\u0004\u0011\u0011!C\u0001\u0003CD\u0011\"!;\u0001#\u0003%\t!a;\t\u0013\t\u0005\u0001!%A\u0005\u0002\t\r\u0001\"\u0003B\u0004\u0001E\u0005I\u0011\u0001B\u0005\u0011%\u0011i\u0001AA\u0001\n\u0003\u0012y\u0001C\u0005\u0003\u001c\u0001\t\t\u0011\"\u0001\u0003\u001e!I!Q\u0005\u0001\u0002\u0002\u0013\u0005!q\u0005\u0005\n\u0005[\u0001\u0011\u0011!C!\u0005_A\u0011B!\u0010\u0001\u0003\u0003%\tAa\u0010\t\u0013\t\r\u0003!!A\u0005B\t\u0015\u0003\"\u0003B%\u0001\u0005\u0005I\u0011\tB&\u000f%\u0011yGLA\u0001\u0012\u0003\u0011\tH\u0002\u0005.]\u0005\u0005\t\u0012\u0001B:\u0011\u0019AX\u0005\"\u0001\u0003\u0006\"I!qQ\u0013\u0002\u0002\u0013\u0015#\u0011\u0012\u0005\n\u0005\u0017+\u0013\u0011!CA\u0005\u001bC\u0011B!&&#\u0003%\tA!\u0003\t\u0013\t]U%!A\u0005\u0002\ne\u0005\"\u0003BTKE\u0005I\u0011\u0001B\u0005\u0011%\u0011I+JA\u0001\n\u0013\u0011YK\u0001\u0007TiJ,8\r^:U_\u000e\u001bhO\u0003\u00020a\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t$'\u0001\u0005dCR\fG._:u\u0015\t\u0019D'A\u0002tc2T!!\u000e\u001c\u0002\u000bM\u0004\u0018M]6\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0002\u0001'\u001d\u0001A\bQ\"G\u001bN\u0003\"!\u0010 \u000e\u00039J!a\u0010\u0018\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!P!\n\u0005\ts#a\u0006+j[\u0016TvN\\3Bo\u0006\u0014X-\u0012=qe\u0016\u001c8/[8o!\tiD)\u0003\u0002F]\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005\u001dSeBA\u001fI\u0013\tIe&A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003\u0013:\u0002\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002U7:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u00031j\na\u0001\u0010:p_Rt\u0014\"\u0001)\n\u0005%{\u0015B\u0001/^\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tIu*A\u0004paRLwN\\:\u0016\u0003\u0001\u0004B!Y3iQ:\u0011!m\u0019\t\u0003->K!\u0001Z(\u0002\rA\u0013X\rZ3g\u0013\t1wMA\u0002NCBT!\u0001Z(\u0011\u0005\u0005L\u0017B\u00016h\u0005\u0019\u0019FO]5oO\u0006Aq\u000e\u001d;j_:\u001c\b%A\u0003dQ&dG-F\u0001o!\tit.\u0003\u0002q]\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002iB\u0019a*\u001e5\n\u0005Y|%AB(qi&|g.A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003{wrl\bCA\u001f\u0001\u0011\u0015qv\u00011\u0001a\u0011\u0015aw\u00011\u0001o\u0011\u001d\u0011x\u0001%AA\u0002Q\f\u0001B\\;mY\u0006\u0014G.Z\u000b\u0003\u0003\u0003\u00012ATA\u0002\u0013\r\t)a\u0014\u0002\b\u0005>|G.Z1o)\u0015Q\u0018\u0011BA\u0006\u0011\u0015q\u0016\u00021\u0001a\u0011\u0015a\u0017\u00021\u0001o)\rQ\u0018q\u0002\u0005\u0006Y*\u0001\rA\u001c\u000b\u0006u\u0006M\u0011Q\u0003\u0005\u0006Y.\u0001\rA\u001c\u0005\u0006=.\u0001\rA\\\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0014\u0001C1oC2L8/[:\n\t\u0005\u0015\u0012q\u0004\u0002\u0010)f\u0004Xm\u00115fG.\u0014Vm];mi\u0006\u0019\u0012n]*vaB|'\u000f^3e\t\u0006$\u0018\rV=qKR!\u0011\u0011AA\u0016\u0011\u001d\ti#\u0004a\u0001\u0003_\t\u0001\u0002Z1uCRK\b/\u001a\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011Q\u0007\u001a\u0002\u000bQL\b/Z:\n\t\u0005e\u00121\u0007\u0002\t\t\u0006$\u0018\rV=qK\u00061qO]5uKJ,\"!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005\u0011\u0011n\u001c\u0006\u0003\u0003\u0013\nAA[1wC&!\u0011QJA\"\u0005=\u0019\u0005.\u0019:BeJ\f\u0017p\u0016:ji\u0016\u0014\bf\u0001\b\u0002RA\u0019a*a\u0015\n\u0007\u0005UsJA\u0005ue\u0006t7/[3oi\u0006Y\u0011N\u001c9viN\u001b\u0007.Z7b+\t\tY\u0006\u0005\u0003\u00022\u0005u\u0013\u0002BA0\u0003g\u0011!b\u0015;sk\u000e$H+\u001f9fQ\ry\u0011\u0011K\u0001\u0004O\u0016tWCAA4!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7a\u0005\u00191m\u001d<\n\t\u0005E\u00141\u000e\u0002\u0013+:Lgo\\2jif<UM\\3sCR|'\u000fK\u0002\u0011\u0003#\n\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005e\u0004c\u0002(\u0002|\u0005}\u0014QQ\u0005\u0004\u0003{z%!\u0003$v]\u000e$\u0018n\u001c82!\rq\u0015\u0011Q\u0005\u0004\u0003\u0007{%aA!osB!\u0011qQAH\u001b\t\tII\u0003\u0003\u00026\u0005-%bAAGi\u00051QO\\:bM\u0016LA!!%\u0002\n\nQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007E\t\t&\u0006\u0002\u00020\u0005aq/\u001b;i)&lWMW8oKR\u0019\u0001)a'\t\u000bI\u001c\u0002\u0019\u00015\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005}\u0014\u0011\u0015\u0005\b\u0003G#\u0002\u0019AA@\u0003\u00151\u0018\r\\;f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003S\u0003R\u0001VAV\u0003_K1!!,^\u0005\r\u0019V-\u001d\t\u0005\u0003c\t\t,\u0003\u0003\u00024\u0006M\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002Q\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2A_A_\u0011\u0019\tyl\u0006a\u0001]\u0006Aa.Z<DQ&dG-A\u0005e_\u001e+gnQ8eKR1\u0011QYAi\u00037\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017t\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u001f\fIM\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t\u0019\u000e\u0007a\u0001\u0003+\f1a\u0019;y!\u0011\t9-a6\n\t\u0005e\u0017\u0011\u001a\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\ti\u000e\u0007a\u0001\u0003\u000b\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\bu\u0006\r\u0018Q]At\u0011\u001dq\u0016\u0004%AA\u0002\u0001Dq\u0001\\\r\u0011\u0002\u0003\u0007a\u000eC\u0004s3A\u0005\t\u0019\u0001;\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001e\u0016\u0004A\u0006=8FAAy!\u0011\t\u00190!@\u000e\u0005\u0005U(\u0002BA|\u0003s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mx*\u0001\u0006b]:|G/\u0019;j_:LA!a@\u0002v\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0001\u0016\u0004]\u0006=\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0017Q3\u0001^Ax\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0003\t\u0005\u0005'\u0011I\"\u0004\u0002\u0003\u0016)!!qCA$\u0003\u0011a\u0017M\\4\n\u0007)\u0014)\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003 A\u0019aJ!\t\n\u0007\t\rrJA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0000\t%\u0002\"\u0003B\u0016?\u0005\u0005\t\u0019\u0001B\u0010\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0007\t\u0007\u0005g\u0011I$a \u000e\u0005\tU\"b\u0001B\u001c\u001f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm\"Q\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0002\t\u0005\u0003\"\u0003B\u0016C\u0005\u0005\t\u0019AA@\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\tE!q\t\u0005\n\u0005W\u0011\u0013\u0011!a\u0001\u0005?\ta!Z9vC2\u001cH\u0003BA\u0001\u0005\u001bB\u0011Ba\u000b$\u0003\u0003\u0005\r!a )'\u0001\u0011\tFa\u0016\u0003Z\tu#q\fB2\u0005K\u0012IGa\u001b\u0011\u0007u\u0012\u0019&C\u0002\u0003V9\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003\\\u0005AuLR+O\u0007~CS\r\u001f9s72\u0002s\u000e\u001d;j_:\u001cX,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007eQ*WAM$(/\u001b8hA]LG\u000f\u001b\u0011bA\u001dLg/\u001a8!gR\u0014Xo\u0019;!m\u0006dW/Z\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!\u0011M\u0001\u0002B*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc.Y7fI~\u001bHO];di\":\u0013m\n\u0017!c1\u0002sEY\u0014-AIJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112YIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\\1nK\u0012|6\u000f\u001e:vGRDs\u0005^5nK\u001eb\u0003\u0005^8`i&lWm\u001d;b[BDsE\r\u00192k5\u0002\u0004(\f\u001a7O1\u0002s%_=zs6jU*\f3eO%JC\u0006I7ba\":C/[7fgR\fW\u000e\u001d$pe6\fGo\n\u0017!O\u0011$w&T'0sfL\u0018pJ\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012dg\f\u00199_I\u0002\u0014'\u000e\u0006!A\u0005)1/\u001b8dK\u0006\u0012!qM\u0001\u0006g9\u0002d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005[\n\u0011bY:w?\u001a,hnY:\u0002\u0019M#(/^2ugR{7i\u001d<\u0011\u0005u*3#B\u0013\u0003v\t\u0005\u0005\u0003\u0003B<\u0005{\u0002g\u000e\u001e>\u000e\u0005\te$b\u0001B>\u001f\u00069!/\u001e8uS6,\u0017\u0002\u0002B@\u0005s\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t\tEa!\n\u0007q\u000b\u0019\u0005\u0006\u0002\u0003r\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\u0012\u0005)\u0011\r\u001d9msR9!Pa$\u0003\u0012\nM\u0005\"\u00020)\u0001\u0004\u0001\u0007\"\u00027)\u0001\u0004q\u0007b\u0002:)!\u0003\u0005\r\u0001^\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002BN\u0005G\u0003BAT;\u0003\u001eB1aJa(a]RL1A!)P\u0005\u0019!V\u000f\u001d7fg!A!Q\u0015\u0016\u0002\u0002\u0003\u0007!0A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001BW!\u0011\u0011\u0019Ba,\n\t\tE&Q\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv x$0) {
        return StructsToCsv$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        StructType structType;
        DataType dataType = this.child().dataType();
        if (dataType instanceof StructType && ((IterableOnceOps)(structType = (StructType)dataType).map((Function1 & Serializable)x$4 -> x$4.dataType())).forall((Function1 & Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedDataType(dt)))) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("UNSUPPORTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)TypeUtils$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
    }

    private boolean isSupportedDataType(DataType dataType) {
        while (true) {
            DataType dataType2;
            if ((dataType2 = dataType) instanceof VariantType) {
                return false;
            }
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                dataType = arrayType.elementType();
                continue;
            }
            if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                if (this.isSupportedDataType(mapType.keyType())) {
                    dataType = mapType.valueType();
                    continue;
                }
                return false;
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                return ((IterableOnceOps)structType.map((Function1 & Serializable)x$5 -> x$5.dataType())).forall((Function1 & Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedDataType(dt)));
            }
            if (!(dataType2 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            dataType = userDefinedType.sqlType();
        }
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.writer$lzycompute();
        }
        return this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.inputSchema = (StructType)this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.inputSchema$lzycompute();
        }
        return this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.gen$lzycompute();
        }
        return this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return Nil$.MODULE$.$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    @Override
    public StructsToCsv withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String structsToCsv = ctx.addReferenceObj("structsToCsv", this, ctx.addReferenceObj$default$3());
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> ev.value() + " = (UTF8String) " + structsToCsv + ".converter().apply(" + eval + ");");
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.options();
            }
            case 1: {
                return this.child();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "options";
            }
            case 1: {
                return "child";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

