/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToJson$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.VariantType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.unsafe.types.VariantVal;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a JSON string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       {\"a\":1,\"b\":2}\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       {\"time\":\"26/08/2015\"}\n      > SELECT _FUNC_(array(named_struct('a', 1, 'b', 2)));\n       [{\"a\":1,\"b\":2}]\n      > SELECT _FUNC_(map('a', named_struct('b', 1)));\n       {\"a\":{\"b\":1}}\n      > SELECT _FUNC_(map(named_struct('a', 1),named_struct('b', 2)));\n       {\"[1]\":{\"b\":2}}\n      > SELECT _FUNC_(map('a', 1));\n       {\"a\":1}\n      > SELECT _FUNC_(array(map('a', 1)));\n       [{\"a\":1}]\n  ", group="json_funcs", since="2.2.0")
@ScalaSignature(bytes="\u0006\u0005\tme\u0001B\u0016-\u0001fB\u0001\u0002\u001b\u0001\u0003\u0016\u0004%\t!\u001b\u0005\tk\u0002\u0011\t\u0012)A\u0005U\"Aa\u000f\u0001BK\u0002\u0013\u0005q\u000f\u0003\u0005|\u0001\tE\t\u0015!\u0003y\u0011!a\bA!f\u0001\n\u0003i\b\"CA\u0002\u0001\tE\t\u0015!\u0003\u007f\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\u0006\u0001!\t!a\u0007\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0001\u0001\u0005\u0002\u0005\u0015\u0002BCA\u0016\u0001!\u0015\r\u0011\"\u0001\u0002.!Q\u0011q\t\u0001\t\u0006\u0004%\t!!\u0013\t\u0015\u0005e\u0003\u0001#b\u0001\n\u0003\tY\u0006\u0003\u0006\u0002l\u0001A)\u0019!C\u0001\u0003[Bq!a#\u0001\t\u0003\nY\u0006C\u0004\u0002\u000e\u0002!\t%a$\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003w\u0003A\u0011IA_\u0011\u001d\ty\f\u0001C)\u0003\u0003D\u0011\"a2\u0001\u0003\u0003%\t!!3\t\u0013\u0005E\u0007!%A\u0005\u0002\u0005M\u0007\"CAu\u0001E\u0005I\u0011AAv\u0011%\ty\u000fAI\u0001\n\u0003\t\t\u0010C\u0005\u0002v\u0002\t\t\u0011\"\u0011\u0002x\"I!1\u0001\u0001\u0002\u0002\u0013\u0005!Q\u0001\u0005\n\u0005\u001b\u0001\u0011\u0011!C\u0001\u0005\u001fA\u0011B!\u0006\u0001\u0003\u0003%\tEa\u0006\t\u0013\t\u0015\u0002!!A\u0005\u0002\t\u001d\u0002\"\u0003B\u0016\u0001\u0005\u0005I\u0011\tB\u0017\u0011%\u0011\t\u0004AA\u0001\n\u0003\u0012\u0019dB\u0005\u0003X1\n\t\u0011#\u0001\u0003Z\u0019A1\u0006LA\u0001\u0012\u0003\u0011Y\u0006C\u0004\u0002\u0006\r\"\tA!\u001c\t\u0013\t=4%!A\u0005F\tE\u0004\"\u0003B:G\u0005\u0005I\u0011\u0011B;\u0011%\u0011ihII\u0001\n\u0003\t\t\u0010C\u0005\u0003\u0000\r\n\t\u0011\"!\u0003\u0002\"I!qR\u0012\u0012\u0002\u0013\u0005\u0011\u0011\u001f\u0005\n\u0005#\u001b\u0013\u0011!C\u0005\u0005'\u0013Qb\u0015;sk\u000e$8\u000fV8Kg>t'BA\u0017/\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005=\u0002\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005E\u0012\u0014aA:rY*\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0013\u0001Qd(Q$K#^k\u0006CA\u001e=\u001b\u0005a\u0013BA\u001f-\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001e@\u0013\t\u0001EFA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011!)R\u0007\u0002\u0007*\u0011A\tL\u0001\bG>$WmZ3o\u0013\t15IA\bD_\u0012,w-\u001a8GC2d'-Y2l!\tY\u0004*\u0003\u0002JY\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005-seBA\u001eM\u0013\tiE&A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0003&A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003\u001b2\u0002\"AU+\u000e\u0003MS!\u0001\u0016\u0019\u0002\r\u0015\u0014(o\u001c:t\u0013\t16KA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\tA6,D\u0001Z\u0015\u0005Q\u0016!B:dC2\f\u0017B\u0001/Z\u0005\u001d\u0001&o\u001c3vGR\u0004\"AX3\u000f\u0005}#gB\u00011d\u001b\u0005\t'B\u000129\u0003\u0019a$o\\8u}%\t!,\u0003\u0002N3&\u0011am\u001a\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u001bf\u000bqa\u001c9uS>t7/F\u0001k!\u0011YwN\u001d:\u000f\u00051l\u0007C\u00011Z\u0013\tq\u0017,\u0001\u0004Qe\u0016$WMZ\u0005\u0003aF\u00141!T1q\u0015\tq\u0017\f\u0005\u0002lg&\u0011A/\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011=\u0004H/[8og\u0002\nQa\u00195jY\u0012,\u0012\u0001\u001f\t\u0003weL!A\u001f\u0017\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u000bi&lWMW8oK&#W#\u0001@\u0011\u0007a{(/C\u0002\u0002\u0002e\u0013aa\u00149uS>t\u0017a\u0003;j[\u0016TvN\\3JI\u0002\na\u0001P5oSRtD\u0003CA\u0005\u0003\u0017\ti!a\u0004\u0011\u0005m\u0002\u0001\"\u00025\b\u0001\u0004Q\u0007\"\u0002<\b\u0001\u0004A\bb\u0002?\b!\u0003\u0005\rA`\u0001\t]VdG.\u00192mKV\u0011\u0011Q\u0003\t\u00041\u0006]\u0011bAA\r3\n9!i\\8mK\u0006tGCBA\u0005\u0003;\ty\u0002C\u0003i\u0013\u0001\u0007!\u000eC\u0003w\u0013\u0001\u0007\u0001\u0010\u0006\u0003\u0002\n\u0005\r\u0002\"\u0002<\u000b\u0001\u0004AHCBA\u0005\u0003O\tI\u0003C\u0003w\u0017\u0001\u0007\u0001\u0010C\u0003i\u0017\u0001\u0007\u00010\u0001\u0004xe&$XM]\u000b\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0002j_*\u0011\u0011\u0011H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002>\u0005M\"aD\"iCJ\f%O]1z/JLG/\u001a:)\u00071\t\t\u0005E\u0002Y\u0003\u0007J1!!\u0012Z\u0005%!(/\u00198tS\u0016tG/A\u0002hK:,\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015/\u0003\u0011Q7o\u001c8\n\t\u0005U\u0013q\n\u0002\u0011\u0015\u0006\u001c7n]8o\u000f\u0016tWM]1u_JD3!DA!\u0003-Ig\u000e];u'\u000eDW-\\1\u0016\u0005\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r\u0004'A\u0003usB,7/\u0003\u0003\u0002h\u0005\u0005$\u0001\u0003#bi\u0006$\u0016\u0010]3)\u00079\t\t%A\u0005d_:4XM\u001d;feV\u0011\u0011q\u000e\t\b1\u0006E\u0014QOA>\u0013\r\t\u0019(\u0017\u0002\n\rVt7\r^5p]F\u00022\u0001WA<\u0013\r\tI(\u0017\u0002\u0004\u0003:L\b\u0003BA?\u0003\u000bk!!a \u000b\t\u0005\r\u0014\u0011\u0011\u0006\u0004\u0003\u0007\u0013\u0014AB;og\u00064W-\u0003\u0003\u0002\b\u0006}$AC+U\rb\u001aFO]5oO\"\u001aq\"!\u0011\u0002\u0011\u0011\fG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!%\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&/\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAN\u0003+\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004}\u0005\u0005\u0006\"\u0002?\u0013\u0001\u0004\u0011\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003BA;\u0003OCq!!+\u0014\u0001\u0004\t)(A\u0003wC2,X-\u0001\u0006j]B,H\u000fV=qKN,\"!a,\u0011\u000by\u000b\t,!.\n\u0007\u0005MvMA\u0002TKF\u0004B!a\u0018\u00028&!\u0011\u0011XA1\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012A]\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\t\u0005%\u00111\u0019\u0005\u0007\u0003\u000b4\u0002\u0019\u0001=\u0002\u00119,wo\u00115jY\u0012\fAaY8qsRA\u0011\u0011BAf\u0003\u001b\fy\rC\u0004i/A\u0005\t\u0019\u00016\t\u000fY<\u0002\u0013!a\u0001q\"9Ap\u0006I\u0001\u0002\u0004q\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003+T3A[AlW\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0015XBAAo\u0015\u0011\ty.!9\u0002\u0013Ut7\r[3dW\u0016$'bAAr3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0018Q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003[T3\u0001_Al\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a=+\u0007y\f9.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003s\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0005\u0003\u007f\f9$\u0001\u0003mC:<\u0017b\u0001;\u0002~\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u0001\t\u00041\n%\u0011b\u0001B\u00063\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\u000fB\t\u0011%\u0011\u0019\"HA\u0001\u0002\u0004\u00119!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00053\u0001bAa\u0007\u0003\"\u0005UTB\u0001B\u000f\u0015\r\u0011y\"W\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0012\u0005;\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011Q\u0003B\u0015\u0011%\u0011\u0019bHA\u0001\u0002\u0004\t)(\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA}\u0005_A\u0011Ba\u0005!\u0003\u0003\u0005\rAa\u0002\u0002\r\u0015\fX/\u00197t)\u0011\t)B!\u000e\t\u0013\tM\u0011%!AA\u0002\u0005U\u0004f\u0005\u0001\u0003:\t}\"\u0011\tB#\u0005\u000f\u0012YE!\u0014\u0003R\tM\u0003cA\u001e\u0003<%\u0019!Q\b\u0017\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!1I\u0001J?\u001a+fjQ0)Kb\u0004(o\u0017\u0017!_B$\u0018n\u001c8t;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA)\u001bvJ\u0014\u0011tiJLgn\u001a\u0011xSRD\u0007%\u0019\u0011hSZ,g\u000eI:ueV\u001cG\u000f\t<bYV,\u0017\u0001C3yC6\u0004H.Z:\"\u0005\t%\u0013\u0001b1\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q9\fW.\u001a3`gR\u0014Xo\u0019;)O\u0005<C\u0006I\u0019-A\u001d\u0012w\u0005\f\u00113S%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001f\u0012bEi\nDF\t2#uIj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8b[\u0016$wl\u001d;sk\u000e$\bf\n;j[\u0016<C\u0006\t;p?RLW.Z:uC6\u0004\bf\n\u001a1cUj\u0003\u0007O\u00173m\u001db\u0003eJ=zsflS*T\u0017eI\u001eJ\u0013\u0006\f\u0011nCBDs\u0005^5nKN$\u0018-\u001c9G_Jl\u0017\r^\u0014-A\u001d\"GmL'N_eL\u00180_\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u00023P\t;j[\u0016\u0014#H\t\u001a7_ABtF\r\u00192k\tj(\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bF\\1nK\u0012|6\u000f\u001e:vGRDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u0012\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u0019\u0012;c1\u0012#M\t\u001e3{vS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQ\u001d\nw\u0005\f\u0011oC6,GmX:ueV\u001cG\u000fK\u0014cO1\u0002\u0013'K\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z(%\u0019\u0012;w\n\u0012'EO\u0019~{*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS.\u00199)]\u0006lW\rZ0tiJ,8\r\u001e\u0015(C\u001eb\u0003%M\u0015-]\u0006lW\rZ0tiJ,8\r\u001e\u0015(E\u001eb\u0003EM\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u00023PI.2;\nR4P\t2#uIjXP\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBDs%Y\u0014-AEJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011|E\u0005\u0014#(M?\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)[\u0006\u0004\bfJ1(Y\u0001\n\u0014&K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u0019\u0012;cul&\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t=\u0013A\u00036t_:|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012!QK\u0001\u0006e9\u0012d\u0006M\u0001\u000e'R\u0014Xo\u0019;t)>T5o\u001c8\u0011\u0005m\u001a3#B\u0012\u0003^\t%\u0004#\u0003B0\u0005KR\u0007P`A\u0005\u001b\t\u0011\tGC\u0002\u0003de\u000bqA];oi&lW-\u0003\u0003\u0003h\t\u0005$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u0011\u0011\u0007B6\u0013\r1\u00171\u0007\u000b\u0003\u00053\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003s\fQ!\u00199qYf$\u0002\"!\u0003\u0003x\te$1\u0010\u0005\u0006Q\u001a\u0002\rA\u001b\u0005\u0006m\u001a\u0002\r\u0001\u001f\u0005\by\u001a\u0002\n\u00111\u0001\u007f\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0007\u0013Y\t\u0005\u0003Y\u007f\n\u0015\u0005C\u0002-\u0003\b*Dh0C\u0002\u0003\nf\u0013a\u0001V;qY\u0016\u001c\u0004\"\u0003BGQ\u0005\u0005\t\u0019AA\u0005\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tU\u0005\u0003BA~\u0005/KAA!'\u0002~\n1qJ\u00196fGR\u0004")
public class StructsToJson
extends UnaryExpression
implements TimeZoneAwareExpression,
CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
QueryErrorsBase,
Serializable {
    private transient CharArrayWriter writer;
    private transient JacksonGenerator gen;
    private transient DataType inputSchema;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToJson$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToJson x$0) {
        return StructsToJson$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToJson$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToJson> tupled() {
        return StructsToJson$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToJson>>> curried() {
        return StructsToJson$.MODULE$.curried();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.writer$lzycompute();
        }
        return this.writer;
    }

    private JacksonGenerator gen$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.gen = new JacksonGenerator(this.inputSchema(), this.writer(), new JSONOptions(this.options(), (String)this.timeZoneId().get(), JSONOptions$.MODULE$.$lessinit$greater$default$3()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.gen;
    }

    public JacksonGenerator gen() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.gen$lzycompute();
        }
        return this.gen;
    }

    private DataType inputSchema$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inputSchema = this.child().dataType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inputSchema;
    }

    public DataType inputSchema() {
        if ((byte)(this.bitmap$trans$0 & 4) == 0) {
            return this.inputSchema$lzycompute();
        }
        return this.inputSchema;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToJson structsToJson = this;
        synchronized (structsToJson) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                Function1 & Serializable intersect;
                DataType dataType = this.inputSchema();
                if (dataType instanceof StructType) {
                    intersect = (Function1 & Serializable)row -> {
                        this.gen().write((InternalRow)row);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof ArrayType) {
                    intersect = (Function1 & Serializable)arr -> {
                        this.gen().write((ArrayData)arr);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function1 & Serializable)map -> {
                        this.gen().write((MapData)map);
                        return this.getAndReset$1();
                    };
                } else if (dataType instanceof VariantType) {
                    intersect = (Function1 & Serializable)v -> {
                        this.gen().write((VariantVal)v);
                        return this.getAndReset$1();
                    };
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.converter = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        if ((byte)(this.bitmap$trans$0 & 8) == 0) {
            return this.converter$lzycompute();
        }
        return this.converter;
    }

    @Override
    public DataType dataType() {
        return SQLConf$.MODULE$.get().defaultStringType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.inputSchema();
        if (dataType instanceof StructType ? true : (dataType instanceof MapType ? true : (dataType instanceof ArrayType ? true : dataType instanceof VariantType))) {
            return JacksonUtils$.MODULE$.verifyType(this.prettyName(), dataType);
        }
        return new TypeCheckResult.DataTypeMismatch("INVALID_JSON_SCHEMA", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"schema"), (Object)this.toSQLType((AbstractDataType)this.child().dataType()))}))));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, StructType$.MODULE$}));
        return Nil$.MODULE$.$colon$colon((Object)typeCollection);
    }

    @Override
    public String prettyName() {
        return "to_json";
    }

    @Override
    public StructsToJson withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    public StructsToJson copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToJson(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToJson";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.options();
            }
            case 1: {
                return this.child();
            }
            case 2: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToJson;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "options";
            }
            case 1: {
                return "child";
            }
            case 2: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToJson)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToJson structsToJson = (StructsToJson)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToJson.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToJson.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToJson.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToJson.canEqual(this)) return false;
        return true;
    }

    private final UTF8String getAndReset$1() {
        this.gen().flush();
        String json = this.writer().toString();
        this.writer().reset();
        return UTF8String.fromString((String)json);
    }

    public StructsToJson(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        Statics.releaseFence();
    }

    public StructsToJson(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToJson(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

